/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandListener;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.task.NodeModelTask;
import com.ef_prime.rflow.core.task.RCommandTask;
import com.ef_prime.rflow.core.task.Task;
import com.ef_prime.rflow.core.task.TaskEvent;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.node.ui.UINodeModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.base.AbstractPreviewView;
import com.ef_prime.rflow.ui.common.component.BusyLayerUI;
import com.ef_prime.rflow.ui.common.component.DelayedExecutor;
import com.ef_prime.rflow.ui.common.component.SwitchPanel;
import com.ef_prime.rflow.ui.common.event.ChangeEvent;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.item.ItemName;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.LayerUI;

public abstract class RPreviewView
extends AbstractPreviewView<String> {
    private boolean changed;
    private boolean previewResult;
    private Handler handler = new Handler();
    protected SwitchPanel previewPane;
    private DelayedExecutor delayedRefreshExecutor;
    private JLayer<JComponent> busyLayer;

    public RPreviewView(ROperation rOperation, WidgetNode widgetNode) {
        super(rOperation, widgetNode);
        rOperation.addChangeEventHandler(this.handler);
        this.previewPane = new SwitchPanel();
        this.setLayout(new BorderLayout());
        this.add(new JLayer<JComponent>(this.previewPane, new PreviewLayerUI()), "Center");
        this.add((Component)this.errorPanel, "South");
    }

    protected abstract Command createCommand(String var1, PreviewOption var2) throws Exception;

    @Override
    public ROperation getModel() {
        return (ROperation)super.getModel();
    }

    @Override
    public void run() {
        if (this.busyLayer == null) {
            this.busyLayer = new JLayer<JPanel>(new JPanel(), new BusyLayerUI());
        }
        ((BusyLayerUI)this.busyLayer.getUI()).start(200);
        this.setPreview(this.busyLayer);
        super.run();
    }

    protected void setPreview(Component component) {
        this.previewPane.set(component);
    }

    protected Component getPreview() {
        return this.previewPane.get();
    }

    protected void setChanged(boolean bl) {
        if (this.changed == bl) {
            return;
        }
        this.changed = bl;
        this.previewPane.repaint();
    }

    protected void setRefreshDelay(long l) {
        this.delayedRefreshExecutor = l > 0L ? new DelayedExecutor(new Runnable(){

            @Override
            public void run() {
                RPreviewView.super.refresh();
            }
        }, l) : null;
    }

    @Override
    protected String getResultName(Task task) {
        if (task.isPreview()) {
            ItemName[] itemNameArray = this.getModel().getNewItemNames();
            if (itemNameArray != null && itemNameArray.length == 1) {
                return itemNameArray[0].getName();
            }
        } else {
            List<ItemName> list = task.getResults();
            if (list.size() == 1) {
                return list.get(0).getName();
            }
        }
        return super.getResultName(task);
    }

    @Override
    public void taskStateChanged(TaskEvent taskEvent) {
        super.taskStateChanged(taskEvent);
        if (taskEvent.isDone()) {
            this.setChanged(false);
            this.previewResult = taskEvent.getTask().isPreview();
            if (this.busyLayer != null) {
                ((BusyLayerUI)this.busyLayer.getUI()).stop();
            }
        }
    }

    @Override
    protected void runTaskFinished(NodeModelTask nodeModelTask) {
        this.previewResult = false;
        this.setChanged(false);
    }

    @Override
    protected String createRunIdentifier(PreviewOption previewOption) throws Exception {
        return this.getModel().getRScript(false, false, PreviewOption.OFF);
    }

    @Override
    protected void checkIdentifier(String string) throws Exception {
        String string2 = R.client().checkSyntax(string);
        if (string2 != null) {
            throw new Exception(Messages.getString("Error.rsyntax"));
        }
    }

    @Override
    protected void run(String string, PreviewOption previewOption) throws Exception {
        Command command = this.createCommand(string, previewOption);
        command.setCheckError(true);
        command.setNoRecover(true);
        if (!Rflow.isDevel() || !Rflow.develSettings().isOutputPreviewCode()) {
            command.setCaptureOutput(true);
        }
        FlowRunOption flowRunOption = new FlowRunOption().setNoHistory(true).setRunImmediately(true);
        RCommandTask rCommandTask = new RCommandTask(flowRunOption, command);
        rCommandTask.setROperation((ROperation)this.getModel().copy());
        rCommandTask.setPreviewOption(previewOption);
        this.getModelExecutor().run(rCommandTask);
    }

    @Override
    public boolean supportsRunResultView() {
        return true;
    }

    @Override
    public void refresh() {
        if (this.delayedRefreshExecutor != null) {
            this.delayedRefreshExecutor.requestAction(false);
        } else {
            super.refresh();
        }
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        if (this.autoRefresh.isSelected()) {
            this.refresh();
        }
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        if (this.getModel() != null) {
            this.getModel().removeChangeEventHandler(this.handler);
        }
        if (this.delayedRefreshExecutor != null) {
            this.delayedRefreshExecutor.cancel();
        }
    }

    private class Handler
    implements ChangeEventHandler,
    CommandListener {
        private Handler() {
        }

        @Override
        public void handleChanged(ChangeEvent changeEvent) {
            if (RPreviewView.this.autoRefresh.isSelected()) {
                RPreviewView.this.refresh();
            } else {
                Task task = RPreviewView.this.executor.getLastTask();
                if (task != null) {
                    NodeModel nodeModel = task.getModel();
                    try {
                        Object object;
                        String string;
                        if (task instanceof RCommandTask) {
                            string = ((RCommandTask)task).getROperation().getRScript(false, false, PreviewOption.OFF);
                        } else {
                            if (!(nodeModel instanceof UINodeModel)) {
                                return;
                            }
                            object = (UINodeModel)nodeModel;
                            if (!(((UINodeModel)object).getModel() instanceof ROperation)) {
                                return;
                            }
                            ROperation rOperation = (ROperation)((UINodeModel)object).getModel();
                            string = rOperation.getRScript(false, false, PreviewOption.OFF);
                        }
                        object = RPreviewView.this.getModel().getRScript(false, false, PreviewOption.OFF);
                        RPreviewView.this.setChanged(!Objects.equals(string, object));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public void commandStart(Command command) {
        }

        @Override
        public void commandFinished(Command command) {
            RPreviewView.this.setChanged(false);
        }

        @Override
        public void commandCanceled(Command command) {
        }

        @Override
        public void errorOccurred(Command command) {
        }

        @Override
        public void commandDiscarded(Command command) {
        }
    }

    private class PreviewLayerUI
    extends LayerUI<JComponent> {
        private PreviewLayerUI() {
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            Graphics2D graphics2D;
            super.paint(graphics, jComponent);
            if (RPreviewView.this.previewPane.get() == null) {
                return;
            }
            if (RPreviewView.this.previewResult) {
                graphics2D = (Graphics2D)graphics.create();
                graphics2D.setComposite(AlphaComposite.getInstance(10, 0.15f));
                graphics2D.setColor(Color.RED);
                graphics2D.setFont(new Font("SansSerif", 1, 72));
                String string = "PREVIEW";
                int n = SwingUtilities.computeStringWidth(graphics2D.getFontMetrics(), string);
                UIUtility.drawStringCenterY(graphics2D, jComponent, string, jComponent.getWidth() / 2 - n / 2);
                graphics2D.dispose();
            }
            if (RPreviewView.this.changed || RPreviewView.this.wasError()) {
                graphics2D = (Graphics2D)graphics.create();
                graphics2D.setComposite(AlphaComposite.getInstance(10, 0.4f));
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
                graphics2D.dispose();
            }
        }
    }
}

