/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.RScript;
import com.ef_prime.rflow.core.base.DevelSettings;
import com.ef_prime.rflow.core.common.keyvalue.KeyWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.node.OpExecutor;
import com.ef_prime.rflow.core.task.Task;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.keyvalue.RTextKeyWidget;
import com.ef_prime.rflow.ui.app.r.script.RCodingTextArea;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.view.ToolbarSupport;
import com.ef_prime.rflow.ui.common.view.View;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class RScriptDialogView
extends View
implements Consumer<Task>,
ToolbarSupport {
    private OpExecutor executor;
    private RCodingTextArea textArea;

    public RScriptDialogView(ValueMap valueMap, WidgetNode widgetNode) {
        this.executor = (OpExecutor)widgetNode.getRoot().getProperty(OpExecutor.PROPERTY_EXECUTOR);
        RTextKeyWidget rTextKeyWidget = (RTextKeyWidget)WidgetFactory.getInstance().create(valueMap, new KeyWidgetNode(RScript.KEY_SCRIPT));
        this.textArea = rTextKeyWidget.getTextArea();
        this.textArea.setTaskRunner(this);
        this.add((Component)rTextKeyWidget, "Center");
        if (Rflow.develSettings().getValue(DevelSettings.UINODE_WINDOW).equals("dialog")) {
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            if (this.executor != null) {
                jToolBar.add(this.createToolBarButton(new Run()));
            }
            jToolBar.add(this.createToolBarButton(this.textArea.getActionMap().get("CodingTextArea.RUN")));
            this.add((Component)jToolBar, "North");
        }
    }

    private JButton createToolBarButton(Action action) {
        JButton jButton = new JButton(action);
        jButton.setFocusable(false);
        return jButton;
    }

    @Override
    public void accept(Task task) {
        if (this.executor != null) {
            this.executor.run(task);
        }
    }

    @Override
    public void configureToolbar(JToolBar jToolBar) {
        Action action = this.textArea.getActionMap().get("CodingTextArea.RUN");
        JButton jButton = new JButton(action);
        jButton.setFocusable(false);
        jToolBar.add(jButton);
    }

    private class Run
    extends LoggableAction {
        public Run() {
            this.putValue("Name", Messages.getString("Action.run"));
            this.putValue("SmallIcon", Icons.getIcon("16/resultset_next.png"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            if (RScriptDialogView.this.executor != null) {
                RScriptDialogView.this.executor.run();
            }
        }
    }
}

