/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r;

import com.ef_prime.rflow.core.app.file.TextFile;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.ui.app.file.TextFileEditView;
import com.ef_prime.rflow.ui.app.r.script.RCodingTextAreaEx;
import com.ef_prime.rflow.ui.app.r.script.RScriptUtility;
import com.ef_prime.rflow.ui.app.r.script.SimpleCodingScrollPane;
import com.ef_prime.rflow.ui.common.component.CodingSearchBar;
import com.ef_prime.rflow.ui.common.component.CodingStatusBar;
import com.ef_prime.rflow.ui.common.component.CodingTextArea;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.text.JTextComponent;
import org.fife.ui.rsyntaxtextarea.ErrorStrip;
import org.fife.ui.rtextarea.RTextArea;

public class RScriptFileEditView
extends TextFileEditView {
    public RScriptFileEditView(TextFile textFile) {
        super(textFile);
    }

    protected RCodingTextAreaEx getTextComponent() {
        return (RCodingTextAreaEx)((Object)super.getTextComponent());
    }

    @Override
    protected Component createEditorComponent() {
        TextFileEditView.TextComponentPanel textComponentPanel = new TextFileEditView.TextComponentPanel();
        RCodingTextAreaEx rCodingTextAreaEx = new RCodingTextAreaEx();
        rCodingTextAreaEx.startAutoCompletionNotifier();
        rCodingTextAreaEx.setCodeFoldingEnabled(true);
        textComponentPanel.setTextComponent((JTextComponent)((Object)rCodingTextAreaEx));
        SimpleCodingScrollPane simpleCodingScrollPane = new SimpleCodingScrollPane((RTextArea)rCodingTextAreaEx);
        CodingSearchBar codingSearchBar = new CodingSearchBar(rCodingTextAreaEx);
        CodingStatusBar codingStatusBar = new CodingStatusBar(rCodingTextAreaEx);
        ErrorStrip errorStrip = RScriptUtility.createErrorStrip(rCodingTextAreaEx);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)((Object)simpleCodingScrollPane), "Center");
        jPanel.add((Component)codingSearchBar, "South");
        textComponentPanel.add((Component)jPanel, "Center");
        textComponentPanel.add((Component)errorStrip, "East");
        textComponentPanel.add((Component)codingStatusBar, "South");
        return textComponentPanel;
    }

    @Override
    public void configureToolbar(JToolBar jToolBar) {
        jToolBar.add(UIUtility.createToolbarButton(this.getTextComponent().getActionMap().get("CodingTextArea.RUN_ALL"), false));
        jToolBar.add(UIUtility.createToolbarButton(this.getTextComponent().getActionMap().get("CodingTextArea.RUN"), false));
        jToolBar.addSeparator();
        jToolBar.add(UIUtility.createToolbarButton(this.getActionMap().get("FileEditView.SAVE"), false));
        jToolBar.add(UIUtility.createToolbarButton(this.getActionMap().get("FileEditView.SAVE_AS_DROP_DOWN"), true));
        jToolBar.add(UIUtility.createToolbarButton(this.getActionMap().get("FileEditView.REOPEN"), false));
    }

    @Override
    protected void refreshSyntax() {
        if (this.getFileEdit() != null && this.getTextComponent() instanceof CodingTextArea) {
            this.getTextComponent().setSyntaxEditingStyle("RSYNTAX");
        }
    }

    @Override
    protected WidgetNode getPropertyWidgetNode() {
        return new PanelWidgetNode().addKeys(TextFile.NEWLINE, TextFile.WHITESPACE);
    }

    @Override
    protected Key<Boolean> getWhitespaceKey() {
        return Settings.R_EDITOR_WHITESPACES;
    }
}

