/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r;

import com.ef_prime.rflow.core.app.file.TextFile;
import com.ef_prime.rflow.core.app.r.RScriptFile;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.FileEditBackups;
import com.ef_prime.rflow.core.base.FileEditEvent;
import com.ef_prime.rflow.core.base.FileEditEventHandler;
import com.ef_prime.rflow.core.base.FileManager;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.keyvalue.ButtonWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.XFlowPanelWidgetNode;
import com.ef_prime.rflow.node.RequestNodeModelNotifyEvent;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.RScriptFileEditView;
import com.ef_prime.rflow.ui.base.FileEditUIUtilty;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.event.SimpleEvent;
import com.ef_prime.rflow.ui.common.event.SimpleEventHandler;
import com.ef_prime.rflow.ui.common.keyvalue.Widget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.view.Page;
import com.ef_prime.rflow.ui.common.view.PagesView;
import com.ef_prime.rflow.ui.common.view.PagesViewFactory;
import com.ef_prime.rflow.ui.common.view.ToolbarSupport;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;

public class RScriptFileNodeView
extends View
implements ActionListener,
ToolbarSupport,
SimpleEventHandler,
FileEditEventHandler {
    private static final Logger LOGGER = Logger.getLogger(RScriptFileNodeView.class.getName());
    private RScriptFile rScriptFile;
    private ValueMap summary;
    private RScriptFileEditView fileEditView;
    private StrKey FILE_SETTINGS_SUMMARY = ((StrKey.Builder)((StrKey.Builder)((StrKey.Builder)StrKey.builder("summary", Messages.getString("Node.RScriptFile.file")).setFixed(true)).setEmptyMessage(Messages.getString("Node.RScriptFile.empty"))).setToolTipSupplier(() -> new File(this.rScriptFile.getValue(RScriptFile.FILE)).getAbsolutePath())).build();

    public RScriptFileNodeView(ValueMap valueMap, WidgetNode widgetNode) {
        this.rScriptFile = (RScriptFile)valueMap;
        this.summary = new ValueMap();
        this.summary.putValue(this.FILE_SETTINGS_SUMMARY, "");
        Widget widget = (Widget)WidgetFactory.getInstance().create(this.summary);
        JButton jButton = new JButton(Messages.getStringWithDots("Node.RScriptFile.settings"));
        jButton.addActionListener(this);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout(new LC().insetsAll("0")));
        jPanel.setBorder(new EmptyBorder(2, 0, 4, 0));
        jPanel.add(widget);
        jPanel.add(jButton);
        this.fileEditView = new RScriptFileNodeEditView(this.rScriptFile.getFileEdit());
        this.fileEditView.doLoadContent();
        this.add((Component)jPanel, "North");
        this.add((Component)this.fileEditView, "Center");
        this.fileSettingsChanged();
        widget.updateWidgetValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileSettingsChanged() {
        TextFile textFile = this.rScriptFile.getFileEdit();
        this.fileEditView.setReloadLock(true);
        try {
            Object object;
            if (textFile != null) {
                object = this.rScriptFile.getValue(RScriptFile.ENCODING);
                Charset charset = RUtility.toJavaEncoding((String)object);
                textFile.putValue(TextFile.ENCODING, charset.name());
            }
            if ((object = this.fileEditView.getFileEdit()) != null) {
                object.removeFileEditEventHandler(this);
            }
            if (textFile != null) {
                textFile.addFileEditEventHandler(this);
            }
        }
        finally {
            this.fileEditView.setReloadLock(false);
        }
        this.fileEditView.setFileEdit(textFile);
        this.fileEditView.refresh();
        this.updateSummary();
    }

    private void updateSummary() {
        Object object;
        TextFile textFile = this.fileEditView.getFileEdit();
        if (textFile == null) {
            object = "";
        } else {
            String string = textFile != null && textFile.isDirty() ? "*" : "";
            String string2 = this.rScriptFile.getValue(RScriptFile.ENCODING);
            if (string2.isEmpty()) {
                string2 = Messages.getString("File.TextSettings.system_default");
            }
            object = string + FilenameUtils.getName((String)textFile.getFile().getPath()) + "  [" + string2 + "]";
        }
        this.summary.putValue(this.FILE_SETTINGS_SUMMARY, object);
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        super.viewDidBecomeDisplayable();
        EventManager.getInstance().registerEventHandler(RequestNodeModelNotifyEvent.class, this);
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        EventManager.getInstance().removeEventHandler(RequestNodeModelNotifyEvent.class, this);
        TextFile textFile = this.fileEditView.getFileEdit();
        if (textFile != null) {
            textFile.removeFileEditEventHandler(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        PagesView pagesView = PagesViewFactory.createOkCancelView(new FileSettingsPage());
        pagesView.showDialog(this, Messages.getString("Node.RScriptFile.settings"), true, new Dimension(500, 200));
    }

    @Override
    public void configureToolbar(JToolBar jToolBar) {
        jToolBar.add(UIUtility.createToolbarButton(this.fileEditView.getTextComponent().getActionMap().get("CodingTextArea.RUN"), false));
        jToolBar.addSeparator();
        jToolBar.add(UIUtility.createToolbarButton(this.fileEditView.getActionMap().get("FileEditView.SAVE"), false));
        jToolBar.add(UIUtility.createToolbarButton(this.fileEditView.getActionMap().get("FileEditView.REOPEN"), false));
    }

    @Override
    public void onEvent(SimpleEvent simpleEvent) {
        TextFile textFile;
        if (simpleEvent.getClass().equals(RequestNodeModelNotifyEvent.class) && (textFile = this.rScriptFile.getFileEdit()).isDirtyForBackup()) {
            try {
                FileEditBackups.getInstance().backup(textFile);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Failed to save backup.", iOException);
            }
        }
    }

    @Override
    public void fileEditStateChanged(FileEditEvent fileEditEvent) {
        if (fileEditEvent.isDirtyChanged()) {
            this.updateSummary();
        }
    }

    private class RScriptFileNodeEditView
    extends RScriptFileEditView {
        public RScriptFileNodeEditView(TextFile textFile) {
            super(textFile);
        }

        @Override
        protected boolean createToolBar() {
            return false;
        }

        @Override
        protected Object getProtectKey() {
            return null;
        }

        @Override
        protected void changeEncoding(String string) {
            String string2;
            super.changeEncoding(string);
            TextFile textFile = this.getFileEdit();
            if (textFile != null && !(string2 = RUtility.toREncoding(textFile.getEncoding(), R.client().getNativeEncoding())).isEmpty()) {
                RScriptFileNodeView.this.rScriptFile.putValue(RScriptFile.ENCODING, string2);
                RScriptFileNodeView.this.updateSummary();
            }
        }
    }

    private class FileSettingsPage
    extends Page {
        private RScriptFile modelCopy;

        public FileSettingsPage() {
            this.modelCopy = (RScriptFile)RScriptFileNodeView.this.rScriptFile.copy();
            WidgetNode widgetNode = new PanelWidgetNode().addElements(RScriptFile.FILE, new XFlowPanelWidgetNode().addElements(new ButtonWidgetNode(Messages.getString("Node.RScriptFile.auto_detect"), "auto_detect"), RScriptFile.AUTODETECT), RScriptFile.ENCODING);
            Component component = WidgetFactory.getInstance().create(this.modelCopy, widgetNode);
            this.add(component);
        }

        @Override
        public boolean viewWillClose(int n) {
            Object object;
            if (n != 1) {
                return true;
            }
            String string = RScriptFileNodeView.this.rScriptFile.getValue(RScriptFile.FILE);
            Path path = WorkingDirectory.toAbsolutePath(new File(string)).toPath();
            Path path2 = WorkingDirectory.toAbsolutePath(new File(this.modelCopy.getValue(RScriptFile.FILE))).toPath();
            if (!(string.isEmpty() || path.equals(path2) || (object = RScriptFileNodeView.this.rScriptFile.getFileEdit()) == null || object.getProtectCount() != 1 || FileEditUIUtilty.confirmAndSave((FileEdit)object))) {
                return false;
            }
            if (Files.exists(path2, new LinkOption[0])) {
                object = this.modelCopy.getFileEdit();
                if (object != null && object.isDirty()) {
                    Charset charset = RUtility.toJavaEncoding(this.modelCopy.getValue(RScriptFile.ENCODING));
                    if (!((TextFile)object).getEncoding().equals(charset)) {
                        JOptionPane.showMessageDialog(this, Messages.format("Error.editing", ((TextFile)object).getFile().getName()), Messages.getString("Error.title.error"), 0);
                        return false;
                    }
                }
                return true;
            }
            object = Messages.format("Message.confirm_file_create", path2.getFileName().toString());
            int n2 = JOptionPane.showConfirmDialog(this, object, Messages.getString("Message.confirm"), 0, 3);
            if (n2 != 0) {
                return false;
            }
            try {
                Files.createFile(path2, new FileAttribute[0]);
                FileManager.getInstance().addNewItem(path2.toFile());
                return true;
            }
            catch (IOException iOException) {
                UIUtility.showErrorDialog((Component)this, iOException);
                return false;
            }
        }

        @Override
        public void closePage(int n) {
            if (n != 1) {
                return;
            }
            RScriptFileNodeView.this.rScriptFile.putValue(RScriptFile.FILE, this.modelCopy.getValue(RScriptFile.FILE));
            RScriptFileNodeView.this.rScriptFile.putValue(RScriptFile.AUTODETECT, this.modelCopy.getValue(RScriptFile.AUTODETECT));
            RScriptFileNodeView.this.rScriptFile.putValue(RScriptFile.ENCODING, this.modelCopy.getValue(RScriptFile.ENCODING));
            RScriptFileNodeView.this.fileSettingsChanged();
        }
    }
}

