/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r;

import com.ef_prime.rflow.core.app.r.RSort;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableRow;
import com.ef_prime.rflow.ui.app.r.object.RDataObjectView;
import com.ef_prime.rflow.ui.common.component.DataTable;
import com.ef_prime.rflow.ui.common.table.SortEvent;
import com.ef_prime.rflow.ui.common.table.SortEventHandler;
import com.ef_prime.rflow.ui.common.table.ThreeClickRowSorter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;

public class RSortTableView
extends RDataObjectView
implements SortEventHandler {
    private RSort model;
    private Map<String, Integer> columnNameToIndexMap = new HashMap<String, Integer>();

    public RSortTableView(ValueMap valueMap, WidgetNode widgetNode) {
        this((RSort)valueMap);
    }

    public RSortTableView(RSort rSort) {
        super(R.getInterface(), null);
        this.model = rSort;
    }

    @Override
    protected DataTable createDataTable() {
        return new RSortDataTable();
    }

    @Override
    protected void setModel(RDataObjectView.OnDemandTableModel onDemandTableModel) {
        super.setModel(onDemandTableModel);
        RSortRowSorter rSortRowSorter = new RSortRowSorter(onDemandTableModel);
        rSortRowSorter.addSortEventHandler(this);
        this.getTable().setRowSorter(rSortRowSorter);
        this.columnNameToIndexMap.clear();
        for (int i = 0; i < onDemandTableModel.getColumnCount(); ++i) {
            this.columnNameToIndexMap.put(onDemandTableModel.getColumnName(i), i);
        }
        this.refreshSortKeys();
    }

    private void refreshSortKeys() {
        KeysTableModel keysTableModel = this.model.getValue(RSort.COLUMN);
        ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>(keysTableModel.getRowCount());
        for (KeysTableRow keysTableRow : keysTableModel) {
            String string = keysTableRow.getValue(RSort.COL_COLUMN);
            Integer n = this.columnNameToIndexMap.get(string);
            if (n == null) continue;
            String string2 = keysTableRow.getValue(RSort.COL_ORDER);
            SortOrder sortOrder = SortOrder.ASCENDING;
            if (string2.equals("DESC")) {
                sortOrder = SortOrder.DESCENDING;
            }
            arrayList.add(new RowSorter.SortKey(n, sortOrder));
        }
        RowSorter<? extends TableModel> rowSorter = this.getTable().getRowSorter();
        if (rowSorter == null) {
            return;
        }
        rowSorter.setSortKeys(arrayList);
    }

    @Override
    public void sortChanged(SortEvent sortEvent) {
        if (sortEvent.getColumn() < 0 || sortEvent.getColumn() >= this.getTable().getColumnCount()) {
            return;
        }
        String string = this.getTable().getColumnName(sortEvent.getColumn());
        KeysTableModel keysTableModel = this.model.getValue(RSort.COLUMN);
        int n = -1;
        for (int i = 0; i < keysTableModel.getRowCount(); ++i) {
            KeysTableRow keysTableRow = (KeysTableRow)keysTableModel.getRow(i);
            if (!keysTableRow.getValue(RSort.COL_COLUMN).equals(string)) continue;
            n = i;
            break;
        }
        switch (sortEvent.getType()) {
            case 0: 
            case 2: {
                String string2;
                String string3 = string2 = sortEvent.getOrder() == 2 ? "DESC" : "ASC";
                if (n < 0) {
                    keysTableModel.addNewRow(string, string2);
                    break;
                }
                keysTableModel.setValueAt(string2, n, keysTableModel.getColumnIndex(RSort.COL_ORDER));
                break;
            }
            case 1: {
                if (n < 0) break;
                keysTableModel.removeRows(new int[]{n});
            }
        }
    }

    private class RSortDataTable
    extends RDataObjectView.RObjectDataTable {
        private RSortDataTable() {
            super(RSortTableView.this);
        }

        @Override
        protected boolean columnSelectionEnabled() {
            return false;
        }
    }

    private class RSortRowSorter
    extends ThreeClickRowSorter<RDataObjectView.OnDemandTableModel> {
        public RSortRowSorter(RDataObjectView.OnDemandTableModel onDemandTableModel) {
            super(onDemandTableModel);
        }

        @Override
        protected void setNewSortKeys(List<RowSorter.SortKey> list) {
            RSortTableView.this.refreshSortKeys();
        }

        @Override
        public void sort() {
        }

        @Override
        public int convertRowIndexToModel(int n) {
            return n;
        }

        @Override
        public int convertRowIndexToView(int n) {
            return n;
        }
    }
}

