/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.app.r.RAddonBuilderModel;
import com.ef_prime.rflow.core.app.r.RAddonOp;
import com.ef_prime.rflow.core.base.DevelSettings;
import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.keyvalue.CompoundValueError;
import com.ef_prime.rflow.core.common.keyvalue.ValidationContext;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.node.ui.OpManager;
import com.ef_prime.rflow.node.ui.OpPagesView;
import com.ef_prime.rflow.node.ui.OpTabPagesView;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.node.ui.RAddonOpData;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.FileFilterFactory;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.MyFileFilter;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.event.ChangeEventSupport;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.FileEditView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JToolBar;
import org.apache.commons.io.FileUtils;

public class RUIBuilderView
extends FileEditView
implements ValueChangeEventHandler {
    private static final String TEST = "RUIBuilderView.TEST";
    private Component dropDown;
    private ChangeEventSupport changeEventSupport = new ChangeEventSupport(this);

    public RUIBuilderView() {
        this(new RAddonBuilderModel(null));
    }

    public RUIBuilderView(RAddonBuilderModel rAddonBuilderModel) {
        super(rAddonBuilderModel);
        this.setIcon(Icons.getOverlaidIcon(Icons.getIcon("16/brick.png"), "16/pencil.png", 10, 7, 6));
        this.getActionMap().put(TEST, new Test());
    }

    @Override
    public Object getKey() {
        File file = this.getFileEdit().getFile();
        return file == null ? this.getFileEdit() : file;
    }

    @Override
    public RAddonBuilderModel getFileEdit() {
        return (RAddonBuilderModel)super.getFileEdit();
    }

    @Override
    protected void loadContent() {
        RAddonBuilderModel rAddonBuilderModel = this.getFileEdit();
        JComponent jComponent = (JComponent)WidgetFactory.getInstance().create(rAddonBuilderModel);
        this.add((Component)jComponent, "Center");
        this.refreshActionState();
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(UIUtility.createToolbarButton(this.getActionMap().get("FileEditView.SAVE"), false));
        this.dropDown = jToolBar.add(UIUtility.createToolbarButton(this.getActionMap().get("FileEditView.SAVE_AS_DROP_DOWN"), false));
        this.dropDown.setVisible(!rAddonBuilderModel.isNew());
        jToolBar.add(UIUtility.createToolbarButton(this.getActionMap().get(TEST), false));
        jToolBar.setFloatable(false);
        this.add((Component)jToolBar, "North");
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        super.viewDidBecomeDisplayable();
        this.getFileEdit().addEventHandler(this);
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        this.getFileEdit().removeEventHandler(this);
    }

    @Override
    protected boolean doSave(boolean bl) throws IOException {
        Object object;
        File file;
        ValidationContext validationContext = this.getFileEdit().getValidationContext();
        if (validationContext.isError() && !validationContext.containsNoError()) {
            CompoundValueError compoundValueError = new CompoundValueError(null, validationContext.getAllErrors(4));
            throw new IOException(compoundValueError.getMessage(true, true));
        }
        RAddonBuilderModel rAddonBuilderModel = this.getFileEdit();
        File file2 = rAddonBuilderModel.getFile();
        if (file2 == null) {
            bl = true;
        }
        if (!(file = UserFolder.getCustomUIDir()).exists()) {
            FileUtils.forceMkdir((File)file);
        }
        while (true) {
            if (bl) {
                object = new JFileChooser(file);
                ((JFileChooser)object).setDialogTitle(Messages.getString("Message.save"));
                MyFileFilter myFileFilter = FileFilterFactory.createYamlFileFilter();
                ((JFileChooser)object).addChoosableFileFilter(myFileFilter);
                ((JFileChooser)object).setFileFilter(myFileFilter);
                ((JFileChooser)object).setSelectedFile(new File(file, FileUtility.toLegalFileName(rAddonBuilderModel.getTitle()) + ".yaml"));
                file2 = UIUtility.chooseSaveFile((JFileChooser)object, this);
                if (file2 == null) {
                    return false;
                }
            }
            if (bl && !file2.equals(rAddonBuilderModel.getFile())) break;
            object = this.checkExternalEdit();
            if (object == null) {
                return false;
            }
            if (((Boolean)object).booleanValue()) break;
            bl = true;
        }
        rAddonBuilderModel.safeSave(WorkingDirectory.toAbsolutePath(file2).toPath(), Rflow.project().getTempDir().toPath());
        rAddonBuilderModel.setFile(file2);
        object = rAddonBuilderModel.getModelData(file2.getName());
        OpManager.getInstance().updateAddonModel(new RAddonOp((RAddonOpData)object));
        this.changeEventSupport.dispatchEvent();
        this.dropDown.setVisible(!rAddonBuilderModel.isNew());
        this.getFileEdit().dispatchFileEditEvent(3);
        return true;
    }

    public void addChangeEventHandler(ChangeEventHandler changeEventHandler) {
        this.changeEventSupport.addEventHandler(changeEventHandler);
    }

    public void removeChangeEventHandler(ChangeEventHandler changeEventHandler) {
        this.changeEventSupport.removeEventHandler(changeEventHandler);
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        this.refreshActionState();
    }

    private void refreshActionState() {
        boolean bl = this.getFileEdit().getValidationContext().isError();
        this.getActionMap().get("FileEditView.SAVE").setEnabled(!bl);
        this.getActionMap().get("FileEditView.SAVE_AS").setEnabled(!bl);
        this.getActionMap().get("FileEditView.SAVE_AS_DROP_DOWN").setEnabled(!bl);
        this.getActionMap().get(TEST).setEnabled(!bl);
    }

    private class Test
    extends LoggableAction {
        public Test() {
            this.putValue("Name", Messages.getString("Action.test"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            RAddonOpData rAddonOpData = RUIBuilderView.this.getFileEdit().getModelData("");
            RAddonOp rAddonOp = new RAddonOp(rAddonOpData);
            rAddonOp.loadResource();
            switch (Rflow.develSettings().getValue(DevelSettings.UINODE_WINDOW)) {
                case "dialog": {
                    TestPagesDView testPagesDView = new TestPagesDView(rAddonOp);
                    JDialog jDialog = testPagesDView.createDialog(Rflow.mainFrame(), testPagesDView.getTitle(), false, new Dimension(700, 700));
                    if (testPagesDView.getIcon() != null && testPagesDView.getIcon() instanceof ImageIcon) {
                        jDialog.setIconImage(((ImageIcon)testPagesDView.getIcon()).getImage());
                    }
                    jDialog.setVisible(true);
                    break;
                }
                default: {
                    Rflow.mainView().getDefaultFlowPane().openView(new TestPagesView(rAddonOp), ViewOpenType.OPEN_NEW, true);
                }
            }
        }
    }

    private class TestPagesDView
    extends OpPagesView {
        public TestPagesDView(Operation operation) {
            super(operation, null);
        }

        @Override
        public String getTitle() {
            String string = super.getTitle();
            return string + " (" + Messages.getString("Action.test") + ")";
        }

        @Override
        protected boolean addEnabled() {
            return false;
        }
    }

    private class TestPagesView
    extends OpTabPagesView {
        public TestPagesView(Operation operation) {
            super(operation, null);
        }

        @Override
        public String getTitle() {
            String string = super.getTitle();
            return string + " (" + Messages.getString("Action.test") + ")";
        }

        @Override
        protected boolean addEnabled() {
            return false;
        }
    }
}

