/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.console;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.base.Apps;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.console.BasicCommand;
import com.ef_prime.rflow.core.app.r.console.BrowseListener;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.ElementType;
import com.ef_prime.rflow.core.app.r.console.RConsole;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.console.RConsoleInput;
import com.ef_prime.rflow.ui.app.r.console.RConsoleOutput;
import com.ef_prime.rflow.ui.app.r.object.RObjectViewer;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.item.ItemName;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.rosuda.JRI.Rengine;

public abstract class RConsoleComponent
extends RConsole
implements BrowseListener {
    private static final Logger LOGGER = Logger.getLogger(RConsoleComponent.class.getName());
    private JPanel panel;
    protected RConsoleOutput output;
    protected RConsoleInput input;
    private InputDocumentListener inputDocumentListener = new InputDocumentListener();
    private int lastWidth;
    private DebugActions debugActions = new DebugActions();
    private Component toolbar;
    private Component errorToolBar;
    private JButton nButton;

    public RConsoleComponent() {
        this.addBrowseListener(this);
        this.output = new RConsoleOutput(){

            @Override
            protected void submitCommand(String string) {
                RConsoleComponent.this.submitCommand(string);
            }

            @Override
            protected RConsoleInput getInput() {
                return RConsoleComponent.this.input;
            }
        };
        this.input = new RConsoleInput(this, this.output);
        InputActions inputActions = new InputActions();
        inputActions.installActions((JComponent)((Object)this.input), false, 0);
        this.input.getInputMap().put(KeyStroke.getKeyStroke(10, 1), inputActions.get("SUBMIT_COMMAND"));
        InnerPanel innerPanel = new InnerPanel(this.output, (JComponent)((Object)this.input));
        JScrollPane jScrollPane = new JScrollPane(innerPanel, 22, 30);
        jScrollPane.setBorder(null);
        jScrollPane.getViewport().setBackground(Color.WHITE);
        jScrollPane.getViewport().putClientProperty("substancelaf.colorizationFactor", 1.0);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)jScrollPane, "Center");
        this.panel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                RConsoleComponent.this.updateConsoleWidth(false);
            }
        });
    }

    protected abstract void addCommandListener(Command var1);

    protected void openObject(RObject rObject) {
        boolean bl = false;
        bl = this.isBrowse() ? R.client().isDebugEnvObject(rObject.getName(false)) : R.client().isGlobalObject(rObject.getFullName());
        if (bl) {
            new ItemName(Apps.R.getId(), rObject.getFullName()).requestFocus();
        } else {
            Rflow.mainView().openViewAtDefaultObjectPane(new RObjectViewer(R.getInterface(), rObject), ViewOpenType.OPEN_NEW, true);
        }
    }

    private void updateConsoleWidth(boolean bl) {
        if (!R.client().isConnected()) {
            return;
        }
        int n = this.output.getConsoleWidth();
        if (n < 10) {
            n = 10;
        } else if (n > 10000) {
            n = 10000;
        }
        if (n == this.lastWidth) {
            return;
        }
        this.lastWidth = n;
        if (bl) {
            R.client().setConsoleWidth(this.lastWidth);
        } else {
            R.queryQueue().addQuery(() -> R.client().setConsoleWidth(this.lastWidth));
        }
    }

    @Override
    public void init(boolean bl) {
        super.init(bl);
        this.output.init(bl);
        if (bl) {
            SwingUtilities.invokeLater(() -> this.clearConsole());
        }
    }

    @Override
    public void initR(boolean bl) {
        super.initR(bl);
        this.updateConsoleWidth(true);
    }

    @Override
    protected void clearPrompt() {
        super.clearPrompt();
        SwingUtilities.invokeLater(() -> this.output.clearPrompt());
    }

    public Component getComponent() {
        return this.panel;
    }

    public void requestFocusOnInput() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RConsoleComponent.this.input.requestFocusInWindow();
            }
        });
    }

    public boolean inputHasFocus() {
        return this.input.isFocusOwner();
    }

    public void clearConsole() {
        try {
            Document document = this.output.getDocument();
            int n = document.getLength();
            if (n > 1 && document.getText(n - 2, 2).equals("> ")) {
                n -= 2;
            }
            document.remove(0, n);
            this.output.clearPrompt();
            this.input.getDocument().remove(0, this.input.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            LOGGER.log(Level.WARNING, "Failed to clear R console", badLocationException);
        }
    }

    public void passOutputCaptureCommand() {
    }

    @Override
    protected void processAppend(final String string, final ElementType elementType) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RConsoleComponent.this.output.append(string, elementType);
            }
        });
    }

    private void submitCommand() {
        this.submitCommand(this.input.getText().trim());
        this.input.setText("");
    }

    private void submitCommand(String string) {
        BasicCommand basicCommand = new BasicCommand(string);
        this.addCommandListener(basicCommand);
        this.passCommandToReceiver(basicCommand, true);
    }

    protected void passCommandToReceiver(Command command, boolean bl) {
        this.getReceiver().passCommand(command);
    }

    public String rChooseFile(Rengine rengine, final int n) {
        FutureTask<String> futureTask = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                File file = UIUtility.chooseFileAwt(Rflow.mainFrame(), Messages.getString("Message.select"), n == 0 ? 0 : 1, WorkingDirectory.getWorkingDirectory());
                return file == null ? null : file.getAbsolutePath();
            }
        });
        try {
            SwingUtilities.invokeAndWait(futureTask);
            return futureTask.get();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to choose file.", exception);
            return null;
        }
    }

    public void quitBrowse(boolean bl) {
        if (this.toolbar != null && this.toolbar.getParent() != null || this.errorToolBar != null && this.errorToolBar.getParent() != null) {
            BasicCommand basicCommand = new BasicCommand("Q");
            this.addCommandListener(basicCommand);
            this.passCommandToReceiver(basicCommand, false);
            if (bl) {
                basicCommand.waitForCommand();
            }
        }
    }

    @Override
    public void browseStateChanged(final int n, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (n) {
                    case 0: {
                        if (RConsoleComponent.this.toolbar == null && RConsoleComponent.this.errorToolBar == null) break;
                        RConsoleComponent.this.panel.remove(RConsoleComponent.this.toolbar);
                        RConsoleComponent.this.panel.remove(RConsoleComponent.this.errorToolBar);
                        RConsoleComponent.this.panel.revalidate();
                        break;
                    }
                    case 1: {
                        Component component;
                        if (RConsoleComponent.this.toolbar == null) {
                            RConsoleComponent.this.toolbar = RConsoleComponent.this.createBrowseBar(false);
                        }
                        if (RConsoleComponent.this.errorToolBar == null) {
                            RConsoleComponent.this.errorToolBar = RConsoleComponent.this.createBrowseBar(true);
                        }
                        Component component2 = component = bl ? RConsoleComponent.this.errorToolBar : RConsoleComponent.this.toolbar;
                        if (component.getParent() != null) break;
                        RConsoleComponent.this.debugActions.doAction(bl ? "DEBUG_START_ERROR" : "DEBUG_START");
                        RConsoleComponent.this.panel.add(component, "North");
                        if (RConsoleComponent.this.nButton.isVisible()) {
                            RConsoleComponent.this.nButton.requestFocusInWindow();
                        }
                        RConsoleComponent.this.panel.revalidate();
                        RConsoleComponent.this.output.scrollToBottom();
                    }
                }
            }
        });
    }

    private JToolBar createBrowseBar(boolean bl) {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setFocusable(true);
        jToolBar.add(new JLabel("  " + Messages.getString("Message.debug") + "  "));
        this.debugActions.installActions(jToolBar, true, 1);
        if (bl) {
            JButton jButton = new JButton(this.debugActions.get("CONTINUE"));
            jButton.setText(Messages.getString("Button.quit"));
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(jButton);
            UIUtility.setWidth(100, jPanel);
            jToolBar.add(jPanel);
        } else {
            JPanel jPanel = new JPanel(new GridLayout(1, 3, 0, 10));
            this.nButton = (JButton)jPanel.add(new JButton(this.debugActions.get("NEXT")));
            jPanel.add(new JButton(this.debugActions.get("CONTINUE")));
            jPanel.add(new JButton(this.debugActions.get("QUIT")));
            UIUtility.setWidth(300, jPanel);
            jToolBar.add(jPanel);
            jToolBar.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    RConsoleComponent.this.nButton.requestFocusInWindow();
                }
            });
        }
        return jToolBar;
    }

    private class InputDocumentListener
    implements DocumentListener {
        private InputDocumentListener() {
        }

        private void updateHistoryState(DocumentEvent documentEvent) {
            if (RConsoleComponent.this.histPos < RConsoleComponent.this.commandHistory.size()) {
                try {
                    RConsoleComponent.this.historyScratch = documentEvent.getDocument().getText(0, documentEvent.getLength());
                    RConsoleComponent.this.histPos = RConsoleComponent.this.commandHistory.size();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateHistoryState(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateHistoryState(documentEvent);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    private class DebugActions
    extends Actions {
        private static final String DEBUG_START = "DEBUG_START";
        private static final String DEBUG_START_ERROR = "DEBUG_START_ERROR";
        private static final String NEXT = "NEXT";
        private static final String CONTINUE = "CONTINUE";
        private static final String QUIT = "QUIT";

        public DebugActions() {
            this.put(DEBUG_START, new DebugStart());
            this.put(DEBUG_START_ERROR, new DebugStartError());
            this.put(NEXT, new NextAction());
            this.put(QUIT, new QuitAction());
            this.put(CONTINUE, new ContinueAction());
        }

        private void sendBrowseCommand(String string) {
            BasicCommand basicCommand = new BasicCommand(string);
            RConsoleComponent.this.addCommandListener(basicCommand);
            RConsoleComponent.this.passCommandToReceiver(basicCommand, false);
        }

        private class DebugStart
        extends LoggableAction {
            private DebugStart() {
            }

            @Override
            public void action(ActionEvent actionEvent) {
            }
        }

        private class DebugStartError
        extends LoggableAction {
            private DebugStartError() {
            }

            @Override
            public void action(ActionEvent actionEvent) {
            }
        }

        private class NextAction
        extends LoggableAction {
            public NextAction() {
                this.putValue("Name", Messages.getString("Button.next") + "  (n)");
                this.putValue("MnemonicKey", 78);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                DebugActions.this.sendBrowseCommand("n");
            }
        }

        private class QuitAction
        extends LoggableAction {
            public QuitAction() {
                this.putValue("Name", Messages.getString("Button.quit") + "  (Q)");
                this.putValue("MnemonicKey", 81);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                DebugActions.this.sendBrowseCommand("Q");
            }
        }

        private class ContinueAction
        extends LoggableAction {
            public ContinueAction() {
                this.putValue("Name", Messages.getString("Button.continue") + "  (c)");
                this.putValue("MnemonicKey", 67);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                DebugActions.this.sendBrowseCommand("c");
            }
        }
    }

    private class InputActions
    extends Actions {
        private static final String SUBMIT_COMMAND = "SUBMIT_COMMAND";
        private static final String HISTORY_UP = "HISTORY_UP";
        private static final String HISTORY_DOWN = "HISTORY_DOWN";

        public InputActions() {
            this.put(new Copy());
            this.put(new Run());
            this.put(SUBMIT_COMMAND, new SubmitCommand());
            this.put(HISTORY_UP, new HistoryUp());
            this.put(HISTORY_DOWN, new HistoryDown());
            this.put(new ClearConsole());
            this.put(new Cancel());
            this.put(new PageUp());
            this.put(new PageDown());
        }

        private String getHistory(int n) {
            if (n == RConsoleComponent.this.commandHistory.size()) {
                return RConsoleComponent.this.historyScratch == null ? "" : RConsoleComponent.this.historyScratch;
            }
            return (String)RConsoleComponent.this.commandHistory.get(n);
        }

        private class Copy
        extends LoggableAction {
            public Copy() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (RConsoleComponent.this.output.hasSelection()) {
                    RConsoleComponent.this.output.copy();
                } else {
                    RConsoleComponent.this.input.copy();
                }
            }
        }

        private class Run
        extends LoggableAction {
            public Run() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (RConsoleComponent.this.output.hasSelection()) {
                    RConsoleComponent.this.output.run();
                } else {
                    RConsoleComponent.this.input.run();
                }
            }
        }

        private class SubmitCommand
        extends LoggableAction {
            public SubmitCommand() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                RConsoleComponent.this.submitCommand();
            }
        }

        private class HistoryUp
        extends LoggableAction {
            public HistoryUp() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (RConsoleComponent.this.histPos == RConsoleComponent.this.commandHistory.size()) {
                    String string = RConsoleComponent.this.input.getText();
                    RConsoleComponent.this.historyScratch = string;
                }
                RConsoleComponent.this.input.getDocument().removeDocumentListener((DocumentListener)RConsoleComponent.this.inputDocumentListener);
                if (--RConsoleComponent.this.histPos < 0) {
                    RConsoleComponent.this.histPos = 0;
                    RConsoleComponent.this.input.setText("");
                } else {
                    RConsoleComponent.this.input.setText(InputActions.this.getHistory(RConsoleComponent.this.histPos));
                }
                RConsoleComponent.this.input.getDocument().addDocumentListener((DocumentListener)RConsoleComponent.this.inputDocumentListener);
            }
        }

        private class HistoryDown
        extends LoggableAction {
            public HistoryDown() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (++RConsoleComponent.this.histPos > RConsoleComponent.this.commandHistory.size()) {
                    RConsoleComponent.this.histPos = RConsoleComponent.this.commandHistory.size();
                } else {
                    RConsoleComponent.this.input.getDocument().removeDocumentListener((DocumentListener)RConsoleComponent.this.inputDocumentListener);
                    RConsoleComponent.this.input.setText(InputActions.this.getHistory(RConsoleComponent.this.histPos));
                    RConsoleComponent.this.input.getDocument().addDocumentListener((DocumentListener)RConsoleComponent.this.inputDocumentListener);
                }
            }
        }

        private class ClearConsole
        extends LoggableAction {
            public ClearConsole() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                RConsoleComponent.this.output.clear();
            }
        }

        private class Cancel
        extends LoggableAction {
            public Cancel() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (RConsoleComponent.this.isBusy() || RConsoleComponent.this.isBusyWaitingForInput() || RConsoleComponent.this.isContinue()) {
                    RConsoleComponent.this.stop(false);
                } else {
                    if (RConsoleComponent.this.input.getDocument().getLength() == 0) {
                        return;
                    }
                    RConsoleComponent.this.input.clear();
                }
            }
        }

        private class PageUp
        extends AbstractAction {
            public PageUp() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(33, 0));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JViewport jViewport = (JViewport)RConsoleComponent.this.input.getParent().getParent();
                Rectangle rectangle = jViewport.getViewRect();
                jViewport.setViewPosition(new Point(rectangle.x, rectangle.y - rectangle.height));
            }
        }

        private class PageDown
        extends AbstractAction {
            public PageDown() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(34, 0));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JViewport jViewport = (JViewport)RConsoleComponent.this.input.getParent().getParent();
                Rectangle rectangle = jViewport.getViewRect();
                jViewport.setViewPosition(new Point(rectangle.x, rectangle.y + rectangle.height));
            }
        }
    }

    private static class InnerPanel
    extends JPanel
    implements Scrollable {
        private JComponent output;
        private JComponent input;

        public InnerPanel(JComponent jComponent, JComponent jComponent2) {
            super(new BorderLayout());
            this.output = jComponent;
            this.input = jComponent2;
            this.add((Component)jComponent, "North");
            this.add((Component)jComponent2, "Center");
            this.setBackground(Color.WHITE);
            this.putClientProperty("substancelaf.colorizationFactor", 1.0);
        }

        @Override
        public Dimension getPreferredSize() {
            Container container = this.getParent();
            Dimension dimension = this.output.getPreferredSize();
            Dimension dimension2 = this.input.getPreferredSize();
            return new Dimension(Math.max(container.getWidth(), dimension.width), Math.max(container.getHeight(), dimension.height + dimension2.height));
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 50;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return n == 1 ? rectangle.height : rectangle.width;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

