/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.console;

import com.ef_prime.rflow.core.app.r.console.RConsole;
import com.ef_prime.rflow.core.app.r.script.RSyntaxDocumentWithIndentChanged;
import com.ef_prime.rflow.ui.app.r.console.RConsoleOutput;
import com.ef_prime.rflow.ui.app.r.script.RCodingTextArea;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import org.apache.commons.lang3.StringUtils;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;

public class RConsoleInput
extends RCodingTextArea {
    private static final Logger LOGGER = Logger.getLogger(RConsoleInput.class.getName());
    private RConsole console;
    private RConsoleOutput output;
    private String prompt = null;
    private int promptLineCount = 0;

    public RConsoleInput(RConsole rConsole, RConsoleOutput rConsoleOutput) {
        this.console = rConsole;
        this.output = rConsoleOutput;
        this.setSimplePopup(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 20, 3));
        this.startAutoCompletionNotifier();
        this.setMarkOccurrences(false);
        this.setMarkOccurrenceAfterFocus(false);
        this.setNavigationFilter(new PromptNavigationFilter());
        this.getDocument().setDocumentFilter((DocumentFilter)new PromptDocumentFilter());
        this.setHighlightCurrentLine(false);
        Handler handler = new Handler();
        this.addMouseListener(handler);
        this.getDocument().addDocumentListener((DocumentListener)handler);
        this.getInputMap().put(KeyStroke.getKeyStroke(33, 0), null);
    }

    public RConsoleOutput getOutput() {
        return this.output;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(graphics2D);
    }

    protected Document createDefaultModel() {
        return new RSyntaxDocumentWithIndentChanged("text/plain"){
            private TokenImpl promptToken;
            {
                this.promptToken = new TokenImpl();
            }

            public Token processGetTokenListForLine(int n) {
                if (RConsoleInput.this.prompt != null && RConsoleInput.this.prompt.length() > 0 && n < RConsoleInput.this.promptLineCount) {
                    Object object;
                    Object object2 = RConsoleInput.this.prompt;
                    if (RConsoleInput.this.promptLineCount <= 1) {
                        object2 = RConsoleInput.this.prompt;
                    } else {
                        object = RConsoleInput.this.prompt.split("\n");
                        if (n < ((String[])object).length) {
                            object2 = object[n];
                        } else {
                            return super.processGetTokenListForLine(n);
                        }
                    }
                    object = this.getDefaultRootElement().getElement(n);
                    int n2 = object.getStartOffset() + ((String)object2).length();
                    int n3 = object.getEndOffset() - 1;
                    this.promptToken.set(((String)object2).toCharArray(), 0, ((String)object2).length() - 1, object.getStartOffset(), 40);
                    if (n3 - n2 >= 0) {
                        try {
                            this.getText(n2, n3 - n2, this.s);
                        }
                        catch (BadLocationException badLocationException) {
                            LOGGER.log(Level.WARNING, "Failed to retrieve text.", badLocationException);
                            return null;
                        }
                        int n4 = 0;
                        n4 = n == 0 ? (RConsoleInput.this.console.isContinue() ? RConsoleInput.this.console.getLastToken() : 0) : this.getLastTokenTypeOnLine(n - 1);
                        Token token = this.tokenMaker.getTokenList(this.s, n4, n2);
                        this.promptToken.setNextToken(token);
                    } else {
                        this.promptToken.setNextToken((Token)new TokenImpl());
                    }
                    return this.promptToken;
                }
                return super.processGetTokenListForLine(n);
            }
        };
    }

    public String getText() {
        if (this.prompt != null) {
            try {
                RSyntaxDocument rSyntaxDocument = this.getDocument();
                return rSyntaxDocument.getText(this.prompt.length(), rSyntaxDocument.getLength() - this.prompt.length());
            }
            catch (BadLocationException badLocationException) {
                LOGGER.log(Level.WARNING, "Invalid console input state: document length " + this.getDocument().getLength() + ", prompt length " + this.prompt.length(), badLocationException);
                return "";
            }
        }
        return super.getText();
    }

    public String getText(int n, int n2) throws BadLocationException {
        int n3;
        if (this.prompt != null && (n3 = this.prompt.length() - n) > 0) {
            String string = n2 - n3 <= 0 ? "" : super.getText(this.prompt.length(), n2 - n3);
            return StringUtils.leftPad((String)string, (int)n2);
        }
        return super.getText(n, n2);
    }

    @Override
    public void setText(String string) {
        if (this.prompt != null) {
            try {
                RSyntaxDocument rSyntaxDocument = this.getDocument();
                rSyntaxDocument.replace(this.prompt.length(), rSyntaxDocument.getLength() - this.prompt.length(), string, null);
            }
            catch (BadLocationException badLocationException) {}
        } else {
            super.setText(string);
        }
    }

    public void setPrompt(String string) {
        try {
            if (this.prompt == null) {
                this.getDocument().insertString(0, string, null);
            } else {
                int n = this.prompt.length();
                this.prompt = null;
                this.getDocument().replace(0, n, string, null);
            }
        }
        catch (BadLocationException badLocationException) {
            LOGGER.log(Level.WARNING, "Set prompt of R Console Input Failed.", badLocationException);
        }
        this.prompt = string;
        this.promptLineCount = string == null ? 0 : StringUtils.countMatches((CharSequence)string, (CharSequence)"\n") + 1;
        this.getDocument().updateSyntaxHighlightingInformation();
    }

    public void clear() {
        try {
            int n = 0;
            int n2 = this.getDocument().getLength();
            if (this.prompt != null) {
                n = this.prompt.length();
                if ((n2 -= this.prompt.length()) < 0) {
                    return;
                }
            }
            this.getDocument().remove(n, n2);
        }
        catch (BadLocationException badLocationException) {
            LOGGER.log(Level.WARNING, "Clear R Console Input Failed.", badLocationException);
        }
    }

    public void clearSelection() {
        this.setStopCaretScroll(true);
        this.getCaret().setDot(this.getCaret().getDot());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RConsoleInput.this.setStopCaretScroll(false);
            }
        });
    }

    public void run() {
        this.getActionMap().get("CodingTextArea.RUN").actionPerformed(new ActionEvent(this, 1001, ""));
    }

    private class PromptNavigationFilter
    extends NavigationFilter {
        private PromptNavigationFilter() {
        }

        @Override
        public void setDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
            if (RConsoleInput.this.prompt != null && n < RConsoleInput.this.prompt.length()) {
                filterBypass.setDot(RConsoleInput.this.prompt.length(), bias);
            } else {
                filterBypass.setDot(n, bias);
            }
        }

        @Override
        public void moveDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
            if (RConsoleInput.this.prompt != null && n < RConsoleInput.this.prompt.length()) {
                filterBypass.moveDot(RConsoleInput.this.prompt.length(), bias);
            } else {
                filterBypass.moveDot(n, bias);
            }
        }
    }

    private class PromptDocumentFilter
    extends DocumentFilter {
        private PromptDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (RConsoleInput.this.prompt == null || n >= RConsoleInput.this.prompt.length()) {
                filterBypass.insertString(n, string, attributeSet);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (RConsoleInput.this.prompt == null || n >= RConsoleInput.this.prompt.length()) {
                filterBypass.replace(n, n2, string, attributeSet);
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            if (RConsoleInput.this.prompt == null || n >= RConsoleInput.this.prompt.length()) {
                filterBypass.remove(n, n2);
            }
        }
    }

    private class Handler
    implements MouseListener,
    DocumentListener {
        private Handler() {
        }

        private void clearOutputSelection() {
            RConsoleInput.this.getOutput().clearSelection();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.clearOutputSelection();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.clearOutputSelection();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.clearOutputSelection();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.clearOutputSelection();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

