/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.console;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.console.ElementType;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.console.RConsoleInput;
import com.ef_prime.rflow.ui.base.UIColor;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.util.FontSupport;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;
import javax.swing.text.View;

public abstract class RConsoleOutput
extends JTextPane
implements MouseListener,
ValueChangeEventHandler {
    private static final Logger LOGGER = Logger.getLogger(RConsoleOutput.class.getName());
    private static final Color COLOR_OUTPUT = UIColor.OUTPUT_BACKGROUND;
    private static final Color COLOR_ERROR = UIColor.ERROR_BACKGROUND;
    private static final Color COLOR_INFO = UIColor.INFO_BACKGROUND;
    private static final String NAME_OUTPUT = "OUTPUT";
    private static final String NAME_ERROR = "ERROR";
    private static final String NAME_INFO = "INFO";
    private static final String NAME_PROMPT = "PROMPT";
    private static final MutableAttributeSet SIMPLE_ATTR = new SimpleAttributeSet();
    private static final MutableAttributeSet INPUT_ATTR = new SimpleAttributeSet();
    private static final MutableAttributeSet PROMPT_ATTR;
    private static final MutableAttributeSet OUTPUT_ATTR;
    private static final MutableAttributeSet ERROR_ATTR;
    private static final MutableAttributeSet INFO_ATTR;
    private static final MutableAttributeSet COMMENT;
    private static final MutableAttributeSet RESERVED_WORD;
    private static final MutableAttributeSet FUNCTION;
    private static final MutableAttributeSet LITERAL_BOOLEAN;
    private static final MutableAttributeSet LITERAL_NUMBER_DECIMAL_INT;
    private static final MutableAttributeSet LITERAL_CHAR;
    private static final MutableAttributeSet IDENTIFIER;
    private static final MutableAttributeSet SEPARATOR;
    private static final MutableAttributeSet OPERATOR;
    private static final MutableAttributeSet ERROR_IDENTIFIER;
    protected int max_char = 65000;
    protected float lineSpacing;
    protected TabSet tabSet;
    private String prompt = null;
    private boolean anyPrompt = false;
    private final float normalPromptWidth;
    private boolean cursorInSelection;
    private OutputActions actions = new OutputActions();

    public RConsoleOutput() {
        this.setOpaque(false);
        this.setFont(FontSupport.getCodeFont());
        this.setEditable(false);
        this.setFocusable(false);
        this.setCaret(new RConsoleOutputCaret());
        this.getCaret().setSelectionVisible(true);
        UIUtility.setTabs(this, this.getFont(), 4);
        UIUtility.insertMouseListener(this, this);
        this.actions.installActions(this, false, 0);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.charWidth('R');
        this.normalPromptWidth = (float)n * 2.0f;
        this.max_char = Rflow.settings().getValue(Settings.CONSOLE_MAX_CHARS);
        this.lineSpacing = Rflow.settings().getValue(Settings.CONSOLE_LINE_SPACING).floatValue();
        Rflow.settings().addEventHandler(this);
    }

    public void init(boolean bl) {
        if (bl) {
            this.anyPrompt = false;
        }
    }

    protected abstract void submitCommand(String var1);

    protected abstract RConsoleInput getInput();

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Document document = this.getDocument();
        if (document.getLength() == 0) {
            return new Dimension(dimension.width, this.getInsets().top);
        }
        try {
            char c = document.getText(document.getLength() - 1, 1).charAt(0);
            if (c == '\n') {
                int n = this.getFontMetrics(this.getFont()).getHeight();
                n = (int)((float)n + ((float)n * this.lineSpacing + (float)this.getMargin().bottom));
                return new Dimension(dimension.width, dimension.height - n);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return dimension;
    }

    public int getConsoleWidth() {
        int n = this.getFontMetrics(this.getFont()).charWidth('R');
        int n2 = (this.getVisibleRect().width - (int)this.normalPromptWidth) / n - 1;
        return n2;
    }

    public void scrollToBottom() {
        Container container = this.getParent();
        if (container instanceof JComponent) {
            ((JComponent)container).scrollRectToVisible(new Rectangle(0, this.getParent().getPreferredSize().height, 0, 0));
        }
    }

    public void updateStyles() {
        this.tabSet = UIUtility.createTabSet(this, this.getFont(), 6);
        Element element = this.getDocument().getDefaultRootElement();
        SimpleAttributeSet simpleAttributeSet = this.createDefaultAttibuteSet();
        for (int i = 0; i < element.getElementCount(); ++i) {
            Element element2 = element.getElement(i);
            this.getStyledDocument().setParagraphAttributes(element2.getStartOffset(), 0, simpleAttributeSet, false);
        }
    }

    public void clear() {
        try {
            this.getDocument().remove(0, this.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void clearPrompt() {
        this.prompt = null;
        if (this.getInput() != null) {
            this.getInput().setPrompt(null);
        }
    }

    public void clearSelection() {
        this.getCaret().setSelectionVisible(false);
    }

    public boolean hasSelection() {
        return this.getCaret().isSelectionVisible() && this.getSelectionStart() != this.getSelectionEnd();
    }

    public void run() {
        this.run(this.getSelectionWithoutPrompt());
    }

    private void run(String string) {
        if (string != null && !string.isEmpty()) {
            this.submitCommand(string);
        }
    }

    private String getSelectionWithoutPrompt() {
        int n;
        int n2 = this.getSelectionStart();
        if (n2 == (n = this.getSelectionEnd())) {
            n2 = n = this.getCaretPosition();
        }
        Element element = this.getDocument().getDefaultRootElement();
        int n3 = element.getElementIndex(n2);
        int n4 = element.getElementIndex(n);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = n2 == n;
        for (int i = n3; i <= n4; ++i) {
            Element element2 = element.getElement(i);
            Element element3 = element2.getElement(0);
            int n5 = element2.getStartOffset();
            int n6 = element2.getEndOffset();
            if (element3.getAttributes().containsAttribute(StyleConstants.NameAttribute, NAME_PROMPT)) {
                n5 = element3.getEndOffset();
            }
            if (!bl && i == n3) {
                n5 = Math.max(n5, n2);
            }
            if (!bl && i == n4) {
                n6 = Math.min(n6, n);
            }
            try {
                stringBuilder.append(this.getText(n5, n6 - n5));
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return stringBuilder.toString();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Document document = this.getDocument();
        Element element = document.getDefaultRootElement();
        Rectangle rectangle = this.getVisibleRect();
        for (int i = 0; i < element.getElementCount(); ++i) {
            Element element2 = element.getElement(i);
            try {
                Rectangle rectangle2 = this.modelToView(element2.getStartOffset());
                Rectangle rectangle3 = this.modelToView(element2.getEndOffset() - 1);
                rectangle2 = rectangle2.union(rectangle3);
                if (rectangle.y > rectangle2.y + rectangle2.height || rectangle.y + rectangle.height < rectangle2.y) continue;
                Element element3 = element2.getElement(0);
                ElementType elementType = ElementType.INPUT;
                Color color = Color.WHITE;
                if (element3.getAttributes().containsAttribute(StyleConstants.NameAttribute, NAME_OUTPUT)) {
                    elementType = ElementType.OUTPUT;
                    color = COLOR_OUTPUT;
                } else if (element3.getAttributes().containsAttribute(StyleConstants.NameAttribute, NAME_ERROR)) {
                    elementType = ElementType.ERROR;
                    color = COLOR_ERROR;
                } else if (element3.getAttributes().containsAttribute(StyleConstants.NameAttribute, NAME_INFO)) {
                    elementType = ElementType.INFO;
                    color = COLOR_INFO;
                }
                Color color2 = graphics.getColor();
                if (!elementType.isInput()) {
                    graphics.setColor(color);
                    graphics.fillRect(rectangle2.x - 5, rectangle2.y, this.getWidth(), rectangle2.height);
                }
                graphics.setColor(color2);
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        super.paintComponent(graphics);
    }

    public void append(String string, ElementType elementType) {
        if (elementType == ElementType.PROMPT) {
            Document document = this.getDocument();
            try {
                char c = document.getText(document.getLength() - 1, 1).charAt(0);
                if (c != '\n') {
                    document.insertString(document.getLength(), "\n", OUTPUT_ATTR);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.anyPrompt = true;
            this.prompt = string;
            if (this.getInput() != null) {
                this.getInput().setPrompt(string);
            }
            this.repaint();
            this.scrollToBottom();
            return;
        }
        MutableAttributeSet mutableAttributeSet = SIMPLE_ATTR;
        switch (elementType) {
            case INPUT: {
                mutableAttributeSet = INPUT_ATTR;
                break;
            }
            case OUTPUT: {
                if (!this.anyPrompt) break;
                mutableAttributeSet = OUTPUT_ATTR;
                break;
            }
            case ERROR: {
                mutableAttributeSet = ERROR_ATTR;
                break;
            }
            case INFO: {
                mutableAttributeSet = INFO_ATTR;
                break;
            }
            case COMMENT_EOL: {
                mutableAttributeSet = COMMENT;
                break;
            }
            case ERROR_IDENTIFIER: {
                mutableAttributeSet = ERROR_IDENTIFIER;
                break;
            }
            case FUNCTION: {
                mutableAttributeSet = FUNCTION;
                break;
            }
            case IDENTIFIER: {
                mutableAttributeSet = IDENTIFIER;
                break;
            }
            case LITERAL_BOOLEAN: {
                mutableAttributeSet = LITERAL_BOOLEAN;
                break;
            }
            case LITERAL_CHAR: {
                mutableAttributeSet = LITERAL_CHAR;
                break;
            }
            case LITERAL_NUMBER_DECIMAL_INT: {
                mutableAttributeSet = LITERAL_NUMBER_DECIMAL_INT;
                break;
            }
            case OPERATOR: {
                mutableAttributeSet = OPERATOR;
                break;
            }
            case RESERVED_WORD: {
                mutableAttributeSet = RESERVED_WORD;
                break;
            }
            case SEPARATOR: {
                mutableAttributeSet = SEPARATOR;
                break;
            }
            case WHITESPACE: {
                mutableAttributeSet = INPUT_ATTR;
                break;
            }
        }
        Document document = this.getDocument();
        if (this.prompt != null && !this.prompt.isEmpty() && elementType != ElementType.INFO) {
            Serializable serializable;
            if (this.prompt.charAt(this.prompt.length() - 1) == ' ') {
                serializable = new StringBuilder(this.prompt);
                ((StringBuilder)serializable).setCharAt(((StringBuilder)serializable).length() - 1, '\u00a0');
                for (int i = ((StringBuilder)serializable).length() - 2; i >= 0 && ((StringBuilder)serializable).charAt(i) == ' '; --i) {
                    ((StringBuilder)serializable).setCharAt(i, '\u00a0');
                }
                this.prompt = ((StringBuilder)serializable).toString();
            }
            try {
                document.insertString(document.getLength(), this.prompt, PROMPT_ATTR);
            }
            catch (BadLocationException badLocationException) {
                LOGGER.log(Level.SEVERE, "Failed to insert prompt", badLocationException);
            }
            serializable = this.createDefaultAttibuteSet();
            ((SimpleAttributeSet)serializable).addAttribute(StyleConstants.LeftIndent, Float.valueOf(0.0f));
            this.getStyledDocument().setParagraphAttributes(document.getLength() - this.prompt.length(), 0, (AttributeSet)((Object)serializable), true);
        }
        if (elementType != ElementType.INFO) {
            this.clearPrompt();
        }
        int n = document.getEndPosition().getOffset() - 1;
        try {
            document.insertString(document.getLength(), string, mutableAttributeSet);
        }
        catch (BadLocationException badLocationException) {
            LOGGER.log(Level.SEVERE, "Failed to insert string", badLocationException);
        }
        if (!elementType.isInput() && this.anyPrompt) {
            Element element;
            Element element2 = document.getDefaultRootElement();
            for (int i = element2.getElementCount() - 1; i >= 0 && (element = element2.getElement(i)).getEndOffset() > n; --i) {
                SimpleAttributeSet simpleAttributeSet = this.createDefaultAttibuteSet();
                simpleAttributeSet.addAttribute(StyleConstants.LeftIndent, Float.valueOf(this.normalPromptWidth));
                this.getStyledDocument().setParagraphAttributes(element.getStartOffset(), 0, simpleAttributeSet, true);
            }
        }
        if (document.getLength() > this.max_char) {
            int n2 = document.getLength() - this.max_char;
            try {
                String string2 = document.getText(0, document.getLength());
                int n3 = string2.indexOf("\n", n2) + 1;
                if (n3 > 0) {
                    document.remove(0, n3);
                }
            }
            catch (BadLocationException badLocationException) {
                LOGGER.log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
            }
        }
        this.setCaretPosition(document.getLength());
    }

    private SimpleAttributeSet createDefaultAttibuteSet() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute(StyleConstants.FontFamily, this.getFont().getFamily());
        simpleAttributeSet.addAttribute(StyleConstants.FontSize, this.getFont().getSize());
        simpleAttributeSet.addAttribute(StyleConstants.LineSpacing, Float.valueOf(this.lineSpacing));
        return simpleAttributeSet;
    }

    @Override
    public void copy() {
        this.actions.doAction("COPY");
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        if (UIUtility.isRightMouseButton(mouseEvent) && (n = this.viewToModel(mouseEvent.getPoint())) >= 0 && this.getSelectionStart() == this.getSelectionEnd()) {
            this.setCaretPosition(n);
        }
        n = this.viewToModel(mouseEvent.getPoint());
        this.cursorInSelection = this.getSelectionStart() != this.getSelectionEnd() && n >= this.getSelectionStart() && n <= this.getSelectionEnd();
        this.getCaret().setSelectionVisible(true);
        RConsoleInput rConsoleInput = this.getInput();
        if (rConsoleInput != null) {
            rConsoleInput.clearSelection();
            rConsoleInput.requestFocusInWindow();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (UIUtility.isRightMouseButton(mouseEvent)) {
            this.createPopup().show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        } else if (UIUtility.isLeftMouseButton(mouseEvent) && (n = this.viewToModel(mouseEvent.getPoint())) >= 0 && !this.cursorInSelection && this.getSelectionStart() == this.getSelectionEnd()) {
            Element element = this.getDocument().getDefaultRootElement();
            int n2 = element.getElementIndex(n);
            Element element2 = element.getElement(n2);
            int n3 = element2.getStartOffset();
            int n4 = element2.getEndOffset();
            try {
                String string = this.getText(n4 - 1, 1);
                if (string.equals("\n")) {
                    --n4;
                }
                this.select(n3, n4);
                mouseEvent.consume();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private JPopupMenu createPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.actions.get("RUN"));
        jPopupMenu.add(this.actions.get("COPY"));
        jPopupMenu.add(this.actions.get("COPY_WITH_PROMPT"));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.actions.get("CLEAR_CONSOLE"));
        return jPopupMenu;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        if (Settings.CONSOLE_MAX_CHARS.equals(valueChangeEvent.getKey())) {
            this.max_char = Rflow.settings().getValue(Settings.CONSOLE_MAX_CHARS);
        } else if (Settings.CONSOLE_LINE_SPACING.equals(valueChangeEvent.getKey())) {
            this.lineSpacing = Rflow.settings().getValue(Settings.CONSOLE_LINE_SPACING).floatValue();
            this.updateStyles();
        }
    }

    static {
        StyleConstants.setForeground(INPUT_ATTR, Color.RED);
        PROMPT_ATTR = new SimpleAttributeSet();
        StyleConstants.setForeground(PROMPT_ATTR, Color.RED);
        PROMPT_ATTR.addAttribute(StyleConstants.NameAttribute, NAME_PROMPT);
        OUTPUT_ATTR = new SimpleAttributeSet();
        StyleConstants.setForeground(OUTPUT_ATTR, new Color(0, 0, 128));
        OUTPUT_ATTR.addAttribute(StyleConstants.NameAttribute, NAME_OUTPUT);
        ERROR_ATTR = new SimpleAttributeSet();
        ERROR_ATTR.addAttribute(StyleConstants.NameAttribute, NAME_ERROR);
        INFO_ATTR = new SimpleAttributeSet();
        INFO_ATTR.addAttribute(StyleConstants.NameAttribute, NAME_INFO);
        COMMENT = new SimpleAttributeSet();
        StyleConstants.setForeground(COMMENT, new Color(0, 128, 0));
        RESERVED_WORD = new SimpleAttributeSet();
        StyleConstants.setForeground(RESERVED_WORD, Color.BLUE);
        StyleConstants.setBold(RESERVED_WORD, true);
        FUNCTION = new SimpleAttributeSet();
        StyleConstants.setForeground(FUNCTION, new Color(173, 128, 0));
        LITERAL_BOOLEAN = new SimpleAttributeSet();
        StyleConstants.setForeground(LITERAL_BOOLEAN, new Color(100, 0, 200));
        LITERAL_NUMBER_DECIMAL_INT = new SimpleAttributeSet();
        StyleConstants.setForeground(LITERAL_NUMBER_DECIMAL_INT, new Color(100, 0, 200));
        LITERAL_CHAR = new SimpleAttributeSet();
        StyleConstants.setForeground(LITERAL_CHAR, new Color(220, 0, 156));
        IDENTIFIER = new SimpleAttributeSet();
        SEPARATOR = new SimpleAttributeSet();
        StyleConstants.setForeground(SEPARATOR, Color.RED);
        OPERATOR = new SimpleAttributeSet();
        StyleConstants.setForeground(OPERATOR, new Color(128, 64, 64));
        ERROR_IDENTIFIER = new SimpleAttributeSet();
        StyleConstants.setForeground(ERROR_IDENTIFIER, new Color(148, 148, 0));
    }

    private class OutputActions
    extends Actions {
        static final String RUN = "RUN";
        static final String COPY = "COPY";
        static final String COPY_WITH_PROMPT = "COPY_WITH_PROMPT";
        static final String CLEAR_CONSOLE = "CLEAR_CONSOLE";

        OutputActions() {
            this.put(RUN, new Run());
            this.put(COPY, new Copy());
            this.put(COPY_WITH_PROMPT, new CopyWithPrompt());
            this.put(CLEAR_CONSOLE, new ClearConsole());
        }

        private class Run
        extends LoggableAction {
            public Run() {
                this.putValue("Name", Messages.getString("Action.run"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                String string = RConsoleOutput.this.getSelectionWithoutPrompt();
                if (!string.isEmpty()) {
                    RConsoleOutput.this.run(string);
                }
            }
        }

        private class Copy
        extends LoggableAction {
            public Copy() {
                this.putValue("Name", Messages.getString("Action.copy"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                String string = RConsoleOutput.this.getSelectionWithoutPrompt();
                if (!string.isEmpty()) {
                    UIUtility.copyToClipboard(string);
                }
            }
        }

        private class CopyWithPrompt
        extends LoggableAction {
            CopyWithPrompt() {
                this.putValue("Name", Messages.getString("Action.copy_with_prompt"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                int n;
                int n2 = RConsoleOutput.this.getSelectionStart();
                if (n2 == (n = RConsoleOutput.this.getSelectionEnd())) {
                    n2 = n = RConsoleOutput.this.getCaretPosition();
                }
                Element element = RConsoleOutput.this.getDocument().getDefaultRootElement();
                int n3 = element.getElementIndex(n2);
                int n4 = element.getElementIndex(n);
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = n3; i <= n4; ++i) {
                    Element element2 = element.getElement(i);
                    Element element3 = element2.getElement(0);
                    int n5 = element2.getStartOffset();
                    try {
                        if (element3.getAttributes().containsAttribute(StyleConstants.NameAttribute, RConsoleOutput.NAME_PROMPT)) {
                            String string = RConsoleOutput.this.getText(element3.getStartOffset(), element3.getEndOffset() - element3.getStartOffset());
                            if (string.charAt(string.length() - 1) == '\u00a0') {
                                StringBuilder stringBuilder2 = new StringBuilder(string);
                                stringBuilder2.setCharAt(stringBuilder2.length() - 1, ' ');
                                for (int j = stringBuilder2.length() - 2; j >= 0 && stringBuilder2.charAt(j) == '\u00a0'; --j) {
                                    stringBuilder2.setCharAt(j, ' ');
                                }
                                string = stringBuilder2.toString();
                            }
                            stringBuilder.append(string);
                            n5 = element3.getEndOffset();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    try {
                        stringBuilder.append(RConsoleOutput.this.getText(n5, element2.getEndOffset() - n5));
                        continue;
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                if (stringBuilder.length() > 0) {
                    UIUtility.copyToClipboard(stringBuilder.toString());
                }
            }
        }

        private class ClearConsole
        extends LoggableAction {
            public ClearConsole() {
                this.putValue("Name", Messages.getString("Action.clear_console"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                RConsoleOutput.this.clear();
            }
        }
    }

    private static class RConsoleOutputCaret
    extends DefaultCaret {
        private RConsoleOutputCaret() {
        }

        @Override
        protected Highlighter.HighlightPainter getSelectionPainter() {
            return new RConsoleOutputHighlightPainter(null);
        }

        private static class RConsoleOutputHighlightPainter
        extends DefaultHighlighter.DefaultHighlightPainter {
            public RConsoleOutputHighlightPainter(Color color) {
                super(color);
            }

            @Override
            public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view2) {
                if (view2.getElement().getAttributes().containsAttribute(StyleConstants.NameAttribute, RConsoleOutput.NAME_PROMPT)) {
                    return null;
                }
                return super.paintLayer(graphics, n, n2, shape, jTextComponent, view2);
            }
        }
    }
}

