/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.console;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RSupport;
import com.ef_prime.rflow.core.app.r.console.BusyListener;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandBuildFailedException;
import com.ef_prime.rflow.core.app.r.console.CommandListener;
import com.ef_prime.rflow.core.app.r.console.CommandPack;
import com.ef_prime.rflow.core.app.r.console.CommandPackListener;
import com.ef_prime.rflow.core.app.r.console.CommandUtility;
import com.ef_prime.rflow.core.base.FileEditManager;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.feature.backup.BackupThread;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.task.RCommandTask;
import com.ef_prime.rflow.core.task.TaskQueue;
import com.ef_prime.rflow.core.util.Platform;
import com.ef_prime.rflow.node.base.FreeNodeModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.console.RConsoleComponent;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.ShapeIconFactory;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.flow.FlowExecutor;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import com.ef_prime.rflow.ui.util.FontSupport;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.ActiveViewEvent;
import com.ef_prime.rflow.ui.view.ActiveViewEventHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class RConsoleView
extends RConsoleComponent
implements ValueChangeEventHandler {
    private static final int CANCEL_OPTION = 0;
    private static final int IGNORE_OPTION = 1;
    private static final int IGNORE_ALL_OPTION = 2;
    private static final int DEBUG_OPTION = 3;
    private boolean ignoreAll;
    private ConsoleActions consoleActions;
    private FileEditManager resourceManager;
    private View view;

    public RConsoleView(FileEditManager fileEditManager) {
        this.resourceManager = fileEditManager;
        EventManager.getInstance().registerEventHandler(ActiveViewEvent.class, new ActiveViewListener());
        this.getReceiver().addCommandPackListener(new ConsoleCommandPackListener());
        this.useBuffer = Rflow.settings().getValue(Settings.USE_CONSOLE_BUFFER);
        Rflow.settings().addEventHandler(this);
        this.consoleActions = new ConsoleActions();
        this.consoleActions.installActions((JComponent)((Object)this.input), false, 0);
        this.addBusyListener(this.consoleActions);
    }

    public View getView() {
        if (this.view == null) {
            this.view = new View();
            this.view.setTitle(Messages.getString("View.console"));
            this.view.add(this.getComponent(), "Center");
            this.view.add((Component)this.createToolBar(), "North");
        }
        return this.view;
    }

    private JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar(){

            @Override
            protected JButton createActionComponent(Action action) {
                JButton jButton = super.createActionComponent(action);
                jButton.setFocusable(false);
                return jButton;
            }
        };
        jToolBar.setFloatable(false);
        jToolBar.add(this.consoleActions.get(ConsoleActions.Cancel.class));
        if (!R.client().isEmbedded()) {
            jToolBar.add(this.consoleActions.get(ConsoleActions.DropDown.class));
        }
        return jToolBar;
    }

    @Override
    protected void passCommandToReceiver(Command command, boolean bl) {
        command.setIgnoreError(true);
        command.setCheckError(true);
        command.setNoRecover(true);
        if (!this.isBusyWaitingForInput() && bl) {
            FlowRunOption flowRunOption = FlowRunOption.createRunImmediatelyOption().setFocusResult(true);
            TaskQueue.getInstance().addTask(new RCommandTask(flowRunOption, command));
        } else {
            super.passCommandToReceiver(command, bl);
        }
    }

    @Override
    protected void addCommandListener(Command command) {
        command.addCommandListener(CommandUtility.objectUpdateListener(R.client()));
        if (!this.isBusyWaitingForInput() && !Platform.isMac()) {
            command.addCommandListener(new TrayNotifyCommandListener());
        }
    }

    @Override
    protected void handleCommandBuildFailedException(CommandBuildFailedException commandBuildFailedException) {
        UIUtility.showErrorDialog((Component)Rflow.mainFrame(), commandBuildFailedException.getMessage());
    }

    @Override
    protected boolean errorOccured() {
        if (this.ignoreAll) {
            return false;
        }
        boolean bl = this.browse;
        FlowNode flowNode = null;
        block8: for (FlowModel flowModel : this.resourceManager.getFlowModels()) {
            for (FlowNode flowNode2 : flowModel.getState().getExecutingNode()) {
                if (flowNode2.getModel().isOpenSubflow()) continue;
                flowNode = flowNode2;
                continue block8;
            }
        }
        if (flowNode == null) {
            return false;
        }
        ErrorOptionAction errorOptionAction = new ErrorOptionAction(flowNode, bl);
        try {
            UIUtility.invokeAndWait(errorOptionAction);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
        boolean bl2 = true;
        switch (errorOptionAction.getOption()) {
            case 0: {
                this.cancel(true);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.ignoreAll = true;
                break;
            }
            case 3: {
                bl2 = false;
                this.cancelCommands();
                TaskQueue.getInstance().cancel();
            }
        }
        return bl && !bl2;
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        if (Settings.USE_CONSOLE_BUFFER.equals(valueChangeEvent.getKey())) {
            this.flushBuffer();
            this.useBuffer = Rflow.settings().getValue(Settings.USE_CONSOLE_BUFFER);
        } else if (Settings.CODE_FONT_FAMILY.equals(valueChangeEvent.getKey()) || Settings.CODE_FONT_SIZE.equals(valueChangeEvent.getKey())) {
            this.output.setFont(FontSupport.getCodeFont());
            this.updateStyles();
        }
    }

    private void updateStyles() {
        this.output.updateStyles();
        FontSupport.setCodeFont((Component)((Object)this.input));
    }

    @Override
    public void browseStateChanged(int n, boolean bl) {
        TrayIcon trayIcon;
        super.browseStateChanged(n, bl);
        if (n != 0 && (trayIcon = Rflow.getInstance().getTrayIcon()) != null) {
            this.consoleActions.doAction(ConsoleActions.TrayMessageDebug.class);
            trayIcon.displayMessage("R AnalyticFlow", Messages.getString("Flow.entering_debug_mode"), TrayIcon.MessageType.INFO);
        }
    }

    private class ActiveViewListener
    implements ActiveViewEventHandler {
        private ActiveViewListener() {
        }

        @Override
        public void activeViewChanged(ActiveViewEvent activeViewEvent) {
            if (activeViewEvent.getActiveView() == null || !activeViewEvent.getActiveView().equals(RConsoleView.this.getView())) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RConsoleView.this.input.requestFocusInWindow();
                }
            });
        }
    }

    private class ConsoleCommandPackListener
    implements CommandPackListener {
        private ConsoleCommandPackListener() {
        }

        @Override
        public void commandCanceled(CommandPack commandPack) {
            RConsoleView.this.ignoreAll = false;
        }

        @Override
        public void commandFinished(CommandPack commandPack) {
            RConsoleView.this.ignoreAll = false;
            BackupThread backupThread = Rflow.getInstance().getBackupThread();
            if (backupThread != null) {
                backupThread.doBackup();
            }
        }

        @Override
        public void commandPending(CommandPack commandPack) {
        }

        @Override
        public void commandStart(CommandPack commandPack) {
        }

        @Override
        public void errorOccurred(CommandPack commandPack) {
        }

        @Override
        public void commandDiscarded(CommandPack commandPack) {
        }
    }

    private class ConsoleActions
    extends Actions
    implements BusyListener {
        private Icon cancelEnabled;
        private Icon cancelDisabled;
        private Icon cancelDisabled2;

        public ConsoleActions() {
            this.put(new TrayMessage());
            this.put(new TrayMessageDebug());
            this.put(new NewNode());
            this.put(new Cancel());
            this.put(new DropDown());
            this.cancelEnabled = Icons.getIcon("16/stop.png");
            this.cancelDisabled = UIManager.getLookAndFeel().getDisabledSelectedIcon(null, this.cancelEnabled);
            this.cancelDisabled2 = new ImageIcon(GrayFilter.createDisabledImage(Icons.getImage("16/stop.png")));
            this.get(Cancel.class).putValue("SmallIcon", this.cancelDisabled);
        }

        @Override
        public void busyStateChanged(int n) {
            Icon icon = RConsoleView.this.isBusy() ? this.cancelEnabled : (RSupport.supportsInputCancel() ? this.cancelDisabled : this.cancelDisabled2);
            this.get(Cancel.class).putValue("SmallIcon", icon);
        }

        private class TrayMessage
        extends LoggableAction {
            private TrayMessage() {
            }

            @Override
            public void action(ActionEvent actionEvent) {
            }
        }

        private class TrayMessageDebug
        extends LoggableAction {
            private TrayMessageDebug() {
            }

            @Override
            public void action(ActionEvent actionEvent) {
            }
        }

        private class NewNode
        extends LoggableAction {
            public NewNode() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                boolean bl;
                FlowViewer flowViewer = Rflow.mainView().getActiveFlowViewer();
                if (flowViewer == null) {
                    return;
                }
                String string = RConsoleView.this.input.getText().trim();
                RConsoleView.this.input.setText("");
                boolean bl2 = bl = string.length() < 1 && RConsoleView.this.histPos == RConsoleView.this.commandHistory.size();
                if (bl) {
                    string = (String)RConsoleView.this.commandHistory.get(RConsoleView.this.histPos - 1);
                }
                FreeNodeModel freeNodeModel = new FreeNodeModel(string);
                flowViewer.addNode(new FlowNode(freeNodeModel), null, true);
                if (!bl) {
                    RConsoleView.this.addToHistory(string);
                }
            }
        }

        private class Cancel
        extends LoggableAction {
            public Cancel() {
                this.putValue("ShortDescription", Messages.getString("Action.interrupt_r"));
                this.putValue("SmallIcon", Icons.getIcon("16/stop.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                RConsoleView.this.stop(false);
            }
        }

        private class DropDown
        extends LoggableAction {
            public DropDown() {
                Icon icon = ShapeIconFactory.create(3, 8, Color.DARK_GRAY);
                this.putValue("SmallIcon", icon);
                this.putValue("SwingLargeIconKey", icon);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                Component component = (Component)actionEvent.getSource();
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(Rflow.getInstance().getActions().get("R_RESTART"));
                jPopupMenu.show(component, 0, component.getHeight());
            }
        }
    }

    private class TrayNotifyCommandListener
    implements CommandListener {
        private long startTime;

        private TrayNotifyCommandListener() {
        }

        @Override
        public void commandStart(Command command) {
            this.startTime = System.currentTimeMillis();
        }

        @Override
        public void commandFinished(Command command) {
            this.done();
        }

        @Override
        public void commandCanceled(Command command) {
        }

        @Override
        public void errorOccurred(Command command) {
        }

        @Override
        public void commandDiscarded(Command command) {
        }

        private void done() {
            long l;
            TrayIcon trayIcon = Rflow.getInstance().getTrayIcon();
            if (trayIcon == null) {
                return;
            }
            long l2 = System.currentTimeMillis();
            if (l2 - this.startTime > (l = Rflow.settings().getValue(Settings.CONSOLE_NOTIFY_TIME).longValue())) {
                RConsoleView.this.consoleActions.doAction(ConsoleActions.TrayMessage.class);
                trayIcon.displayMessage("R AnalyticFlow", FlowExecutor.doneMesssage(this.startTime, l2), TrayIcon.MessageType.INFO);
            }
        }
    }

    private class ErrorOptionAction
    implements Runnable {
        private FlowNode errorNode;
        private boolean isBrowse;
        private int option = 0;

        public ErrorOptionAction(FlowNode flowNode, boolean bl) {
            this.errorNode = flowNode;
            this.isBrowse = bl;
        }

        public int getOption() {
            return this.option;
        }

        @Override
        public void run() {
            int n;
            JOptionPane jOptionPane = new JOptionPane(Messages.getString("Message.node_name") + " : " + this.errorNode.getTitle() + "\n" + Messages.getString("Message.error_occurred"), 0);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(Messages.getString("Button.stop"));
            arrayList.add(Messages.getString("Button.ignore"));
            arrayList.add(Messages.getString("Button.ignore_all"));
            if (this.isBrowse) {
                arrayList.add(Messages.getString("Button.debug"));
            }
            jOptionPane.setOptions(arrayList.toArray(new String[0]));
            JDialog jDialog = jOptionPane.createDialog(Rflow.getInstance().getMainFrame(), Messages.getString("Error.title.error"));
            jDialog.setVisible(true);
            jDialog.dispose();
            String string = (String)jOptionPane.getValue();
            if (string == null) {
                n = 0;
            } else {
                for (n = 0; n < arrayList.size() && !((String)arrayList.get(n)).equals(string); ++n) {
                }
            }
            this.option = n;
        }
    }
}

