/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.gd;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.ui.app.r.RflowGDView;
import com.ef_prime.rflow.ui.app.r.gd.GDHandler;
import com.ef_prime.rflow.ui.app.r.gd.GDView;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rosuda.javaGD.GDInterface;
import org.rosuda.javaGD.LocatorSync;

public class GD
extends GDInterface {
    private static final Logger LOGGER = Logger.getLogger(GD.class.getName());
    private static final List<GDHandler> handlers = new ArrayList<GDHandler>();
    private static GDView precreatedView;

    public static int[] openDevice(final double d, final double d2) {
        try {
            UIUtility.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    precreatedView = null;
                    precreatedView = GD.open(d, d2);
                }
            });
            if (precreatedView != null) {
                precreatedView.waitForSizeInit(3000L);
                Dimension dimension = precreatedView.getCanvasSize();
                if (dimension.width > 0 && dimension.height > 0) {
                    return new int[]{dimension.width, dimension.height};
                }
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to open graphic device.", exception);
        }
        return new int[]{(int)d, (int)d2};
    }

    public void gdOpen(final double d, final double d2) {
        super.gdOpen(d, d2);
        if (precreatedView != null) {
            this.c = precreatedView;
            precreatedView = null;
        } else {
            try {
                UIUtility.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        GD.this.c = GD.open(d, d2);
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Failed to open graphic device.", exception);
            }
        }
    }

    public void gdActivate() {
        super.gdActivate();
        this.getContainer().setActive(true);
    }

    public void gdDeactivate() {
        super.gdDeactivate();
        this.getContainer().setActive(false);
    }

    public double[] gdLocator() {
        if (this.c == null) {
            return null;
        }
        if (this.ls == null) {
            this.ls = new LocatorSync();
        }
        if (!this.c.prepareLocator(this.ls)) {
            return null;
        }
        R.console().setInteractiveAction(this.getContainer());
        return this.ls.waitForAction();
    }

    public static void addGDHandler(GDHandler gDHandler) {
        handlers.add(gDHandler);
    }

    public static void removeGDHandler(GDHandler gDHandler) {
        handlers.remove(gDHandler);
    }

    private static GDView open(double d, double d2) {
        if (handlers.size() > 0) {
            return handlers.get(handlers.size() - 1).openGraphicDevice(R.getInterface(), (int)d, (int)d2);
        }
        RflowGDView rflowGDView = new RflowGDView(R.getInterface(), new Dimension((int)d, (int)d2), false);
        Rflow.mainView().openGraphicDevice(rflowGDView);
        return rflowGDView;
    }

    private GDView getContainer() {
        return (GDView)this.c;
    }
}

