/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.gd;

import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.DoubleKey;
import com.ef_prime.rflow.core.common.keyvalue.IntKey;
import com.ef_prime.rflow.core.common.keyvalue.ListKey;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.ui.common.component.FileFilterFactory;
import com.google.common.collect.Lists;
import java.awt.Dimension;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.filechooser.FileFilter;

public class GDSettings
extends ValueMap {
    public static final String SAVE_TYPE_PNG = "png";
    public static final String SAVE_TYPE_JPG = "jpg";
    public static final String SAVE_TYPE_EPS = "eps";
    public static final String SAVE_TYPE_EMF = "emf";
    public static final String SAVE_TYPE_SVG = "svg";
    private static final Dimension DEFAULT_CANVAS_SIZE = new Dimension(600, 600);
    public static final ListKey<Integer> GD_CANVAS_SIZE = ((ListKey.Builder)ListKey.builder("GD_CANVAS_SIZE", "", IntKey.builder("size", "").build()).setNoSave(true)).build();
    public static final BoolKey GD_CANVAS_FIX_ASPECT_RATIO = ((BoolKey.Builder)BoolKey.builder("GD_CANVAS_FIX_ASPECT_RATIO", "").setDefaultValue(false)).build();
    public static final DoubleKey GD_ZOOM = ((DoubleKey.Builder)((DoubleKey.Builder)DoubleKey.builder("GD_ZOOM", "").setDefaultValue(1.0)).setNoSave(true)).build();
    public static final StrKey GD_SAVE_TYPE = ((StrKey.Builder)StrKey.builder("GD_SAVE_TYPE", "").setDefaultValue("")).build();
    public static final BoolKey GD_FIT_CANVAS_SIZE = ((BoolKey.Builder)BoolKey.builder("GD_FIT_CANVAS_SIZE", "").setDefaultValue(true)).build();
    public static final DoubleKey GD_PRE_ZOOM = ((DoubleKey.Builder)((DoubleKey.Builder)DoubleKey.builder("GD_PRE_ZOOM", "").setDefaultValue(1.2)).setNoSave(true)).build();

    public static Map<String, FileFilter> getFilterMap() {
        TreeMap<String, FileFilter> treeMap = new TreeMap<String, FileFilter>();
        treeMap.put(SAVE_TYPE_EMF, FileFilterFactory.createEmfFileFilter());
        treeMap.put(SAVE_TYPE_EPS, FileFilterFactory.createEpsFileFilter());
        treeMap.put(SAVE_TYPE_PNG, FileFilterFactory.createPngFileFilter());
        treeMap.put(SAVE_TYPE_JPG, FileFilterFactory.createJpegFileFilter());
        treeMap.put(SAVE_TYPE_SVG, FileFilterFactory.createSvgFileFilter());
        return treeMap;
    }

    public GDSettings() {
        this.registerKeys(GD_CANVAS_SIZE, GD_CANVAS_FIX_ASPECT_RATIO, GD_ZOOM, GD_SAVE_TYPE, GD_FIT_CANVAS_SIZE, GD_PRE_ZOOM);
    }

    public Dimension getSize() {
        return GDSettings.toDimension((List)((Object)this.getValue(GD_CANVAS_SIZE)));
    }

    public static Dimension toDimension(List<Integer> list) {
        try {
            return new Dimension(list.get(0), list.get(1));
        }
        catch (Exception exception) {
            return DEFAULT_CANVAS_SIZE;
        }
    }

    public void setSize(Dimension dimension) {
        this.putValue(GD_CANVAS_SIZE, Lists.newArrayList((Object[])new Integer[]{dimension.width, dimension.height}));
    }

    public boolean isFixAspectRatio() {
        return this.getValue(GD_CANVAS_FIX_ASPECT_RATIO);
    }

    public void setFixAspectRatio(boolean bl) {
        this.putValue(GD_CANVAS_FIX_ASPECT_RATIO, bl);
    }

    public double getZoom() {
        return this.getValue(GD_ZOOM);
    }

    public void setZoom(double d) {
        this.putValue(GD_ZOOM, d);
    }

    public String getSaveType() {
        return this.getValue(GD_SAVE_TYPE);
    }

    public void setSaveType(String string) {
        this.putValue(GD_SAVE_TYPE, string);
    }

    public boolean isFitCanvasSize() {
        return this.getValue(GD_FIT_CANVAS_SIZE);
    }

    public void setFitCanvasSize(boolean bl) {
        this.putValue(GD_FIT_CANVAS_SIZE, bl);
    }

    public double getPreprocessingZoom() {
        return this.getValue(GD_PRE_ZOOM);
    }

    public void setPreprocessingZoom(double d) {
        this.putValue(GD_PRE_ZOOM, d);
    }
}

