/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.gd;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RInterface;
import com.ef_prime.rflow.core.app.r.console.BusyListener;
import com.ef_prime.rflow.core.app.r.console.RInteractiveAction;
import com.ef_prime.rflow.core.app.r.console.RInteractiveActionEvent;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.util.ThreadUtility;
import com.ef_prime.rflow.core.util.Platform;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.gd.GDSettings;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.BusyLayerUI;
import com.ef_prime.rflow.ui.common.component.EmfSelection;
import com.ef_prime.rflow.ui.common.component.ImageSelection;
import com.ef_prime.rflow.ui.common.component.LightDelayedExecutor;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.Refreshable;
import com.ef_prime.rflow.ui.common.component.ShowingListener;
import com.ef_prime.rflow.ui.common.component.SplitPaneTracker;
import com.ef_prime.rflow.ui.common.component.WindowSizeTracker;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.event.FileEvent;
import com.ef_prime.rflow.ui.common.event.SimpleEvent;
import com.ef_prime.rflow.ui.common.event.SimpleEventHandler;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.util.GraphicsUtility;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.ArrayUtils;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;
import org.rosuda.javaGD.GDContainer;
import org.rosuda.javaGD.GDObject;
import org.rosuda.javaGD.LocatorSync;

public class GDView
extends View
implements GDContainer,
BusyListener,
RInteractiveAction,
SimpleEventHandler,
ValueChangeEventHandler {
    private static final Logger LOGGER = Logger.getLogger(GDView.class.getName());
    private static final int ZOOM_FIT = -1;
    private static final int ZOOM_FIT_WIDTH = -2;
    private static final int ZOOM_FIT_HEIGHT = -3;
    private static final Icon ACTIVE_ICON = Icons.getIcon("16/chart_bar.png");
    private static final Icon INACTIVE_ICON = Icons.getDisabledIcon("16/chart_bar.png");
    private RInterface r;
    private int devNumber = -1;
    private boolean active;
    private GDActions actions = new GDActions();
    private ViewPanel viewPanel;
    private BusyLayerUI<JComponent> busyLayer;
    private GDScrollPane scrollPane;
    private GDToolBar toolBar;
    private GDObject.GDState gdState = new GDObject.GDState();
    private Dimension originalSize;
    private AffineTransform viewTransform = new AffineTransform();
    private AffineTransform scrollTransform = new AffineTransform();
    private boolean resizeRequest;
    private Dimension sizeBeforeResize;
    private boolean closeParentView = true;
    private boolean preview;
    private Refreshable refreshable;
    private Boolean sizeInitialized = false;
    private Object sizeInitLock = new Object();
    private double actualWidthPreZoom = 1.0;
    private double actualHeightPreZoom = 1.0;
    private SplitPaneTracker splitPaneTracker;
    private WindowSizeTracker windowSizeTracker;
    private Predicate<GDView> resizeTest = gDView -> true;
    private GDSettings gdSettings;
    private boolean propertyChangeLock;
    private boolean repaintLock;
    private boolean locatorEnabled;
    private LocatorSync locatorSync;
    private Painter painter;

    public GDView(RInterface rInterface, Dimension dimension, boolean bl) {
        this.r = rInterface;
        this.originalSize = dimension;
        this.sizeBeforeResize = dimension;
        this.preview = bl;
        this.gdSettings = bl ? new GDSettings() : Rflow.settings().getGDSettings();
        double d = this.gdSettings.getPreprocessingZoom();
        if (d != 1.0) {
            int n = dimension.width;
            int n2 = dimension.height;
            int n3 = (int)((double)n / d + 0.5);
            int n4 = (int)((double)n2 / d + 0.5);
            this.actualWidthPreZoom = (double)n / (double)n3;
            this.actualHeightPreZoom = (double)n2 / (double)n4;
        } else {
            this.actualWidthPreZoom = 1.0;
            this.actualHeightPreZoom = 1.0;
        }
        this.setIcon(ACTIVE_ICON);
        this.setClosable(true);
        this.viewPanel = new ViewPanel();
        this.viewPanel.setOpaque(false);
        this.viewPanel.setFocusable(true);
        this.busyLayer = new BusyLayerUI();
        this.busyLayer.setBackground(null);
        JLayer<JComponent> jLayer = new JLayer<JComponent>(this.viewPanel, this.busyLayer);
        this.scrollPane = new GDScrollPane(jLayer);
        this.toolBar = new GDToolBar();
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.toolBar, "North");
        this.painter = new Painter();
        MouseHandler mouseHandler = new MouseHandler();
        this.viewPanel.addMouseListener(mouseHandler);
        this.viewPanel.addMouseMotionListener(mouseHandler);
        this.viewPanel.addMouseWheelListener(mouseHandler);
        this.addHierarchyListener(new ShowingHandler());
        this.actions.installActions(this, false);
        this.splitPaneTracker = new SplitPaneTracker(this){

            @Override
            protected void dragFinished() {
                GDView.this.processResizeRequest();
            }
        };
        this.windowSizeTracker = new WindowSizeTracker(this){

            @Override
            protected void resizeFinished() {
                GDView.this.processResizeRequest();
            }
        };
        this.gdSettings.addEventHandler(this);
        this.updateViewTransform();
    }

    public void setActive(boolean bl) {
        if (this.active != bl) {
            this.active = bl;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GDView.this.setIcon(GDView.this.isActive() ? ACTIVE_ICON : INACTIVE_ICON);
                    GDView.this.updateTab();
                }
            });
        }
    }

    public void setCloseParentView(boolean bl) {
        this.closeParentView = bl;
    }

    public boolean isCloseParentView() {
        return this.closeParentView;
    }

    public void setResizeTest(Predicate<GDView> predicate) {
        this.resizeTest = predicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForSizeInit(long l) {
        if (this.sizeInitialized.booleanValue()) {
            return true;
        }
        Object object = this.sizeInitLock;
        synchronized (object) {
            try {
                this.sizeInitLock.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.sizeInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSizeInitialized() {
        Object object = this.sizeInitLock;
        synchronized (object) {
            return this.sizeInitialized;
        }
    }

    @Override
    public boolean canRefreshView() {
        return true;
    }

    @Override
    public void refreshView() {
        this.repaint();
    }

    @Override
    public void loadView() {
        R.console().addBusyListener(this);
        this.repaintLock = false;
        this.painter.getExecutor();
    }

    @Override
    public void unloadView() {
        this.cancel();
        R.console().removeBusyListener(this);
        if (this.getDeviceNumber() > 0) {
            int n = this.getDeviceNumber() + 1;
            R.queryQueue().addQuery(() -> this.r.client().gdDevOff_Wait(n));
        }
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        this.painter.shutdown();
    }

    @Override
    public String getTitle() {
        String string = "Graphics:" + (this.getDeviceNumber() + 1);
        return !this.active ? "(" + string + ")" : string;
    }

    public List<GDObject> getGdObjects() throws InterruptedException, ExecutionException {
        return this.painter.getGDObjects().get();
    }

    public void setGdObjects(List<GDObject> list) {
        this.painter.setGDObjects(list);
    }

    public void add(GDObject gDObject) {
        this.painter.add(gDObject);
    }

    public void reset() {
        this.painter.reset();
    }

    public GDObject.GDState getGState() {
        return this.getGdState();
    }

    public boolean prepareLocator(LocatorSync locatorSync) {
        if (this.locatorSync != locatorSync) {
            this.finishLocator();
        }
        this.locatorSync = locatorSync;
        this.setLocatorEnabled(true);
        return true;
    }

    private void finishLocator() {
        if (this.locatorSync != null) {
            this.locatorSync.triggerAction(null);
            this.locatorSync = null;
        }
        this.setLocatorEnabled(false);
    }

    public void setLocatorEnabled(boolean bl) {
        if (this.locatorEnabled != bl) {
            this.locatorEnabled = bl;
            this.toolBar.finishLocator.setVisible(bl);
            if (bl) {
                this.viewPanel.setCursor(Cursor.getPredefinedCursor(1));
                R.console().addRInteractiveActionEventHandler(this);
            } else {
                this.viewPanel.setCursor(Cursor.getPredefinedCursor(0));
                R.console().removeRInteractiveActionEventHandler(this);
            }
        }
    }

    public void syncDisplay(boolean bl) {
        if (bl) {
            this.painter.refresh();
        }
    }

    public int getDeviceNumber() {
        return this.devNumber;
    }

    public void setDeviceNumber(int n) {
        if (this.devNumber != n) {
            this.devNumber = n;
            SwingUtilities.invokeLater(() -> this.updateTab());
        }
    }

    public void closeDisplay() {
        this.devNumber = -1;
        if (this.isCloseParentView()) {
            SwingUtilities.invokeLater(() -> this.closeTab());
        }
    }

    public Graphics getGDGraphics() {
        return this.viewPanel.getGraphics();
    }

    public Dimension getGDSize() {
        return this.getCanvasSize();
    }

    public void setRefreshable(Refreshable refreshable) {
        this.refreshable = refreshable;
    }

    private void setPreZoomedCanvasSize(Dimension dimension) {
        double d = this.getPreZoom();
        if (d == 1.0) {
            this.actualWidthPreZoom = 1.0;
            this.actualHeightPreZoom = 1.0;
            this.updateViewTransform();
            this.gdSettings.setSize(dimension);
        } else {
            int n = dimension.width;
            int n2 = dimension.height;
            int n3 = (int)((double)n / d + 0.5);
            int n4 = (int)((double)n2 / d + 0.5);
            this.actualWidthPreZoom = (double)n / (double)n3;
            this.actualHeightPreZoom = (double)n2 / (double)n4;
            this.updateViewTransform();
            this.gdSettings.setSize(new Dimension(n3, n4));
        }
    }

    private Dimension getPreZoomedCanvasSize() {
        double d = this.getPreZoom();
        if (d == 1.0) {
            return this.getCanvasSize();
        }
        Dimension dimension = this.getCanvasSize();
        int n = dimension.width;
        int n2 = dimension.height;
        n = (int)((double)n * this.actualWidthPreZoom + 0.5);
        n2 = (int)((double)n2 * this.actualHeightPreZoom + 0.5);
        return new Dimension(n, n2);
    }

    public boolean isActive() {
        return this.active;
    }

    public Dimension getOriginalSize() {
        return this.originalSize;
    }

    public Dimension getCanvasSize() {
        return this.gdSettings.getSize();
    }

    public Dimension getViewSize() {
        if (Platform.isWindowsFamily()) {
            return this.getActualSize();
        }
        return this.viewPanel.getSize();
    }

    private Dimension getActualSize() {
        Cloneable cloneable;
        Dimension dimension = this.viewPanel.getSize();
        double d = dimension.getWidth();
        double d2 = dimension.getHeight();
        GraphicsConfiguration graphicsConfiguration = this.viewPanel.getGraphicsConfiguration();
        if (graphicsConfiguration != null) {
            cloneable = graphicsConfiguration.getDefaultTransform();
            d *= ((AffineTransform)cloneable).getScaleX();
            d2 *= ((AffineTransform)cloneable).getScaleY();
        }
        cloneable = new Dimension((int)d, (int)d2);
        return cloneable;
    }

    public GDObject.GDState getGdState() {
        return this.gdState;
    }

    private boolean isAutoResizeCanvas() {
        return this.gdSettings.isFitCanvasSize();
    }

    private double getZoom() {
        return this.convertZoom((Double)this.toolBar.zoomPanel.scale.getSelectedItem());
    }

    private double convertZoom(Double d) {
        if (d == -1.0) {
            Dimension dimension = this.getViewSize();
            boolean bl = true;
            Dimension dimension2 = this.getPreZoomedCanvasSize();
            double d2 = (dimension.getWidth() - (double)bl) / dimension2.getWidth();
            double d3 = (dimension.getHeight() - (double)bl) / dimension2.getHeight();
            d = Math.min(d2, d3);
            d = Math.rint(d * 100.0) / 100.0;
        } else if (d == -2.0) {
            Dimension dimension = this.getViewSize();
            boolean bl = true;
            Dimension dimension3 = this.getPreZoomedCanvasSize();
            d = (dimension.getWidth() - (double)bl) / dimension3.getWidth();
            d = Math.rint(d * 100.0) / 100.0;
        } else if (d == -3.0) {
            Dimension dimension = this.getViewSize();
            boolean bl = true;
            Dimension dimension4 = this.getPreZoomedCanvasSize();
            d = (dimension.getHeight() - (double)bl) / dimension4.getHeight();
            d = Math.rint(d * 100.0) / 100.0;
        }
        return d;
    }

    private double getPreZoom() {
        return (Double)this.toolBar.configPanel.zoomPanel.scale.getSelectedItem();
    }

    private void updateViewTransform() {
        double d = this.actualHeightPreZoom * this.getZoom();
        d = Math.max(Math.min(d, 100.0), 1.0E-4);
        double d2 = this.actualWidthPreZoom * this.getZoom();
        d2 = Math.max(Math.min(d2, 100.0), 1.0E-4);
        if (this.viewTransform.getScaleX() != d || this.viewTransform.getScaleY() != d2) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(d, d2);
            this.viewTransform = affineTransform;
            this.painter.clearImage();
        }
    }

    private Rectangle getPaintRectangle(boolean bl) {
        if (this.getCanvasSize() == null) {
            return new Rectangle();
        }
        Rectangle rectangle = new Rectangle(0, 0, this.getCanvasSize().width, this.getCanvasSize().height);
        if (bl) {
            return this.viewTransform.createTransformedShape(rectangle).getBounds();
        }
        return rectangle;
    }

    private void doResize() {
        Dimension dimension = this.toolBar.getToolbarCanvasSize();
        this.setPreZoomedCanvasSize(dimension);
    }

    private void doAutoResize() {
        Dimension dimension = this.getViewSize();
        int n = 1;
        int n2 = dimension.width - n;
        int n3 = dimension.height - n;
        if (n2 <= 0 || n3 <= 0) {
            return;
        }
        if (this.toolBar.fixRatio.isSelected()) {
            n2 = n3 = Math.min(n2, n3);
        }
        double d = this.getPreZoom();
        int n4 = n2;
        int n5 = n3;
        if (d != 1.0) {
            n4 = (int)((double)n2 / d + 0.5);
            n5 = (int)((double)n3 / d + 0.5);
            this.actualWidthPreZoom = (double)n2 / (double)n4;
            this.actualHeightPreZoom = (double)n3 / (double)n5;
        } else {
            this.actualWidthPreZoom = 1.0;
            this.actualHeightPreZoom = 1.0;
        }
        this.updateViewTransform();
        this.gdSettings.setSize(new Dimension(n4, n5));
    }

    private void processResizeRequest() {
        if (this.resizeRequest) {
            this.setRequestResize(false);
            this.canvasSizeChanged();
        }
    }

    private void setRequestResize(boolean bl) {
        if (this.resizeRequest != bl) {
            this.resizeRequest = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        Key<?> key = valueChangeEvent.getKey();
        boolean bl = !this.propertyChangeLock;
        boolean bl2 = true;
        this.propertyChangeLock = true;
        try {
            if (key == GDSettings.GD_CANVAS_SIZE) {
                if (!this.resizeRequest) {
                    this.sizeBeforeResize = GDSettings.toDimension((List)valueChangeEvent.getOldValue());
                }
                this.canvasSizeChanged();
            } else if (key == GDSettings.GD_ZOOM) {
                this.updateViewTransform();
            } else if (key == GDSettings.GD_PRE_ZOOM) {
                if (this.isAutoResizeCanvas()) {
                    this.doAutoResize();
                } else {
                    this.doResize();
                }
                this.updateViewTransform();
                bl2 = false;
            } else if (key == GDSettings.GD_FIT_CANVAS_SIZE) {
                boolean bl3 = this.isAutoResizeCanvas();
                if (bl3) {
                    this.doAutoResize();
                }
                this.toolBar.width.setEnabled(!bl3);
                this.toolBar.height.setEnabled(!bl3 && !this.toolBar.fixRatio.isSelected());
            } else if (key == GDSettings.GD_CANVAS_FIX_ASPECT_RATIO) {
                if (this.gdSettings.isFixAspectRatio()) {
                    this.toolBar.updateCanvasSize(true);
                }
                if (this.isAutoResizeCanvas()) {
                    this.doAutoResize();
                }
                this.toolBar.height.setEnabled(!this.isAutoResizeCanvas() && !this.toolBar.fixRatio.isSelected());
            }
        }
        finally {
            if (bl) {
                this.scrollPane.updateScrollBar();
                if (bl2) {
                    this.viewPanel.repaint();
                }
                this.propertyChangeLock = false;
            }
        }
    }

    private void canvasSizeChanged() {
        this.r.client().setGdSize(this.gdSettings.getSize().width, this.gdSettings.getSize().height);
        if (this.preview) {
            if (this.isSizeInitialized()) {
                if (this.isShowing()) {
                    if (this.splitPaneTracker.isDragging() || this.windowSizeTracker.isResizing()) {
                        this.setRequestResize(true);
                    } else if (this.refreshable != null) {
                        this.refreshable.refresh();
                        this.repaintLock = this.preview;
                    }
                } else {
                    this.resizeRequest = true;
                }
            }
        } else if (this.getDeviceNumber() >= 0) {
            if (this.isShowing()) {
                if (this.splitPaneTracker.isDragging() || this.windowSizeTracker.isResizing()) {
                    this.setRequestResize(true);
                } else {
                    this.r.queryQueue().addQuery(() -> this.r.client().gdResize(this.getDeviceNumber()));
                    this.setRequestResize(false);
                }
            } else {
                this.setRequestResize(true);
            }
        }
        this.toolBar.setToolbarCanvasSize(this.getCanvasSize());
        this.toolBar.configPanel.setOriginalSizeLabel(this.getCanvasSize());
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.actions.get("COPY"));
        if (this.actions.get("COPY_AS_METAFILE") != null) {
            jPopupMenu.add(this.actions.get("COPY_AS_METAFILE"));
        }
        jPopupMenu.add(this.actions.get("SAVE"));
        return jPopupMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void componentSizeChanged() {
        if (this.isAutoResizeCanvas() && this.resizeTest.test(this)) {
            this.doAutoResize();
        }
        this.scrollPane.updateScrollBar();
        Object object = this.sizeInitLock;
        synchronized (object) {
            if (!this.sizeInitialized.booleanValue()) {
                this.sizeInitialized = true;
                this.sizeInitLock.notifyAll();
            }
        }
    }

    public void setUpperLeft(Component component) {
        this.add(component, "East");
    }

    @Override
    public void busyStateChanged(int n) {
        if (n == 0) {
            SwingUtilities.invokeLater(() -> this.processResizeRequest());
        }
    }

    @Override
    public void cancel() {
        this.finishLocator();
    }

    @Override
    public void onEvent(SimpleEvent simpleEvent) {
        RInteractiveActionEvent rInteractiveActionEvent;
        if (simpleEvent.getClass().equals(RInteractiveActionEvent.class) && (rInteractiveActionEvent = (RInteractiveActionEvent)simpleEvent).getRInteractiveAction() != this) {
            this.finishLocator();
        }
    }

    private class GDActions
    extends Actions {
        private static final String COPY = "COPY";
        private static final String COPY_AS_METAFILE = "COPY_AS_METAFILE";
        private static final String SAVE = "SAVE";

        public GDActions() {
            this.put(COPY, new Copy());
            if (Platform.isWindowsFamily()) {
                this.put(COPY_AS_METAFILE, new CopyAsMetafile());
            }
            this.put(SAVE, new Save());
        }

        private class Copy
        extends LoggableAction {
            public Copy() {
                this.putValue("Name", Messages.getString("Action.copy"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                BufferedImage bufferedImage;
                try {
                    bufferedImage = GDView.this.painter.createImage(true);
                }
                catch (IOException iOException) {
                    UIUtility.showErrorDialog((Component)GDView.this, iOException);
                    return;
                }
                ImageSelection imageSelection = new ImageSelection(bufferedImage);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(imageSelection, imageSelection);
            }
        }

        private class CopyAsMetafile
        extends LoggableAction {
            public CopyAsMetafile() {
                this.putValue("Name", Messages.getString("Action.copy_as_metafile"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                byte[] byArray = GraphicsUtility.writeEmfToBytes(GDView.this.getPaintRectangle(true).getSize(), null, GDView.this.painter.createPaintable(true));
                EmfSelection emfSelection = new EmfSelection(new ByteArrayInputStream(byArray));
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(emfSelection, emfSelection);
            }
        }

        private class Save
        extends LoggableAction {
            public Save() {
                this.putValue("Name", Messages.getStringWithDots("Action.save_as"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                Boolean bl = this.askSaveOption();
                if (bl == null) {
                    return;
                }
                Map<String, FileFilter> map = GDSettings.getFilterMap();
                HashMap<FileFilter, String> hashMap = new HashMap<FileFilter, String>();
                JFileChooser jFileChooser = new JFileChooser(WorkingDirectory.getWorkingDirectory());
                jFileChooser.setAcceptAllFileFilterUsed(false);
                for (Map.Entry<String, FileFilter> object2 : map.entrySet()) {
                    jFileChooser.addChoosableFileFilter(object2.getValue());
                    hashMap.put(object2.getValue(), object2.getKey());
                }
                FileFilter fileFilter = map.get(GDView.this.gdSettings.getSaveType());
                if (fileFilter != null) {
                    jFileChooser.setFileFilter(fileFilter);
                } else {
                    jFileChooser.setFileFilter(map.get("png"));
                }
                File file = UIUtility.chooseSaveFile(jFileChooser, GDView.this);
                if (file == null) {
                    return;
                }
                boolean bl2 = bl != false && !GDView.this.viewTransform.isIdentity();
                boolean bl3 = !bl2;
                try {
                    FileFilter iOException = jFileChooser.getFileFilter();
                    String string = (String)hashMap.get(iOException);
                    if (string == null) {
                        return;
                    }
                    GDView.this.gdSettings.setSaveType(string);
                    switch (string) {
                        case "png": {
                            ImageIO.write((RenderedImage)GDView.this.painter.createImage(bl3), "png", file);
                            break;
                        }
                        case "jpg": {
                            GraphicsUtility.writeJpeg(GDView.this.painter.createImage(bl3), file, 0.9f);
                            break;
                        }
                        case "emf": {
                            GraphicsUtility.writeEmf(file, GDView.this.getPaintRectangle(bl3).getSize(), null, GDView.this.painter.createPaintable(bl3));
                            break;
                        }
                        case "svg": {
                            GraphicsUtility.writeSvg(file, GDView.this.getPaintRectangle(bl3).getSize(), Color.WHITE, GDView.this.painter.createPaintable(bl3));
                            break;
                        }
                        case "eps": {
                            GraphicsUtility.writePs(file, GDView.this.getPaintRectangle(bl3).getSize(), null, GDView.this.painter.createPaintable(bl3));
                            break;
                        }
                    }
                    EventManager.getInstance().dispatchEvent(new FileEvent(file));
                }
                catch (IOException iOException) {
                    UIUtility.showErrorDialog((Component)GDView.this, iOException);
                }
            }

            private Boolean askSaveOption() {
                JPanel jPanel = new JPanel((LayoutManager)new MigLayout(""));
                jPanel.setBorder(new TitledBorder(Messages.getString("GraphicDevice.image_size")));
                JRadioButton[] jRadioButtonArray = UIUtility.createRadioButtons(new String[]{Messages.getString("GraphicDevice.image_size.canvas_size"), Messages.getString("GraphicDevice.image_size.as_displayed")}, 0);
                jRadioButtonArray[0].setFocusable(false);
                jRadioButtonArray[1].setFocusable(false);
                Rectangle rectangle = GDView.this.getPaintRectangle(true);
                jPanel.add(jRadioButtonArray[0]);
                jPanel.add((Component)new JLabel(" (" + GDView.this.getCanvasSize().width + " x " + GDView.this.getCanvasSize().height + ")"), "wrap");
                jPanel.add(jRadioButtonArray[1]);
                jPanel.add((Component)new JLabel(" (" + rectangle.width + " x " + rectangle.height + ")"), "wrap");
                int n = JOptionPane.showConfirmDialog(GDView.this, jPanel, Messages.getString("GraphicDevice.save_option"), 2, -1);
                if (n != 0) {
                    return null;
                }
                return jRadioButtonArray[0].isSelected();
            }
        }
    }

    private class ViewPanel
    extends JPanel
    implements ComponentListener {
        private final AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);

        public ViewPanel() {
            this.addComponentListener(this);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            if (Platform.isWindowsFamily()) {
                AffineTransform affineTransform = graphics2D.getTransform();
                double d = affineTransform.getTranslateX();
                double d2 = affineTransform.getTranslateY();
                affineTransform.setToTranslation(d, d2);
                graphics2D.setTransform(affineTransform);
            }
            this.draw(graphics2D, true);
            graphics2D.dispose();
        }

        private void draw(Graphics2D graphics2D, boolean bl) {
            Dimension dimension = GDView.this.getCanvasSize();
            if (dimension == null) {
                return;
            }
            BufferedImage bufferedImage = GDView.this.painter.getImage();
            if (bufferedImage == null) {
                GDView.this.painter.paintImage();
                return;
            }
            GDView.this.busyLayer.stop();
            if (bl) {
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            }
            if (bl) {
                graphics2D.drawImage(bufferedImage, GDView.this.scrollTransform, null);
            } else {
                graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            }
            if (GDView.this.resizeRequest && !GDView.this.locatorEnabled) {
                graphics2D.setComposite(this.alphaComposite);
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            GDView.this.scrollPane.repaintScrollbars();
        }

        @Override
        public void repaint() {
            if (GDView.this.busyLayer != null) {
                GDView.this.busyLayer.setViewHidden(false);
            }
            if (!GDView.this.repaintLock) {
                super.repaint();
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            GDView.this.componentSizeChanged();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }
    }

    private class GDScrollPane
    extends JPanel
    implements AdjustmentListener {
        private JScrollBar horizontalScrollBar;
        private JScrollBar verticalScrollBar = new JScrollBar(1);
        private JComponent corner;
        private JPanel south;
        private boolean scrollBarModelChanging;

        public GDScrollPane(JComponent jComponent) {
            this.horizontalScrollBar = new JScrollBar(0);
            this.setLayout(new BorderLayout());
            this.add((Component)jComponent, "Center");
            this.add((Component)this.verticalScrollBar, "East");
            this.south = new JPanel(new BorderLayout());
            this.south.add((Component)this.horizontalScrollBar, "Center");
            this.setCorner(new JPanel());
            this.add((Component)this.south, "South");
            this.updateScrollBar();
            this.verticalScrollBar.addAdjustmentListener(this);
            this.horizontalScrollBar.addAdjustmentListener(this);
        }

        public void setCorner(JComponent jComponent) {
            this.corner = jComponent;
            jComponent.setPreferredSize(new Dimension(this.verticalScrollBar.getPreferredSize().width, this.horizontalScrollBar.getPreferredSize().height));
            this.south.add((Component)this.corner, "East");
        }

        public void scrollVertical(int n) {
            int n2 = this.verticalScrollBar.getValue() + n;
            this.verticalScrollBar.setValue(n2);
        }

        public void scrollHorizontal(int n) {
            int n2 = this.horizontalScrollBar.getValue() + n;
            this.horizontalScrollBar.setValue(n2);
        }

        public void updateScrollBar() {
            Dimension dimension = GDView.this.getViewSize();
            Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
            Rectangle rectangle2 = GDView.this.getPaintRectangle(true);
            Rectangle rectangle3 = rectangle.union(rectangle2);
            int n = this.horizontalScrollBar.getValue();
            int n2 = this.verticalScrollBar.getValue();
            GDView.this.scrollTransform.setToIdentity();
            this.scrollBarModelChanging = true;
            this.horizontalScrollBar.setValues((int)rectangle.getMinX(), (int)rectangle.getWidth(), (int)rectangle3.getMinX(), (int)rectangle3.getMaxX());
            this.verticalScrollBar.setValues((int)rectangle.getMinY(), (int)rectangle.getHeight(), (int)rectangle3.getMinY(), (int)rectangle3.getMaxY());
            this.horizontalScrollBar.setValue(n);
            this.verticalScrollBar.setValue(n2);
            this.scrollBarModelChanging = false;
            this.scrollValueChanged();
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            this.scrollValueChanged();
        }

        private void scrollValueChanged() {
            if (this.scrollBarModelChanging) {
                return;
            }
            this.scrollBarModelChanging = true;
            int n = -this.horizontalScrollBar.getValue();
            int n2 = -this.verticalScrollBar.getValue();
            if (GDView.this.scrollTransform.getTranslateX() != (double)n || GDView.this.scrollTransform.getTranslateY() != (double)n2) {
                GDView.this.scrollTransform = AffineTransform.getTranslateInstance(n, n2);
                GDView.this.viewPanel.repaint();
            }
            this.scrollBarModelChanging = false;
        }

        public void repaintScrollbars() {
            this.horizontalScrollBar.repaint();
            this.verticalScrollBar.repaint();
        }
    }

    private class GDToolBar
    extends JPanel
    implements ItemListener,
    FocusListener,
    ActionListener {
        private JPanel canvasCustomPanel;
        private JFormattedTextField width;
        private JFormattedTextField height;
        private JCheckBox fixRatio;
        private ZoomPanel zoomPanel;
        private JToggleButton fitCanvasSizeButton;
        private JButton configButton;
        private ConfigPanel configPanel;
        private Popup configPopup;
        private JButton finishLocator;

        public GDToolBar() {
            Dimension dimension = GDView.this.getCanvasSize();
            this.width = new JFormattedTextField(NumberFormat.getIntegerInstance());
            this.height = new JFormattedTextField(NumberFormat.getIntegerInstance());
            this.width.setHorizontalAlignment(4);
            this.height.setHorizontalAlignment(4);
            this.width.addFocusListener(this);
            this.height.addFocusListener(this);
            this.width.addActionListener(this);
            this.height.addActionListener(this);
            this.width.setToolTipText(Messages.getString("GraphicDevice.width"));
            this.height.setToolTipText(Messages.getString("GraphicDevice.height"));
            JLabel jLabel = new JLabel(" x ");
            boolean bl = GDView.this.gdSettings.isFixAspectRatio();
            if (bl && dimension.width != dimension.height) {
                bl = false;
            }
            this.fixRatio = new JCheckBox(Messages.getString("GraphicDevice.one_to_one"), bl);
            this.fixRatio.addItemListener(this);
            this.canvasCustomPanel = new JPanel((LayoutManager)new MigLayout("insets 0, hidemode 2"));
            this.canvasCustomPanel.add((Component)this.width, "width 40!");
            this.canvasCustomPanel.add(jLabel);
            this.canvasCustomPanel.add((Component)this.height, "width 40!");
            this.canvasCustomPanel.add(this.fixRatio);
            this.zoomPanel = new ZoomPanel(){

                @Override
                protected Double[] createChoices() {
                    return (Double[])ArrayUtils.addAll((Object[])super.createChoices(), (Object[])new Double[]{-1.0, -2.0, -3.0});
                }
            };
            this.zoomPanel.scale.setSelectedItem(GDView.this.gdSettings.getZoom());
            this.zoomPanel.scale.addItemListener(this);
            this.fitCanvasSizeButton = new JToggleButton(Icons.getIcon("16/panel_resize.png"), GDView.this.gdSettings.isFitCanvasSize());
            this.fitCanvasSizeButton.setToolTipText(Messages.getString("GraphicDevice.auto_fit"));
            this.fitCanvasSizeButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
            this.fitCanvasSizeButton.setFocusable(false);
            this.fitCanvasSizeButton.addItemListener(this);
            this.configButton = new JButton(Icons.getIcon("16/cog.png"));
            this.configButton.setToolTipText(Messages.getString("GraphicDevice.config"));
            this.configButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
            this.configButton.setFocusable(false);
            this.configButton.addActionListener(this);
            this.finishLocator = new JButton(Messages.getString("GraphicDevice.finish_locator"));
            this.finishLocator.setVisible(false);
            this.finishLocator.addActionListener(this);
            this.setLayout((LayoutManager)new MigLayout(new LC().fillX().insetsAll("4").hideMode(2).gridGapX("4"), new AC().grow(100.0f, new int[]{6}).grow(0.0f, new int[]{7})));
            this.add(this.fitCanvasSizeButton);
            this.add(this.canvasCustomPanel);
            this.add((Component)new JSeparator(1), new CC().growY());
            this.add(this.zoomPanel);
            this.add((Component)new JSeparator(1), new CC().growY());
            this.add(this.configButton);
            this.add((Component)new JPanel(), new CC().growX());
            this.add(this.finishLocator);
            this.configPanel = new ConfigPanel();
            this.setToolbarCanvasSize(GDView.this.gdSettings.getSize());
            this.width.setEnabled(!GDView.this.gdSettings.isFitCanvasSize());
            this.height.setEnabled(!GDView.this.gdSettings.isFitCanvasSize() && !bl);
            this.zoomPanel.scale.setPreferredSize(new Dimension(this.configPanel.zoomPanel.scale.getPreferredSize().width, this.zoomPanel.scale.getPreferredSize().height));
        }

        public void setToolbarCanvasSize(Dimension dimension) {
            int n = dimension.width;
            int n2 = dimension.height;
            double d = GDView.this.gdSettings.getPreprocessingZoom();
            if (d != 1.0) {
                n = (int)((double)n * GDView.this.actualWidthPreZoom + 0.5);
                n2 = (int)((double)n2 * GDView.this.actualHeightPreZoom + 0.5);
            }
            this.width.setValue(n);
            this.height.setValue(n2);
        }

        public Dimension getToolbarCanvasSize() {
            return new Dimension(((Number)this.width.getValue()).intValue(), ((Number)this.height.getValue()).intValue());
        }

        private void updateCanvasSize(boolean bl) {
            int n = ((Number)this.width.getValue()).intValue();
            int n2 = ((Number)this.height.getValue()).intValue();
            if (this.fixRatio.isSelected()) {
                if (bl) {
                    n2 = n;
                } else {
                    n = n2;
                }
            }
            GDView.this.setPreZoomedCanvasSize(new Dimension(n, n2));
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl;
            boolean bl2 = bl = itemEvent.getStateChange() == 1;
            if (itemEvent.getSource() == this.zoomPanel.scale) {
                if (bl) {
                    Double d = (Double)this.zoomPanel.scale.getSelectedItem();
                    if (d < 0.0) {
                        d = GDView.this.getZoom();
                        this.zoomPanel.scale.setSelectedItem(d);
                    } else {
                        GDView.this.gdSettings.setZoom(GDView.this.getZoom());
                    }
                }
            } else if (itemEvent.getSource() == this.fixRatio) {
                GDView.this.gdSettings.setFixAspectRatio(this.fixRatio.isSelected());
            } else if (itemEvent.getSource() == this.fitCanvasSizeButton) {
                GDView.this.gdSettings.setFitCanvasSize(this.fitCanvasSizeButton.isSelected());
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == this.width) {
                SwingUtilities.invokeLater(() -> this.width.selectAll());
            } else if (focusEvent.getSource() == this.height) {
                SwingUtilities.invokeLater(() -> this.height.selectAll());
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() == this.width || focusEvent.getSource() == this.height) {
                try {
                    if (focusEvent.getSource() == this.width) {
                        this.width.commitEdit();
                    } else {
                        this.height.commitEdit();
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                this.updateCanvasSize(focusEvent.getSource() == this.width);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.width || actionEvent.getSource() == this.height) {
                this.updateCanvasSize(actionEvent.getSource() == this.width);
            } else if (actionEvent.getSource() == this.configButton) {
                this.toggleConfigPopup();
            } else if (actionEvent.getSource() == this.finishLocator) {
                GDView.this.cancel();
            }
        }

        private void toggleConfigPopup() {
            if (this.configPopup != null) {
                this.configPopup.hide();
            } else {
                Point point = new Point();
                SwingUtilities.convertPointToScreen(point, this.configButton);
                this.configPanel.setOriginalSizeLabel(GDView.this.getCanvasSize());
                this.configPopup = PopupFactory.getSharedInstance().getPopup(this.configButton, this.configPanel, point.x, point.y + this.configButton.getHeight());
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        Component component;
                        if (!propertyChangeEvent.getPropertyName().equals("focusOwner") || !(propertyChangeEvent.getNewValue() instanceof Component)) {
                            return;
                        }
                        for (component = (Component)propertyChangeEvent.getNewValue(); component != null && component != GDToolBar.this.configPanel; component = component.getParent()) {
                        }
                        if (component == null) {
                            if (GDToolBar.this.configPopup != null) {
                                GDToolBar.this.configPopup.hide();
                            }
                            GDToolBar.this.configPopup = null;
                            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this);
                        }
                    }
                });
                this.configPopup.show();
                this.configPanel.requestFocusInWindow();
            }
        }
    }

    private class Painter
    implements Callable<BufferedImage> {
        private ThreadPoolExecutor paintExecutor;
        private List<GDObject> gdObjects = new ArrayList<GDObject>(256);
        private BufferedImage image;
        private FutureTask<BufferedImage> task;
        private LightDelayedExecutor refresher = new LightDelayedExecutor(() -> {
            if (this.image == null && this.paintExecutor != null && this.paintExecutor.getQueue().isEmpty()) {
                GDView.this.viewPanel.repaint();
            }
        }, 50L, 50L);

        public Painter() {
            this.getExecutor();
        }

        ThreadPoolExecutor getExecutor() {
            if (this.paintExecutor == null) {
                this.paintExecutor = new ThreadPoolExecutor(0, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ThreadUtility.threadFactory("Plot-%d", false));
            }
            return this.paintExecutor;
        }

        void shutdown() {
            if (this.paintExecutor != null) {
                ThreadPoolExecutor threadPoolExecutor = this.paintExecutor;
                this.paintExecutor = null;
                threadPoolExecutor.shutdown();
            }
        }

        void add(final GDObject gDObject) {
            this.cancelPaint();
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    Painter.this.gdObjects.add(gDObject);
                    Painter.this.image = null;
                    GDView.this.busyLayer.setViewHidden(true);
                    GDView.this.busyLayer.start(50);
                    Painter.this.refresher.requestAction();
                }
            });
        }

        void reset() {
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    Painter.this.gdObjects.clear();
                    Painter.this.image = null;
                    SwingUtilities.invokeLater(() -> GDView.this.toFront());
                    Painter.this.refresher.requestAction();
                }
            });
        }

        void refresh() {
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    GDView.this.viewPanel.repaint();
                }
            });
        }

        void clearImage() {
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    Painter.this.image = null;
                }
            });
        }

        void setGDObjects(final List<GDObject> list) {
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    Painter.this.gdObjects.clear();
                    Painter.this.gdObjects = list;
                    Painter.this.image = null;
                    GDView.this.viewPanel.repaint();
                }
            });
        }

        Future<List<GDObject>> getGDObjects() {
            FutureTask<List<GDObject>> futureTask = new FutureTask<List<GDObject>>(() -> new ArrayList<GDObject>(this.gdObjects));
            this.getExecutor().execute(futureTask);
            return futureTask;
        }

        BufferedImage getImage() {
            return this.image;
        }

        Future<BufferedImage> paintImage() {
            GDView.this.busyLayer.setViewHidden(true);
            GDView.this.busyLayer.start(50);
            this.task = new FutureTask<BufferedImage>(this);
            this.getExecutor().execute(this.task);
            return this.task;
        }

        private void cancelPaint() {
            if (this.task != null && !this.task.isDone()) {
                this.task.cancel(true);
                this.task = null;
            }
        }

        @Override
        public BufferedImage call() throws Exception {
            if (this.image != null) {
                return this.image;
            }
            this.image = this.paintImage(true);
            GDView.this.busyLayer.stop();
            GDView.this.viewPanel.repaint();
            return this.image;
        }

        private BufferedImage paintImage(boolean bl) {
            Dimension dimension = GDView.this.getCanvasSize();
            if (dimension == null) {
                return null;
            }
            if (Thread.interrupted()) {
                return null;
            }
            Dimension dimension2 = !GDView.this.resizeRequest ? dimension : GDView.this.sizeBeforeResize;
            BufferedImage bufferedImage = new BufferedImage((int)((double)dimension2.width * GDView.this.viewTransform.getScaleX() + 0.5), (int)((double)dimension2.height * GDView.this.viewTransform.getScaleY() + 0.5), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            boolean bl2 = this.paintToGraphics(graphics2D, bl);
            graphics2D.dispose();
            if (!bl2) {
                return null;
            }
            return bufferedImage;
        }

        private boolean paintToGraphics(Graphics2D graphics2D, boolean bl) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            if (bl) {
                graphics2D.transform(GDView.this.viewTransform);
            }
            GDObject.GDState gDState = new GDObject.GDState();
            gDState.f = GDView.this.gdState.f;
            gDState.col = GDView.this.gdState.col;
            gDState.fill = GDView.this.gdState.fill;
            gDState.viewRect = GDView.this.gdState.viewRect;
            graphics2D.setFont(gDState.f);
            gDState.viewRect = null;
            for (GDObject gDObject : this.gdObjects) {
                gDObject.paint((Component)GDView.this.viewPanel, gDState, (Graphics)graphics2D);
                if (!Thread.interrupted()) continue;
                return false;
            }
            graphics2D.dispose();
            return true;
        }

        public BufferedImage createImage(final boolean bl) throws IOException {
            Object object;
            Object object2;
            BufferedImage bufferedImage;
            BufferedImage bufferedImage2 = bufferedImage = !bl ? null : this.getImage();
            if (bufferedImage == null) {
                object2 = new FutureTask<BufferedImage>(new Callable<BufferedImage>(){

                    @Override
                    public BufferedImage call() throws Exception {
                        return Painter.this.paintImage(bl);
                    }
                });
                this.getExecutor().execute((Runnable)object2);
                object = object2;
                try {
                    bufferedImage = (BufferedImage)object.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    throw new IOException(exception);
                }
                if (bufferedImage == null) {
                    throw new IOException("Failed to create a image.");
                }
            }
            object2 = GDView.this.getPaintRectangle(bl);
            object = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            BufferedImage bufferedImage3 = ((GraphicsConfiguration)object).createCompatibleImage(((Rectangle)object2).width, ((Rectangle)object2).height);
            Graphics2D graphics2D = bufferedImage3.createGraphics();
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, ((Rectangle)object2).width, ((Rectangle)object2).height);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
            return bufferedImage3;
        }

        public GraphicsUtility.Paintable createPaintable(final boolean bl) {
            return new GraphicsUtility.Paintable(){

                @Override
                public void paintToGraphics(Graphics2D graphics2D, Dimension dimension, Color color) {
                    if (color != null) {
                        graphics2D.setColor(color);
                        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
                    }
                    Painter.this.paintToGraphics(graphics2D, bl);
                }
            };
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private Point dragStartPoint;
        private boolean dragStarted;

        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (GDView.this.locatorSync != null && this.dragStartPoint == null) {
                double[] dArray = null;
                try {
                    if (UIUtility.isLeftMouseButton(mouseEvent)) {
                        Point2D.Double double_ = new Point2D.Double(mouseEvent.getX(), mouseEvent.getY());
                        GDView.this.scrollTransform.inverseTransform(double_, double_);
                        GDView.this.viewTransform.inverseTransform(double_, double_);
                        dArray = new double[]{((Point2D)double_).getX(), ((Point2D)double_).getY()};
                    }
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    LOGGER.log(Level.SEVERE, "Failed to transform the clicked point to the orginal cordinate.", noninvertibleTransformException);
                }
                if (dArray == null) {
                    GDView.this.finishLocator();
                } else {
                    GDView.this.locatorSync.triggerAction(dArray);
                    GDView.this.locatorSync = null;
                }
            } else if (UIUtility.isRightMouseButton(mouseEvent)) {
                GDView.this.viewPanel.repaint();
                JPopupMenu jPopupMenu = GDView.this.createPopupMenu();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            GDView.this.viewPanel.requestFocusInWindow();
            int n = 704;
            if ((mouseEvent.getModifiersEx() & n) > 0) {
                return;
            }
            this.dragStartPoint = mouseEvent.getPoint();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.dragStartPoint != null) {
                if (!this.dragStarted) {
                    GDView.this.viewPanel.setCursor(Cursor.getPredefinedCursor(12));
                    this.dragStarted = true;
                }
                Point point = mouseEvent.getPoint();
                int n = point.x - this.dragStartPoint.x;
                int n2 = point.y - this.dragStartPoint.y;
                GDView.this.scrollPane.scrollHorizontal(-n * 2);
                GDView.this.scrollPane.scrollVertical(-n2 * 2);
                this.dragStartPoint = point;
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.dragStartPoint = null;
            this.dragStarted = false;
            GDView.this.viewPanel.setCursor(GDView.this.locatorEnabled ? Cursor.getPredefinedCursor(1) : Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            int n = GDView.this.getViewSize().height / 4;
            if (mouseWheelEvent.getWheelRotation() < 0) {
                n *= -1;
            }
            GDView.this.scrollPane.scrollVertical(n);
        }
    }

    private class ShowingHandler
    extends ShowingListener {
        private ShowingHandler() {
        }

        @Override
        protected void didBecomeShowing(HierarchyEvent hierarchyEvent) {
            GDView.this.processResizeRequest();
        }
    }

    private class ZoomPanel
    extends JPanel
    implements ActionListener {
        private JComboBox<Double> scale;

        public ZoomPanel() {
            this.setLayout((LayoutManager)new MigLayout(new LC().insetsAll("0").gridGapX("0")));
            JButton jButton = new JButton(Icons.getIcon("16/magnifier_zoom_out.png"));
            jButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
            jButton.setToolTipText(Messages.getString("GraphicDevice.zoom_out"));
            jButton.setActionCommand("zoom_out");
            jButton.addActionListener(this);
            JButton jButton2 = new JButton(Icons.getIcon("16/magnifier_zoom_in.png"));
            jButton2.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
            jButton2.setToolTipText(Messages.getString("GraphicDevice.zoom_in"));
            jButton2.setActionCommand("zoom_in");
            jButton2.addActionListener(this);
            this.scale = new JComboBox<Double>(this.createChoices());
            this.scale.setEditor(new PercentComboBoxEditor());
            this.scale.setRenderer((ListCellRenderer<Double>)((Object)new PercentComboBoxRenderer()));
            this.scale.setEditable(true);
            this.add(jButton);
            this.add(jButton2);
            this.add(this.scale);
        }

        protected Double[] createChoices() {
            return new Double[]{0.5, 0.8, 1.0, 1.2, 1.5, 2.0};
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            double d = 1.0;
            switch (actionEvent.getActionCommand()) {
                case "zoom_out": {
                    d = (Double)this.scale.getSelectedItem() - 0.1;
                    break;
                }
                case "zoom_in": {
                    d = (Double)this.scale.getSelectedItem() + 0.1;
                }
            }
            d = Math.max(0.0, d);
            this.scale.setSelectedItem(d);
        }
    }

    private class ConfigPanel
    extends JPanel
    implements ItemListener {
        private ZoomPanel zoomPanel;
        private JLabel originalSizeLabel;

        public ConfigPanel() {
            this.setLayout((LayoutManager)new MigLayout(new LC().insetsAll("5")));
            this.zoomPanel = new ZoomPanel();
            this.zoomPanel.scale.setSelectedItem(GDView.this.gdSettings.getPreprocessingZoom());
            this.zoomPanel.scale.addItemListener(this);
            this.add((Component)new JLabel(Messages.getString("GraphicDevice.scaling_factor")), new CC().split(2));
            this.add((Component)this.zoomPanel, new CC().wrap());
            this.originalSizeLabel = new JLabel();
            this.add((Component)this.originalSizeLabel, new CC().wrap());
        }

        public void setOriginalSizeLabel(Dimension dimension) {
            this.originalSizeLabel.setText("(" + Messages.getString("GraphicDevice.orginal_canvas_size") + ": " + dimension.width + " x " + dimension.height + ")");
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == this.zoomPanel.scale) {
                GDView.this.gdSettings.setPreprocessingZoom(((Number)this.zoomPanel.scale.getSelectedItem()).doubleValue());
            }
        }
    }

    private static class PercentComboBoxRenderer
    extends SubstanceDefaultListCellRenderer {
        private PercentComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            double d = (Double)object;
            if (d == -1.0) {
                this.setText(Messages.getString("GraphicDevice.zoom.fit_canvas"));
            } else if (d == -2.0) {
                this.setText(Messages.getString("GraphicDevice.zoom.fit_width"));
            } else if (d == -3.0) {
                this.setText(Messages.getString("GraphicDevice.zoom.fit_height"));
            } else {
                this.setText(NumberFormat.getPercentInstance().format(object));
            }
            return this;
        }
    }

    private class PercentComboBoxEditor
    extends BasicComboBoxEditor {
        private PercentComboBoxEditor() {
        }

        @Override
        protected JTextField createEditorComponent() {
            DecimalFormat decimalFormat = new DecimalFormat("#0.##%");
            JFormattedTextField jFormattedTextField = new JFormattedTextField(decimalFormat);
            jFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(decimalFormat){

                @Override
                public Object stringToValue(String object) throws ParseException {
                    if (!((String)(object = ((String)object).trim())).endsWith("%")) {
                        object = (String)object + "%";
                    }
                    return super.stringToValue((String)object);
                }
            }));
            jFormattedTextField.setBorder(null);
            return jFormattedTextField;
        }

        @Override
        public Object getItem() {
            JFormattedTextField jFormattedTextField = (JFormattedTextField)this.getEditorComponent();
            Object object = jFormattedTextField.getValue();
            Double d = 1.0;
            if (object instanceof Long) {
                d = ((Long)object).doubleValue();
            } else if (object instanceof Double) {
                d = (Double)object;
            } else {
                LOGGER.severe("Failed to get zoom value: " + String.valueOf(object));
            }
            return GDView.this.convertZoom(d);
        }

        @Override
        public void setItem(Object object) {
            JFormattedTextField jFormattedTextField = (JFormattedTextField)this.getEditorComponent();
            if (object instanceof Double) {
                jFormattedTextField.setValue(GDView.this.convertZoom((Double)object));
            } else {
                LOGGER.severe("Failed to set zoom value: " + String.valueOf(object));
                jFormattedTextField.setValue(1.0);
            }
        }
    }
}

