/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.keyvalue;

import com.ef_prime.rflow.core.app.base.KeyModel;
import com.ef_prime.rflow.core.app.r.RAddonBuilderModel;
import com.ef_prime.rflow.core.app.r.RArgKeyEntry;
import com.ef_prime.rflow.core.app.r.RStrKeyModel;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.common.keyvalue.BatchAddSupport;
import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceBatchAddSupport;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceProvider;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.TableKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.RBrowser;
import com.ef_prime.rflow.ui.app.r.RHelpView;
import com.ef_prime.rflow.ui.app.r.RJavaUI;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.SwitchPanel;
import com.ef_prime.rflow.ui.common.keyvalue.Widget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.table.GeneralTable;
import com.ef_prime.rflow.ui.common.table.UIGeneralTableModel;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.common.view.ViewTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;

public class RArgEntryWidget
extends Widget
implements ChoiceProvider,
HierarchyListener,
ValueChangeEventHandler {
    private ValueMapTable table;
    private ViewTabbedPane previewTabpane;
    private JButton rHelpButton;

    public RArgEntryWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
    }

    @Override
    protected void loadContent() {
        this.setLayout(new BorderLayout());
        this.table = new ValueMapTable(RAddonBuilderModel.ARGS);
        this.add((Component)this.table, "Center");
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(new JLabel(RAddonBuilderModel.ARGS.getTitle()));
        jToolBar.add(Box.createHorizontalStrut(2));
        this.rHelpButton = jToolBar.add(new RHelp());
        this.rHelpButton.setFocusable(false);
        this.add((Component)jToolBar, "North");
        this.addHierarchyListener(this);
    }

    @Override
    public void updateImmediately() {
        if (this.table.detailPanel == null) {
            return;
        }
        Component component = this.table.detailPanel.panel.get();
        if (component instanceof Widget) {
            ((Widget)component).updateImmediately();
        }
    }

    @Override
    public boolean startEditing() {
        return false;
    }

    private void updateWidget(boolean bl) {
        if (!(this.table == null || bl && this.table.getInnerModel() == this.getTableModel())) {
            this.table.setModel(this.getTableModel(), this.getValueMap());
        }
    }

    @Override
    public void updateWidget() {
        this.updateWidget(true);
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        super.viewDidBecomeDisplayable();
        this.updateWidget(false);
        this.getValueMap().addEventHandler(this);
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        if (this.table != null) {
            this.table.unload();
        }
        this.getValueMap().removeEventHandler(this);
    }

    private RAddonBuilderModel getBuilderModel() {
        return (RAddonBuilderModel)this.getValueMap();
    }

    private KeysTableModel getTableModel() {
        return this.getValueMap().getValue(RAddonBuilderModel.ARGS);
    }

    @Override
    public List<Choice> getChoices(ValueMap valueMap) {
        return this.getBuilderModel().getArgChoices();
    }

    @Override
    public boolean isLabel() {
        return false;
    }

    @Override
    public boolean isDescription() {
        return true;
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        Container container;
        Container container2 = this;
        while (container2.getParent() != null && !((container = container2.getParent()) instanceof Window)) {
            View view2;
            container2 = container;
            if (!(container2 instanceof JComponent) || (view2 = (View)((JComponent)container2).getClientProperty("PROPERTY_PREVIEW")) == null) continue;
            this.previewTabpane = view2.getParentTabbedPane();
            this.removeHierarchyListener(this);
            break;
        }
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        if (valueChangeEvent.getKey() == RAddonBuilderModel.TYPE) {
            this.rHelpButton.setVisible(this.getBuilderModel().isTypeDefault());
        }
    }

    private class ValueMapTable
    extends GeneralTable {
        private DetailPanel detailPanel;

        public ValueMapTable(TableKey tableKey) {
            super(tableKey);
        }

        @Override
        protected UIGeneralTableModel createUIGeneralTableModel(KeysTableModel keysTableModel) {
            return new ArgsTableModel(keysTableModel);
        }

        @Override
        protected Component createDetail(Object object) {
            if (this.detailPanel == null) {
                this.detailPanel = new DetailPanel();
            }
            this.detailPanel.setEntry((RArgKeyEntry)object);
            return this.detailPanel;
        }

        @Override
        protected BatchAddSupport<?> getBatchAddSupport() {
            final ArgsTableModel argsTableModel = (ArgsTableModel)this.getModel();
            return new ChoiceBatchAddSupport(argsTableModel.argKey){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void apply(List<String> list, Key<?> key, ValueMap valueMap) {
                    HashSet<String> hashSet = new HashSet<String>();
                    for (int i = 0; i < argsTableModel.getModelRowCount(); ++i) {
                        hashSet.add(argsTableModel.getValueAt(i, 0).toString());
                    }
                    argsTableModel.beginValueChange();
                    try {
                        for (String string : list) {
                            String string2 = string.toString();
                            if (hashSet.contains(string2)) continue;
                            RStrKeyModel rStrKeyModel = new RStrKeyModel();
                            rStrKeyModel.setKeyId(string2);
                            RArgKeyEntry rArgKeyEntry = new RArgKeyEntry();
                            rArgKeyEntry.setArgument(string2);
                            rArgKeyEntry.setKeyModel(rStrKeyModel);
                            argsTableModel.addNewRow(rArgKeyEntry);
                        }
                    }
                    finally {
                        argsTableModel.endValueChange();
                    }
                }
            };
        }

        private class ArgsTableModel
        extends UIGeneralTableModel {
            private ChoiceKey argKey;

            public ArgsTableModel(KeysTableModel keysTableModel) {
                super(keysTableModel, true);
                this.argKey = ((ChoiceKey.Builder)((ChoiceKey.Builder)ChoiceKey.builder("arg", "").setChoiceEditable(true)).setChoiceProvider(RArgEntryWidget.this)).build();
            }

            @Override
            public Key<?> getColumnKey(int n) {
                return this.argKey;
            }

            @Override
            public Key<?>[] getColumnKeys() {
                return new Key[]{this.argKey};
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (object instanceof String) {
                    RArgKeyEntry rArgKeyEntry = (RArgKeyEntry)this.getValueAt(n, n2);
                    rArgKeyEntry.setArgument(object.toString());
                    return;
                }
                super.setValueAt(object, n, n2);
            }
        }
    }

    private class RHelp
    extends LoggableAction
    implements RBrowser {
        private RHelpView helpView;

        public RHelp() {
            this.putValue("Name", Messages.getString("Widget.R.help"));
            this.putValue("SmallIcon", Icons.getIcon("16/help.png"));
            this.putValue("ShortDescription", this.getValue("Name"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            R.queryQueue().addQuery(new Runnable(){

                @Override
                public void run() {
                    String string = RArgEntryWidget.this.getBuilderModel().getFunction();
                    if (string.isEmpty()) {
                        return;
                    }
                    if (RArgEntryWidget.this.previewTabpane != null) {
                        RJavaUI.addBrowser(RHelp.this);
                        try {
                            R.client().silentIdleEval("print(?" + string + ")");
                        }
                        finally {
                            RJavaUI.removeBrowser(RHelp.this);
                        }
                    } else {
                        R.client().silentIdleEval("print(?" + string + ")");
                    }
                }
            });
        }

        @Override
        public void open(final String string, boolean bl) {
            if (!bl || RArgEntryWidget.this.previewTabpane == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (RHelp.this.helpView == null) {
                        for (int i = 0; i < RArgEntryWidget.this.previewTabpane.getTabCount(); ++i) {
                            Component component = RArgEntryWidget.this.previewTabpane.getComponentAt(i);
                            if (!(component instanceof RHelpView)) continue;
                            RHelp.this.helpView = (RHelpView)component;
                            break;
                        }
                        if (RHelp.this.helpView == null) {
                            RHelp.this.helpView = new RHelpView();
                            RHelp.this.helpView.setClosable(false);
                            RHelp.this.helpView.setIconOnly(true);
                            RHelp.this.helpView.setRBrowser(RHelp.this);
                        }
                        RArgEntryWidget.this.previewTabpane.openView(RHelp.this.helpView, ViewOpenType.OPEN_NEW, true);
                        RHelp.this.helpView.load(string);
                    } else {
                        RHelp.this.helpView.load(string);
                        RHelp.this.helpView.toFront();
                    }
                }
            });
        }
    }

    private class DetailPanel
    extends JPanel
    implements ActionListener {
        private JComboBox<String> types;
        private SwitchPanel panel;
        private RArgKeyEntry entry;
        private Map<String, KeyModel> typeModels;
        private Map<Class<?>, String> classToKey;

        DetailPanel() {
            Set<String> set = RArgKeyEntry.KEY_MODEL.getClassMap().keySet();
            String[] stringArray = set.toArray(new String[set.size()]);
            this.typeModels = new HashMap<String, KeyModel>(stringArray.length);
            this.classToKey = new HashMap(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    String string = stringArray[i];
                    Class<?> clazz = Class.forName(RArgKeyEntry.KEY_MODEL.getClassMap().get(string));
                    this.typeModels.put(string, (KeyModel)clazz.newInstance());
                    this.classToKey.put(clazz, string);
                    continue;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                    throw new RuntimeException(reflectiveOperationException);
                }
            }
            this.types = new JComboBox<String>(stringArray);
            this.types.addActionListener(this);
            this.types.setRenderer((ListCellRenderer<String>)((Object)new TypesRenderer()));
            JPanel jPanel = new JPanel((LayoutManager)new MigLayout(new LC().insets("0", "0", "4", "0").fill()));
            jPanel.add(this.types);
            this.panel = new SwitchPanel();
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "North");
            this.add((Component)this.panel, "Center");
        }

        public void setEntry(RArgKeyEntry rArgKeyEntry) {
            this.entry = rArgKeyEntry;
            this.refreshKeyModelUI();
            this.types.setSelectedItem(this.classToKey.get(rArgKeyEntry.getKeyModel().getClass()));
        }

        private void refreshKeyModelUI() {
            this.panel.set(WidgetFactory.getInstance().create(this.entry.getKeyModel()));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.types.getSelectedItem().toString();
            String string2 = RArgKeyEntry.KEY_MODEL.getClassMap().get(string);
            try {
                Class<?> clazz = Class.forName(string2);
                if (clazz.equals(this.entry.getKeyModel().getClass())) {
                    return;
                }
                KeyModel keyModel = (KeyModel)clazz.newInstance();
                keyModel.setKeyId(this.entry.getKeyModel().getKeyId());
                keyModel.setKeyTitle(this.entry.getKeyModel().getKeyTitle());
                this.entry.setKeyModel(keyModel);
                this.refreshKeyModelUI();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                throw new RuntimeException(reflectiveOperationException);
            }
        }

        private class TypesRenderer
        extends SubstanceDefaultListCellRenderer {
            private TypesRenderer() {
            }

            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent(jList, object, n, bl, bl2);
                KeyModel keyModel = DetailPanel.this.typeModels.get(object.toString());
                this.setText(keyModel.getTitle());
                this.setIcon(keyModel.getSmallIcon());
                return this;
            }
        }
    }
}

