/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.keyvalue;

import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.DescriptionLink;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.ui.app.r.keyvalue.RCharSupportDocumentHandler;
import com.ef_prime.rflow.ui.app.r.script.RCodingTextField;
import com.ef_prime.rflow.ui.app.r.script.RCompletion;
import com.ef_prime.rflow.ui.app.r.script.RCompletionAddOn;
import com.ef_prime.rflow.ui.app.r.script.RCompletionProvider;
import com.ef_prime.rflow.ui.common.keyvalue.ChoiceComboboxModel;
import com.ef_prime.rflow.ui.common.keyvalue.ChoiceKeyWidget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetConstants;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.fife.ui.autocomplete.CompletionProvider;
import org.pushingpixels.substance.internal.ui.SubstanceComboBoxUI;

public class RChoiceKeyWidget
extends ChoiceKeyWidget {
    private RCompletionProvider completionProvider;

    public RChoiceKeyWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
    }

    @Override
    protected void loadContent() {
        super.loadContent();
        if (this.combobox.getEditor() instanceof RChoiceComboBoxEditor) {
            RChoiceComboBoxEditor rChoiceComboBoxEditor = (RChoiceComboBoxEditor)this.combobox.getEditor();
            if (this.completionProvider == null) {
                this.completionProvider = new RCompletionProvider();
            }
            if (this.getKey().getChoiceProvider() != null) {
                this.completionProvider.setPriorityList(new CompletionAddOn());
            } else {
                this.completionProvider.setPriorityList(null);
            }
            rChoiceComboBoxEditor.field.getAutoCompletion().setCompletionProvider((CompletionProvider)this.completionProvider);
            rChoiceComboBoxEditor.field.discardAllEdits();
        }
    }

    @Override
    public RChoiceKey getKey() {
        return (RChoiceKey)super.getKey();
    }

    @Override
    protected ComboBoxEditor createComboBoxEditor() {
        return new RChoiceComboBoxEditor();
    }

    @Override
    protected void refreshEmptyMessage() {
        if (!this.combobox.isEditable()) {
            return;
        }
        Component component = this.combobox.getEditor().getEditorComponent();
        if (component instanceof RChoiceComboxTextField) {
            RChoiceComboxTextField rChoiceComboxTextField = (RChoiceComboxTextField)((Object)component);
            if (this.getKey().isDynamicDefault()) {
                rChoiceComboxTextField.updateDescription();
            } else {
                rChoiceComboxTextField.setEmptyMessage(this.getKey().getEmptyMessage(this.getValueMap()));
            }
            this.combobox.repaint();
        }
    }

    @Override
    protected void refreshDescription(Key<?> key) {
        Component component;
        if (!this.combobox.isEditable()) {
            return;
        }
        DescriptionLink descriptionLink = this.getKey().getDescriptionLink();
        if (descriptionLink != null && (key == null || descriptionLink.contains(key.getId())) && (component = this.combobox.getEditor().getEditorComponent()) instanceof RChoiceComboxTextField) {
            ((RChoiceComboxTextField)((Object)component)).setDescription(this.getKey().getDescriptionMessage(this.getValueMap()));
        }
    }

    @Override
    protected boolean supportsAutoValueLink() {
        return true;
    }

    private class RChoiceComboBoxEditor
    implements ComboBoxEditor,
    FocusListener {
        private RChoiceComboxTextField field;

        public RChoiceComboBoxEditor() {
            this.field = new RChoiceComboxTextField();
            this.field.addFocusListener(this);
            if (RChoiceKeyWidget.this.getKey().isCharSupport()) {
                this.field.getDocument().setDocumentFilter((DocumentFilter)new RCharSupportDocumentHandler((JTextComponent)((Object)this.field)));
            }
        }

        @Override
        public Component getEditorComponent() {
            return this.field;
        }

        @Override
        public void setItem(Object object) {
            if (object == null) {
                object = "";
            }
            this.field.setText(object.toString());
            ChoiceComboboxModel choiceComboboxModel = (ChoiceComboboxModel)RChoiceKeyWidget.this.combobox.getModel();
            choiceComboboxModel.clearFilter();
        }

        @Override
        public Object getItem() {
            return new Choice(this.field.getText());
        }

        @Override
        public void selectAll() {
            this.field.selectAll();
            this.field.requestFocusInWindow();
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            this.field.addActionListener(actionListener);
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
            this.field.removeActionListener(actionListener);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.field.fireActionPerformed();
            ChoiceComboboxModel choiceComboboxModel = (ChoiceComboboxModel)RChoiceKeyWidget.this.combobox.getModel();
            choiceComboboxModel.clearFilter();
        }
    }

    private class CompletionAddOn
    implements RCompletionAddOn {
        private CompletionAddOn() {
        }

        @Override
        public List<RCompletion> getCompletions(CompletionProvider completionProvider) {
            ArrayList arrayList = Lists.newArrayList();
            List<Choice> list = RChoiceKeyWidget.this.getKey().getChoices(RChoiceKeyWidget.this.getValueMap());
            if (list == null || list.isEmpty()) {
                return arrayList;
            }
            for (Choice choice : list) {
                arrayList.add(new RCompletion(completionProvider, choice.getValue()));
            }
            return arrayList;
        }

        @Override
        public boolean isExclusive() {
            return false;
        }
    }

    private class RChoiceComboxTextField
    extends RCodingTextField
    implements DocumentListener,
    KeyListener {
        public RChoiceComboxTextField() {
            super("");
            this.getDocument().addDocumentListener((DocumentListener)this);
            this.setOpaque(false);
            this.setBorder(null);
            if (this.getForeground() != null && !(this.getForeground() instanceof UIResource)) {
                this.setForeground(new ColorUIResource(this.getForeground()));
            }
            if (this.getBackground() != null && !(this.getBackground() instanceof UIResource)) {
                this.setBackground(new ColorUIResource(this.getBackground()));
            }
            this.updateDescription();
            this.addKeyListener(this);
        }

        @Override
        public void setText(String string) {
            if (this.getText().equals(string)) {
                return;
            }
            super.setText(string);
        }

        private void updateDescription() {
            if (!RChoiceKeyWidget.this.getKey().isLabel()) {
                return;
            }
            String string = null;
            Color color = this.getDescriptionColor();
            String string2 = this.getText();
            String string3 = RChoiceKeyWidget.this.getKey().getLabel(string2, RChoiceKeyWidget.this.getValueMap());
            if (!StringUtils.isEmpty((CharSequence)string3)) {
                string = "(" + string3 + ")";
                color = string2.isEmpty() && RChoiceKeyWidget.this.getKey().isDynamicDefault() ? WidgetConstants.AUTO_FONT_COLOR : WidgetConstants.INFO_FONT_COLOR;
            }
            this.setDescriptionColor(color);
            this.setDescription(string);
        }

        private void updateModel() {
            ChoiceComboboxModel choiceComboboxModel = (ChoiceComboboxModel)RChoiceKeyWidget.this.combobox.getModel();
            String string = this.getText();
            ChoiceComboboxModel.setStandardChoiceFilter(choiceComboboxModel, string);
            if (string.isEmpty() || choiceComboboxModel.getSize() == 0) {
                RChoiceKeyWidget.this.combobox.setPopupVisible(false);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateDescription();
            this.updateModel();
            RChoiceKeyWidget.this.getDelayedUpdater().requestAction();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateDescription();
            this.updateModel();
            RChoiceKeyWidget.this.getDelayedUpdater().requestAction();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if ((keyEvent.getModifiersEx() | 0x40) != 64) {
                return;
            }
            char c = keyEvent.getKeyChar();
            if (Character.getType(c) != 15 && !RChoiceKeyWidget.this.combobox.isPopupVisible()) {
                ChoiceComboboxModel choiceComboboxModel = (ChoiceComboboxModel)RChoiceKeyWidget.this.combobox.getModel();
                ChoiceComboboxModel.setStandardChoiceFilter(choiceComboboxModel, this.getText());
                choiceComboboxModel.setData(RChoiceKeyWidget.this.getKey().getChoices(RChoiceKeyWidget.this.getValueMap()), this.getText());
                if (choiceComboboxModel.getSize() > 0) {
                    RChoiceKeyWidget.this.combobox.setPopupVisible(true);
                    if (RChoiceKeyWidget.this.combobox.getUI() instanceof SubstanceComboBoxUI) {
                        SubstanceComboBoxUI substanceComboBoxUI = (SubstanceComboBoxUI)RChoiceKeyWidget.this.combobox.getUI();
                        substanceComboBoxUI.getPopup().getList().clearSelection();
                    }
                }
            }
        }
    }
}

