/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.keyvalue;

import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RFileKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.ui.app.r.script.RCodingTextField;
import com.ef_prime.rflow.ui.app.r.script.RCodingTextFieldWithBorder;
import com.ef_prime.rflow.ui.common.keyvalue.FileKeyWidget;
import java.io.File;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.swing.text.JTextComponent;

public class RFileKeyWidget
extends FileKeyWidget {
    public RFileKeyWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
    }

    @Override
    protected JTextComponent createTextComponent() {
        return new RCodingTextFieldWithBorder((String)this.getKeyValue());
    }

    @Override
    protected void configureTextComponent() {
        super.configureTextComponent();
        if (this.input instanceof RCodingTextFieldWithBorder) {
            ((RCodingTextFieldWithBorder)((Object)this.input)).addActionListener(this);
        }
    }

    public RCodingTextField getInput() {
        return (RCodingTextField)((Object)super.getInput());
    }

    @Override
    public RFileKey getKey() {
        return (RFileKey)super.getKey();
    }

    @Override
    protected void refreshEmptyMessage() {
        if (this.getKey().isDynamicDefault()) {
            this.getInput().setEmptyMessage(this.getKey().getDynamicDefaultMessage(this.getValueMap()));
            this.getInput().setEmptyMessageColor(AUTO_FONT_COLOR);
        } else {
            this.getInput().setEmptyMessage(this.getKey().getEmptyMessage(this.getValueMap()));
            this.getInput().setEmptyMessageColor(INFO_FONT_COLOR);
        }
    }

    @Override
    protected void refreshAutoValueLinkColor() {
        this.getInput().setConstantColor(this.isAutoValueLinkEnabled() ? AUTO_FONT_COLOR : null);
        this.getInput().repaint();
    }

    @Override
    protected File valueToFile(String string) {
        return new File(RUtility.unquote(string));
    }

    @Override
    protected String fileToValue(File file) {
        return RUtility.quotedPath(file.getPath());
    }

    @Override
    protected String filesToValue(File[] fileArray) {
        if (fileArray.length == 1) {
            return this.fileToValue(fileArray[0]);
        }
        return Arrays.stream(fileArray).map(file -> RUtility.quotedPath(file.getPath())).collect(Collectors.joining(", ", "c(", ")"));
    }
}

