/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.keyvalue;

import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.RBrowser;
import com.ef_prime.rflow.ui.app.r.RHelpView;
import com.ef_prime.rflow.ui.app.r.RJavaUI;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.keyvalue.Widget;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.common.view.ViewTabbedPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class RHelpAction
extends LoggableAction
implements RBrowser,
HierarchyListener {
    private Widget parent;
    private Supplier<String> topicSupplier;
    private RHelpView helpView;
    private ViewTabbedPane previewTabpane;

    public RHelpAction(Widget widget, Supplier<String> supplier, boolean bl) {
        this.parent = widget;
        this.topicSupplier = supplier;
        this.putValue("Name", Messages.getString("Widget.R.help"));
        this.putValue("SmallIcon", Icons.getIcon("16/help.png"));
        this.putValue("ShortDescription", this.getValue("Name"));
        if (bl) {
            widget.addHierarchyListener(this);
        }
    }

    @Override
    public void action(ActionEvent actionEvent) {
        R.queryQueue().addQuery(new Runnable(){

            @Override
            public void run() {
                String string = "print(?" + RHelpAction.this.topicSupplier.get() + ")";
                if (RHelpAction.this.previewTabpane != null) {
                    RJavaUI.addBrowser(RHelpAction.this);
                    try {
                        R.client().silentIdleEval(string);
                    }
                    finally {
                        RJavaUI.removeBrowser(RHelpAction.this);
                    }
                } else {
                    R.client().silentIdleEval(string);
                }
            }
        });
    }

    @Override
    public void open(final String string, boolean bl) {
        if (!bl || this.previewTabpane == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (RHelpAction.this.helpView == null) {
                    for (int i = 0; i < RHelpAction.this.previewTabpane.getTabCount(); ++i) {
                        Component component = RHelpAction.this.previewTabpane.getComponentAt(i);
                        if (!(component instanceof RHelpView)) continue;
                        RHelpAction.this.helpView = (RHelpView)component;
                        break;
                    }
                    if (RHelpAction.this.helpView == null) {
                        RHelpAction.this.helpView = new RHelpView();
                        RHelpAction.this.helpView.setClosable(false);
                        RHelpAction.this.helpView.setIconOnly(true);
                        RHelpAction.this.helpView.setRBrowser(RHelpAction.this);
                    }
                    RHelpAction.this.previewTabpane.openView(RHelpAction.this.helpView, ViewOpenType.OPEN_NEW, true);
                    RHelpAction.this.helpView.load(string);
                } else {
                    RHelpAction.this.helpView.load(string);
                    RHelpAction.this.helpView.toFront();
                }
            }
        });
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        Container container;
        Container container2 = this.parent;
        while (container2.getParent() != null && !((container = container2.getParent()) instanceof Window)) {
            View view2;
            container2 = container;
            if (!(container2 instanceof JComponent) || (view2 = (View)((JComponent)container2).getClientProperty("PROPERTY_PREVIEW")) == null) continue;
            this.previewTabpane = view2.getParentTabbedPane();
            this.parent.removeHierarchyListener(this);
            break;
        }
    }
}

