/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.keyvalue;

import com.ef_prime.rflow.core.app.r.RReplaceNA;
import com.ef_prime.rflow.core.app.r.RReplaceNAMulti;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.list.ListModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.keyvalue.ComponentTableKeyWidget;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class RReplaceNATableWidget
extends ComponentTableKeyWidget {
    public RReplaceNATableWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
    }

    @Override
    protected ComponentTableKeyWidget.ComponentTableActions createActions() {
        return new NATableActions();
    }

    @Override
    protected void configureToolBar(JToolBar jToolBar) {
        jToolBar.add(this.createButton(ComponentTableKeyWidget.ComponentTableActions.Add.class));
        jToolBar.add(this.createButton(ComponentTableKeyWidget.ComponentTableActions.Remove.class));
        jToolBar.add(this.createButton(NATableActions.Unify.class));
        jToolBar.add(this.createButton(ComponentTableKeyWidget.ComponentTableActions.Up.class));
        jToolBar.add(this.createButton(ComponentTableKeyWidget.ComponentTableActions.Down.class));
    }

    private class NATableActions
    extends ComponentTableKeyWidget.ComponentTableActions {
        public NATableActions() {
            super(RReplaceNATableWidget.this);
            this.put(new Unify());
            this.updateState();
        }

        @Override
        protected void updateState() {
            super.updateState();
            Action action = this.get(Unify.class);
            if (action != null) {
                action.setEnabled(RReplaceNATableWidget.this.getTable().getSelections().length > 0);
            }
        }

        private class Unify
        extends AbstractAction {
            public Unify() {
                this.putValue("Name", Messages.getString("Action.group"));
                this.putValue("SmallIcon", Icons.getIcon("16/arrow_join_right.png"));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComponentTableKeyWidget.ComponentTable componentTable = RReplaceNATableWidget.this.getTable();
                ListModel listModel = RReplaceNATableWidget.this.getListModel();
                int[] nArray = componentTable.getSelections();
                if (nArray.length < 1) {
                    return;
                }
                RReplaceNATableWidget.this.getUndoableEditSupport().beginUpdate();
                listModel.beginValueChange();
                try {
                    componentTable.clearSelection();
                    RReplaceNA rReplaceNA = (RReplaceNA)listModel.get(nArray[0]);
                    List<String> list = Arrays.stream(nArray).mapToObj(n -> (ValueMap)listModel.get(n)).flatMap(valueMap -> ((RReplaceNA)valueMap).getColumns().stream()).filter(string -> !string.isEmpty()).collect(Collectors.toList());
                    RReplaceNAMulti rReplaceNAMulti = new RReplaceNAMulti(list, rReplaceNA);
                    listModel.remove(nArray);
                    listModel.add(nArray[0], rReplaceNAMulti);
                    SwingUtilities.invokeLater(() -> componentTable.setSelectedIndex(nArray[0]));
                }
                finally {
                    RReplaceNATableWidget.this.getUndoableEditSupport().endUpdate();
                    listModel.endValueChange();
                }
            }
        }
    }
}

