/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.keyvalue;

import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.common.keyvalue.DescriptionLink;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.TextSearchResult;
import com.ef_prime.rflow.ui.app.r.keyvalue.RCharSupportDocumentHandler;
import com.ef_prime.rflow.ui.app.r.script.RCodingTextField;
import com.ef_prime.rflow.ui.app.r.script.RCodingTextFieldWithBorder;
import com.ef_prime.rflow.ui.common.keyvalue.KeyWidget;
import com.ef_prime.rflow.ui.common.keyvalue.LabeledWidget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetConstants;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

public class RStrKeyWidget
extends LabeledWidget
implements WidgetConstants,
ActionListener {
    private RCodingTextField input;
    private EmptyMessageHandler emptyMessageHandler;
    private DescriptionHandler descriptionHandler;
    private KeyWidget.AutoValueLinkButton linkButton;

    public RStrKeyWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
    }

    @Override
    protected void loadContent() {
        this.input = new RCodingTextFieldWithBorder((String)this.getKeyValue());
        this.input.addFocusListener(this.createUpdateFocusListener());
        this.input.getDocument().addDocumentListener(this.createUpdateDocumentListener());
        this.input.addActionListener(this);
        if (this.getKey().isCharSupport()) {
            this.input.getDocument().setDocumentFilter((DocumentFilter)new RCharSupportDocumentHandler((JTextComponent)((Object)this.input)));
        }
        if (this.getKey().isDynamicDefault() || this.getKey().isEmptyMessage()) {
            this.emptyMessageHandler = new EmptyMessageHandler();
            this.refreshEmptyMessage();
        }
        if (this.getKey().getDescriptionLink() != null) {
            this.descriptionHandler = new DescriptionHandler();
            this.refreshDescription(null);
        }
        this.getKey().installCompletionSupport(this.input, this.getValueMap());
        this.setLayout(new BorderLayout());
        this.add(this.createLayer((Component)((Object)this.input)));
        if (this.getKey().getAutoValueLink() != null) {
            this.linkButton = this.createAutoValueLinkButton();
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(new EmptyBorder(0, 4, 0, 0));
            jPanel.add(this.linkButton);
            this.add((Component)jPanel, "East");
            this.input.getDocument().addDocumentListener(this.createAutoValueDocumentListener(this.linkButton));
            this.refreshAutoValueLinkColor();
        }
    }

    public RStrKey getKey() {
        return (RStrKey)super.getKey();
    }

    @Override
    protected Object getValue() {
        return this.input.getText();
    }

    @Override
    public void updateWidget() {
        if (this.input != null) {
            this.input.setText((String)this.getKeyValue());
        }
    }

    @Override
    public boolean startEditing() {
        this.input.selectAll();
        this.input.requestFocusInWindow();
        return true;
    }

    @Override
    public void select(SearchResult searchResult) {
        if (!(searchResult instanceof TextSearchResult) || this.input == null) {
            return;
        }
        TextSearchResult textSearchResult = (TextSearchResult)searchResult;
        this.input.select(textSearchResult.getOffset(), textSearchResult.getEnd());
        this.input.requestFocusInWindow();
    }

    @Override
    public void clearSelection() {
        if (this.input != null) {
            this.input.select(0, 0);
        }
    }

    @Override
    protected boolean supportsAutoValueLink() {
        return true;
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        super.viewDidBecomeDisplayable();
        if (this.emptyMessageHandler != null) {
            this.refreshEmptyMessage();
            this.getValueMap().addEventHandler(this.emptyMessageHandler);
        }
        if (this.descriptionHandler != null) {
            this.refreshDescription(null);
            this.getValueMap().addEventHandler(this.descriptionHandler);
        }
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        if (this.emptyMessageHandler != null) {
            this.getValueMap().removeEventHandler(this.emptyMessageHandler);
        }
        if (this.descriptionHandler != null) {
            this.getValueMap().removeEventHandler(this.descriptionHandler);
        }
    }

    private void refreshEmptyMessage() {
        if (this.getKey().isDynamicDefault()) {
            this.input.setEmptyMessage(this.getKey().getDynamicDefaultMessage(this.getValueMap()));
            this.input.setEmptyMessageColor(AUTO_FONT_COLOR);
        } else {
            this.input.setEmptyMessage(this.getKey().getEmptyMessage(this.getValueMap()));
            this.input.setEmptyMessageColor(INFO_FONT_COLOR);
        }
    }

    private void refreshDescription(Key<?> key) {
        DescriptionLink descriptionLink = this.getKey().getDescriptionLink();
        if (descriptionLink != null && (key == null || descriptionLink.contains(key.getId()))) {
            this.input.setDescription(this.getKey().getDescriptionMessage(this.getValueMap()));
        }
    }

    private void refreshAutoValueLinkColor() {
        this.input.setConstantColor(this.isAutoValueLinkEnabled() ? AUTO_FONT_COLOR : null);
        this.input.repaint();
    }

    @Override
    protected void autoValueLinkChanged() {
        if (this.linkButton != null) {
            this.linkButton.updateWidget();
        }
        super.autoValueLinkChanged();
    }

    @Override
    protected void autoValueLinkStateChanged() {
        UIUtility.invokeLater(new Runnable(){

            @Override
            public void run() {
                RStrKeyWidget.this.refreshAutoValueLinkColor();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.update();
    }

    private class EmptyMessageHandler
    implements ValueChangeEventHandler {
        private EmptyMessageHandler() {
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            RStrKeyWidget.this.refreshEmptyMessage();
        }
    }

    private class DescriptionHandler
    implements ValueChangeEventHandler {
        private DescriptionHandler() {
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            RStrKeyWidget.this.refreshDescription(valueChangeEvent.getKey());
        }
    }
}

