/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.keyvalue;

import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.keyvalue.RGeneralTable;
import com.ef_prime.rflow.ui.app.r.script.RCodingTextField;
import com.ef_prime.rflow.ui.common.keyvalue.ChoiceComboboxModel;
import com.ef_prime.rflow.ui.common.keyvalue.TableChoiceComboBox;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetConstants;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.apache.commons.lang3.StringUtils;

public class RTableChoiceComboBox
extends TableChoiceComboBox {
    private static final Logger LOGGER = Logger.getLogger(RTableChoiceComboBox.class.getName());

    public RTableChoiceComboBox(RGeneralTable rGeneralTable, RChoiceKey rChoiceKey, ValueMap valueMap, boolean bl) {
        super(rGeneralTable, rChoiceKey, valueMap, bl);
    }

    @Override
    public void setSelectedItem(Object object) {
        super.setSelectedItem(object);
        ComboBoxEditor comboBoxEditor = this.getEditor();
        if (comboBoxEditor instanceof RChoiceComboBoxEditor) {
            ((RChoiceComboBoxEditor)comboBoxEditor).field.updateDescription();
        }
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new RChoiceComboBoxEditor();
    }

    @Override
    public RChoiceKey getKey() {
        return (RChoiceKey)super.getKey();
    }

    private class RChoiceComboBoxEditor
    implements ComboBoxEditor,
    FocusListener {
        private RChoiceComboxTextField field;

        public RChoiceComboBoxEditor() {
            this.field = new RChoiceComboxTextField();
            this.field.addFocusListener(this);
        }

        @Override
        public Component getEditorComponent() {
            return this.field;
        }

        @Override
        public void setItem(Object object) {
            if (object == null) {
                object = "";
            }
            if (this.field.getText().equals(object)) {
                return;
            }
            this.field.setText(object.toString());
        }

        @Override
        public Object getItem() {
            return new Choice(this.field.getText());
        }

        @Override
        public void selectAll() {
            this.field.selectAll();
            this.field.requestFocusInWindow();
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            this.field.addActionListener(actionListener);
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
            this.field.removeActionListener(actionListener);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (!RTableChoiceComboBox.this.isPopupVisible()) {
                RTableChoiceComboBox.this.setPopupVisible(true);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class RChoiceComboxTextField
    extends RCodingTextField
    implements DocumentListener {
        private String description;
        private Color descriptionColor;

        public RChoiceComboxTextField() {
            super("");
            this.descriptionColor = WidgetConstants.INFO_FONT_COLOR;
            this.getDocument().addDocumentListener((DocumentListener)this);
            this.setOpaque(false);
            this.setBorder(null);
            if (RTableChoiceComboBox.this.getKey().getChoiceProvider() != null) {
                RChoiceProvider.install(RTableChoiceComboBox.this.getKey().getChoiceProvider(), this, RTableChoiceComboBox.this.getValueMap());
            }
            if (RTableChoiceComboBox.this.isForRendering()) {
                this.removeFocusListener(this);
                this.setBracketMatchingEnabled(false);
            }
        }

        @Override
        protected void tabPressed() {
            RTableChoiceComboBox.this.getTable().next(true);
        }

        @Override
        protected void shiftTabPressed() {
            RTableChoiceComboBox.this.getTable().next(false);
        }

        @Override
        public void setText(String string) {
            if (this.getText().equals(string)) {
                return;
            }
            super.setText(string);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (this.description == null) {
                return dimension;
            }
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            dimension.width += SwingUtilities.computeStringWidth(fontMetrics, this.description);
            return dimension;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Rectangle rectangle;
            super.paintComponent(graphics);
            if (this.description == null) {
                return;
            }
            int n = this.getDocument().getLength();
            TextUI textUI = this.getUI();
            try {
                rectangle = textUI.modelToView((JTextComponent)((Object)this), n, Position.Bias.Backward);
            }
            catch (BadLocationException badLocationException) {
                LOGGER.log(Level.SEVERE, "Unexpected BadLocationException.", badLocationException);
                return;
            }
            Color color = graphics.getColor();
            graphics.setColor(this.descriptionColor);
            UIUtility.drawStringCenterY(graphics, (Component)((Object)this), this.description, rectangle.x + rectangle.width + 5);
            graphics.setColor(color);
        }

        private void updateDescription() {
            Object object;
            this.description = null;
            String string = this.getText();
            if (string.isEmpty() && RTableChoiceComboBox.this.getKey().isDynamicDefault() && RTableChoiceComboBox.this.getTable() != null && (object = RTableChoiceComboBox.this.getValueMap().getDynamicDefaultValue(RTableChoiceComboBox.this.getTable().getInnerModel(), RTableChoiceComboBox.this.getRow(), RTableChoiceComboBox.this.getKey())) instanceof String) {
                this.description = "(" + String.valueOf(object) + ")";
                this.descriptionColor = WidgetConstants.AUTO_FONT_COLOR;
                return;
            }
            object = RTableChoiceComboBox.this.getKey().getLabel(string, RTableChoiceComboBox.this.getValueMap());
            this.description = StringUtils.isEmpty((CharSequence)object) ? null : "(" + (String)object + ")";
            this.descriptionColor = WidgetConstants.INFO_FONT_COLOR;
        }

        private void documentChanged() {
            this.updateDescription();
            ComboBoxModel comboBoxModel = RTableChoiceComboBox.this.getModel();
            String string = this.getText();
            ChoiceComboboxModel.setStandardChoiceFilter((ChoiceComboboxModel<Choice>)comboBoxModel, string);
            if (string.isEmpty() || ((ChoiceComboboxModel)comboBoxModel).getSize() == 0) {
                RTableChoiceComboBox.this.setPopupVisible(false);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.documentChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.documentChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

