/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.keyvalue;

import com.ef_prime.rflow.ui.app.r.script.RCodingTextField;
import com.ef_prime.rflow.ui.common.component.TextComponentContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class TableRTextArea
extends JScrollPane
implements ComponentListener,
DocumentListener,
TextComponentContainer,
FocusListener {
    private JTable table;
    private RCodingTextField textArea = new RCodingTextField();

    public TableRTextArea(boolean bl, JTable jTable) {
        this.table = jTable;
        this.textArea.setLineWrap(!bl);
        this.textArea.setBorder(new CompoundBorder(new LineBorder(Color.GRAY){

            @Override
            public Insets getBorderInsets(Component component) {
                return new Insets(0, 0, 0, 0);
            }

            @Override
            public Insets getBorderInsets(Component component, Insets insets) {
                insets.bottom = 0;
                insets.right = 0;
                insets.top = 0;
                insets.left = 0;
                return insets;
            }
        }, new EmptyBorder(2, 4, 2, 4)));
        this.setHorizontalScrollBarPolicy(31);
        this.setVerticalScrollBarPolicy(21);
        this.setBorder(null);
        this.setViewportView((Component)((Object)this.textArea));
        this.addFocusListener(this);
        this.textArea.addComponentListener(this);
        this.textArea.getDocument().addDocumentListener((DocumentListener)this);
    }

    public RCodingTextField getTextArea() {
        return this.textArea;
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setText(String string) {
        this.textArea.setText(string);
    }

    public void discardAllEdits() {
        this.textArea.discardAllEdits();
    }

    private void refreshRowHeight(boolean bl) {
        final int n = this.table.getEditingRow();
        if (n < 0) {
            return;
        }
        if (!bl) {
            this.refreshRowHeight(n);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TableRTextArea.this.refreshRowHeight(n);
                }
            });
        }
    }

    private void refreshRowHeight(int n) {
        this.setFont(this.getFont());
        Dimension dimension = this.textArea.getPreferredSize();
        int n2 = (int)dimension.getHeight();
        if (n2 != this.table.getRowHeight(n)) {
            this.table.setRowHeight(n, n2);
        }
    }

    @Override
    public final Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public final Insets getInsets(Insets insets) {
        insets.bottom = 0;
        insets.right = 0;
        insets.top = 0;
        insets.left = 0;
        return insets;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        return this.textArea.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.refreshRowHeight(false);
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.refreshRowHeight(true);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public JTextComponent getTextComponent() {
        return this.textArea;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.textArea == null) {
            return;
        }
        this.textArea.requestFocusInWindow();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }
}

