/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.node;

import com.ef_prime.rflow.core.app.r.RModel;
import com.ef_prime.rflow.core.app.r.RModelInterface;
import com.ef_prime.rflow.core.app.r.RModeling;
import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TableKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ValueMapKey;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableRow;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.node.OpExecutor;
import com.ef_prime.rflow.core.task.NodeModelTask;
import com.ef_prime.rflow.core.task.TaskQueue;
import com.ef_prime.rflow.node.ui.OpManager;
import com.ef_prime.rflow.node.ui.UINodeModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.keyvalue.ListAndDetailsKeyWidget;
import com.ef_prime.rflow.ui.common.table.GeneralTable;
import com.ef_prime.rflow.ui.common.table.UIGeneralTableModel;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class RModelsWidget
extends ListAndDetailsKeyWidget {
    private OpExecutor executor;

    public RModelsWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
        this.executor = (OpExecutor)widgetNode.getRoot().getProperty(OpExecutor.PROPERTY_EXECUTOR);
    }

    @Override
    protected GeneralTable createTable(TableKey tableKey) {
        return new ModelsTable(tableKey);
    }

    private class ModelsTable
    extends ListAndDetailsKeyWidget.ValueMapTable {
        public ModelsTable(TableKey tableKey) {
            super(RModelsWidget.this, tableKey);
        }

        @Override
        protected UIGeneralTableModel createUIGeneralTableModel(KeysTableModel keysTableModel) {
            return new ModelsTableModel(keysTableModel);
        }

        @Override
        protected GeneralTable.GeneralTableActions createActions() {
            return new RModelsActions();
        }

        @Override
        protected void insert(ActionEvent actionEvent, int n) {
            Object object;
            Object object22;
            ValueMapKey valueMapKey = this.getValueMapKey();
            HashSet<String> hashSet = new HashSet<String>();
            for (Object object22 : RModelsWidget.this.getTableModel()) {
                object = (RModel)((KeysTableRow)object22).getValue(valueMapKey);
                hashSet.add(((RModel)object).getName());
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            object22 = RModelInterface.METHOD.getChoices(null);
            object = object22.iterator();
            while (object.hasNext()) {
                Choice choice = (Choice)object.next();
                RModel rModel = (RModel)OpManager.getInstance().getInstance(new RModel().getId());
                rModel.putValue(RModel.METHOD, choice.getValue());
                String string = rModel.getDefaultName();
                Object object3 = string;
                int n2 = 0;
                while (hashSet.contains(object3) || n2 > 1000) {
                    object3 = string + "_" + ++n2;
                }
                rModel.setName((String)object3);
                jPopupMenu.add(new AddAction(rModel, n));
            }
            this.showPopupMenu(jPopupMenu, actionEvent.getSource());
        }

        @Override
        protected void configurePopup(JPopupMenu jPopupMenu) {
            super.configurePopup(jPopupMenu);
            jPopupMenu.insert(this.actions.get(RModelsActions.RunSelected.class), 0);
            jPopupMenu.insert(new JPopupMenu.Separator(), 1);
        }

        private class ModelsTableModel
        extends UIGeneralTableModel {
            private StrKey nameKey;

            public ModelsTableModel(KeysTableModel keysTableModel) {
                super(keysTableModel, true);
                this.nameKey = StrKey.builder("name", "").build();
            }

            @Override
            public Key<?> getColumnKey(int n) {
                return this.nameKey;
            }

            @Override
            public Key<?>[] getColumnKeys() {
                return new Key[]{this.nameKey};
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (object instanceof String) {
                    RModel rModel = (RModel)this.getValueAt(n, n2);
                    rModel.setName(object.toString());
                    return;
                }
                super.setValueAt(object, n, n2);
            }
        }

        private class RModelsActions
        extends GeneralTable.GeneralTableActions {
            public RModelsActions() {
                super(ModelsTable.this);
                this.put(new RunSelected());
            }

            @Override
            protected void updateState() {
                super.updateState();
                boolean bl = ModelsTable.this.table.getSelectionModel().isSelectionEmpty();
                this.get(RunSelected.class).setEnabled(!bl);
            }

            private class RunSelected
            extends LoggableAction {
                public RunSelected() {
                    this.putValue("Name", Messages.getString("Action.run_selection"));
                    this.putValue("SmallIcon", Icons.getIcon("16/bullet_arrow_right.png"));
                    this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, UIUtility.MENU_KEY_MASK));
                }

                @Override
                public void action(ActionEvent actionEvent) {
                    int[] nArray = ModelsTable.this.table.getSelectedRows();
                    if (nArray == null || nArray.length == 0) {
                        return;
                    }
                    RModeling rModeling = (RModeling)RModelsWidget.this.getValueMap();
                    rModeling = rModeling.runSelectionInstance(nArray);
                    FlowRunOption flowRunOption = FlowRunOption.createRunImmediatelyOption().setFocusResult(true);
                    NodeModelTask nodeModelTask = new NodeModelTask(flowRunOption, new UINodeModel(rModeling));
                    if (RModelsWidget.this.executor != null) {
                        RModelsWidget.this.executor.run(nodeModelTask);
                    } else {
                        TaskQueue.getInstance().addTask(nodeModelTask);
                    }
                }
            }
        }

        private class AddAction
        extends AbstractAction {
            private RModel rModel;
            private int row;

            public AddAction(RModel rModel, int n) {
                this.putValue("Name", rModel.getMethodLabel());
                this.rModel = rModel;
                this.row = n;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelsTable.this.stopEditing();
                RModelsWidget.this.getTableModel().insertNewRow(this.row, this.rModel);
                ModelsTable.this.table.scrollRectToVisible(ModelsTable.this.table.getCellRect(this.row, 0, true));
                ModelsTable.this.selectCell(this.row, 0);
                SwingUtilities.invokeLater(() -> ModelsTable.this.startDetailEditing());
            }
        }
    }
}

