/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.object;

import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RInterface;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.object.RDataObjectView;
import com.ef_prime.rflow.ui.app.r.object.RObjectBrowser;
import com.ef_prime.rflow.ui.app.r.object.RObjectView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.RList;

public class RArrayObjectView
extends RObjectView {
    private static final Logger LOGGER = Logger.getLogger(RArrayObjectView.class.getName());
    private static final String TYPE_DEFAULT = "default";
    private static final String TYPE_RATIO = "ratio";
    private static final String TYPE_ROW_RATIO = "row_ratio";
    private static final String TYPE_COLUMN_RATIO = "column_ratio";
    private JPanel controlPanel;
    private VarComboBox rowComboBox;
    private VarComboBox columnComboBox;
    private ConditionComboBox conditionComboBox;
    private JPanel typePanel;
    private TypeComboBox typeComboBox;
    private JPanel titlePanel;
    private JLabel titleLabel;
    private RDataObjectView objectView;
    private List<String> varNames;
    private List<String[]> names = new ArrayList<String[]>(0);
    private int[] conditionDim;
    private boolean lockRefresh;

    public RArrayObjectView(RInterface rInterface, RObjectBrowser rObjectBrowser) {
        super(rInterface, rObjectBrowser);
        this.setTitle(Messages.getString("R.Object.Table.title"));
    }

    public static boolean isViewable(RObject rObject) {
        return rObject.isFlag(4);
    }

    @Override
    protected void loadContent() {
        this.rowComboBox = new VarComboBox();
        this.columnComboBox = new VarComboBox();
        this.conditionComboBox = new ConditionComboBox();
        this.controlPanel = new JPanel((LayoutManager)new MigLayout(new LC().insetsAll("0").fill()));
        this.controlPanel.add((Component)this.rowComboBox, new CC().split(5));
        this.controlPanel.add(new JLabel(" x "));
        this.controlPanel.add(this.columnComboBox);
        this.controlPanel.add(new JLabel(Messages.getString("R.Object.Array.condition")));
        this.controlPanel.add(this.conditionComboBox);
        this.controlPanel.setVisible(false);
        this.typeComboBox = new TypeComboBox();
        this.typePanel = new JPanel((LayoutManager)new MigLayout(new LC().insetsAll("0").fill()));
        this.typePanel.add((Component)new JLabel(Messages.getString("R.Object.Array.type") + " "), new CC().split(2));
        this.typePanel.add(this.typeComboBox);
        this.typePanel.setVisible(false);
        this.titleLabel = new JLabel(" ");
        this.titlePanel = new JPanel((LayoutManager)new MigLayout(new LC().insetsAll("0").fill()));
        this.titlePanel.add(this.titleLabel);
        this.titlePanel.setVisible(false);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout(new LC().insetsAll("0").fill().gridGapY("4").hideMode(3)));
        jPanel.add((Component)this.typePanel, new CC().wrap());
        jPanel.add((Component)this.controlPanel, new CC().wrap());
        jPanel.add((Component)this.titlePanel, new CC().wrap());
        this.objectView = new RDataObjectView(this.r, this.getBrowser());
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)this.objectView, "Center");
    }

    @Override
    protected Object refreshWork() throws Exception {
        RObject rObject = this.getRObject();
        if (rObject == null) {
            return null;
        }
        int[] nArray = rObject.getDim();
        if (nArray == null) {
            return null;
        }
        ArrayList arrayList = null;
        ArrayList<String[]> arrayList2 = null;
        REXP rEXP = this.r.client().silentTimeoutEvalGet("dimnames(" + rObject.getFullName() + ")");
        RList rList = RClient.rexpToRList(rEXP);
        if (rList != null) {
            if (rList.names != null) {
                arrayList = new ArrayList(rList.names);
            }
            arrayList2 = new ArrayList<String[]>(rList.size());
            for (int i = 0; i < rList.size(); ++i) {
                REXP rEXP2 = rList.at(i);
                if (rEXP2 != null && rEXP2.isString()) {
                    arrayList2.add(rEXP2.asStrings());
                    continue;
                }
                arrayList2.add(null);
            }
        }
        return new Object[]{arrayList, arrayList2};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refreshWorkDone(Object object) {
        this.lockRefresh = true;
        try {
            Object object2;
            this.varNames = (List)((Object[])object)[0];
            this.names = (List)((Object[])object)[1];
            RObject rObject = this.getRObject();
            if (rObject == null) {
                return;
            }
            int[] nArray = rObject.getDim();
            if (nArray == null) {
                return;
            }
            ComboBoxModel comboBoxModel = this.rowComboBox.getModel();
            ComboBoxModel comboBoxModel2 = this.columnComboBox.getModel();
            ((DefaultComboBoxModel)comboBoxModel).removeAllElements();
            ((DefaultComboBoxModel)comboBoxModel2).removeAllElements();
            if (nArray.length > 2) {
                this.controlPanel.setVisible(true);
                for (int i = 0; i < nArray.length; ++i) {
                    ((DefaultComboBoxModel)comboBoxModel).addElement(i);
                    ((DefaultComboBoxModel)comboBoxModel2).addElement(i);
                }
                this.columnComboBox.setSelectedIndex(1);
            } else {
                this.controlPanel.setVisible(false);
            }
            this.typePanel.setVisible(rObject.inherits("table"));
            if (this.typePanel.isVisible()) {
                ComboBoxModel comboBoxModel3 = this.typeComboBox.getModel();
                ((DefaultComboBoxModel)comboBoxModel3).removeAllElements();
                object2 = nArray.length == 1 ? new String[]{TYPE_DEFAULT, TYPE_RATIO} : new String[]{TYPE_DEFAULT, TYPE_RATIO, TYPE_ROW_RATIO, TYPE_COLUMN_RATIO};
                for (String string : object2) {
                    ((DefaultComboBoxModel)comboBoxModel3).addElement(string);
                }
            }
            if (nArray.length == 2 && this.varNames != null && this.varNames.size() == 2) {
                this.titlePanel.setVisible(true);
                String string = this.varNames.get(0);
                object2 = this.varNames.get(1);
                this.titleLabel.setText(string + "  x  " + (String)object2);
            } else {
                this.titlePanel.setVisible(false);
            }
        }
        finally {
            this.lockRefresh = false;
        }
        this.updateConditions();
        this.refreshTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConditions() {
        if (this.lockRefresh) {
            return;
        }
        this.lockRefresh = true;
        try {
            ComboBoxModel comboBoxModel = this.conditionComboBox.getModel();
            ((DefaultComboBoxModel)comboBoxModel).removeAllElements();
            Integer n = (Integer)this.rowComboBox.getSelectedItem();
            Integer n2 = (Integer)this.columnComboBox.getSelectedItem();
            if (n == n2 || n == null || n2 == null) {
                ((DefaultComboBoxModel)comboBoxModel).addElement(null);
                return;
            }
            int[] nArray = this.getRObject().getDim();
            if (nArray.length > 2) {
                int[] nArray2 = new int[nArray.length - 2];
                this.conditionDim = new int[nArray.length - 2];
                int n3 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    if (i == n || i == n2) continue;
                    nArray2[n3] = nArray[i];
                    this.conditionDim[n3] = i;
                    ++n3;
                }
                this.walkNDim(nArray2, 0, new int[nArray2.length], (DefaultComboBoxModel<int[]>)comboBoxModel);
            }
        }
        finally {
            this.lockRefresh = false;
        }
    }

    private void walkNDim(int[] nArray, int n, int[] nArray2, DefaultComboBoxModel<int[]> defaultComboBoxModel) {
        if (defaultComboBoxModel.getSize() > 10000) {
            return;
        }
        for (int i = 0; i < nArray[n]; ++i) {
            nArray2[n] = i;
            if (n == nArray2.length - 1) {
                defaultComboBoxModel.addElement((int[])nArray2.clone());
                continue;
            }
            this.walkNDim(nArray, n + 1, nArray2, defaultComboBoxModel);
        }
    }

    private void refreshTable() {
        Object object;
        Object object2;
        Object object3;
        if (this.lockRefresh) {
            return;
        }
        RObject rObject = this.getRObject();
        int[] nArray = this.getRObject().getDim();
        if (nArray.length > 2) {
            object3 = (Integer)this.rowComboBox.getSelectedItem();
            object2 = (Integer)this.columnComboBox.getSelectedItem();
            object = (int[])this.conditionComboBox.getSelectedItem();
            if (object3 == object2 || object3 == null || object2 == null || object == null || this.conditionDim == null) {
                rObject = null;
            } else {
                RObject rObject2;
                Object[] objectArray = new String[nArray.length];
                int n = 0;
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = i == (Integer)object3 || i == (Integer)object2 ? "" : Integer.toString((int)(object[n++] + true));
                }
                String string = this.getRObject().getFullName() + "[" + StringUtils.join((Object[])objectArray, (String)",") + "]";
                if ((Integer)object3 > (Integer)object2) {
                    string = "t(" + string + ")";
                }
                rObject = rObject2 = RObject.builder(string).setType(rObject.getType()).setClasses(rObject.getClasses()).setNewClasses(rObject.getNewClasses()).setFlag(4).setDim(nArray[(Integer)object3], nArray[(Integer)object2]).build();
            }
        }
        if (rObject != null && this.typePanel.isVisible()) {
            object3 = (String)this.typeComboBox.getItemAt(this.typeComboBox.getSelectedIndex());
            object2 = null;
            switch (object3) {
                case "ratio": {
                    object2 = RUtility.function("prop.table", "", rObject.getFullName());
                    break;
                }
                case "row_ratio": {
                    object2 = RUtility.function("prop.table", "", rObject.getFullName(), "margin", "1");
                    break;
                }
                case "column_ratio": {
                    object2 = RUtility.function("prop.table", "", rObject.getFullName(), "margin", "2");
                    break;
                }
            }
            if (object2 != null) {
                object = rObject.getName(false);
                rObject = RObject.builder((String)object2).setType("double").setClasses("table").setFlag(4).setDim(rObject.getDim()).build();
                rObject.setDisplayName((String)object);
            }
        }
        if (rObject == null) {
            this.objectView.setVisible(false);
        } else {
            this.objectView.setVisible(true);
            this.objectView.setRObject(rObject);
        }
    }

    private String getVarName(int n) {
        if (this.varNames == null) {
            return "(Dim " + Integer.toString(n + 1) + ")";
        }
        if (n >= 0 && n < this.varNames.size()) {
            return this.varNames.get(n);
        }
        LOGGER.warning("Invalid index: " + n + " size: " + this.varNames.size());
        return "";
    }

    private class VarComboBox
    extends JComboBox<Integer> {
        public VarComboBox() {
            this.setRenderer(new VarRenderer());
            this.addActionListener(new VarHandler());
        }

        @Override
        public DefaultComboBoxModel<Integer> getModel() {
            return (DefaultComboBoxModel)super.getModel();
        }

        private class VarRenderer
        extends SubstanceDefaultListCellRenderer {
            private VarRenderer() {
            }

            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent(jList, object, n, bl, bl2);
                Integer n2 = (Integer)object;
                if (n2 != null) {
                    this.setText(RArrayObjectView.this.getVarName(n2));
                }
                return this;
            }
        }

        private class VarHandler
        implements ActionListener {
            private VarHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RArrayObjectView.this.updateConditions();
                RArrayObjectView.this.refreshTable();
            }
        }
    }

    private class ConditionComboBox
    extends JComboBox<int[]> {
        public ConditionComboBox() {
            this.setRenderer(new ConditionRenderer());
            this.addActionListener(new ConditionHandler());
        }

        @Override
        public DefaultComboBoxModel<int[]> getModel() {
            return (DefaultComboBoxModel)super.getModel();
        }

        private class ConditionRenderer
        extends SubstanceDefaultListCellRenderer {
            private ConditionRenderer() {
            }

            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent(jList, object, n, bl, bl2);
                int[] nArray = (int[])object;
                if (nArray != null && RArrayObjectView.this.conditionDim != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < nArray.length; ++i) {
                        stringBuilder.append(RArrayObjectView.this.getVarName(RArrayObjectView.this.conditionDim[i]));
                        stringBuilder.append("=");
                        String[] stringArray = RArrayObjectView.this.names.get(RArrayObjectView.this.conditionDim[i]);
                        stringBuilder.append(stringArray == null ? Integer.toString(nArray[i] + 1) : stringArray[nArray[i]]);
                        if (i == nArray.length - 1) continue;
                        stringBuilder.append(", ");
                    }
                    this.setText(stringBuilder.toString());
                } else {
                    this.setText(" ");
                }
                return this;
            }
        }

        private class ConditionHandler
        implements ActionListener {
            private ConditionHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RArrayObjectView.this.refreshTable();
            }
        }
    }

    private class TypeComboBox
    extends JComboBox<String> {
        public TypeComboBox() {
            this.addActionListener(new TypeHandler());
            this.setRenderer(new TypeListCellRenderer());
        }

        @Override
        public DefaultComboBoxModel<String> getModel() {
            return (DefaultComboBoxModel)super.getModel();
        }

        private class TypeHandler
        implements ActionListener {
            private TypeHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RArrayObjectView.this.refreshTable();
            }
        }

        private class TypeListCellRenderer
        extends SubstanceDefaultListCellRenderer {
            private TypeListCellRenderer() {
            }

            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent(jList, object, n, bl, bl2);
                if (object != null) {
                    switch (object.toString()) {
                        case "default": {
                            this.setText(Messages.getString("R.Object.Array.default"));
                            break;
                        }
                        case "ratio": {
                            this.setText(Messages.getString("R.Object.Array.ratio"));
                            break;
                        }
                        case "row_ratio": {
                            this.setText(Messages.getString("R.Object.Array.row_ratio"));
                            break;
                        }
                        case "column_ratio": {
                            this.setText(Messages.getString("R.Object.Array.column_ratio"));
                            break;
                        }
                    }
                }
                return this;
            }
        }
    }
}

