/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.object;

import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RInterface;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.ui.app.r.object.RObjectBrowser;
import com.ef_prime.rflow.ui.app.r.object.RPlotObjectView;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.FutureTask;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;
import org.rosuda.REngine.REXP;

public class RBiplotObjectView
extends RPlotObjectView {
    private PCComboBox xComboBox;
    private PCComboBox yComboBox;
    private int numPC;
    private boolean refreshLock;

    public RBiplotObjectView(RInterface rInterface, RObjectBrowser rObjectBrowser) {
        super(rInterface, rObjectBrowser);
        this.setTitle("biplot");
    }

    public static boolean isViewable(RObject rObject) {
        return rObject.inherits("prcomp");
    }

    @Override
    protected void loadContent() {
        super.loadContent();
        this.xComboBox = new PCComboBox(0);
        this.yComboBox = new PCComboBox(1);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout(new LC().insetsAll("0").fill()));
        jPanel.add((Component)this.xComboBox, new CC().split(3));
        jPanel.add(new JLabel(" x "));
        jPanel.add(this.yComboBox);
        this.add((Component)jPanel, "North");
    }

    @Override
    protected String getPlotRScript() {
        Integer n = (Integer)this.xComboBox.getSelectedItem();
        Integer n2 = (Integer)this.yComboBox.getSelectedItem();
        Object object = "";
        if (this.numPC > 0 && n != null && n2 != null && n > 0 && n <= this.numPC && n2 > 0 && n2 <= this.numPC && n != n2) {
            object = "c(" + n + "L, " + n2 + "L)";
        }
        return RUtility.function("biplot", new String[]{"", this.getRObject().getFullName(), "choices", object});
    }

    private void refreshPlot() {
        if (this.refreshLock) {
            return;
        }
        try {
            super.refreshWork();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void resized() {
        this.refreshPlot();
    }

    @Override
    protected Object refreshWork() throws Exception {
        this.numPC = 0;
        this.refreshPlot();
        RObject rObject = this.getRObject();
        if (rObject == null) {
            return null;
        }
        FutureTask<REXP> futureTask = new FutureTask<REXP>(() -> this.r.client().silentTimeoutEvalGet("ncol(" + rObject.getFullName() + "$rotation)"));
        this.r.queryQueue().addQuery(futureTask);
        Integer n = RClient.rexpToInteger(futureTask.get(), null);
        if (n != null) {
            this.numPC = n;
        }
        return null;
    }

    @Override
    protected void refreshWorkDone(Object object) {
        super.refreshWorkDone(object);
        if (this.numPC <= 0) {
            return;
        }
        this.refreshLock = true;
        try {
            ((DefaultComboBoxModel)this.xComboBox.getModel()).removeAllElements();
            ((DefaultComboBoxModel)this.yComboBox.getModel()).removeAllElements();
            for (int i = 0; i < this.numPC; ++i) {
                ((DefaultComboBoxModel)this.xComboBox.getModel()).addElement(i + 1);
                ((DefaultComboBoxModel)this.yComboBox.getModel()).addElement(i + 1);
            }
            if (this.numPC > 1) {
                this.yComboBox.setSelectedIndex(1);
            }
        }
        finally {
            this.refreshLock = false;
        }
    }

    @Override
    protected void refreshFailed(Exception exception) {
        super.refreshFailed(exception);
    }

    private class PCComboBox
    extends JComboBox<Integer> {
        public PCComboBox(int n) {
            super(new Integer[]{1, 2});
            this.setSelectedIndex(n);
            this.setRenderer(new PCRenderer());
            this.addActionListener(new PCHandler());
        }

        @Override
        public DefaultComboBoxModel<Integer> getModel() {
            return (DefaultComboBoxModel)super.getModel();
        }

        private class PCRenderer
        extends SubstanceDefaultListCellRenderer {
            private PCRenderer() {
            }

            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent(jList, object, n, bl, bl2);
                Integer n2 = (Integer)object;
                if (n2 != null) {
                    this.setText("PC" + n2);
                }
                return this;
            }
        }

        private class PCHandler
        implements ActionListener {
            private PCHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Integer n = (Integer)RBiplotObjectView.this.xComboBox.getSelectedItem();
                Integer n2 = (Integer)RBiplotObjectView.this.yComboBox.getSelectedItem();
                if (n != null && n2 != null && n == n2) {
                    PCComboBox pCComboBox = actionEvent.getSource() == RBiplotObjectView.this.xComboBox ? RBiplotObjectView.this.yComboBox : RBiplotObjectView.this.xComboBox;
                    int n3 = pCComboBox.getSelectedIndex();
                    if (++n3 >= pCComboBox.getItemCount()) {
                        n3 = 0;
                    }
                    pCComboBox.setSelectedIndex(n3);
                    return;
                }
                RBiplotObjectView.this.refreshPlot();
            }
        }
    }
}

