/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.object;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RInterface;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RObjectSet;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.object.RObjectActions;
import com.ef_prime.rflow.ui.app.r.object.RObjectBrowser;
import com.ef_prime.rflow.ui.app.r.object.RObjectView;
import com.ef_prime.rflow.ui.base.UIColor;
import com.ef_prime.rflow.ui.common.component.DataTable;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.ShowInvisibleTextRenderer;
import com.ef_prime.rflow.ui.common.component.SideBorder;
import com.ef_prime.rflow.ui.util.FontSupport;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.RFactor;
import org.rosuda.REngine.RList;

public class RDataObjectView
extends RObjectView {
    private static final Logger LOGGER = Logger.getLogger(RDataObjectView.class.getName());
    private static Object ERROR_OBJECT = new Object();
    private OnDemandTableModel defaultModel = new OnDemandTableModel();
    protected DataTable dataTable;
    private JScrollBar scrollBar;
    private JScrollBar horizontalScrollBar;
    private JPanel corner;
    private SettingsListener settingsListener;
    private int columnIndex = 0;

    public static boolean isViewable(RObject rObject) {
        if (rObject.inherits("data.frame")) {
            return true;
        }
        String string = rObject.getType();
        return rObject.getDim().length == 1 && !rObject.isFlag(4) && (string.equals("character") || string.equals("double") || string.equals("numeric") || string.equals("logical") || string.equals("integer") || string.equals("complex"));
    }

    public RDataObjectView(RInterface rInterface, RObjectBrowser rObjectBrowser) {
        super(rInterface, rObjectBrowser);
        this.setTitle(Messages.getString("R.Object.Table.title"));
    }

    @Override
    protected void loadContent() {
        Handler handler = new Handler();
        this.dataTable = this.createDataTable();
        this.dataTable.getTable().setModel(this.defaultModel);
        this.dataTable.getViewport().addChangeListener(handler);
        MouseWheelListener[] mouseWheelListenerArray = this.dataTable.getMouseWheelListeners();
        handler.defaultMouseWheelListeners = mouseWheelListenerArray;
        for (MouseWheelListener mouseWheelListener : mouseWheelListenerArray) {
            this.dataTable.removeMouseWheelListener(mouseWheelListener);
        }
        this.dataTable.addMouseWheelListener(handler);
        this.setLayout(new BorderLayout());
        this.add((Component)this.dataTable, "Center");
        this.scrollBar = new JScrollBar(1){

            @Override
            public int getBlockIncrement(int n) {
                return this.getModel().getExtent();
            }
        };
        this.scrollBar.getModel().addChangeListener(handler);
        this.scrollBar.setVisible(false);
        this.horizontalScrollBar = this.dataTable.getHorizontalScrollBar();
        this.corner = new JPanel();
        this.corner.setPreferredSize(new Dimension(this.scrollBar.getPreferredSize().width, this.horizontalScrollBar.getPreferredSize().height));
        this.corner.setVisible(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.scrollBar, "Center");
        jPanel.add((Component)this.corner, "South");
        this.add((Component)jPanel, "East");
        this.refreshFont();
    }

    protected Font getCodeFont() {
        return FontSupport.getDataFont();
    }

    protected void refreshFont() {
        JTable jTable = this.dataTable.getTable();
        jTable.setFont(this.getCodeFont());
        jTable.getTableHeader().setFont(this.getCodeFont());
        this.dataTable.getRowHeaderTable().setFont(this.getCodeFont());
        this.refreshRowHeight();
    }

    protected DataTable createDataTable() {
        return new RObjectDataTable();
    }

    protected void refreshRowHeight() {
        StringCellRenderer stringCellRenderer = new StringCellRenderer();
        stringCellRenderer.setFont(this.dataTable.getTable().getFont());
        this.dataTable.getTable().setRowHeight(stringCellRenderer.getPreferredSize().height);
        this.dataTable.getRowHeaderTable().setRowHeight(this.dataTable.getTable().getRowHeight());
    }

    protected OnDemandTableModel getModel() {
        return (OnDemandTableModel)this.dataTable.getTable().getModel();
    }

    protected void setModel(OnDemandTableModel onDemandTableModel) {
        Dimension dimension = this.dataTable.getViewport().getExtentSize();
        int n = dimension.height / this.dataTable.getTable().getRowHeight();
        onDemandTableModel.setVisibleRowCount(n);
        this.dataTable.getTable().setModel(onDemandTableModel);
        this.dataTable.getRowHeaderTable().setModel(onDemandTableModel.getRowHeaderModel());
        int n2 = this.scrollBar.getValue();
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= onDemandTableModel.getActualRowCount() - n) {
            n2 = Math.max(0, onDemandTableModel.getActualRowCount() - n);
        }
        this.scrollBar.getModel().setRangeProperties(n2, n, 0, onDemandTableModel.getActualRowCount(), false);
        this.scrollBar.setVisible(this.scrollBar.getModel().getMaximum() > this.scrollBar.getModel().getExtent());
        this.corner.setVisible(this.horizontalScrollBar.isVisible() && this.scrollBar.isVisible());
        int n3 = this.columnIndex;
        this.updateRowOffset();
        this.updateTable();
        this.columnIndex = n3;
        this.syncScrollBarWithColumnIndex();
    }

    protected void syncScrollBarWithColumnIndex() {
        if (this.columnIndex != 0) {
            TableColumnModel tableColumnModel = this.getTable().getColumnModel();
            int n = 0;
            int n2 = Math.min(this.columnIndex, tableColumnModel.getColumnCount());
            for (int i = 0; i < n2; ++i) {
                n += tableColumnModel.getColumn(i).getWidth();
            }
            this.horizontalScrollBar.setValue(n);
        }
    }

    @Override
    protected void refreshWorkDone(Object object) {
        RObject rObject = this.getRObject();
        if (rObject == null) {
            return;
        }
        try {
            Integer n = this.r.client().getLength(rObject.getFullName());
            if (n == null) {
                n = 0;
            }
            this.setModel(new OnDemandTableModel(rObject, n));
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to load object table.", exception);
        }
        this.updateTab();
    }

    protected JTable getTable() {
        return this.dataTable.getTable();
    }

    protected JTable getRowHeaderTable() {
        return this.dataTable.getRowHeaderTable();
    }

    private boolean isVector(RObject rObject) {
        String string = rObject.getType();
        return rObject.getDim().length == 1 && (string.equals("character") || string.equals("double") || string.equals("numeric") || string.equals("logical") || string.equals("integer") || string.equals("complex"));
    }

    private MetaData getMetaData(RObject rObject) {
        if (rObject == null) {
            return null;
        }
        try {
            if (rObject.inherits("data.frame")) {
                return this.getDataFrameMetaData(rObject);
            }
            if (rObject.isFlag(4) && rObject.getDim().length <= 2) {
                return this.getMatrixMetaData(rObject);
            }
            if (this.isVector(rObject)) {
                return this.getVectorMetaData(rObject);
            }
        }
        catch (REXPMismatchException rEXPMismatchException) {
            // empty catch block
        }
        return null;
    }

    private MetaData getDataFrameMetaData(RObject rObject) {
        Object object;
        Object object2;
        String[] stringArray;
        String string = rObject.getFullName();
        Boolean bl = RClient.rexpToBoolean(this.r.client().silentIdleEvalGet("any(sapply(" + string + ", is.matrix))"), false);
        if (!bl.booleanValue()) {
            stringArray = RClient.rexpToStrings(this.r.client().silentIdleEvalGet("names(" + string + ")"), null, "<NA>");
        } else {
            object2 = new StringBuilder(300 + string.length()).append("(function(obj) unlist(lapply(seq_along(obj), function(i){").append("x <- obj[[i]];").append("name <- names(obj)[i];").append("if (is.matrix(x)) {").append("mnames <- colnames(x);").append("if (length(mnames) == 0) mnames <- seq_len(ncol(x));").append("if (!nzchar(name)) {colnames(x)} else {paste(name, colnames(x), sep = \".\")}").append("} else { name }}").append(")))(obj = " + string + ")").toString();
            stringArray = RClient.rexpToStrings(this.r.client().silentIdleEvalGet((String)object2), null, "<NA>");
        }
        if (stringArray == null) {
            object2 = RClient.rexpToInteger(this.r.client().silentIdleEvalGet("ncol(" + string + ")"), 0);
            stringArray = new String[((Integer)object2).intValue()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = "";
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("structure(")) continue;
            stringArray[i] = " ";
        }
        REXP rEXP = bl == false ? this.r.client().silentIdleEvalGet("unlist(lapply(" + string + ", function(x) {class(x)[1]} ))") : this.r.client().silentIdleEvalGet("unlist(lapply(" + string + ", function(x){ if (is.matrix(x)) { rep(mode(x), ncol(x)) } else { class(x)[1] }}))");
        String[] stringArray2 = RClient.rexpToStrings(rEXP, null, "");
        if (stringArray2 == null) {
            return null;
        }
        int[] nArray = null;
        if (bl.booleanValue()) {
            object = this.r.client().silentIdleEvalGet("(function(obj) unlist(lapply(seq_along(obj), function(i){x <- obj[[i]]; if (is.matrix(x)) { rep(i-1L, ncol(x)) } else { i-1L }})))(obj = " + string + ")");
            nArray = RClient.rexpToIntegers((REXP)object, null);
        }
        object = RClient.rexpToBoolean(this.r.client().silentIdleEvalGet("is.numeric(attr(" + string + ", \"row.names\"))"), false);
        boolean bl2 = rObject.inherits("tbl_df");
        if (!bl2) {
            Integer n = RClient.rexpToInteger(this.r.client().silentIdleEvalGet(".row_names_info(" + string + ", type = 0L)[1]"), null);
            bl2 = n != null && REXPInteger.isNA((int)n);
        }
        return new MetaData(stringArray, stringArray2, nArray, (Boolean)object, bl2);
    }

    private MetaData getMatrixMetaData(RObject rObject) throws REXPMismatchException {
        int n;
        Object object;
        REXP rEXP;
        String[] stringArray = null;
        String[] stringArray2 = null;
        RList rList = RClient.rexpToRList(this.r.client().silentIdleEvalGet("dimnames(" + rObject.getFullName() + ")"));
        boolean bl = false;
        if (rList != null) {
            if (rList.size() == 1) {
                if (rList.names != null && !rList.names.isEmpty()) {
                    stringArray = new String[]{(String)rList.names.get(0)};
                }
            } else if (rList.size() > 1) {
                rEXP = rList.at(0);
                if (rEXP != null && !rEXP.isString()) {
                    bl = true;
                }
                if ((object = rList.at(1)) != null && object.isString()) {
                    stringArray = object.asStrings();
                    for (n = 0; n < stringArray.length; ++n) {
                        if (stringArray[n] != null) continue;
                        stringArray[n] = "<NA>";
                    }
                }
            }
        }
        if (stringArray == null) {
            int n2 = rObject.getDim().length >= 2 ? rObject.getDim()[1] : 1;
            stringArray = new String[n2];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = Integer.toString(i + 1);
            }
        }
        if ((rEXP = this.r.client().silentIdleEvalGet("class(as.vector(" + rObject.getFullName() + "))")) == null || !rEXP.isString()) {
            return null;
        }
        object = rEXP.asString();
        stringArray2 = new String[stringArray.length];
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray2[n] = object;
        }
        return new MetaData(stringArray, stringArray2, null, bl, false);
    }

    private MetaData getVectorMetaData(RObject rObject) {
        String[] stringArray = new String[]{rObject.getDisplayName()};
        String[] stringArray2 = new String[]{rObject.getClas()};
        boolean bl = RClient.rexpToBoolean(this.r.client().silentIdleEvalGet("is.null(names(" + rObject.getFullName() + "))"), false);
        return new MetaData(stringArray, stringArray2, null, bl, false);
    }

    private DataChunk getChunk(RObject rObject) {
        if (rObject == null) {
            return DataChunk.FAILED;
        }
        try {
            if (rObject.inherits("data.frame")) {
                return this.getDataFrameChunk(rObject);
            }
            if (rObject.isFlag(4) && rObject.getDim().length <= 2) {
                return this.getMatrixChunk(rObject);
            }
            if (this.isVector(rObject)) {
                return this.getVectorChunk(rObject);
            }
        }
        catch (REXPMismatchException rEXPMismatchException) {
            // empty catch block
        }
        return DataChunk.FAILED;
    }

    private DataChunk getDataFrameChunk(RObject rObject) throws REXPMismatchException {
        REXP rEXP = this.r.client().silentIdleEvalGet("format.data.frame(" + rObject.getFullName() + ", trim = TRUE, justify = \"none\", na.encode=FALSE)");
        if (rEXP == null || !rEXP.isList()) {
            return DataChunk.FAILED;
        }
        RList rList = rEXP.asList();
        if (rList == null) {
            return DataChunk.FAILED;
        }
        REXP rEXP2 = rEXP.getAttribute("row.names");
        if (rEXP2 != null && rEXP2.isNull()) {
            rEXP2 = null;
        }
        return new DataChunk((List<REXP>)rList, rEXP2);
    }

    private DataChunk getMatrixChunk(RObject rObject) throws REXPMismatchException {
        REXP rEXP;
        REXP rEXP2 = this.r.client().silentIdleEvalGet("format(" + rObject.getFullName() + ", trim = TRUE, justify = \"none\", na.encode=FALSE)");
        REXP rEXP3 = this.r.client().silentIdleEvalGet("dim(" + rObject.getFullName() + ")");
        if (rEXP2 == null || rEXP3 == null || !rEXP3.isInteger()) {
            return DataChunk.FAILED;
        }
        int[] nArray = rEXP3.asIntegers();
        int n = nArray.length > 1 ? nArray[1] : 1;
        int n2 = nArray[0];
        ArrayList<REXP> arrayList = new ArrayList<REXP>(n);
        if (rEXP2.isFactor()) {
            rEXP = rEXP2.asFactor();
            for (var9_9 = 0; var9_9 < n; ++var9_9) {
                String[] stringArray = new String[nArray[0]];
                for (int i = 0; i < n2; ++i) {
                    stringArray[i] = rEXP.at(var9_9 * n2 + i);
                }
                arrayList.add((REXP)new REXPString(stringArray));
            }
        } else if (rEXP2.isInteger()) {
            rEXP = (REXP)rEXP2.asIntegers();
            for (var9_9 = 0; var9_9 < n; ++var9_9) {
                int[] nArray2 = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    nArray2[i] = (int)rEXP[var9_9 * n2 + i];
                }
                arrayList.add((REXP)new REXPInteger(nArray2));
            }
        } else if (rEXP2.isNumeric()) {
            rEXP = (REXP)rEXP2.asDoubles();
            for (var9_9 = 0; var9_9 < n; ++var9_9) {
                double[] dArray = new double[n2];
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = (double)rEXP[var9_9 * n2 + i];
                }
                arrayList.add((REXP)new REXPDouble(dArray));
            }
        } else if (rEXP2.isString()) {
            rEXP = rEXP2.asStrings();
            for (var9_9 = 0; var9_9 < n; ++var9_9) {
                String[] stringArray = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    stringArray[i] = rEXP[var9_9 * n2 + i];
                }
                arrayList.add((REXP)new REXPString(stringArray));
            }
        }
        rEXP = null;
        RList rList = RClient.rexpToRList(this.r.client().silentIdleEvalGet("dimnames(" + rObject.getFullName() + ")"));
        if (rList != null && (rEXP = rList.at(0)) != null && !rEXP.isString()) {
            rEXP = null;
        }
        return new DataChunk(arrayList, rEXP);
    }

    private DataChunk getVectorChunk(RObject rObject) {
        REXP rEXP = this.r.client().silentIdleEvalGet("format(" + rObject.getFullName() + ", trim = TRUE, justify = \"none\", na.encode=FALSE)");
        if (rEXP == null) {
            return DataChunk.FAILED;
        }
        ArrayList<REXP> arrayList = new ArrayList<REXP>(1);
        arrayList.add(rEXP);
        REXP rEXP2 = rEXP.getAttribute("names");
        if (rEXP2 == null) {
            rEXP2 = rEXP.getAttribute("row.names");
        }
        if (rEXP2 != null && rEXP2.isNull()) {
            rEXP2 = null;
        }
        return new DataChunk(arrayList, rEXP2);
    }

    private void updateTable() {
        int n = 30;
        this.getRowHeaderTable().getColumnModel().getColumn(0).setPreferredWidth(30);
        for (int i = 0; i < this.getTable().getColumnCount(); ++i) {
            int n2 = 70;
            this.getTable().getColumnModel().getColumn(i).setPreferredWidth(n2);
            n += n2;
        }
        n += this.dataTable.getVerticalScrollBar().getPreferredSize().width;
        if ((n += 2) > 800) {
            n = 800;
        }
        this.setPreferredSize(new Dimension(n, 400));
        TableModel tableModel = this.getTable().getModel();
        if (tableModel instanceof OnDemandTableModel && ((OnDemandTableModel)tableModel).hasNoColumn()) {
            TableColumn tableColumn = this.getTable().getColumnModel().getColumn(0);
            tableColumn.setMinWidth(0);
            tableColumn.setMaxWidth(0);
            tableColumn.setResizable(false);
        } else if (tableModel.getColumnCount() > 0) {
            TableColumn tableColumn = this.getTable().getColumnModel().getColumn(0);
            tableColumn.setMinWidth(0);
            tableColumn.setMaxWidth(Integer.MAX_VALUE);
            tableColumn.setResizable(true);
        }
        UIUtility.resizeColumns(this.getTable(), 0, 20, 500, 0, 20);
        TableCellRenderer tableCellRenderer = this.getRowHeaderTable().getCellRenderer(0, 0);
        Component component = tableCellRenderer.getTableCellRendererComponent(this.getRowHeaderTable(), "00000", false, false, 0, 0);
        UIUtility.resizeColumns(this.getRowHeaderTable(), 0, component.getPreferredSize().width, 200);
        int n3 = Math.max(30, this.getRowHeaderTable().getColumnModel().getColumn(0).getPreferredWidth());
        UIUtility.setPreferredWidth(n3, this.dataTable.getRowHeader());
        this.getTable().doLayout();
        this.dataTable.getParent().revalidate();
        this.dataTable.getParent().repaint();
    }

    public List<RObject> getColumnRObjects(int[] nArray) {
        ArrayList<RObject> arrayList = new ArrayList<RObject>();
        RObject rObject = this.getRObject();
        if (rObject == null) {
            return null;
        }
        if (rObject.inherits("data.frame")) {
            OnDemandTableModel onDemandTableModel = (OnDemandTableModel)this.getTable().getModel();
            RObjectSet rObjectSet = this.r.client().getObjects(rObject, false, 0);
            for (int n : nArray) {
                int n2 = onDemandTableModel.getListIndex(n);
                RObject rObject2 = rObjectSet.getObjects().get(n2);
                if (!rObject2.isFlag(2)) {
                    arrayList.add(rObject2);
                    continue;
                }
                int n3 = onDemandTableModel.getMatrixColumn(n);
                arrayList.add(RObject.builder(rObject2.getName(true) + "[," + n3 + "]").setParent(rObject).setType(rObject2.getType()).setClasses(onDemandTableModel.getColClass(n)).setDim(rObject2.getDim()[0]).build());
            }
        } else if (rObject.isFlag(4) && rObject.getDim().length <= 2) {
            for (int n : nArray) {
                arrayList.add(RObject.builder("[," + (n + 1) + "]").setParent(rObject).setType(rObject.getType()).setDim(rObject.getDim()[0]).setTip(rObject.getTip()).setIndexObject(true).build());
            }
        } else {
            arrayList.add(rObject);
        }
        return arrayList;
    }

    public RObject getPartialRObject(int n, int n2, int n3, int n4) {
        RObject rObject = this.getRObject();
        if (rObject == null) {
            return null;
        }
        if (rObject.getDim().length < 2) {
            return this.getRowRObject(n, n2);
        }
        int n5 = rObject.getDim()[0];
        int n6 = rObject.getDim()[1];
        if (rObject.getDim().length > 2 || n < 0 || n5 <= n || n3 < 0 || n6 <= n3) {
            return null;
        }
        int n7 = n5 >= n + n2 ? n2 : n5 - n;
        int n8 = n6 >= n3 + n4 ? n4 : n6 - n3;
        String string = n7 == 1 ? "" + (n + 1) : n + 1 + ":" + (n + n7);
        String string2 = n8 == 1 ? "" + (n3 + 1) : n3 + 1 + ":" + (n3 + n8);
        RObject.Builder builder = RObject.builder("").setParent(rObject).setType(rObject.getType()).setClasses(rObject.getClasses()).setNewClasses(rObject.getNewClasses()).setTip(rObject.getTip()).setIndexObject(true);
        if (rObject.inherits("data.frame")) {
            return builder.setName("[" + string + ", " + string2 + ", drop=FALSE]").setDim(n7, n8).build();
        }
        if (rObject.isFlag(4) && rObject.getDim().length <= 2) {
            return builder.setName("[" + string + ", " + string2 + ", drop=FALSE]").setFlag(6).setDim(n7, n8).build();
        }
        return builder.setName("[" + string + ", " + string2 + ", drop=FALSE]").setDim(n7, n8).build();
    }

    public RObject getRowRObject(int n, int n2) {
        RObject rObject = this.getRObject();
        if (n < 0 || rObject == null || rObject.getDim()[0] <= n || rObject.getDim().length > 2) {
            return null;
        }
        int n3 = rObject.getDim()[0] >= n + n2 ? n2 : rObject.getDim()[0] - n;
        String string = n3 == 1 ? "" + (n + 1) : n + 1 + ":" + (n + n3);
        RObject.Builder builder = RObject.builder("").setParent(rObject).setType(rObject.getType()).setClasses(rObject.getClasses()).setNewClasses(rObject.getNewClasses()).setTip(rObject.getTip()).setIndexObject(true);
        if (rObject.inherits("data.frame")) {
            return builder.setName("[" + string + ",,drop=FALSE]").setDim(n3, rObject.getDim()[1]).build();
        }
        if (rObject.isFlag(4) && rObject.getDim().length <= 2) {
            int[] nArray = (int[])rObject.getDim().clone();
            nArray[0] = n3;
            String string2 = nArray.length > 1 ? ",," : ",";
            return builder.setName("[" + string + string2 + "drop=FALSE]").setFlag(6).setDim(nArray).build();
        }
        return builder.setName("[" + string + "]").setDim(n3).build();
    }

    public RObject getRowRObjects(List<Range> list) {
        RObject rObject = this.getRObject();
        if (rObject == null) {
            return null;
        }
        int n = 0;
        for (Range object2 : list) {
            n += object2.length();
        }
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return this.getRowRObject(list.get(0).getFirst(), 1);
        }
        String string = list.size() == 1 ? list.get(0).toString(1) : list.stream().map(range -> range.toString(1)).collect(Collectors.joining(", ", "c(", ")"));
        RObject.Builder builder = RObject.builder("").setParent(rObject).setType(rObject.getType()).setClasses(rObject.getClasses()).setNewClasses(rObject.getNewClasses()).setTip(rObject.getTip()).setIndexObject(true);
        if (rObject.inherits("data.frame")) {
            return builder.setName("[" + (String)string + ",]").setDim(n, rObject.getDim()[1]).build();
        }
        if (rObject.isFlag(4) && rObject.getDim().length <= 2) {
            int[] nArray = (int[])rObject.getDim().clone();
            nArray[0] = n;
            String string2 = nArray.length > 1 ? "," : "";
            return builder.setName("[" + (String)string + string2 + "]").setFlag(6).setDim(nArray).build();
        }
        return builder.setName("[" + (String)string + "]").setDim(n).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modelUpdated() {
        SelectionModel selectionModel = (SelectionModel)this.dataTable.getTable().getSelectionModel();
        SelectionModel selectionModel2 = (SelectionModel)this.dataTable.getTable().getColumnModel().getSelectionModel();
        SelectionModel selectionModel3 = (SelectionModel)this.dataTable.getRowHeaderTable().getSelectionModel();
        SelectionModel selectionModel4 = (SelectionModel)this.dataTable.getRowHeaderTable().getColumnModel().getSelectionModel();
        selectionModel.setLockSelection(true);
        selectionModel2.setLockSelection(true);
        selectionModel3.setLockSelection(true);
        selectionModel4.setLockSelection(true);
        try {
            this.getModel().fireTableDataChanged();
            this.getModel().rowHeaderModel.fireTableDataChanged();
        }
        finally {
            selectionModel.setLockSelection(false);
            selectionModel2.setLockSelection(false);
            selectionModel3.setLockSelection(false);
            selectionModel4.setLockSelection(false);
        }
    }

    private void updateRowOffset() {
        int n = this.scrollBar.getValue();
        n = Math.max(0, n - 2);
        this.getModel().setRowOffset(n);
        if (this.scrollBar.getValue() <= 2) {
            Point point = this.dataTable.getViewport().getViewPosition();
            point.y = Math.min(2, this.scrollBar.getValue()) * this.getTable().getRowHeight();
            this.dataTable.getViewport().setViewPosition(point);
        }
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        super.viewDidBecomeDisplayable();
        if (this.settingsListener == null) {
            this.settingsListener = new SettingsListener();
            Rflow.settings().addEventHandler(this.settingsListener);
        }
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        if (this.settingsListener != null) {
            Rflow.settings().removeEventHandler(this.settingsListener);
        }
    }

    protected class OnDemandTableModel
    extends AbstractTableModel
    implements ColClass {
        private static final int CHUNK_ROW_SIZE = 100;
        private static final int CHUNK_COL_SIZE = 20;
        private static final int CACHE_LIMIT = 10;
        private Map<Long, DataChunk> map = new HashMap<Long, DataChunk>(11);
        private Deque<Long> indexList = new ArrayDeque<Long>();
        private int rowCount;
        private MetaData metaData;
        private List<Integer> columnShown = new ArrayList<Integer>(2);
        private int maxRowDigits = 3;
        private int rowOffset = 0;
        private int visibleRowCount = 0;
        private RowHeaderDataTableModel rowHeaderModel = new RowHeaderDataTableModel(this);
        private int lastChunkRowIndex = -1;
        private int lastChunkColIndex = -2;
        private DataChunk lastChunk = null;

        OnDemandTableModel() {
            this.rowCount = 0;
            this.metaData = new MetaData(null, null, null, false, false);
        }

        OnDemandTableModel(RObject rObject, int n) {
            this.rowCount = n;
            this.metaData = RDataObjectView.this.getMetaData(rObject);
            if (this.metaData == null) {
                this.metaData = new MetaData(null, null, null, false, false);
            }
            this.columnShown.add(1);
        }

        public RowHeaderDataTableModel getRowHeaderModel() {
            return this.rowHeaderModel;
        }

        public void setRowOffset(int n) {
            if (this.rowOffset != n) {
                this.rowOffset = n;
                RDataObjectView.this.modelUpdated();
            }
        }

        public int getRowOffset() {
            return this.rowOffset;
        }

        public void setVisibleRowCount(int n) {
            if (this.visibleRowCount != n) {
                this.visibleRowCount = n;
                RDataObjectView.this.modelUpdated();
            }
        }

        public int getVisibleRowCount() {
            return this.visibleRowCount;
        }

        @Override
        public String getColClass(int n) {
            return this.metaData.getColClass(n);
        }

        public int getListIndex(int n) {
            return this.metaData.getListIndex(n);
        }

        public int getMatrixColumn(int n) {
            return this.metaData.getMatrixColumn(n);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public String getColumnName(int n) {
            return this.metaData.getColumnName(n);
        }

        @Override
        public int getColumnCount() {
            return this.metaData.getColumnCount();
        }

        public boolean hasNoColumn() {
            return this.metaData.hasNoColumn();
        }

        @Override
        public int getRowCount() {
            if (RDataObjectView.this.getRObject() == null) {
                return 0;
            }
            int n = this.visibleRowCount + 10;
            if (n + this.rowOffset > this.rowCount) {
                return this.rowCount - this.rowOffset;
            }
            return n;
        }

        public int getActualRowCount() {
            return this.rowCount;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DataChunk dataChunk;
            int n3;
            int n4 = (n += this.rowOffset) / 100;
            int n5 = n3 = n2 < 0 ? Math.max(0, this.lastChunkColIndex) : n2 / 20;
            if (this.lastChunkRowIndex == n4 && this.lastChunkColIndex == n3) {
                dataChunk = this.lastChunk;
            } else {
                long l = (long)n4 << 32 | (long)n3;
                dataChunk = this.map.get(l);
                if (dataChunk == null) {
                    int n6;
                    int n7;
                    if (this.metaData.hasMatrixColumn()) {
                        n7 = this.getListIndex(n3 * 20);
                        int n8 = this.getListIndex(Math.min(n3 * 20 + 20 - 1, this.metaData.getColumnCount() - 1));
                        n6 = n8 - n7 + 1;
                    } else {
                        n7 = n3 * 20;
                        n6 = 20;
                    }
                    RObject rObject = RDataObjectView.this.getPartialRObject(n4 * 100, 100, n7, n6);
                    dataChunk = RDataObjectView.this.getChunk(rObject);
                    this.setColumnShown(n3);
                    this.setRowShown(n4);
                    this.map.put(l, dataChunk);
                    this.indexList.addLast(l);
                    if (this.indexList.size() > 10) {
                        this.map.remove(this.indexList.poll());
                    }
                    if (dataChunk != DataChunk.FAILED) {
                        Iterator<Long> iterator = this.indexList.descendingIterator();
                        while (iterator.hasNext()) {
                            Long l2 = iterator.next();
                            if (this.map.get(l2) != null) continue;
                            this.map.remove(l2);
                            iterator.remove();
                        }
                    }
                }
            }
            this.lastChunkRowIndex = n4;
            this.lastChunkColIndex = n3;
            this.lastChunk = dataChunk;
            if (dataChunk == DataChunk.FAILED || dataChunk == null) {
                if (n2 == -1) {
                    return n + 1;
                }
                return ERROR_OBJECT;
            }
            if (n2 == -1) {
                if (dataChunk.rownames == null || this.metaData.isDefaultRowNames()) {
                    return n + 1;
                }
                return dataChunk.getRowName(n - n4 * 100);
            }
            int n9 = n - n4 * 100;
            int n10 = this.metaData.hasMatrixColumn() ? n2 - this.metaData.getColumnIndex(this.getListIndex(n3 * 20)) : n2 - n3 * 20;
            return dataChunk.getValueAt(n9, n10);
        }

        private void setColumnShown(int n) {
            int n2 = n / 32;
            while (n2 >= this.columnShown.size()) {
                this.columnShown.add(0);
            }
            Integer n3 = this.columnShown.get(n2);
            int n4 = n - n2 * 32;
            int n5 = 1 << n4;
            if ((n3 & n5) == 0) {
                n3 = n3 | n5;
                this.columnShown.set(n2, n3);
                SwingUtilities.invokeLater(() -> {
                    int n2 = RDataObjectView.this.columnIndex;
                    UIUtility.resizeColumns(RDataObjectView.this.getTable(), 0, 20, 500, n * 20, 20);
                    SwingUtilities.invokeLater(() -> {
                        RDataObjectView.this.columnIndex = n2;
                        RDataObjectView.this.syncScrollBarWithColumnIndex();
                    });
                });
            }
        }

        private void setRowShown(int n) {
            if (!this.metaData.isNumberRowname()) {
                return;
            }
            int n2 = n * 100 + 100 - 1;
            int n3 = (int)Math.log10(n2) + 1;
            if (this.maxRowDigits < n3) {
                this.maxRowDigits = n3;
                SwingUtilities.invokeLater(() -> {
                    UIUtility.resizeColumn(RDataObjectView.this.getRowHeaderTable().getTableHeader(), 0, 0, 0, 0, 200);
                    JViewport jViewport = RDataObjectView.this.dataTable.getRowHeader();
                    Dimension dimension = jViewport.getPreferredSize();
                    int n = RDataObjectView.this.getRowHeaderTable().getPreferredSize().width;
                    if (dimension.width < n) {
                        dimension.width = n;
                        jViewport.setPreferredSize(dimension);
                        RDataObjectView.this.getTable().doLayout();
                        RDataObjectView.this.dataTable.revalidate();
                        RDataObjectView.this.dataTable.repaint();
                    }
                });
            }
        }
    }

    private class Handler
    implements ChangeListener,
    MouseWheelListener {
        private MouseWheelListener[] defaultMouseWheelListeners;

        private Handler() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == RDataObjectView.this.scrollBar.getModel()) {
                RDataObjectView.this.updateRowOffset();
            } else if (changeEvent.getSource() == RDataObjectView.this.dataTable.getViewport()) {
                if (RDataObjectView.this.getModel() == RDataObjectView.this.defaultModel) {
                    return;
                }
                Dimension dimension = RDataObjectView.this.dataTable.getViewport().getExtentSize();
                int n = dimension.height / RDataObjectView.this.dataTable.getTable().getRowHeight();
                BoundedRangeModel boundedRangeModel = RDataObjectView.this.scrollBar.getModel();
                if (boundedRangeModel.getExtent() != n) {
                    RDataObjectView.this.getModel().setVisibleRowCount(n);
                    boundedRangeModel.setExtent(n);
                }
                RDataObjectView.this.scrollBar.setVisible(boundedRangeModel.getMaximum() > boundedRangeModel.getExtent());
                RDataObjectView.this.corner.setVisible(RDataObjectView.this.horizontalScrollBar.isVisible() && RDataObjectView.this.scrollBar.isVisible());
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (!RDataObjectView.this.dataTable.isWheelScrollingEnabled() || mouseWheelEvent.getWheelRotation() == 0) {
                return;
            }
            if (!RDataObjectView.this.scrollBar.isVisible() || mouseWheelEvent.isShiftDown()) {
                if (this.defaultMouseWheelListeners != null) {
                    for (MouseWheelListener mouseWheelListener : this.defaultMouseWheelListeners) {
                        mouseWheelListener.mouseWheelMoved(mouseWheelEvent);
                    }
                }
                return;
            }
            int n = mouseWheelEvent.getWheelRotation() < 0 ? -1 : 1;
            int n2 = 0;
            switch (mouseWheelEvent.getScrollType()) {
                case 0: {
                    n2 = Math.min(1 * Math.abs(mouseWheelEvent.getUnitsToScroll()), RDataObjectView.this.getModel().getVisibleRowCount());
                    break;
                }
                case 1: {
                    n2 = RDataObjectView.this.getModel().getVisibleRowCount();
                    break;
                }
            }
            int n3 = n > 0 ? Math.min(RDataObjectView.this.scrollBar.getValue() + n2, RDataObjectView.this.scrollBar.getMaximum()) : Math.max(RDataObjectView.this.scrollBar.getValue() - n2, RDataObjectView.this.scrollBar.getMinimum());
            RDataObjectView.this.scrollBar.setValue(n3);
        }
    }

    protected class RObjectDataTable
    extends DataTable {
        public RObjectDataTable() {
            this.setVerticalScrollBarPolicy(21);
            this.getTable().setDefaultRenderer(String.class, (TableCellRenderer)((Object)new StringCellRenderer()));
            this.getTable().setGridColor(UIColor.TABLE_GRID);
            this.getRowHeaderTable().setRowHeight(this.getTable().getRowHeight());
            if (this.getBorder() instanceof LineBorder) {
                LineBorder lineBorder = (LineBorder)this.getBorder();
                this.setBorder(new SideBorder(7, lineBorder.getLineColor()));
            }
        }

        private void changeSelectionImpl(JTable jTable, SelectionModel selectionModel, SelectionModel selectionModel2, int n, int n2, boolean bl, boolean bl2) {
            Rectangle rectangle;
            int n3 = selectionModel.getAnchor();
            int n4 = selectionModel2.getAnchor();
            boolean bl3 = true;
            if (n3 == -1) {
                if (jTable.getRowCount() > 0) {
                    n3 = 0;
                }
                bl3 = false;
            }
            if (n4 == -1) {
                if (jTable.getColumnCount() > 0) {
                    n4 = 0;
                }
                bl3 = false;
            }
            boolean bl4 = jTable.isCellSelected(n, n2);
            bl3 = bl3 && (jTable.getRowSelectionAllowed() && selectionModel.isAnchorSelected() || jTable.getColumnSelectionAllowed() && selectionModel2.isAnchorSelected());
            this.changeSelectionModel(selectionModel2, n2, bl, bl2, bl4, n4, bl3);
            this.changeSelectionModel(selectionModel, bl2 ? n + RDataObjectView.this.getModel().getRowOffset() : n, bl, bl2, bl4, n3, bl3);
            if (jTable.getAutoscrolls() && (rectangle = jTable.getCellRect(n, n2, false)) != null) {
                jTable.scrollRectToVisible(rectangle);
            }
        }

        private void changeSelectionModel(SelectionModel selectionModel, int n, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
            if (bl2) {
                if (bl) {
                    if (bl4) {
                        selectionModel.addSelection(n2, n);
                    } else {
                        selectionModel.removeSelection(n2, n);
                    }
                } else {
                    selectionModel.setSelection(n2, n);
                }
            } else if (bl) {
                if (bl3) {
                    selectionModel.removeSelectionInterval(n, n);
                } else {
                    selectionModel.addSelectionInterval(n, n);
                }
            } else {
                selectionModel.setSelectionInterval(n, n);
            }
        }

        @Override
        protected JTable createTable() {
            return new DataTable.TableImpl(){

                @Override
                public int getHeight() {
                    return super.getHeight() + this.getRowHeight();
                }

                @Override
                public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                    ListSelectionModel listSelectionModel = this.getSelectionModel();
                    ListSelectionModel listSelectionModel2 = this.getColumnModel().getSelectionModel();
                    if (!(listSelectionModel instanceof SelectionModel) || !(listSelectionModel2 instanceof SelectionModel)) {
                        super.changeSelection(n, n2, bl, bl2);
                        return;
                    }
                    RObjectDataTable.this.changeSelectionImpl(this, (SelectionModel)listSelectionModel, (SelectionModel)listSelectionModel2, n, n2, bl, bl2);
                }
            };
        }

        @Override
        protected DataTable.RowHeaderTable createRowHeaderTable() {
            return new DataTable.RowHeaderTable(){

                @Override
                public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                    ListSelectionModel listSelectionModel = this.getSelectionModel();
                    ListSelectionModel listSelectionModel2 = this.getColumnModel().getSelectionModel();
                    if (!(listSelectionModel instanceof SelectionModel) || !(listSelectionModel2 instanceof SelectionModel)) {
                        super.changeSelection(n, n2, bl, bl2);
                        return;
                    }
                    RObjectDataTable.this.changeSelectionImpl(this, (SelectionModel)listSelectionModel, (SelectionModel)listSelectionModel2, n, n2, bl, bl2);
                }

                @Override
                protected void syncTableWithRowHeader(ListSelectionModel listSelectionModel) {
                    if (listSelectionModel.isSelectionEmpty()) {
                        return;
                    }
                    if (!(listSelectionModel instanceof SelectionModel)) {
                        super.syncTableWithRowHeader(listSelectionModel);
                        return;
                    }
                    SelectionModel selectionModel = (SelectionModel)listSelectionModel;
                    JTable jTable = RObjectDataTable.this.getTable();
                    jTable.clearSelection();
                    jTable.setRowSelectionAllowed(true);
                    jTable.setColumnSelectionAllowed(false);
                    List<Range> list = selectionModel.getSelection();
                    SelectionModel selectionModel2 = (SelectionModel)jTable.getSelectionModel();
                    for (Range range : list) {
                        selectionModel2.addSelection(range.start, range.end);
                    }
                }
            };
        }

        @Override
        protected JViewport createViewport() {
            return new JViewport(){

                @Override
                public void setViewPosition(Point point) {
                    int n;
                    int n2;
                    int n3;
                    if (this != RObjectDataTable.this.getRowHeader() && this.getView() != null) {
                        TableColumnModel tableColumnModel = RObjectDataTable.this.getTable().getColumnModel();
                        n3 = 0;
                        n2 = tableColumnModel.getColumnCount();
                        if (this == RObjectDataTable.this.getViewport()) {
                            RDataObjectView.this.columnIndex = 0;
                            for (n = 0; n < n2 && point.x > n3; ++n) {
                                n3 += tableColumnModel.getColumn(n).getWidth();
                                ++RDataObjectView.this.columnIndex;
                            }
                        } else {
                            for (n = 0; n < n2 && point.x > n3; n3 += tableColumnModel.getColumn(n).getWidth(), ++n) {
                            }
                        }
                        if (n3 + this.getExtentSize().width < this.getView().getWidth()) {
                            point.x = n3;
                        }
                    }
                    if (this == RObjectDataTable.this.getColumnHeader() || RDataObjectView.this.scrollBar == null) {
                        super.setViewPosition(point);
                        return;
                    }
                    int n4 = Math.min(2, RDataObjectView.this.scrollBar.getValue()) * RObjectDataTable.this.getTable().getRowHeight();
                    if (point.y != n4) {
                        n3 = point.y;
                        point.y = n4;
                        super.setViewPosition(point);
                        n2 = n3 - n4;
                        n = (int)((double)n2 / (double)RObjectDataTable.this.getTable().getRowHeight() + (double)(n2 > 0 ? false : false));
                        RDataObjectView.this.scrollBar.setValue(RDataObjectView.this.scrollBar.getValue() + n);
                    } else {
                        super.setViewPosition(point);
                    }
                }
            };
        }

        @Override
        protected ListSelectionModel createListSelectionModel(boolean bl) {
            return new SelectionModel(bl);
        }

        @Override
        protected void selectAll() {
            super.selectAll();
            SelectionModel selectionModel = (SelectionModel)this.getTable().getSelectionModel();
            selectionModel.selectAll(RDataObjectView.this.getModel().getActualRowCount());
        }

        @Override
        protected DataTable.CopyTableModel getTableModelForCopy() {
            return new RCopyTableModel(this.getTable());
        }

        @Override
        protected JPopupMenu createTablePopupMenu() {
            JPopupMenu jPopupMenu = super.createTablePopupMenu();
            jPopupMenu.addSeparator();
            jPopupMenu.add(new RefreshAction());
            return jPopupMenu;
        }

        @Override
        protected JPopupMenu createBackgroundPopupMenu() {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(new RefreshAction());
            return jPopupMenu;
        }

        @Override
        protected JPopupMenu createColumnHeaderPopupMenu() {
            JTableHeader jTableHeader = this.getTable().getTableHeader();
            List<RObject> list = RDataObjectView.this.getColumnRObjects(jTableHeader.getColumnModel().getSelectedColumns());
            if (list.size() == 0) {
                return null;
            }
            RObjectActions rObjectActions = new RObjectActions(() -> list.toArray(new RObject[list.size()]), null);
            JPopupMenu jPopupMenu = rObjectActions.getPopupMenu(false);
            jPopupMenu.insert(RDataObjectView.this.dataTable.getCopyMenu(), 0);
            jPopupMenu.insert(new JPopupMenu.Separator(), 1);
            return jPopupMenu;
        }

        @Override
        protected JPopupMenu createRowHeaderPopupMenu() {
            ArrayList<RObject> arrayList = new ArrayList<RObject>();
            ListSelectionModel listSelectionModel = this.getTable().getSelectionModel();
            if (listSelectionModel instanceof SelectionModel) {
                arrayList.add(RDataObjectView.this.getRowRObjects(((SelectionModel)listSelectionModel).getSelection()));
            }
            if (arrayList.size() == 0) {
                return null;
            }
            RObjectActions rObjectActions = new RObjectActions(() -> arrayList.toArray(new RObject[arrayList.size()]), null);
            JPopupMenu jPopupMenu = rObjectActions.getPopupMenu(false);
            jPopupMenu.insert(RDataObjectView.this.dataTable.getCopyMenu(), 0);
            jPopupMenu.insert(new JPopupMenu.Separator(), 1);
            return jPopupMenu;
        }
    }

    protected static class StringCellRenderer
    extends ShowInvisibleTextRenderer {
        private Color naColor = new Color(200, 0, 100);
        private Color infNanColor = new Color(0, 200, 150);
        private Color trueColor = new Color(33023);
        private Color falseColor = new Color(0xFF8000);
        private Border padding = new EmptyBorder(1, 2, 0, 2);

        protected StringCellRenderer() {
            super(false);
            this.setBorder(new CompoundBorder(noFocusBorder, this.padding));
            this.setText(" ");
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!bl) {
                this.setForeground(null);
            }
            if (object == ERROR_OBJECT) {
                this.setText("-");
                this.setHorizontalAlignment(0);
                this.setForeground(Color.LIGHT_GRAY);
            } else {
                String string = (String)object;
                if (jTable.getModel() instanceof ColClass) {
                    ColClass colClass = (ColClass)((Object)jTable.getModel());
                    String string2 = colClass.getColClass(n2);
                    if (string2.equals("numeric") || string2.equals("integer") || string2.equals("logical") || string2.equals("complex")) {
                        this.setHorizontalAlignment(4);
                        if (string != null) {
                            if (string.endsWith("NA")) {
                                this.setText("<NA>");
                                if (!bl) {
                                    this.setForeground(this.naColor);
                                }
                            } else if (string.endsWith("Inf") || string.endsWith("NaN")) {
                                if (!bl) {
                                    this.setForeground(this.infNanColor);
                                }
                            } else if ((string.endsWith("TRUE") || string.endsWith("FALSE")) && !bl) {
                                if (string.endsWith("TRUE")) {
                                    this.setForeground(this.trueColor);
                                } else {
                                    this.setForeground(this.falseColor);
                                }
                            }
                        }
                    } else {
                        this.setHorizontalAlignment(2);
                        if (string == null) {
                            this.setText("<NA>");
                            if (!bl) {
                                this.setForeground(this.naColor);
                            }
                        }
                    }
                }
            }
            this.setBorder(new CompoundBorder(this.getBorder(), this.padding));
            this.setToolTipText(this.getText());
            return this;
        }
    }

    private class RowHeaderDataTableModel
    extends AbstractTableModel {
        private OnDemandTableModel model;

        public RowHeaderDataTableModel(OnDemandTableModel onDemandTableModel) {
            this.model = onDemandTableModel;
        }

        @Override
        public int getRowCount() {
            return this.model.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int n) {
            return " ";
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return Object.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.model.getValueAt(n, -1);
        }
    }

    private static class MetaData {
        private String[] colNames;
        private String[] colClasses;
        private int[] listIndices;
        private int[] listToColumnIndex;
        private boolean numberRowname;
        private boolean emptyColNames;
        private boolean defaultRowNames;

        public MetaData(String[] stringArray, String[] stringArray2, int[] nArray, boolean bl, boolean bl2) {
            this.colNames = stringArray;
            this.colClasses = stringArray2;
            this.listIndices = nArray;
            this.numberRowname = bl;
            this.defaultRowNames = bl2;
            if (nArray != null && nArray.length > 0) {
                int n = nArray[nArray.length - 1] + 1;
                this.listToColumnIndex = new int[n];
                int n2 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    if (n2 != nArray[i]) continue;
                    this.listToColumnIndex[n2] = i;
                    ++n2;
                }
            }
            if (this.hasNoColumn()) {
                this.emptyColNames = true;
            } else {
                this.emptyColNames = true;
                for (String string : stringArray) {
                    if (string == null || string.isEmpty()) continue;
                    this.emptyColNames = false;
                    break;
                }
            }
        }

        public String getColumnName(int n) {
            if (this.emptyColNames) {
                return " ";
            }
            return this.colNames[n];
        }

        public boolean hasNoColumn() {
            return this.colNames == null || this.colNames.length == 0;
        }

        public int getColumnCount() {
            if (this.hasNoColumn()) {
                return 1;
            }
            return this.colNames.length;
        }

        public String getColClass(int n) {
            if (this.colClasses == null || this.colClasses.length <= n) {
                return "character";
            }
            return this.colClasses[n];
        }

        public int getListIndex(int n) {
            if (this.listIndices == null) {
                return n;
            }
            return this.listIndices[n];
        }

        public int getColumnIndex(int n) {
            if (this.listToColumnIndex == null) {
                return n;
            }
            return this.listToColumnIndex[n];
        }

        public boolean isNumberRowname() {
            return this.numberRowname;
        }

        public boolean isDefaultRowNames() {
            return this.defaultRowNames;
        }

        public boolean hasMatrixColumn() {
            return this.listIndices != null;
        }

        public int getMatrixColumn(int n) {
            return this.getMatrixColumn(n, false);
        }

        public int getMatrixColumnLength(int n) {
            return this.getMatrixColumn(n, true);
        }

        private int getMatrixColumn(int n, boolean bl) {
            int n2;
            if (this.listIndices == null) {
                return 1;
            }
            int n3 = this.listIndices[n];
            int n4 = 1;
            for (n2 = n - 1; n2 >= 0 && this.listIndices[n2] == n3; --n2) {
                ++n4;
            }
            if (bl) {
                for (n2 = n + 1; n2 < this.listIndices.length && this.listIndices[n2] == n3; ++n2) {
                    ++n4;
                }
            }
            return n4;
        }
    }

    private static class DataChunk {
        public static final DataChunk FAILED = new DataChunk(null, null);
        private List<REXP> vectors;
        private REXP rownames;

        DataChunk(List<REXP> list, REXP rEXP) {
            this.vectors = list;
            this.rownames = rEXP;
        }

        public Object getRowName(int n) {
            try {
                if (this.rownames == null) {
                    return n + 1;
                }
                if (this.rownames.isString()) {
                    String[] stringArray = this.rownames.asStrings();
                    if (stringArray.length <= n) {
                        return "";
                    }
                    String string = stringArray[n];
                    return string == null ? "<NA>" : string;
                }
                if (this.rownames.isInteger()) {
                    int[] nArray = this.rownames.asIntegers();
                    if (nArray.length <= n) {
                        return "";
                    }
                    return nArray[n];
                }
                return n + 1;
            }
            catch (REXPMismatchException rEXPMismatchException) {
                return null;
            }
        }

        public Object getValueAt(int n, int n2) {
            try {
                if (this.vectors.isEmpty()) {
                    return null;
                }
                if (n2 < 0 || n2 >= this.vectors.size()) {
                    return ERROR_OBJECT;
                }
                REXP rEXP = this.vectors.get(n2);
                if (rEXP == null) {
                    return ERROR_OBJECT;
                }
                if (rEXP.isString()) {
                    String[] stringArray = rEXP.asStrings();
                    if (stringArray.length <= n) {
                        return ERROR_OBJECT;
                    }
                    return stringArray[n];
                }
                if (rEXP.isFactor()) {
                    RFactor rFactor = rEXP.asFactor();
                    if (rFactor.size() <= n) {
                        return ERROR_OBJECT;
                    }
                    return rFactor.at(n);
                }
                if (rEXP.isInteger()) {
                    int[] nArray = rEXP.asIntegers();
                    if (nArray.length <= n) {
                        return ERROR_OBJECT;
                    }
                    return nArray[n];
                }
                if (rEXP.isNumeric()) {
                    double[] dArray = rEXP.asDoubles();
                    if (dArray.length <= n) {
                        return ERROR_OBJECT;
                    }
                    return dArray[n];
                }
            }
            catch (REXPMismatchException rEXPMismatchException) {
                // empty catch block
            }
            return null;
        }
    }

    private static class Range
    implements Comparable<Range> {
        public int start;
        public int end;
        private boolean rev;

        public Range(int n, int n2) {
            this.rev = n > n2;
            this.start = this.rev ? n2 : n;
            this.end = this.rev ? n : n2;
        }

        public boolean isReversed() {
            return this.rev;
        }

        public int getFirst() {
            return this.rev ? this.end : this.start;
        }

        public int length() {
            return this.end - this.start + 1;
        }

        public void set(Range range) {
            this.start = range.start;
            this.end = range.end;
        }

        public boolean intersects(Range range) {
            return range.start <= this.end && range.end >= this.start;
        }

        public boolean connects(Range range) {
            return range.start <= this.end + 1 && range.end >= this.start - 1;
        }

        public Range intersection(Range range) {
            if (!this.intersects(range)) {
                return null;
            }
            if (this.start <= range.start && this.end >= range.end) {
                return new Range(range.start, range.end);
            }
            if (this.start >= range.start && this.end <= range.end) {
                return new Range(this.start, this.end);
            }
            if (this.start < range.start) {
                return new Range(range.start, this.end);
            }
            if (this.end > range.end) {
                return new Range(this.start, range.end);
            }
            return null;
        }

        public boolean contains(int n) {
            return this.start <= n && n <= this.end;
        }

        public void unify(Range range) {
            this.start = Math.min(this.start, range.start);
            this.end = Math.max(this.end, range.end);
        }

        public Range[] subtract(Range range) {
            if (!this.intersects(range)) {
                return null;
            }
            if (this.start < range.start && this.end > range.end) {
                return new Range[]{new Range(this.start, range.start - 1), new Range(range.end + 1, this.end)};
            }
            if (this.start < range.start) {
                return new Range[]{new Range(this.start, range.start - 1)};
            }
            if (this.end > range.end) {
                return new Range[]{new Range(range.end + 1, this.end)};
            }
            return new Range[0];
        }

        public String toString() {
            if (this.start == this.end) {
                return Integer.toString(this.start);
            }
            return this.start + ":" + this.end;
        }

        public String toString(int n) {
            if (this.start == this.end) {
                return Integer.toString(this.start + n);
            }
            return this.start + n + ":" + (this.end + n);
        }

        @Override
        public int compareTo(Range range) {
            return Integer.compare(this.start, range.start);
        }

        public static List<Range> toRanges(List<Integer> list) {
            ArrayList<Range> arrayList = new ArrayList<Range>();
            Range range = null;
            for (Integer n : list) {
                if (range == null || range.end + 1 != n) {
                    range = new Range(n, n);
                    arrayList.add(range);
                    continue;
                }
                range.end = n;
            }
            return arrayList;
        }

        public static String rangesToIndex(List<?> list) {
            if (list.size() == 1) {
                return list.get(0).toString();
            }
            return list.stream().map(object -> object.toString()).collect(Collectors.joining(", ", "c(", ")"));
        }
    }

    private class SelectionModel
    extends DefaultListSelectionModel {
        private boolean row;
        private List<Range> selection = new ArrayList<Range>();
        private int anchor = -1;
        private boolean lockSelection;

        public SelectionModel(boolean bl) {
            this.row = bl;
        }

        public List<Range> getSelection() {
            return this.selection;
        }

        public void setLockSelection(boolean bl) {
            block6: {
                this.lockSelection = bl;
                if (bl) break block6;
                super.clearSelection();
                if (this.row) {
                    int n = RDataObjectView.this.getModel().getRowOffset();
                    int n2 = RDataObjectView.this.getModel().getRowCount();
                    for (Range range : this.selection) {
                        int n3 = Math.max(0, range.start - n);
                        int n4 = Math.min(n2 - 1, range.end - n);
                        if (n3 >= n2 || n4 < 0) continue;
                        if (range.isReversed()) {
                            super.addSelectionInterval(n4, n3);
                            continue;
                        }
                        super.addSelectionInterval(n3, n4);
                    }
                } else {
                    for (Range range : this.selection) {
                        if (range.isReversed()) {
                            super.addSelectionInterval(range.end, range.start);
                            continue;
                        }
                        super.addSelectionInterval(range.start, range.end);
                    }
                }
            }
        }

        public void selectAll(int n) {
            this.selection.clear();
            this.selection.add(new Range(0, Math.max(0, n - 1)));
        }

        public int getAnchor() {
            return this.anchor;
        }

        public boolean isAnchorSelected() {
            if (this.anchor < 0) {
                return false;
            }
            for (Range range : this.selection) {
                if (!range.contains(this.anchor)) continue;
                return true;
            }
            return false;
        }

        private Range getViewRange(int n, int n2) {
            int n3;
            Range range = new Range(n, n2);
            int n4 = RDataObjectView.this.getModel().getRowOffset();
            Range range2 = new Range(n4, n4 + (n3 = RDataObjectView.this.getModel().getRowCount()) - 1);
            Range range3 = range.intersection(range2);
            if (range3 == null) {
                return null;
            }
            range3.start -= n4;
            range3.end -= n4;
            if (n > n2) {
                int n5 = range3.start;
                range3.start = range3.end;
                range3.end = n5;
            }
            return range3;
        }

        public void setSelection(int n, int n2) {
            if (this.row) {
                this.setSelectionInterval(new Range(n, n2));
                Range range = this.getViewRange(n, n2);
                if (range != null) {
                    super.setSelectionInterval(range.start, range.end);
                }
            } else {
                this.setSelectionInterval(n, n2);
            }
        }

        public void addSelection(int n, int n2) {
            if (this.row) {
                this.addSelectionInterval(new Range(n, n2));
                Range range = this.getViewRange(n, n2);
                if (range != null) {
                    super.addSelectionInterval(range.start, range.end);
                }
            } else {
                this.addSelectionInterval(n, n2);
            }
        }

        public void removeSelection(int n, int n2) {
            if (this.row) {
                this.removeSelectionInterval(new Range(n, n2));
                Range range = this.getViewRange(n, n2);
                if (range != null) {
                    super.removeSelectionInterval(range.start, range.end);
                }
            } else {
                this.removeSelectionInterval(n, n2);
            }
        }

        private Range getRange(int n, int n2) {
            Range range = new Range(n, n2);
            if (this.row) {
                int n3 = RDataObjectView.this.getModel().getRowOffset();
                range.start += n3;
                range.end += n3;
            }
            return range;
        }

        @Override
        public void setSelectionInterval(int n, int n2) {
            if (n == -1 || n2 == -1) {
                return;
            }
            this.setSelectionInterval(this.getRange(n, n2));
            super.setSelectionInterval(n, n2);
        }

        private void setSelectionInterval(Range range) {
            this.selection.clear();
            this.selection.add(range);
            this.anchor = range.getFirst();
        }

        @Override
        public void addSelectionInterval(int n, int n2) {
            if (n == -1 || n2 == -1) {
                return;
            }
            this.addSelectionInterval(this.getRange(n, n2));
            super.addSelectionInterval(n, n2);
        }

        private void addSelectionInterval(Range range) {
            this.anchor = range.getFirst();
            if (this.selection.isEmpty()) {
                this.selection.add(range);
            } else {
                Range range2;
                Range range3 = null;
                int n = Collections.binarySearch(this.selection, range);
                if (n < 0) {
                    n = Math.abs(n + 1);
                    if (--n >= 0 && (range2 = this.selection.get(n)).connects(range)) {
                        range2.unify(range);
                        range3 = range2;
                    }
                    ++n;
                }
                if (n >= this.selection.size()) {
                    if (range3 == null) {
                        this.selection.add(range);
                    }
                    return;
                }
                range2 = this.selection.get(n);
                if (range3 == null) {
                    if (range2.connects(range)) {
                        range2.unify(range);
                        range3 = range2;
                    }
                } else if (range2.connects(range3)) {
                    range3.unify(range2);
                    this.selection.remove(n);
                    --n;
                }
                if (range3 == null) {
                    this.selection.add(n, range);
                } else {
                    ++n;
                    while (n < this.selection.size()) {
                        Range range4 = this.selection.get(n);
                        if (range4.connects(range3)) {
                            range3.unify(range4);
                            this.selection.remove(n);
                            --n;
                        }
                        ++n;
                    }
                }
            }
        }

        @Override
        public void removeSelectionInterval(int n, int n2) {
            if (n == -1 || n2 == -1) {
                return;
            }
            this.removeSelectionInterval(this.getRange(n, n2));
            super.removeSelectionInterval(n, n2);
        }

        public void removeSelectionInterval(Range range) {
            if (this.selection.isEmpty()) {
                return;
            }
            this.anchor = range.getFirst();
            int n = Collections.binarySearch(this.selection, range);
            if (n < 0) {
                n = Math.abs(n + 1);
                if (--n >= 0) {
                    n = this.subtract(n, range);
                }
                ++n;
            }
            if (n >= this.selection.size()) {
                return;
            }
            int n2 = this.subtract(n, range);
            if (n2 < n) {
                while (n < this.selection.size() && (n2 = this.subtract(n, range)) < n) {
                    ++n;
                }
            }
        }

        private int subtract(int n, Range range) {
            Range range2 = this.selection.get(n);
            Range[] rangeArray = range2.subtract(range);
            if (rangeArray != null) {
                if (rangeArray.length == 0) {
                    this.selection.remove(n);
                    --n;
                } else if (rangeArray.length == 1) {
                    range2.set(rangeArray[0]);
                } else if (rangeArray.length == 2) {
                    range2.set(rangeArray[0]);
                    this.selection.add(n + 1, rangeArray[1]);
                    ++n;
                }
            }
            return n;
        }

        @Override
        public void clearSelection() {
            super.clearSelection();
            if (!this.lockSelection) {
                this.selection.clear();
                this.anchor = -1;
            }
        }
    }

    private class SettingsListener
    implements ValueChangeEventHandler {
        private SettingsListener() {
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            if (Settings.DATA_FONT_SIZE.equals(valueChangeEvent.getKey())) {
                RDataObjectView.this.refreshFont();
            }
        }
    }

    private class RefreshAction
    extends LoggableAction {
        public RefreshAction() {
            this.putValue("Name", Messages.getString("Action.refresh"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            RDataObjectView.this.refresh();
        }
    }

    private class RCopyTableModel
    implements DataTable.CopyTableModel {
        private int chunkRowSize;
        private int chunkColumnSize;
        private static final int CACHE_LIMIT = 5;
        private Map<Long, DataChunk> map = new HashMap<Long, DataChunk>(6);
        private Deque<Long> indexList = new ArrayDeque<Long>();
        private OnDemandTableModel model;
        private int[] rows;
        private int[] cols;
        private int lastChunkRowIndex = -1;
        private int lastChunkColIndex = -2;
        private DataChunk lastChunk = null;

        public RCopyTableModel(JTable jTable) {
            this.model = (OnDemandTableModel)jTable.getModel();
            this.rows = jTable.getRowSelectionAllowed() ? this.getSelectedRows() : new int[]{};
            this.cols = jTable.getColumnSelectionAllowed() ? jTable.getSelectedColumns() : new int[]{};
            int n = 100000;
            this.chunkRowSize = Math.max(1, n / this.getColumnCount());
            this.chunkColumnSize = n / this.chunkRowSize;
        }

        private int[] getSelectedRows() {
            SelectionModel selectionModel = (SelectionModel)RDataObjectView.this.getTable().getSelectionModel();
            int n = 0;
            for (Range range : selectionModel.getSelection()) {
                n += range.length();
            }
            if (n == this.model.getActualRowCount()) {
                return new int[0];
            }
            Object object = new int[n];
            int n2 = 0;
            for (Range range : selectionModel.getSelection()) {
                for (int i = range.start; i <= range.end; ++i) {
                    object[n2++] = i;
                }
            }
            return object;
        }

        @Override
        public String getColumnName(int n) {
            if (this.cols.length > 0) {
                n = this.cols[n];
            }
            return this.model.metaData.getColumnName(n);
        }

        @Override
        public int getColumnCount() {
            return this.cols.length == 0 ? this.model.getColumnCount() : this.cols.length;
        }

        @Override
        public int getRowCount() {
            return this.rows.length == 0 ? this.model.getActualRowCount() : this.rows.length;
        }

        public int getListIndex(int n) {
            return this.model.metaData.getListIndex(n);
        }

        private String getIndices(int[] nArray, int n, int n2) {
            if (nArray.length == 0) {
                if (n2 == 1) {
                    return Integer.toString(n + 1);
                }
                return n + 1 + ":" + (n + n2);
            }
            if (n2 == 1) {
                return Integer.toString(nArray[n] + 1);
            }
            ArrayList<Range> arrayList = new ArrayList<Range>();
            Range range = null;
            for (int i = n; i < n + n2; ++i) {
                int n3 = nArray[i] + 1;
                if (range == null || range.end + 1 != n3) {
                    range = new Range(n3, n3);
                    arrayList.add(range);
                    continue;
                }
                range.end = n3;
            }
            return Range.rangesToIndex(arrayList);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private String getMatrixDataframeObject(String string, String string2, int n, int n2) {
            ArrayList<List> arrayList;
            int n3;
            int n4 = n + n2;
            ArrayList<Serializable> arrayList2 = new ArrayList<Serializable>(n2);
            int n5 = -1;
            for (int i = n; i < n4; ++i) {
                int n6;
                int n7 = this.cols.length > 0 ? this.cols[i] : i;
                n3 = this.getListIndex(n7);
                if (n3 == n5) {
                    n6 = this.model.metaData.getMatrixColumn(n7);
                    List list2 = (List)arrayList2.get(arrayList2.size() - 1);
                    list2.add(n6);
                    continue;
                }
                n6 = this.model.metaData.getMatrixColumnLength(n7);
                if (n6 > 1) {
                    int n8 = this.model.metaData.getMatrixColumn(n7);
                    arrayList2.add(Lists.newArrayList((Object[])new Integer[]{n3, n6, n8}));
                    n5 = n3;
                    continue;
                }
                arrayList2.add(Integer.valueOf(n3));
                n5 = -1;
            }
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            Range range = null;
            n3 = 0;
            for (Object e : arrayList2) {
                int n9;
                block13: {
                    n9 = -1;
                    if (e instanceof List) {
                        List list3 = (List)e;
                        if ((Integer)list3.get(1) == list3.size() - 2) {
                            n9 = (Integer)list3.get(0) + 1;
                            break block13;
                        } else {
                            int n10 = (Integer)list3.get(0) + 1;
                            List<Integer> list4 = list3.subList(2, list3.size());
                            List<Range> list5 = Range.toRanges(list4);
                            list5.add(new Range(n10, n10));
                            arrayList3.add(list5);
                            n3 = 1;
                            continue;
                        }
                    }
                    n9 = (Integer)e + 1;
                }
                if (range == null || range.end + 1 != n9) {
                    range = new Range(n9, n9);
                    arrayList3.add(range);
                    continue;
                }
                range.end = n9;
            }
            if (n3 == 0) {
                arrayList = Range.rangesToIndex(arrayList3);
                return string + "[" + string2 + ", " + arrayList + ", drop=FALSE]";
            }
            arrayList = new ArrayList<List>();
            Object var12_19 = null;
            Iterator iterator = arrayList3.iterator();
            while (iterator.hasNext()) {
                void var12_20;
                Object e = iterator.next();
                if (e instanceof List) {
                    arrayList.add((List)e);
                    Object var12_21 = null;
                    continue;
                }
                if (var12_20 == null) {
                    ArrayList<Object> arrayList4 = new ArrayList<Object>();
                    arrayList4.add(null);
                    arrayList.add(arrayList4);
                }
                var12_20.set(var12_20.size() - 1, (Range)e);
                var12_20.add(null);
            }
            return arrayList.stream().map(list -> {
                if (list.get(list.size() - 1) == null) {
                    list.remove(list.size() - 1);
                    String string3 = Range.rangesToIndex(list);
                    return string + "[" + string2 + ", " + string3 + ", drop=FALSE]";
                }
                int n = ((Range)list.remove((int)(list.size() - 1))).start;
                String string4 = Range.rangesToIndex(list);
                return string + "[" + string2 + ", " + n + "][," + string4 + ", drop=FALSE]";
            }).collect(Collectors.joining(", ", "cbind(", ")"));
        }

        private RObject getCopyRObject(int n, int n2, int n3, int n4) {
            RObject rObject = RDataObjectView.this.getRObject();
            if (rObject == null) {
                return null;
            }
            if (rObject.getDim().length < 2) {
                return this.getCopyVectorRObject(n, n2);
            }
            int n5 = this.getRowCount();
            int n6 = this.getColumnCount();
            if (rObject.getDim().length > 2 || n < 0 || n5 <= n || n3 < 0 || n6 <= n3) {
                return null;
            }
            int n7 = Math.min(n2, n5 - n);
            int n8 = Math.min(n4, n6 - n3);
            RObject.Builder builder = RObject.builder("").setParent(rObject).setType(rObject.getType()).setClasses(rObject.getClasses()).setNewClasses(rObject.getNewClasses()).setTip(rObject.getTip()).setIndexObject(true);
            String string = this.getIndices(this.rows, n, n7);
            if (this.model.metaData.hasMatrixColumn() && rObject.inherits("data.frame")) {
                builder = builder.setParent(rObject.getParent()).setIndexObject(false);
                return builder.setName(this.getMatrixDataframeObject(rObject.getName(true), string, n3, n8)).setDim(n7, n8).build();
            }
            String string2 = this.getIndices(this.cols, n3, n8);
            if (rObject.inherits("data.frame")) {
                return builder.setName("[" + string + ", " + string2 + ", drop=FALSE]").setDim(n7, n8).build();
            }
            if (rObject.isFlag(4) && rObject.getDim().length <= 2) {
                return builder.setName("[" + string + ", " + string2 + ", drop=FALSE]").setFlag(6).setDim(n7, n8).build();
            }
            return builder.setName("[" + string + ", " + string2 + ", drop=FALSE]").setDim(n7, n8).build();
        }

        public RObject getCopyVectorRObject(int n, int n2) {
            RObject rObject = RDataObjectView.this.getRObject();
            int n3 = this.getRowCount();
            if (n < 0 || rObject == null || n3 <= n) {
                return null;
            }
            int n4 = Math.min(n2, n3 - n);
            String string = this.getIndices(this.rows, n, n4);
            RObject.Builder builder = RObject.builder("").setParent(rObject).setType(rObject.getType()).setClasses(rObject.getClasses()).setNewClasses(rObject.getNewClasses()).setTip(rObject.getTip()).setFlag(rObject.getFlag()).setIndexObject(true);
            return builder.setName("[" + string + "]").setDim(n4).build();
        }

        @Override
        public String getValue(int n, int n2) throws Exception {
            DataChunk dataChunk;
            int n3;
            int n4 = n / this.chunkRowSize;
            int n5 = n3 = n2 < 0 ? Math.max(0, this.lastChunkColIndex) : n2 / this.chunkColumnSize;
            if (this.lastChunkRowIndex == n4 && this.lastChunkColIndex == n3) {
                dataChunk = this.lastChunk;
            } else {
                long l = (long)n4 << 32 | (long)n3;
                dataChunk = this.map.get(l);
                if (dataChunk == null) {
                    RObject rObject = this.getCopyRObject(n4 * this.chunkRowSize, this.chunkRowSize, n3 * this.chunkColumnSize, this.chunkColumnSize);
                    dataChunk = RDataObjectView.this.getChunk(rObject);
                    for (int i = 0; dataChunk == DataChunk.FAILED && i < 5; ++i) {
                        dataChunk = RDataObjectView.this.getChunk(rObject);
                    }
                    if (dataChunk == DataChunk.FAILED) {
                        throw new Exception("Failed to retrieve data from R.");
                    }
                    this.map.put(l, dataChunk);
                    this.indexList.addLast(l);
                    if (this.indexList.size() > 5) {
                        this.map.remove(this.indexList.poll());
                    }
                    if (dataChunk != DataChunk.FAILED) {
                        Iterator<Long> iterator = this.indexList.descendingIterator();
                        while (iterator.hasNext()) {
                            Long l2 = iterator.next();
                            if (this.map.get(l2) != null) continue;
                            this.map.remove(l2);
                            iterator.remove();
                        }
                    }
                }
            }
            this.lastChunkRowIndex = n4;
            this.lastChunkColIndex = n3;
            this.lastChunk = dataChunk;
            if (dataChunk == DataChunk.FAILED || dataChunk == null) {
                if (n2 == -1) {
                    return Integer.toString(n + 1);
                }
                return "";
            }
            if (n2 == -1) {
                if (dataChunk.rownames == null || this.model.metaData.isDefaultRowNames()) {
                    return Integer.toString(n + 1);
                }
                return this.stringValue(dataChunk.getRowName(n - n4 * this.chunkRowSize));
            }
            int n6 = n - n4 * this.chunkRowSize;
            int n7 = n2 - n3 * this.chunkColumnSize;
            return this.stringValue(dataChunk.getValueAt(n6, n7));
        }

        @Override
        public String getRowHeaderValue(int n) throws Exception {
            return this.getValue(n, -1);
        }

        @Override
        public String getRowheaderColumnName() throws Exception {
            return "";
        }
    }

    private static interface ColClass {
        public String getColClass(int var1);
    }
}

