/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.object;

import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RInterface;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.object.RObjectBrowser;
import com.ef_prime.rflow.ui.app.r.object.RObjectView;
import com.ef_prime.rflow.ui.app.r.script.AbstractRCodingTextArea;
import com.ef_prime.rflow.ui.app.r.script.RCodingTextArea;
import com.ef_prime.rflow.ui.app.r.script.RScriptUtility;
import com.ef_prime.rflow.ui.base.MenuActionProvider;
import com.google.common.collect.Lists;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.rosuda.REngine.REXP;

public class RFunctionObjectView
extends RObjectView
implements MenuActionProvider,
ItemListener {
    private AbstractRCodingTextArea textArea;
    private JCheckBox format;

    public static boolean isViewable(RObject rObject) {
        return rObject.inherits("function");
    }

    public RFunctionObjectView(RInterface rInterface, RObjectBrowser rObjectBrowser) {
        super(rInterface, rObjectBrowser);
        this.setTitle("Function");
    }

    @Override
    protected void loadContent() {
        this.textArea = new RCodingTextArea();
        this.textArea.setEditable(false);
        this.textArea.setUneditableBackgroundColor();
        this.textArea.setBracketMatchingEnabled(false);
        this.textArea.setCodeFoldingEnabled(true);
        this.format = new JCheckBox(Messages.getString("R.Object.Function.format"));
        this.format.addItemListener(this);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout(new LC().insetsAll("0").hideMode(2)));
        jPanel.add(this.format);
        this.add((Component)jPanel, "North");
        this.add((Component)RScriptUtility.createScriptPane(this.textArea), "Center");
    }

    @Override
    protected Object refreshWork() throws Exception {
        REXP rEXP;
        Object[] objectArray;
        Boolean bl = RClient.rexpToBoolean(this.r.client().silentTimeoutEvalGet("!is.null(attr(" + this.getRObject().getFullName() + ", \"srcref\", exact = TRUE))"), false);
        SwingUtilities.invokeLater(() -> this.format.setVisible(bl));
        ArrayList arrayList = Lists.newArrayList((Object[])new String[]{"keepInteger", "keepNA"});
        if (bl.booleanValue() && !this.format.isSelected()) {
            arrayList.add("useSource");
        }
        if ((objectArray = RClient.rexpToStrings(rEXP = this.r.client().silentTimeoutEvalGet(RUtility.function("deparse", "expr", this.getRObject().getFullName(), "width.cutoff", Integer.toString(300), "control", RUtility.combineCharacters(arrayList))), null, "")) == null) {
            return "";
        }
        return StringUtils.join((Object[])objectArray, (char)'\n');
    }

    @Override
    protected void refreshWorkDone(Object object) {
        this.textArea.setText(object.toString());
        this.textArea.setCaretPosition(0);
    }

    @Override
    public Action getAction(String string) {
        if ("MENU_ACTION_FIND".equals(string) && this.textArea != null) {
            return this.textArea.getFindAction();
        }
        return null;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.refresh();
    }
}

