/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.object;

import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RInterface;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RObjectSet;
import com.ef_prime.rflow.ui.app.r.object.RObjectActions;
import com.ef_prime.rflow.ui.app.r.object.RObjectBrowser;
import com.ef_prime.rflow.ui.app.r.object.RObjectView;
import com.ef_prime.rflow.ui.app.r.object.RObjectViewer;
import com.ef_prime.rflow.ui.base.Icons;
import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class RListObjectView
extends RObjectView {
    private ListView listView;

    public RListObjectView(RInterface rInterface, RObjectBrowser rObjectBrowser) {
        super(rInterface, rObjectBrowser);
        this.setTitle("List");
        this.listView = rObjectBrowser == null ? new TreeListView() : new TableListView();
    }

    public static boolean isViewable(RObject rObject) {
        return rObject.getType().equals("list") || rObject.getType().equals("environment");
    }

    @Override
    protected void loadContent() {
        this.listView.loadContent();
    }

    @Override
    protected Object refreshWork() throws Exception {
        return this.listView.refreshWork();
    }

    @Override
    protected void refreshWorkDone(Object object) {
        this.listView.refreshWorkDone(object);
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        this.listView.viewDidBecomeUndisplayable();
    }

    private class TreeListView
    implements ListView {
        private RObjectBrowser objectBrowser;
        private RObjectViewer objectView;

        private TreeListView() {
        }

        @Override
        public void loadContent() {
            this.objectBrowser = new ObjectBrowserForList();
            this.objectBrowser.setRootVisible(true);
            this.objectView = new RObjectViewerForList(RListObjectView.this.r);
            this.objectView.setBrowser(this.objectBrowser);
            JSplitPane jSplitPane = new JSplitPane(1, this.objectBrowser, this.objectView);
            RListObjectView.this.setLayout(new BorderLayout());
            RListObjectView.this.add(jSplitPane);
            jSplitPane.setDividerLocation(250);
        }

        @Override
        public Object refreshWork() throws Exception {
            return null;
        }

        @Override
        public void refreshWorkDone(Object object) {
            this.objectBrowser.setTopObject(RListObjectView.this.getRObject());
            this.objectBrowser.setTopName(RListObjectView.this.getRObject().getName(false));
            this.objectBrowser.update(false);
            RListObjectView.this.r.queryQueue().addQuery(() -> SwingUtilities.invokeLater(() -> this.objectBrowser.select(RListObjectView.this.getRObject().getFullName(), false, false)));
        }

        @Override
        public void viewDidBecomeUndisplayable() {
        }

        private class ObjectBrowserForList
        extends RObjectBrowser
        implements TreeSelectionListener {
            public ObjectBrowserForList() {
                super("", null, false);
                this.tree.setToggleClickCount(2);
                this.tree.getSelectionModel().addTreeSelectionListener(this);
                this.tree.setRootVisible(true);
                this.tree.setShowsRootHandles(false);
            }

            @Override
            protected void updateFinished() {
                this.selectionChanged();
            }

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                this.selectionChanged();
            }

            private void selectionChanged() {
                if (!this.isRefreshing() && !this.isWeakSelection()) {
                    RObject rObject;
                    ArrayList arrayList = this.getSelectedObjects(true);
                    if (arrayList.isEmpty() && (rObject = this.getWeakSelection()) != null) {
                        arrayList = Lists.newArrayList((Object[])new RObject[]{rObject});
                    }
                    if (arrayList.isEmpty()) {
                        TreeListView.this.objectView.clearView();
                    } else {
                        TreeListView.this.objectView.setRObject(RObjectViewer.convertObject(arrayList));
                    }
                }
            }
        }

        private class RObjectViewerForList
        extends RObjectViewer {
            public RObjectViewerForList(RInterface rInterface) {
                super(rInterface, null);
                this.setAutoRefresh(false);
            }
        }
    }

    private class TableListView
    implements ListView {
        private JTable table;
        private int rollOverRow = -1;
        private RObjectTableModel emptyModel = new RObjectTableModel(RObjectSet.createEmptySet());

        private TableListView() {
        }

        @Override
        public void loadContent() {
            this.table = new JTable(this.emptyModel);
            this.table.setShowGrid(false);
            this.table.setTableHeader(null);
            this.table.setFocusable(false);
            this.table.setCellSelectionEnabled(false);
            this.table.setDefaultRenderer(Object.class, new RObjectRenderer());
            MouseHandler mouseHandler = new MouseHandler();
            this.table.addMouseListener(mouseHandler);
            this.table.addMouseMotionListener(mouseHandler);
            JScrollPane jScrollPane = new JScrollPane(this.table);
            RListObjectView.this.add((Component)jScrollPane, "Center");
        }

        @Override
        public Object refreshWork() throws Exception {
            RObject rObject = RListObjectView.this.getRObject();
            if (rObject == null) {
                return null;
            }
            String string = "length(" + rObject.getFullName() + ")";
            return RClient.rexpToInteger(RListObjectView.this.r.client().silentTimeoutEvalGet(string), 0);
        }

        @Override
        public void refreshWorkDone(Object object) {
            if (object == null) {
                this.table.setModel(this.emptyModel);
            } else {
                this.table.setModel(new OnDemandRObjectTableModel((Integer)object));
            }
        }

        @Override
        public void viewDidBecomeUndisplayable() {
            this.setRollOvered(-1);
        }

        private AbstractTableModel getTableModel() {
            return (AbstractTableModel)this.table.getModel();
        }

        public void setRollOvered(int n) {
            if (this.rollOverRow != n) {
                int n2 = this.rollOverRow;
                this.rollOverRow = n;
                this.getTableModel().fireTableRowsUpdated(n2, n2);
                this.getTableModel().fireTableRowsUpdated(this.rollOverRow, this.rollOverRow);
                if (n < 0) {
                    this.table.setCursor(Cursor.getDefaultCursor());
                } else {
                    this.table.setCursor(Cursor.getPredefinedCursor(12));
                }
            }
        }

        public int getRollOverRow() {
            return this.rollOverRow;
        }

        private class RObjectTableModel
        extends AbstractTableModel {
            private RObjectSet set;

            public RObjectTableModel(RObjectSet rObjectSet) {
                this.set = rObjectSet;
            }

            @Override
            public String getColumnName(int n) {
                return "";
            }

            @Override
            public int getRowCount() {
                return this.set.getObjects().size();
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                switch (n2) {
                    case 0: {
                        List<RObject> list = this.set.getObjects();
                        if (n >= list.size()) break;
                        return list.get(n);
                    }
                }
                return null;
            }
        }

        private class RObjectRenderer
        extends DefaultTableCellRenderer {
            private RObjectRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (object != null) {
                    RObject rObject = (RObject)object;
                    String string = rObject.getHtmlString(n == TableListView.this.getRollOverRow());
                    this.setText(string);
                    this.setIcon(Icons.getIcon(rObject.getIcon()));
                }
                return this;
            }
        }

        private class MouseHandler
        extends MouseAdapter {
            private MouseHandler() {
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = TableListView.this.table.rowAtPoint(mouseEvent.getPoint());
                int n2 = TableListView.this.table.columnAtPoint(mouseEvent.getPoint());
                TableListView.this.setRollOvered(n2 == 0 ? n : -1);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                TableListView.this.setRollOvered(-1);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                RObject rObject;
                int n = TableListView.this.table.rowAtPoint(mouseEvent.getPoint());
                int n2 = TableListView.this.table.columnAtPoint(mouseEvent.getPoint());
                if (n < 0 || n2 != 0) {
                    return;
                }
                if (RListObjectView.this.getBrowser() != null && (rObject = (RObject)TableListView.this.getTableModel().getValueAt(n, n2)) != null && !RListObjectView.this.getBrowser().select(rObject.getFullName(true), false, false)) {
                    RObject[] rObjectArray = new RObject[]{rObject};
                    new RObjectActions(() -> rObjectArray, null).doAction("OBJECT_VIEW");
                }
            }
        }

        private class OnDemandRObjectTableModel
        extends AbstractTableModel {
            private static final int CHUNK_SIZE = 100;
            private static final int CACHE_LIMIT = 10;
            private Map<Integer, RObjectTableModel> map = new HashMap<Integer, RObjectTableModel>(11);
            private Deque<Integer> indexList = new ArrayDeque<Integer>();
            private int lastChunkIndex = -1;
            private RObjectTableModel lastModel = null;
            private RObjectTableModel failedModel = new RObjectTableModel(null);
            private int rowCount;

            public OnDemandRObjectTableModel(int n) {
                this.rowCount = n;
            }

            @Override
            public int getRowCount() {
                return this.rowCount;
            }

            @Override
            public String getColumnName(int n) {
                return "";
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            private RObjectTableModel getTableModel(int n, int n2) {
                RObjectSet rObjectSet;
                RObject rObject = RListObjectView.this.getRObject();
                if (rObject != null && (rObjectSet = RListObjectView.this.r.client().getObjects(rObject, false, n2, n, 0)) != null) {
                    return new RObjectTableModel(rObjectSet);
                }
                return this.failedModel;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                RObjectTableModel rObjectTableModel;
                int n3 = n / 100;
                if (this.lastChunkIndex == n3) {
                    rObjectTableModel = this.lastModel;
                } else {
                    rObjectTableModel = this.map.get(n3);
                    if (rObjectTableModel == null) {
                        rObjectTableModel = this.getTableModel(n3 * 100, 100);
                        this.map.put(n3, rObjectTableModel);
                        this.indexList.addLast(n3);
                        if (this.indexList.size() > 10) {
                            this.map.remove(this.indexList.poll());
                        }
                        if (rObjectTableModel != this.failedModel) {
                            Iterator<Integer> iterator = this.indexList.descendingIterator();
                            while (iterator.hasNext()) {
                                Integer n4 = iterator.next();
                                if (this.map.get(n4) != null) continue;
                                this.map.remove(n4);
                                iterator.remove();
                            }
                        }
                    }
                }
                this.lastChunkIndex = n3;
                this.lastModel = rObjectTableModel;
                if (rObjectTableModel == this.failedModel || rObjectTableModel == null) {
                    return "-";
                }
                return rObjectTableModel.getValueAt(n - n3 * 100, n2);
            }
        }
    }

    private static interface ListView {
        public void loadContent();

        public Object refreshWork() throws Exception;

        public void refreshWorkDone(Object var1);

        public void viewDidBecomeUndisplayable();
    }
}

