/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.object;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.node.ui.OpPopupMenu;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.object.RObjectAction;
import com.ef_prime.rflow.ui.app.r.object.RObjectEditAction;
import com.ef_prime.rflow.ui.app.r.object.RObjectEditActionWithSelection;
import com.ef_prime.rflow.ui.app.r.object.RObjectTransferable;
import com.ef_prime.rflow.ui.app.r.object.RObjectViewer;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.util.PlatformUtility;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.google.common.collect.Lists;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class RObjectActions
extends Actions {
    public static final String OBJECT_VIEW = "OBJECT_VIEW";
    public static final String PRINT = "PRINT";
    public static final String SUMMARY = "SUMMARY";
    public static final String REMOVE = "REMOVE";
    public static final String PLOT = "PLOT";
    public static final String HIST = "HIST";
    public static final String TABLE = "TABLE";
    public static final String COPY = "COPY";
    public static final String RENAME = "RENAME";
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode();
    private static final String SEPARATOR = "<separator>";
    private static final String EDIT_MENU = Messages.getString("Action.open_with_external_editor");
    private static final String UI_MENU = "<ui_menu>";
    private Supplier<RObject[]> supplier;

    public RObjectActions(Supplier<RObject[]> supplier, Runnable runnable) {
        this.supplier = supplier;
        this.put(OBJECT_VIEW, new ObjectViewAction(supplier, runnable));
        this.put(PRINT, new PrintAction(supplier));
        this.put(SUMMARY, new SummaryAction(supplier));
        this.put(REMOVE, new RmAction(supplier));
        this.put(PLOT, new PlotAction(supplier));
        this.put(HIST, new HistAction(supplier));
        this.put(TABLE, new TableAction(supplier));
        this.put(COPY, new Copy(supplier));
        this.put(new CopyFullPath(supplier));
        this.put(RENAME, new Rename(supplier));
        this.root.add(new DefaultMutableTreeNode(this.get(OBJECT_VIEW)));
        this.root.add(new DefaultMutableTreeNode(SEPARATOR));
        this.root.add(new DefaultMutableTreeNode(UI_MENU));
        this.root.add(new DefaultMutableTreeNode(this.get(PRINT)));
        this.root.add(new DefaultMutableTreeNode(this.get(SUMMARY)));
        this.root.add(new DefaultMutableTreeNode(this.get(TABLE)));
        this.root.add(new DefaultMutableTreeNode(this.get(RENAME)));
        this.root.add(new DefaultMutableTreeNode(this.get(REMOVE)));
        this.root.add(new DefaultMutableTreeNode(SEPARATOR));
        this.root.add(new DefaultMutableTreeNode(this.get(PLOT)));
        this.root.add(new DefaultMutableTreeNode(this.get(HIST)));
        this.root.add(new DefaultMutableTreeNode(SEPARATOR));
        this.root.add(new DefaultMutableTreeNode(this.get(COPY)));
        this.root.add(new DefaultMutableTreeNode(this.get(CopyFullPath.class)));
        this.root.add(new DefaultMutableTreeNode(EDIT_MENU));
    }

    public JPopupMenu getPopupMenu(boolean bl) {
        RObject[] rObjectArray = this.supplier.get();
        JPopupMenu jPopupMenu = new JPopupMenu();
        Enumeration<TreeNode> enumeration = this.root.children();
        while (enumeration.hasMoreElements()) {
            Serializable serializable;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode.getUserObject() instanceof RObjectAction) {
                serializable = (RObjectAction)defaultMutableTreeNode.getUserObject();
                if (!((RObjectAction)serializable).isActionEnable(rObjectArray)) continue;
                jPopupMenu.add((Action)((Object)serializable));
                continue;
            }
            if (defaultMutableTreeNode.getUserObject().toString().equals(SEPARATOR)) {
                if (jPopupMenu.getComponentCount() <= 0 || jPopupMenu.getComponent(jPopupMenu.getComponentCount() - 1) instanceof JSeparator) continue;
                jPopupMenu.addSeparator();
                continue;
            }
            if (defaultMutableTreeNode.getUserObject().toString().equals(UI_MENU)) {
                jPopupMenu.add(OpPopupMenu.createMenu(new RObjectTransferable(R.getInterface(), rObjectArray), true));
                continue;
            }
            serializable = new JMenu(defaultMutableTreeNode.getUserObject().toString());
            if (defaultMutableTreeNode.getUserObject().toString().equals(EDIT_MENU)) {
                if (!bl) continue;
                this.addEditMenu(rObjectArray, jPopupMenu, (JMenu)serializable);
                continue;
            }
            if (!defaultMutableTreeNode.isLeaf()) {
                this.createPopupMenu(rObjectArray, (JMenu)serializable, defaultMutableTreeNode);
            }
            if (((JMenu)serializable).getItemCount() <= 0) continue;
            jPopupMenu.add((JMenuItem)serializable);
        }
        UIUtility.clearPopupSeparator(jPopupMenu);
        return jPopupMenu;
    }

    private void addEditMenu(RObject[] rObjectArray, JPopupMenu jPopupMenu, JMenu jMenu) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        List list = (List)((Object)Rflow.settings().getValue(Settings.EDITORS));
        int n = 0;
        while (n + 1 < list.size()) {
            RObjectEditAction rObjectEditAction = new RObjectEditAction(this.supplier, (String)list.get(n), (String)list.get(n + 1));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(rObjectEditAction));
            n += 2;
        }
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(SEPARATOR));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new RObjectEditActionWithSelection(this.supplier)));
        if (defaultMutableTreeNode.getChildCount() > 0) {
            jMenu.setEnabled(true);
            this.createPopupMenu(rObjectArray, jMenu, defaultMutableTreeNode);
            if (jMenu.getItemCount() > 0) {
                jPopupMenu.add(jMenu);
            }
        }
    }

    private void createPopupMenu(RObject[] rObjectArray, JMenu jMenu, DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            Serializable serializable;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode2.getUserObject() instanceof RObjectAction) {
                serializable = (RObjectAction)defaultMutableTreeNode2.getUserObject();
                if (!((RObjectAction)serializable).isActionEnable(rObjectArray)) continue;
                jMenu.add((Action)((Object)serializable));
                continue;
            }
            if (defaultMutableTreeNode2.getUserObject().toString().equals(SEPARATOR)) {
                if (jMenu.getItemCount() <= 0 || jMenu.getMenuComponent(jMenu.getItemCount() - 1) instanceof JSeparator) continue;
                jMenu.addSeparator();
                continue;
            }
            serializable = new JMenu(defaultMutableTreeNode2.getUserObject().toString());
            if (!defaultMutableTreeNode2.isLeaf()) {
                this.createPopupMenu(rObjectArray, (JMenu)serializable, defaultMutableTreeNode2);
            }
            if (((JMenu)serializable).getItemCount() <= 0) continue;
            jMenu.add((JMenuItem)serializable);
        }
    }

    public Action getDefaultAction() {
        return this.get(OBJECT_VIEW);
    }

    public void setObjectWillOpenAction(Runnable runnable) {
        ObjectViewAction objectViewAction = (ObjectViewAction)this.get(OBJECT_VIEW);
        objectViewAction.setObjectWillOpen(runnable);
    }

    public static class ObjectViewAction
    extends RObjectAction {
        private Runnable objectWillOpen;

        public ObjectViewAction(Supplier<RObject[]> supplier, Runnable runnable) {
            super(supplier);
            this.objectWillOpen = runnable;
            this.putValue("Name", Messages.getString("Action.open"));
        }

        @Override
        public boolean isActionEnable(RObject[] rObjectArray) {
            return rObjectArray.length == 1 || RObjectViewer.isViewable(Lists.newArrayList((Object[])rObjectArray));
        }

        @Override
        public void action(RObject[] rObjectArray) {
            RObjectViewer rObjectViewer;
            if (this.objectWillOpen != null) {
                this.objectWillOpen.run();
            }
            if ((rObjectViewer = RObjectViewer.create(R.getInterface(), Lists.newArrayList((Object[])rObjectArray))) != null) {
                Rflow.mainView().openViewAtDefaultObjectPane(rObjectViewer, ViewOpenType.OPEN_NEW, true);
            }
        }

        public void setObjectWillOpen(Runnable runnable) {
            this.objectWillOpen = runnable;
        }
    }

    private static class PrintAction
    extends RObjectAction {
        public PrintAction(Supplier<RObject[]> supplier) {
            super(supplier);
            this.putValue("Name", "print");
        }

        @Override
        public boolean isActionEnable(RObject[] rObjectArray) {
            return rObjectArray.length == 1 && rObjectArray[0].getType().length() > 0;
        }

        @Override
        public void action(RObject[] rObjectArray) {
            this.passCommand("print(" + rObjectArray[0].getFullName() + ")");
        }
    }

    private static class SummaryAction
    extends RObjectAction {
        public SummaryAction(Supplier<RObject[]> supplier) {
            super(supplier);
            this.putValue("Name", "summary");
        }

        @Override
        public boolean isActionEnable(RObject[] rObjectArray) {
            return rObjectArray.length == 1 && rObjectArray[0].getType().length() > 0;
        }

        @Override
        public void action(RObject[] rObjectArray) {
            this.passCommand("summary(" + rObjectArray[0].getFullName() + ")");
        }
    }

    private static class RmAction
    extends RObjectAction {
        public RmAction(Supplier<RObject[]> supplier) {
            super(supplier);
            this.putValue("Name", Messages.getString("Action.remove"));
            this.putValue("AcceleratorKey", PlatformUtility.getDeleteKeyStroke());
        }

        @Override
        public boolean isActionEnable(RObject[] rObjectArray) {
            RObject rObject = rObjectArray[0].getParent();
            for (int i = 1; i < rObjectArray.length; ++i) {
                if (ObjectUtils.equals((Object)rObject, (Object)rObjectArray[i].getParent())) continue;
                return false;
            }
            return true;
        }

        @Override
        public void action(RObject[] rObjectArray) {
            if (!UIUtility.confirmDelete(Rflow.mainFrame(), rObjectArray.length, rObjectArray[0].getName(false))) {
                return;
            }
            RObject rObject = rObjectArray[0].getParent();
            StringBuilder stringBuilder = new StringBuilder();
            if (rObject == null) {
                stringBuilder.append("rm(");
                for (int i = 0; i < rObjectArray.length; ++i) {
                    stringBuilder.append(rObjectArray[i].getFullName());
                    if (i == rObjectArray.length - 1) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(")");
            } else if (rObjectArray.length == 1) {
                RObject rObject2 = rObjectArray[0];
                if (rObject2.isIndexName()) {
                    stringBuilder.append(rObject.getFullName() + "[" + rObject2.getName(false) + "] <- NULL");
                } else {
                    stringBuilder.append(rObject.getFullName() + "$" + rObject2.getName(true) + " <- NULL");
                }
            } else {
                stringBuilder.append(rObject.getFullName() + "[");
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (int i = 0; i < rObjectArray.length; ++i) {
                    RObject rObject3 = rObjectArray[i];
                    if (rObject3.isIndexName()) {
                        arrayList.add(rObject3.getName(false));
                        continue;
                    }
                    arrayList2.add(rObject3.getQuotedName());
                }
                StringBuilder stringBuilder2 = new StringBuilder();
                if (arrayList2.size() > 0) {
                    stringBuilder2.append("c(" + StringUtils.join(arrayList2, (char)',') + ")");
                }
                if (arrayList.size() > 0) {
                    stringBuilder.append("c(" + StringUtils.join(arrayList, (char)','));
                    if (arrayList2.size() > 0) {
                        stringBuilder.append(", which(names(" + rObject.getFullName() + ") %in% " + stringBuilder2.toString() + ")");
                    }
                    stringBuilder.append(")");
                } else {
                    stringBuilder.append("(" + stringBuilder2.toString() + ")");
                }
                stringBuilder.append("] <- NULL");
            }
            this.passCommand(stringBuilder.toString());
        }
    }

    private static class PlotAction
    extends RObjectAction {
        public PlotAction(Supplier<RObject[]> supplier) {
            super(supplier);
            this.putValue("Name", "plot");
        }

        @Override
        public boolean isActionEnable(RObject[] rObjectArray) {
            if (rObjectArray.length == 1) {
                return true;
            }
            int n = rObjectArray[0].getDim()[0];
            for (RObject rObject : rObjectArray) {
                if (rObject.getDim().length == 1 && rObject.getDim()[0] == n) continue;
                return false;
            }
            return true;
        }

        @Override
        public void action(RObject[] rObjectArray) {
            Object object = null;
            if (rObjectArray.length == 1) {
                object = "plot(" + rObjectArray[0].getFullName() + ")";
            } else {
                boolean bl = false;
                RObject rObject = rObjectArray[0].getParent();
                if (rObject != null && rObject.getClas().equals("data.frame")) {
                    bl = true;
                    for (RObject rObject2 : rObjectArray) {
                        if (rObject2.getParent() == null || rObject.equals(rObject2.getParent())) continue;
                        bl = false;
                        break;
                    }
                }
                object = bl ? RUtility.function("plot", "", this.toFormula(rObjectArray, false), "data", rObject.getFullName()) : (rObjectArray.length == 2 ? "plot(" + rObjectArray[0].getFullName() + ", " + rObjectArray[1].getFullName() + ")" : "plot(" + this.toFormula(rObjectArray, true) + ")");
            }
            if (object != null) {
                this.passCommand((String)object);
            }
        }

        private String toFormula(RObject[] rObjectArray, boolean bl) {
            if (rObjectArray.length == 2) {
                return this.toFormula(rObjectArray[0], rObjectArray[1], bl);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("~");
            for (int i = 0; i < rObjectArray.length; ++i) {
                RObject rObject = rObjectArray[i];
                stringBuilder.append(" ");
                stringBuilder.append(bl ? rObject.getFullName() : rObject.getName(true));
                if (i == rObjectArray.length - 1) continue;
                stringBuilder.append(" +");
            }
            return stringBuilder.toString();
        }

        private String toFormula(RObject rObject, RObject rObject2, boolean bl) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(bl ? rObject.getFullName() : rObject.getName(true));
            stringBuilder.append(" ~ ");
            stringBuilder.append(bl ? rObject2.getFullName() : rObject2.getName(true));
            return stringBuilder.toString();
        }
    }

    private static class HistAction
    extends RObjectAction {
        public HistAction(Supplier<RObject[]> supplier) {
            super(supplier);
            this.putValue("Name", "hist");
        }

        @Override
        public boolean isActionEnable(RObject[] rObjectArray) {
            return rObjectArray.length == 1 && (rObjectArray[0].getClas().equals("numeric") || rObjectArray[0].getClas().equals("integer"));
        }

        @Override
        public void action(RObject[] rObjectArray) {
            this.passCommand("hist(" + rObjectArray[0].getFullName() + ")");
        }
    }

    private static class TableAction
    extends RObjectAction {
        public TableAction(Supplier<RObject[]> supplier) {
            super(supplier);
            this.putValue("Name", "table");
        }

        @Override
        public boolean isActionEnable(RObject[] rObjectArray) {
            return rObjectArray.length == 1 && (rObjectArray[0].getClas().equals("factor") || rObjectArray[0].getClas().equals("character")) && rObjectArray[0].getDim()[0] > 1;
        }

        @Override
        public void action(RObject[] rObjectArray) {
            this.passCommand(RUtility.function("table", "", rObjectArray[0].getFullName()));
        }
    }

    private static class Copy
    extends RObjectAction
    implements ClipboardOwner {
        public Copy(Supplier<RObject[]> supplier) {
            super(supplier);
            this.putValue("Name", Messages.getString("Action.copy_name"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, UIUtility.MENU_KEY_MASK));
        }

        @Override
        public void action(RObject[] rObjectArray) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new RObjectTransferable(R.getInterface(), rObjectArray, false), this);
        }

        @Override
        public boolean isActionEnable(RObject[] rObjectArray) {
            return true;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }

    private static class CopyFullPath
    extends RObjectAction
    implements ClipboardOwner {
        public CopyFullPath(Supplier<RObject[]> supplier) {
            super(supplier);
            this.putValue("Name", Messages.getString("Action.copy_full_object_name"));
        }

        @Override
        public void action(RObject[] rObjectArray) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new RObjectTransferable(R.getInterface(), rObjectArray, true), this);
        }

        @Override
        public boolean isActionEnable(RObject[] rObjectArray) {
            return true;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }

    private static class Rename
    extends RObjectAction {
        public Rename(Supplier<RObject[]> supplier) {
            super(supplier);
            this.putValue("Name", Messages.getString("Action.rename"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(113, 0));
        }

        @Override
        public void action(RObject[] rObjectArray) {
            String string;
            RObject rObject;
            RObject rObject2 = (rObject = rObjectArray[0]).getParent();
            String string2 = rObject.getName(rObject2 == null);
            while (true) {
                if ((string = UIUtility.showInputDialog(Rflow.mainFrame(), (String)this.getValue("Name"), "", string2)) == null || string2.equals(string)) {
                    return;
                }
                RObject rObject3 = RObject.builder(string).setParent(rObject2).build();
                Boolean bl = R.client().exists(rObject3);
                if (bl == null) {
                    return;
                }
                if (!bl.booleanValue()) break;
                if (rObject2 == null) {
                    int n = JOptionPane.showConfirmDialog(Rflow.mainFrame(), Messages.format("Message.ask_overwrite", string), Messages.getString("Message.confirm_overwrite"), 2, 2);
                    if (n == 0) break;
                    return;
                }
                JOptionPane.showMessageDialog(Rflow.mainFrame(), Messages.format("Error.already_exists", string), Messages.getString("Error.title.error"), 2);
            }
            if (rObject2 == null) {
                this.passCommand(string + " <- " + string2 + "; rm(" + string2 + ")");
            } else {
                String string3 = "names(" + rObject2.getFullName() + ")";
                this.passCommand(string3 + "[" + string3 + " == " + RUtility.quote(string2) + "] <- " + RUtility.quote(string));
            }
        }

        @Override
        public boolean isActionEnable(RObject[] rObjectArray) {
            return rObjectArray.length == 1;
        }
    }
}

