/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.object;

import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RObjectSet;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.object.RObjectActions;
import com.ef_prime.rflow.ui.app.r.object.RObjectTransferable;
import com.ef_prime.rflow.ui.app.r.object.RObjectsBuilder;
import com.ef_prime.rflow.ui.app.r.object.RObjectsClassifier;
import com.ef_prime.rflow.ui.app.r.object.RObjectsFactory;
import com.ef_prime.rflow.ui.app.r.object.RObjectsFactoryEvent;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.UIColor;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.RflowTree;
import com.ef_prime.rflow.ui.common.event.SimpleEvent;
import com.ef_prime.rflow.ui.common.event.SimpleEventHandler;
import com.ef_prime.rflow.ui.common.tree.BasicTreeCellRenderer;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.ArrayUtils;

public class RObjectBrowser
extends JPanel
implements Supplier<RObject[]>,
SimpleEventHandler {
    public static final int PRESENTATION_FLAT = 0;
    public static final int PRESENTATION_HIERARCHICAL = 1;
    private static final int OBJECT_LIMIT = 200;
    protected static final RObject EMPTY_TOP_OBJECT = RObject.builder("EMPTY").build();
    private String topName;
    protected RObject topObject;
    protected RflowTree tree;
    private Supplier<RObjectSet> objectSetSupplier;
    private ObjectBrowserActions actions = new ObjectBrowserActions();
    private RObjectActions objectActions;
    protected int presentation = 0;
    private TreePath weakSelection;
    private boolean editable;
    private boolean refreshing;

    public RObjectBrowser(String string, RObject rObject, boolean bl) {
        this.setLayout(new BorderLayout());
        this.topName = string;
        this.topObject = rObject;
        this.editable = bl;
        this.objectActions = new RObjectActions(this, null);
        this.tree = new RObjectTree();
        this.tree.setModel(new DefaultTreeModel(new FolderNode(string)));
        this.tree.setCellRenderer(new ObjectTreeRenderer());
        this.tree.addTreeWillExpandListener(new ObjectTreeWillExpand());
        this.installMouseListener();
        this.tree.setToggleClickCount(10);
        this.tree.setDragEnabled(true);
        this.tree.setTransferHandler(new RObjectTransferHandler());
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add(jScrollPane);
        this.actions.installActions(this.tree, false, 1);
        this.objectActions.installActions(this.tree, false, 0);
        RObjectsFactory.getInstance().addEventHandler(this);
    }

    public RflowTree getTree() {
        return this.tree;
    }

    protected void installMouseListener() {
        this.tree.addMouseListener(new MouseHandler());
    }

    private DefaultTreeModel getModel() {
        return (DefaultTreeModel)this.tree.getModel();
    }

    public void setObjectWillOpenAction(Runnable runnable) {
        this.objectActions.setObjectWillOpenAction(runnable);
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.tree.addTreeSelectionListener(treeSelectionListener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.tree.removeTreeSelectionListener(treeSelectionListener);
    }

    public TreePath[] getSelectedPaths() {
        return this.tree.getSelectionPaths();
    }

    public void setTopName(String string) {
        this.topName = string;
    }

    protected RObject getTopObject() {
        return this.topObject;
    }

    public void setTopObject(RObject rObject) {
        this.topObject = rObject;
    }

    public void setObjectSetSupplier(Supplier<RObjectSet> supplier) {
        this.objectSetSupplier = supplier;
    }

    public void setRootVisible(boolean bl) {
        this.tree.setRootVisible(bl);
        this.tree.setShowsRootHandles(!bl);
    }

    public void setPresention(int n) {
        if (this.presentation == n) {
            return;
        }
        this.presentation = n;
    }

    public int getPresentation() {
        return this.presentation;
    }

    public void clearWeakSelection() {
        this.weakSelection = null;
        this.repaint();
    }

    public void weakSelectCurrentPath() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        this.tree.clearSelection();
        this.weakSelection = treePath;
        this.repaint();
    }

    public boolean isWeakSelection() {
        return this.weakSelection != null;
    }

    public RObject getWeakSelection() {
        if (!this.isWeakSelection()) {
            return null;
        }
        ObjectTreeNode objectTreeNode = (ObjectTreeNode)this.weakSelection.getLastPathComponent();
        return objectTreeNode.getRObject();
    }

    public boolean select(String string, boolean bl, boolean bl2) {
        ObjectTreeNode objectTreeNode = (ObjectTreeNode)this.tree.getModel().getRoot();
        if (this.tree.isRootVisible()) {
            return this.select(objectTreeNode, string, bl, bl2);
        }
        for (int i = 0; i < objectTreeNode.getChildCount(); ++i) {
            if (!this.select((ObjectTreeNode)objectTreeNode.getChildAt(i), string, bl, bl2)) continue;
            return true;
        }
        return false;
    }

    private boolean select(ObjectTreeNode objectTreeNode, String string, boolean bl, boolean bl2) {
        block7: {
            block6: {
                char c;
                if (!objectTreeNode.isRObject()) break block6;
                String string2 = objectTreeNode.getRObject().getFullName(true);
                TreePath treePath = new TreePath(objectTreeNode.getPath());
                if (string.equals(string2)) {
                    if (bl) {
                        this.tree.clearSelection();
                        this.weakSelection = treePath;
                        this.repaint();
                    } else {
                        this.tree.setSelectionPath(treePath);
                        if (bl2) {
                            this.tree.expandPath(treePath);
                        }
                    }
                    UIUtility.scrollPathToVisibleIncludingExpandControl(this.tree, treePath);
                    return true;
                }
                if (!string.startsWith(string2) || (c = string.charAt(string2.length())) != '$' && c != '[') break block7;
                this.tree.expandPath(treePath);
                for (int i = 0; i < objectTreeNode.getChildCount(); ++i) {
                    if (!this.select((ObjectTreeNode)objectTreeNode.getChildAt(i), string, bl, bl2)) continue;
                    return true;
                }
                break block7;
            }
            for (int i = 0; i < objectTreeNode.getChildCount(); ++i) {
                if (!this.select((ObjectTreeNode)objectTreeNode.getChildAt(i), string, bl, bl2)) continue;
                return true;
            }
        }
        return false;
    }

    public void update(boolean bl) {
        this.update(200, bl);
    }

    private void update(int n, boolean bl) {
        Object object;
        Object object2 = this.objectSetSupplier != null ? this.objectSetSupplier.get() : (R.client() == null ? RObjectSet.createEmptySet() : ((object = this.getTopObject()) == EMPTY_TOP_OBJECT ? null : this.update(n, bl, (RObject)object)));
        if (object2 == null) {
            return;
        }
        object = object2;
        UIUtility.invokeLater(() -> this.lambda$update$0((RObjectSet)object, bl));
    }

    protected RObjectSet update(int n, boolean bl, RObject rObject) {
        if (SwingUtilities.isEventDispatchThread()) {
            R.queryQueue().addQuery(() -> {
                RObjectSet rObjectSet = R.client().getObjects(rObject, false, n);
                if (rObjectSet == null) {
                    return;
                }
                if (rObject == null) {
                    this.addExtraObjects(rObjectSet);
                }
                SwingUtilities.invokeLater(() -> this.update(rObjectSet, bl));
            });
            return null;
        }
        RObjectSet rObjectSet = R.client().getObjects(rObject, false, n);
        if (rObjectSet != null && rObject == null) {
            this.addExtraObjects(rObjectSet);
        }
        return rObjectSet;
    }

    protected void addExtraObjects(RObjectSet rObjectSet) {
        List<RObjectsBuilder> list = RObjectsFactory.getInstance().getBuilders();
        for (RObjectsBuilder rObjectsBuilder : list) {
            List<RObject> list2 = rObjectsBuilder.getRObjects(R.client());
            rObjectSet.addExtraObjects(list2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(RObjectSet rObjectSet, boolean bl) {
        this.refreshing = true;
        try {
            Object object;
            Serializable serializable;
            List<TreePath> list = this.getExpandedPaths();
            TreePath[] treePathArray = this.tree.getSelectionPaths();
            ((DefaultTreeModel)this.tree.getModel()).setRoot(this.createRoot(rObjectSet));
            for (TreePath treePath2 : list) {
                serializable = this.getTreePath(treePath2);
                if (serializable == null) continue;
                this.tree.expandPath((TreePath)serializable);
            }
            if (bl && this.presentation == 1) {
                object = (ObjectTreeNode)this.tree.getModel().getRoot();
                for (int i = 0; i < ((DefaultMutableTreeNode)object).getChildCount(); ++i) {
                    serializable = (ObjectTreeNode)((DefaultMutableTreeNode)object).getChildAt(i);
                    this.tree.expandPath(new TreePath(((DefaultMutableTreeNode)serializable).getPath()));
                }
            }
            if (treePathArray != null) {
                object = Arrays.stream(treePathArray).mapToInt(treePath -> this.tree.getRowForPath((TreePath)treePath)).filter(n -> n >= 0).toArray();
                if (((Object)object).length > 0) {
                    this.tree.setSelectionRows((int[])object);
                } else {
                    this.tree.clearSelection();
                }
            }
        }
        finally {
            this.refreshing = false;
            this.updateFinished();
        }
    }

    protected void updateFinished() {
    }

    public boolean isRefreshing() {
        return this.refreshing;
    }

    private ObjectTreeNode createRoot(RObjectSet rObjectSet) {
        int n;
        List<RObject> list;
        if (this.tree.isRootVisible()) {
            ObjectNode objectNode = new ObjectNode(this.getTopObject());
            for (RObject rObject : rObjectSet.getObjects()) {
                objectNode.add(new ObjectNode(rObject));
            }
            return objectNode;
        }
        if (this.presentation == 0) {
            FolderNode folderNode = new FolderNode(this.topName);
            this.addRObjectSet(folderNode, rObjectSet);
            return folderNode;
        }
        List<RObjectsClassifier> list2 = RObjectsFactory.getInstance().getClassifiers();
        ArrayList<List<ObjectTreeNode>> arrayList = new ArrayList<List<ObjectTreeNode>>(list2.size());
        for (int i = 0; i < list2.size(); ++i) {
            arrayList.add(new ArrayList());
        }
        this.addRObjects(rObjectSet.getObjects(), list2, arrayList);
        if (this.getTopObject() == null && (list = rObjectSet.getExtraObjects()) != null) {
            this.addRObjects(list, list2, arrayList);
        }
        if (rObjectSet.isLimitExceeded() && (n = list2.indexOf(RObjectsFactory.getInstance().getOtherClassifier())) >= 0) {
            ((List)arrayList.get(n)).add(new MoreObjectsNode(rObjectSet.getExceededCount()));
        }
        ArrayList<ObjectTreeNode> arrayList2 = new ArrayList<ObjectTreeNode>();
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList2.add(new FolderNode(list2.get(i).getName(), (List)arrayList.get(i)));
        }
        return new FolderNode(this.topName, arrayList2);
    }

    private void addRObjects(List<RObject> list, List<RObjectsClassifier> list2, List<List<ObjectTreeNode>> list3) {
        block0: for (RObject rObject : list) {
            for (int i = 0; i < list2.size(); ++i) {
                RObjectsClassifier rObjectsClassifier = list2.get(i);
                if (!rObjectsClassifier.accept(rObject)) continue;
                list3.get(i).add(new ObjectNode(rObject));
                continue block0;
            }
        }
    }

    private void addRObjectSet(ObjectTreeNode objectTreeNode, RObjectSet rObjectSet) {
        if (rObjectSet == null) {
            return;
        }
        for (RObject rObject : rObjectSet.getObjects()) {
            objectTreeNode.add(new ObjectNode(rObject));
        }
        if (rObjectSet.isLimitExceeded()) {
            objectTreeNode.add(new MoreObjectsNode(rObjectSet.getExceededCount()));
        }
    }

    private List<TreePath> getExpandedPaths() {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        ArrayDeque<DefaultMutableTreeNode> arrayDeque = new ArrayDeque<DefaultMutableTreeNode>();
        arrayDeque.add((DefaultMutableTreeNode)this.tree.getModel().getRoot());
        while (arrayDeque.size() > 0) {
            Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)arrayDeque.poll()).children();
            while (enumeration.hasMoreElements()) {
                TreePath treePath;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                if (defaultMutableTreeNode.isLeaf() || !this.tree.isExpanded(treePath = new TreePath(defaultMutableTreeNode.getPath()))) continue;
                arrayDeque.addLast(defaultMutableTreeNode);
                arrayList.add(treePath);
            }
        }
        return arrayList;
    }

    private TreePath getTreePath(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        if (!defaultMutableTreeNode.equals(treePath.getPathComponent(0))) {
            return null;
        }
        for (int i = 1; i < treePath.getPathCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getPathComponent(i);
            int n = 0;
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements() && !defaultMutableTreeNode2.equals(enumeration.nextElement())) {
                ++n;
            }
            if (n >= defaultMutableTreeNode.getChildCount()) {
                return null;
            }
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
        }
        return new TreePath(defaultMutableTreeNode.getPath());
    }

    public List<RObject> getSelectedObjects(boolean bl) {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        ArrayList<RObject> arrayList = new ArrayList<RObject>();
        if (treePathArray != null) {
            if (bl) {
                int[] objectArray = this.tree.getSelectionRows();
                if (objectArray == null) {
                    return arrayList;
                }
                Arrays.sort(objectArray);
                treePathArray = new TreePath[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    treePathArray[i] = this.tree.getPathForRow(objectArray[i]);
                }
            }
            for (TreePath treePath : treePathArray) {
                ObjectTreeNode objectTreeNode = (ObjectTreeNode)treePath.getLastPathComponent();
                if (!objectTreeNode.isRObject()) {
                    return new ArrayList<RObject>(0);
                }
                RObject rObject = (RObject)objectTreeNode.getUserObject();
                arrayList.add(rObject);
            }
        }
        return arrayList;
    }

    @Override
    public RObject[] get() {
        return this.getSelectedObjects(true).toArray(new RObject[0]);
    }

    @Override
    public void onEvent(SimpleEvent simpleEvent) {
        if (simpleEvent.getClass().equals(RObjectsFactoryEvent.class)) {
            R.queryQueue().addQuery(() -> this.update(true));
        }
    }

    private /* synthetic */ void lambda$update$0(RObjectSet rObjectSet, boolean bl) {
        this.update(rObjectSet, bl);
    }

    private class ObjectBrowserActions
    extends Actions {
        static final String UPDATE = "UPDATE";
        static final String FLAT = "PRESENTATION_FLAT";
        static final String HIERARCHICAL = "PRESENTATION_HIERARCHICAL";
        static final String OPEN_MORE_OBJECTS = "OPEN_MORE_OBJECTS";

        public ObjectBrowserActions() {
            this.put(UPDATE, new Update());
            this.put(FLAT, new Flat());
            this.put(HIERARCHICAL, new Hierarchical());
            this.put(OPEN_MORE_OBJECTS, new OpenMoreObjects());
        }

        private class Update
        extends LoggableAction {
            public Update() {
                this.putValue("Name", Messages.getString("Action.refresh_latest"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                RObjectBrowser.this.update(false);
            }
        }

        private class Flat
        extends LoggableAction {
            public Flat() {
                this.putValue("Name", Messages.getString("View.object_browser.flat"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                RObjectBrowser.this.setPresention(0);
                RObjectBrowser.this.update(true);
            }
        }

        private class Hierarchical
        extends LoggableAction {
            public Hierarchical() {
                this.putValue("Name", Messages.getString("View.object_browser.hierarchical"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                RObjectBrowser.this.setPresention(1);
                RObjectBrowser.this.update(true);
            }
        }

        private class OpenMoreObjects
        extends LoggableAction {
            public OpenMoreObjects() {
                this.putValue("Name", Messages.format("R.Object.open_next_objects", 200));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                TreePath treePath = RObjectBrowser.this.tree.getSelectionPath();
                if (treePath == null) {
                    return;
                }
                if (!(treePath.getLastPathComponent() instanceof MoreObjectsNode)) {
                    return;
                }
                MoreObjectsNode moreObjectsNode = (MoreObjectsNode)treePath.getLastPathComponent();
                ObjectTreeNode objectTreeNode = (ObjectTreeNode)moreObjectsNode.getParent();
                if (!objectTreeNode.isRObject()) {
                    return;
                }
                int n = objectTreeNode.getChildCount() - 1;
                RObjectSet rObjectSet = R.client().getObjects(objectTreeNode.getRObject(), false, 200, n, 0);
                if (rObjectSet == null) {
                    return;
                }
                RObjectBrowser.this.getModel().removeNodeFromParent(moreObjectsNode);
                RObjectBrowser.this.addRObjectSet(objectTreeNode, rObjectSet);
                RObjectBrowser.this.getModel().nodeStructureChanged(objectTreeNode);
            }
        }
    }

    private class RObjectTree
    extends RflowTree {
        private RObjectTree() {
        }

        @Override
        public void collapseAll() {
            switch (RObjectBrowser.this.getPresentation()) {
                case 1: {
                    this.collapseAll(2);
                    break;
                }
                default: {
                    super.collapseAll();
                }
            }
        }
    }

    private class FolderNode
    extends ObjectTreeNode {
        public FolderNode(String string) {
            super(string);
        }

        public FolderNode(String string, List<ObjectTreeNode> list) {
            super(string);
            for (ObjectTreeNode objectTreeNode : list) {
                this.add(objectTreeNode);
            }
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public RObject getRObject() {
            return null;
        }

        public int hashCode() {
            return this.getUserObject().hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !(object instanceof FolderNode)) {
                return false;
            }
            return this.getUserObject().equals(((FolderNode)object).getUserObject());
        }
    }

    private class ObjectTreeRenderer
    extends BasicTreeCellRenderer {
        private boolean weak;

        private ObjectTreeRenderer() {
        }

        @Override
        public Color getBackgroundNonSelectionColor() {
            if (this.weak) {
                return UIColor.WEAK_SELECTION;
            }
            return super.getBackgroundNonSelectionColor();
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof ObjectNode) {
                TreePath treePath;
                ObjectNode objectNode = (ObjectNode)object;
                String string = objectNode.getRObject().getFullName(true);
                if (!bl && R.client().isNewItem(string)) {
                    this.setForeground(Color.BLUE);
                }
                this.weak = (treePath = jTree.getPathForRow(n)) != null && treePath.equals(RObjectBrowser.this.weakSelection);
                RObject rObject = objectNode.getRObject();
                this.setIcon(Icons.getIcon(rObject.getIcon()));
                this.setText(rObject.getHtmlString(false));
            } else {
                this.weak = false;
            }
            return this;
        }
    }

    private class ObjectTreeWillExpand
    implements TreeWillExpandListener {
        private ObjectTreeWillExpand() {
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            JTree jTree = (JTree)treeExpansionEvent.getSource();
            if (!jTree.hasBeenExpanded(treeExpansionEvent.getPath())) {
                ObjectTreeNode objectTreeNode = (ObjectTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
                if (!objectTreeNode.isRObject()) {
                    return;
                }
                RObject rObject = objectTreeNode.getRObject();
                FutureTask<RObjectSet> futureTask = new FutureTask<RObjectSet>(() -> R.client().getObjects(rObject, false, 200));
                R.queryQueue().addQuery(futureTask);
                try {
                    RObjectSet rObjectSet = futureTask.get(300L, TimeUnit.MILLISECONDS);
                    RObjectBrowser.this.addRObjectSet(objectTreeNode, rObjectSet);
                    RObjectBrowser.this.getModel().nodeStructureChanged(objectTreeNode);
                }
                catch (InterruptedException | ExecutionException exception) {
                }
                catch (TimeoutException timeoutException) {
                    R.queryQueue().addQuery(() -> {
                        try {
                            RObjectSet rObjectSet = (RObjectSet)futureTask.get();
                            SwingUtilities.invokeLater(() -> {
                                RObjectBrowser.this.addRObjectSet(objectTreeNode, rObjectSet);
                                RObjectBrowser.this.getModel().nodeStructureChanged(objectTreeNode);
                            });
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
            }
        }
    }

    private class RObjectTransferHandler
    extends TransferHandler {
        private RObjectTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            List<RObject> list = RObjectBrowser.this.getSelectedObjects(true);
            if (list.isEmpty()) {
                return null;
            }
            return new RObjectTransferable(R.getInterface(), list);
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && UIUtility.isLeftMouseButton(mouseEvent)) {
                Point point;
                JTree jTree = (JTree)mouseEvent.getSource();
                TreePath treePath = jTree.getPathForLocation((int)(point = mouseEvent.getPoint()).getX(), (int)point.getY());
                if (treePath == null) {
                    return;
                }
                ObjectTreeNode objectTreeNode = (ObjectTreeNode)treePath.getLastPathComponent();
                if (objectTreeNode instanceof MoreObjectsNode) {
                    jTree.setSelectionPath(treePath);
                    RObjectBrowser.this.actions.doAction("OPEN_MORE_OBJECTS");
                } else {
                    if (!objectTreeNode.isRObject()) {
                        return;
                    }
                    Action action = RObjectBrowser.this.objectActions.getDefaultAction();
                    if (action != null) {
                        action.actionPerformed(new ActionEvent(this, 1001, ""));
                    } else if (jTree.isExpanded(treePath)) {
                        jTree.collapsePath(treePath);
                    } else {
                        jTree.expandPath(treePath);
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (UIUtility.isRightMouseButton(mouseEvent)) {
                JPopupMenu jPopupMenu;
                Point point;
                JTree jTree = (JTree)mouseEvent.getSource();
                TreePath treePath = jTree.getPathForLocation((int)(point = mouseEvent.getPoint()).getX(), (int)point.getY());
                if (treePath == null) {
                    jTree.clearSelection();
                } else if (!jTree.getSelectionModel().isPathSelected(treePath)) {
                    jTree.setSelectionPath(treePath);
                }
                RObject[] rObjectArray = treePath == null ? null : RObjectBrowser.this.getSelectedObjects(true).toArray(new RObject[0]);
                JPopupMenu jPopupMenu2 = jPopupMenu = ArrayUtils.isEmpty(rObjectArray) ? new JPopupMenu() : RObjectBrowser.this.objectActions.getPopupMenu(RObjectBrowser.this.editable);
                if (jPopupMenu.getComponentCount() > 0) {
                    jPopupMenu.addSeparator();
                }
                if (treePath != null && treePath.getLastPathComponent() instanceof MoreObjectsNode) {
                    jPopupMenu.add(RObjectBrowser.this.actions.get("OPEN_MORE_OBJECTS"));
                    jPopupMenu.addSeparator();
                }
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(RObjectBrowser.this.actions.get("PRESENTATION_FLAT"));
                jRadioButtonMenuItem.setSelected(RObjectBrowser.this.presentation == 0);
                JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(RObjectBrowser.this.actions.get("PRESENTATION_HIERARCHICAL"));
                jRadioButtonMenuItem2.setSelected(RObjectBrowser.this.presentation == 1);
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(jRadioButtonMenuItem);
                buttonGroup.add(jRadioButtonMenuItem2);
                JMenu jMenu = new JMenu(Messages.getString("View.object_browser.presentation"));
                jMenu.add(jRadioButtonMenuItem);
                jMenu.add(jRadioButtonMenuItem2);
                jPopupMenu.add(jMenu);
                jPopupMenu.add(jTree.getActionMap().get("ACTION_COLLAPSE_ALL"));
                jPopupMenu.add(new JMenuItem(RObjectBrowser.this.actions.get("UPDATE")));
                jPopupMenu.show(jTree, point.x, point.y);
            }
        }
    }

    private static abstract class ObjectTreeNode
    extends DefaultMutableTreeNode {
        public ObjectTreeNode(Object object) {
            super(object);
        }

        public ObjectTreeNode(Object object, boolean bl) {
            super(object, bl);
        }

        public abstract RObject getRObject();

        public boolean isRObject() {
            return this.getRObject() != null;
        }
    }

    private class ObjectNode
    extends ObjectTreeNode {
        public ObjectNode(RObject rObject) {
            super(rObject, !rObject.isAtomic());
        }

        @Override
        public RObject getRObject() {
            return (RObject)this.getUserObject();
        }

        @Override
        public boolean isLeaf() {
            return ((RObject)this.getUserObject()).isAtomic();
        }

        public int hashCode() {
            return this.getRObject().simpleHashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !(object instanceof ObjectNode)) {
                return false;
            }
            return this.getRObject().simpleEquals(((ObjectNode)object).getRObject());
        }
    }

    private class MoreObjectsNode
    extends ObjectTreeNode {
        public MoreObjectsNode(int n) {
            super(Messages.format("R.Object.more_objects", n));
        }

        @Override
        public RObject getRObject() {
            return null;
        }
    }
}

