/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.object;

import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RObjectSet;
import com.ef_prime.rflow.core.app.r.console.BasicCommand;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandAdapter;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.RJavaUI;
import com.ef_prime.rflow.ui.app.r.object.RflowRObjectBrowser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;

public class RObjectBrowserWithStack
extends RflowRObjectBrowser
implements ActionListener {
    private JComboBox<String> stackComboBox = new JComboBox(new DefaultComboBoxModel());
    private boolean lockFrameChange;
    private boolean isRecover;

    public RObjectBrowserWithStack(String string, RObject rObject) {
        super(string, rObject, false);
        this.stackComboBox.addActionListener(this);
        this.add(this.stackComboBox, "North");
    }

    @Override
    protected RObject getTopObject() {
        int n = this.stackComboBox.getSelectedIndex() + 1;
        if (n <= 0) {
            return EMPTY_TOP_OBJECT;
        }
        return RObject.environment("[[" + n + "]]").setParent(this.topObject).setIndexObject(true).build();
    }

    @Override
    public void update(boolean bl) {
        if (R.client() == null) {
            return;
        }
        this.updateStack();
        this.updateTopName();
        super.update(bl);
    }

    private void updateTopName() {
        int n = this.stackComboBox.getSelectedIndex();
        if (n >= 0) {
            this.setTopName(this.stackComboBox.getSelectedItem().toString());
        } else {
            this.setTopName(Messages.getString("Message.debug"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStack() {
        this.stackComboBox.removeActionListener(this);
        try {
            String[] stringArray = R.client().getCurrentCalls();
            this.isRecover = R.console().isRecover();
            if (stringArray != null) {
                int n;
                this.lockFrameChange = true;
                DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.stackComboBox.getModel();
                defaultComboBoxModel.removeAllElements();
                for (n = 0; n < stringArray.length; ++n) {
                    defaultComboBoxModel.addElement(stringArray[n]);
                }
                int n2 = n = this.isRecover ? RJavaUI.getFrame() : R.console().getPseudoFrame();
                if (n > 0) {
                    this.stackComboBox.setSelectedIndex(this.frameToIndex(n));
                }
                this.lockFrameChange = false;
            }
        }
        finally {
            this.stackComboBox.addActionListener(this);
        }
    }

    @Override
    protected RObjectSet update(final int n, final boolean bl, final RObject rObject) {
        if (rObject != null) {
            R.queryQueue().addQuery(() -> {
                BasicCommand basicCommand = new BasicCommand(".rflowForceEvaluation(" + rObject.getFullName() + ")");
                basicCommand.addCommandListener(new CommandAdapter(){

                    @Override
                    public void commandFinished(Command command) {
                        R.queryQueue().addQuery(() -> {
                            RObjectSet rObjectSet = R.client().getObjects(rObject, false, n);
                            if (rObjectSet == null) {
                                return;
                            }
                            SwingUtilities.invokeLater(() -> RObjectBrowserWithStack.this.update(rObjectSet, bl));
                        });
                    }
                });
                basicCommand.setCaptureOutput(true);
                R.receiver().passCommand(basicCommand);
            }, 3000L);
            return null;
        }
        return super.update(n, bl, rObject);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isRecover && !this.lockFrameChange) {
            int n = Math.max(0, this.stackComboBox.getSelectedIndex());
            String string = (String)this.stackComboBox.getModel().getElementAt(n);
            final int n2 = this.indexToFrame(n);
            if (n2 > 0 && n2 != RJavaUI.getFrame()) {
                BasicCommand basicCommand = new BasicCommand("c # frame changed to " + string);
                basicCommand.addCommandListener(new CommandAdapter(){

                    @Override
                    public void commandStart(Command command) {
                        RJavaUI.setSelectedFrame(n2);
                    }

                    @Override
                    public void commandFinished(Command command) {
                        RJavaUI.setSelectedFrame(0);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                RObjectBrowserWithStack.this.updateTopName();
                                RObjectBrowserWithStack.super.update(true);
                            }
                        });
                    }
                });
                R.receiver().passCommand(basicCommand);
            }
        } else {
            if (!this.isRecover && !this.lockFrameChange) {
                int n = Math.max(0, this.stackComboBox.getSelectedIndex());
                String string = (String)this.stackComboBox.getModel().getElementAt(n);
                int n3 = n == 0 ? 0 : this.indexToFrame(n);
                R.console().setPseudoFrame(n3, string);
            }
            this.updateTopName();
            super.update(true);
        }
    }

    private int frameToIndex(int n) {
        return this.stackComboBox.getItemCount() - n;
    }

    private int indexToFrame(int n) {
        return this.stackComboBox.getItemCount() - n;
    }
}

