/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.object;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RObjectSet;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.console.BasicCommand;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandAdapter;
import com.ef_prime.rflow.core.app.r.console.CommandListener;
import com.ef_prime.rflow.core.common.util.ThreadUtility;
import com.ef_prime.rflow.core.util.Platform;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.object.RObjectAction;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class RObjectEditAction
extends RObjectAction {
    protected String name;
    protected String path;

    public RObjectEditAction(Supplier<RObject[]> supplier, String string, String string2) {
        super(supplier);
        this.name = string;
        this.path = string2;
        this.putValue("Name", string);
    }

    @Override
    public void action(RObject[] rObjectArray) {
        Object object;
        Object object2;
        RObject rObject = rObjectArray[0];
        RObjectSet rObjectSet = R.client().getObjects(rObject, false, 1000);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (rObjectSet != null && !rObjectSet.isLimitExceeded()) {
            object2 = rObjectSet.getObjects().iterator();
            while (object2.hasNext()) {
                object = (RObject)object2.next();
                hashMap.put(((RObject)object).getName(false), ((RObject)object).getClas());
            }
        }
        if (!((File)(object = FileUtility.getUniqueNumberFile((File)(object2 = Rflow.project().getTempDir()), rObject.getName(false), ".txt", 3, true))).getParentFile().exists() && !((File)object).getParentFile().mkdirs()) {
            UIUtility.showErrorDialog((Component)Rflow.mainFrame(), Messages.getString("Error.file.create_folder") + ": " + ((File)object).getParentFile().getPath());
            return;
        }
        String string = RUtility.quotedPath(((File)object).getAbsolutePath());
        BasicCommand basicCommand = RObjectEditAction.isVector(rObject) ? new BasicCommand("write(x=" + rObject.getFullName() + ", file=" + string + ", sep=\"\\t\", ncolumns=1)") : new BasicCommand("write.table(x=" + rObject.getFullName() + ", file=" + string + ", sep=\"\\t\", na=\"\", col.names=NA, row.names=TRUE)");
        basicCommand.addCommandListener(new EditAction(this.path, rObject, (File)object, hashMap));
        R.receiver().passCommand(basicCommand);
    }

    @Override
    public boolean isActionEnable(RObject[] rObjectArray) {
        if (rObjectArray.length == 1) {
            return rObjectArray[0].getClas().equals("data.frame") || rObjectArray[0].getClas().equals("matrix") || rObjectArray[0].getType().equals("character") || rObjectArray[0].getType().equals("double") || rObjectArray[0].getType().equals("numeric") || rObjectArray[0].getType().equals("logical") || rObjectArray[0].getType().equals("integer");
        }
        return false;
    }

    private static boolean isVector(RObject rObject) {
        return !rObject.getClas().equals("data.frame") && !rObject.getClas().equals("matrix");
    }

    private static class EditAction
    implements CommandListener {
        private String path;
        private RObject obj;
        private File file;
        private Map<String, String> col2Class;

        public EditAction(String string, RObject rObject, File file, Map<String, String> map) {
            this.path = string;
            this.obj = rObject;
            this.file = file;
            this.col2Class = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doEdit() {
            EditMonitor editMonitor = new EditMonitor(this.obj, this.file, this.col2Class);
            editMonitor.start();
            try {
                StringBuilder stringBuilder = new StringBuilder();
                if (Platform.isMac()) {
                    stringBuilder.append("open -W -n -a ");
                }
                stringBuilder.append(this.path);
                stringBuilder.append(" ");
                stringBuilder.append(this.file.getAbsolutePath());
                Process process = Runtime.getRuntime().exec(stringBuilder.toString());
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            catch (IOException iOException) {
                UIUtility.showErrorDialog((Component)Rflow.mainFrame(), iOException);
            }
            finally {
                editMonitor.processFinished();
            }
        }

        @Override
        public void commandFinished(Command command) {
            ThreadUtility.execute(() -> this.doEdit());
        }

        @Override
        public void commandStart(Command command) {
        }

        @Override
        public void errorOccurred(Command command) {
        }

        @Override
        public void commandCanceled(Command command) {
        }

        @Override
        public void commandDiscarded(Command command) {
        }
    }

    private static class EditMonitor
    extends Thread {
        private RObject obj;
        private File file;
        private Map<String, String> col2Class;
        private long lastModified;
        private boolean processFinished = false;
        private JDialog dialog;

        public EditMonitor(RObject rObject, File file, Map<String, String> map) {
            super("Edit-Monitor");
            this.obj = rObject;
            this.file = file;
            this.col2Class = map;
            this.lastModified = file.lastModified();
            this.setDaemon(true);
        }

        public void processFinished() {
            this.processFinished = true;
            this.interrupt();
        }

        @Override
        public void run() {
            while (!this.processFinished) {
                while (!this.processFinished && this.file.exists() && this.file.lastModified() == this.lastModified) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.processFinished) break;
                this.lastModified = this.file.lastModified();
                if (!this.file.exists()) continue;
                this.showSaveEditDialog();
            }
            if (this.file.exists()) {
                if (this.file.lastModified() != this.lastModified) {
                    this.showSaveEditDialog();
                } else if (this.dialog == null || !this.dialog.isVisible()) {
                    this.file.delete();
                }
            }
        }

        private void readTable(String string) {
            BasicCommand basicCommand;
            String string2 = RUtility.quotedPath(this.file.getAbsolutePath());
            if (RObjectEditAction.isVector(this.obj)) {
                String string3 = this.obj.getFullName() + "[0]";
                basicCommand = new BasicCommand(string + " <- scan(file=" + string2 + ", what=" + string3 + ",quiet=TRUE)");
            } else {
                Object object = null;
                String[] stringArray = R.client().readHeader(this.file, "\t");
                if (stringArray != null && stringArray.length > 0) {
                    object = "c(";
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string4 = this.col2Class.get(stringArray[i]);
                        object = string4 != null ? (String)object + "\"" + string4 + "\"" : (String)object + "NA";
                        object = i != stringArray.length - 1 ? (String)object + ", " : (String)object + ")";
                    }
                }
                basicCommand = new BasicCommand(string + " <- read.table(file=" + string2 + ", header=TRUE, " + (String)(object == null ? "" : "colClasses=" + (String)object + ", ") + "row.names=1, na.strings=\"\", sep=\"\\t\")");
            }
            basicCommand.addCommandListener(new CommandAdapter(){

                @Override
                public void commandFinished(Command command) {
                    R.client().fireItemStructureChanged();
                    if (processFinished && file.exists()) {
                        file.delete();
                    }
                }
            });
            R.receiver().passCommand(basicCommand);
        }

        void showSaveEditDialog() {
            if (this.dialog != null && this.dialog.isVisible()) {
                return;
            }
            String string = this.obj.getFullName() + Messages.getString("Object.confirm_external_change") + "\n\n" + Messages.getString("Object.external_change_name");
            final JOptionPane jOptionPane = new JOptionPane(string, -1, 0);
            jOptionPane.setWantsInput(true);
            jOptionPane.setInitialSelectionValue(this.obj.getFullName());
            this.dialog = jOptionPane.createDialog(Rflow.getInstance().getMainFrame(), Messages.getString("Object.external_change_title"));
            this.dialog.setModal(false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    Object object = jOptionPane.getValue();
                    if (object == null) {
                        return;
                    }
                    if (!(object instanceof Integer)) {
                        return;
                    }
                    if ((Integer)object != 0) {
                        return;
                    }
                    this.readTable(jOptionPane.getInputValue().toString());
                }
            });
            this.dialog.setVisible(true);
        }
    }
}

