/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.object;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.object.RObjectEditAction;
import com.ef_prime.rflow.ui.common.component.RflowTextField;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;

public class RObjectEditActionWithSelection
extends RObjectEditAction {
    public RObjectEditActionWithSelection(Supplier<RObject[]> supplier) {
        super(supplier, "", "");
        this.putValue("Name", Messages.getStringWithDots("Menu.other"));
    }

    @Override
    public void action(RObject[] rObjectArray) {
        EditorSelection editorSelection = new EditorSelection("");
        int n = JOptionPane.showConfirmDialog(Rflow.getInstance().getMainFrame(), editorSelection, Messages.getString("Object.choose_editor_title"), 2, -1);
        if (n != 0) {
            return;
        }
        this.path = editorSelection.editorPath.getText();
        this.name = FilenameUtils.removeExtension((String)new File(this.path).getName());
        if (editorSelection.remember.isSelected()) {
            List list = (List)((Object)Rflow.settings().getValue(Settings.EDITORS));
            list.add(this.name);
            list.add(this.path);
            Rflow.settings().putValue(Settings.EDITORS, list);
        }
        super.action(rObjectArray);
    }

    private File chooseEditor(Component component, File file) {
        return UIUtility.chooseOpenFile(Messages.getString("Message.choose"), file, new FileFilter[0], component);
    }

    private class EditorSelection
    extends JPanel {
        private JTextField editorPath;
        private JCheckBox remember;

        public EditorSelection(String string) {
            super(new BorderLayout());
            String string2 = RUtility.path(string);
            this.editorPath = new RflowTextField(string2);
            UIUtility.setWidth(500, this.editorPath);
            JButton jButton = new JButton("...");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    File file = RObjectEditActionWithSelection.this.chooseEditor(EditorSelection.this, new File(EditorSelection.this.editorPath.getText()));
                    if (file == null) {
                        return;
                    }
                    Object object = RUtility.path(file.getAbsolutePath());
                    if (((String)object).contains(" ")) {
                        object = "\"" + (String)object + "\"";
                    }
                    EditorSelection.this.editorPath.setText((String)object);
                }
            });
            Box box = Box.createHorizontalBox();
            box.add(this.editorPath);
            box.add(jButton);
            this.add((Component)box, "Center");
            this.remember = new JCheckBox(Messages.getString("Object.choose_editor_register"), true);
            this.add((Component)this.remember, "South");
        }
    }
}

