/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.object;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.base.App;
import com.ef_prime.rflow.core.app.base.Apps;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RSessionManager;
import com.ef_prime.rflow.core.app.r.console.BrowseListener;
import com.ef_prime.rflow.core.base.RflowEventHandler;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.task.TaskQueue;
import com.ef_prime.rflow.core.task.TaskQueueEvent;
import com.ef_prime.rflow.core.task.TaskQueueEventHandler;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.base.HasApp;
import com.ef_prime.rflow.ui.app.r.object.RObjectBrowser;
import com.ef_prime.rflow.ui.app.r.object.RObjectBrowserWithStack;
import com.ef_prime.rflow.ui.app.r.object.RObjectTransferable;
import com.ef_prime.rflow.ui.app.r.object.RObjectViewer;
import com.ef_prime.rflow.ui.app.r.object.RflowRObjectBrowser;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.WindowSizeSetEvent;
import com.ef_prime.rflow.ui.common.event.ChangeEvent;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import com.ef_prime.rflow.ui.common.event.SimpleEvent;
import com.ef_prime.rflow.ui.common.event.SimpleEventHandler;
import com.ef_prime.rflow.ui.common.item.Item;
import com.ef_prime.rflow.ui.common.item.ItemEvent;
import com.ef_prime.rflow.ui.common.item.ItemEventHandler;
import com.ef_prime.rflow.ui.common.item.ItemSelectable;
import com.ef_prime.rflow.ui.common.item.ItemSelectionEvent;
import com.ef_prime.rflow.ui.common.item.ItemSelectionEventHandler;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.util.SwingXUtility;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jdesktop.swingx.JXMultiSplitPane;

public class RObjectExplorer
extends View
implements BrowseListener,
ItemSelectable,
ItemEventHandler,
ChangeEventHandler,
HasApp,
RflowEventHandler,
RSessionManager.RSessionEventHandler,
SimpleEventHandler {
    private JXMultiSplitPane splitPane;
    private RObjectViewer preview;
    private RObjectBrowser globalBrowser;
    private RObjectBrowser debugBrowser;
    private JPanel browserPanel;
    private int browse;
    private EventSupport<ItemSelectionEvent, ItemSelectionEventHandler> eventSupport = new EventSupport();

    public RObjectExplorer() {
        this.setTitle(Messages.getString("Explorer.objects"));
        this.setIcon(Icons.getIcon("16/rflow_16.png"));
        this.setIconOnly(true);
        this.globalBrowser = new RflowRObjectBrowser(Messages.getString("Explorer.objects.root"), null, true){

            @Override
            protected void updateFinished() {
                RObjectExplorer.this.dispatchItemSelectionEvent(this);
            }
        };
        this.globalBrowser.update(true);
        this.globalBrowser.addTreeSelectionListener(new ObjectTreeSelectionListener(this.globalBrowser));
        this.globalBrowser.setObjectWillOpenAction(new BeforeOpen(this.globalBrowser));
        String string = "as.environment(\".RflowEnv\")";
        RObject rObject = RObject.environment(string + "$.rflowDebugEnvironment").build();
        this.debugBrowser = new RObjectBrowserWithStack(Messages.getString("Message.debug"), rObject){

            @Override
            protected void updateFinished() {
                RObjectExplorer.this.dispatchItemSelectionEvent(this);
            }
        };
        this.debugBrowser.update(true);
        this.debugBrowser.addTreeSelectionListener(new ObjectTreeSelectionListener(this.debugBrowser));
        this.debugBrowser.setObjectWillOpenAction(new BeforeOpen(this.debugBrowser));
        this.browserPanel = new JPanel(new BorderLayout());
        this.browserPanel.add(this.globalBrowser);
        this.setLayout(new BorderLayout());
        double d = Rflow.settings().getRatio(Settings.SPLIT_ROBJECT);
        this.preview = new RObjectViewer(R.getInterface(), null);
        this.preview.setAutoRefresh(false);
        this.splitPane = SwingXUtility.createHorizontalSplitPane(this.browserPanel, this.preview, d);
        SwingXUtility.installWeightChanger(this.splitPane, 0.0, 1.0);
        this.add((Component)this.splitPane);
        R.addEventHandler(this);
        Rflow.getInstance().addRflowEventHandler(this);
        R.sessionManager().addEventHandler(this);
        EventManager.getInstance().registerEventHandler(WindowSizeSetEvent.class, this);
        TaskQueue.getInstance().addTaskQueueEventHandler(new TaskQueueEventHandler(){

            @Override
            public void handleTaskQueueEvent(TaskQueueEvent taskQueueEvent) {
                R.client().clearNewItems();
            }
        });
    }

    public RObjectBrowser getDebugBrowser() {
        return this.debugBrowser;
    }

    private void update() {
        this.globalBrowser.update(false);
        if (this.browse == 1 && R.console().isBrowse()) {
            String string = Messages.getString("Message.debug");
            String string2 = R.client().getCurrentCall();
            if (string2 != null) {
                string = string2;
            }
            this.getDebugBrowser().setTopName(string);
            this.getDebugBrowser().update(true);
        }
    }

    @Override
    public void browseStateChanged(final int n, boolean bl) {
        this.browse = n;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RObjectExplorer.this.browserPanel.removeAll();
                if (n == 1) {
                    JSplitPane jSplitPane = new JSplitPane(0, RObjectExplorer.this.globalBrowser, RObjectExplorer.this.getDebugBrowser());
                    RObjectExplorer.this.browserPanel.add(jSplitPane);
                    RObjectExplorer.this.browserPanel.revalidate();
                    jSplitPane.setDividerLocation(RObjectExplorer.this.browserPanel.getHeight() / 2);
                    RObjectExplorer.this.toFront();
                } else {
                    RObjectExplorer.this.browserPanel.add(RObjectExplorer.this.globalBrowser);
                    RObjectExplorer.this.browserPanel.revalidate();
                }
                RObjectExplorer.this.update();
            }
        });
    }

    @Override
    public Item getSelectedItem() {
        return this.getSelectedItem(this.globalBrowser);
    }

    private Item getSelectedItem(RObjectBrowser rObjectBrowser) {
        ArrayList arrayList = rObjectBrowser.getSelectedObjects(true);
        if (arrayList.isEmpty()) {
            RObject rObject = rObjectBrowser.getWeakSelection();
            if (rObject == null) {
                return null;
            }
            arrayList = Lists.newArrayList((Object[])new RObject[]{rObject});
        }
        return new RObjectTransferable(R.getInterface(), arrayList);
    }

    @Override
    public void addItemEventHandler(ItemSelectionEventHandler itemSelectionEventHandler) {
        this.eventSupport.addEventHandler(itemSelectionEventHandler);
    }

    @Override
    public void removeItemEventHandler(ItemSelectionEventHandler itemSelectionEventHandler) {
        this.eventSupport.removeEventHandler(itemSelectionEventHandler);
    }

    private void dispatchItemSelectionEvent(RObjectBrowser rObjectBrowser) {
        ItemSelectionEvent itemSelectionEvent = new ItemSelectionEvent(this.getSelectedItem(rObjectBrowser), rObjectBrowser.isRefreshing(), rObjectBrowser.isWeakSelection());
        this.eventSupport.dispatchEvent(itemSelectionEvent);
        EventManager.getInstance().dispatchEvent(itemSelectionEvent);
        if (!itemSelectionEvent.isAdjusting() && !itemSelectionEvent.isWeakSelection() && this.preview != null) {
            List<RObject> list;
            this.updateTabBusy(false);
            RObjectTransferable rObjectTransferable = (RObjectTransferable)itemSelectionEvent.getItem();
            List<RObject> list2 = list = rObjectTransferable == null ? null : rObjectTransferable.getObjects();
            if (list == null || list.isEmpty()) {
                this.preview.clearView();
            } else {
                this.preview.setBrowser(rObjectBrowser);
                this.preview.setRObject(RObjectViewer.convertObject(list));
            }
        }
    }

    @Override
    public void itemChanged(final ItemEvent itemEvent) {
        switch (itemEvent.getType()) {
            case 0: {
                this.repaint();
                break;
            }
            case 2: {
                this.update();
                this.setUnread(true);
                break;
            }
            case 1: {
                this.update();
                break;
            }
            case 3: 
            case 4: {
                if (!Rflow.settings().getValue(Settings.AUTO_SELECT_ITEM).booleanValue()) break;
                UIUtility.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean bl;
                        boolean bl2 = bl = itemEvent.getType() == 4;
                        if (RObjectExplorer.this.browse == 1) {
                            RObjectExplorer.this.getDebugBrowser().select(itemEvent.getName(), bl, false);
                        } else {
                            RObjectExplorer.this.globalBrowser.select(itemEvent.getName(), bl, false);
                        }
                        RObjectExplorer.this.toFront();
                    }
                });
            }
        }
    }

    @Override
    public void handleChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof RClient) {
            RClient rClient = (RClient)changeEvent.getSource();
            rClient.addItemEventHandler(this);
        }
    }

    @Override
    public App getApp() {
        return Apps.R;
    }

    @Override
    public void rflowWillShutdown() {
        Double d = SwingXUtility.getHorizontalRatio(this.splitPane);
        if (d != null) {
            Rflow.settings().putValue(Settings.SPLIT_ROBJECT, d);
        }
    }

    @Override
    public void rflowProjectDidStart() {
    }

    @Override
    public void rflowProjectWillEnd() {
    }

    @Override
    public void onRSessionEvent(RSessionManager.RSessionEvent rSessionEvent) {
        switch (rSessionEvent.getType()) {
            case 0: {
                this.update();
                break;
            }
        }
    }

    @Override
    public void onEvent(SimpleEvent simpleEvent) {
        if (simpleEvent.getClass().equals(WindowSizeSetEvent.class)) {
            double d = Rflow.settings().getRatio(Settings.SPLIT_ROBJECT);
            SwingXUtility.setHorizontalSplit(this.splitPane, d);
        }
    }

    private class ObjectTreeSelectionListener
    implements TreeSelectionListener {
        private RObjectBrowser browser;

        public ObjectTreeSelectionListener(RObjectBrowser rObjectBrowser) {
            this.browser = rObjectBrowser;
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            this.browser.clearWeakSelection();
            RObjectExplorer.this.dispatchItemSelectionEvent(this.browser);
        }
    }

    private class BeforeOpen
    implements Runnable {
        private RObjectBrowser browser;

        public BeforeOpen(RObjectBrowser rObjectBrowser) {
            this.browser = rObjectBrowser;
        }

        @Override
        public void run() {
            this.browser.weakSelectCurrentPath();
            RObjectExplorer.this.dispatchItemSelectionEvent(this.browser);
        }
    }
}

