/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.object;

import com.ef_prime.rflow.core.app.r.base.RInterface;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.ui.app.r.object.RObjectFlavor;
import com.ef_prime.rflow.ui.app.r.object.RObjectViewer;
import com.ef_prime.rflow.ui.common.item.AbstractItem;
import com.ef_prime.rflow.ui.common.view.View;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class RObjectTransferable
extends AbstractItem {
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{RObjectFlavor.getInstance(), DataFlavor.stringFlavor, RObjectFlavor.getFullPathFlavor()};
    private RInterface r;
    private List<RObject> objects;
    private boolean fullPath;

    public RObjectTransferable(RInterface rInterface, RObject[] rObjectArray) {
        this(rInterface, rObjectArray, false);
    }

    public RObjectTransferable(RInterface rInterface, RObject[] rObjectArray, boolean bl) {
        this.r = rInterface;
        this.objects = new ArrayList<RObject>();
        for (int i = 0; i < rObjectArray.length; ++i) {
            this.objects.add(rObjectArray[i]);
        }
        this.fullPath = bl;
        this.init();
    }

    public RObjectTransferable(RInterface rInterface, Collection<RObject> collection) {
        this(rInterface, collection, false);
    }

    public RObjectTransferable(RInterface rInterface, Collection<RObject> collection, boolean bl) {
        this.r = rInterface;
        this.objects = Collections.unmodifiableList(new ArrayList<RObject>(collection));
        this.fullPath = bl;
        this.init();
    }

    private void init() {
        this.setName(this.objects.stream().map(rObject -> rObject.getName(false)).collect(Collectors.joining(", ")));
    }

    public List<RObject> getObjects() {
        return this.objects;
    }

    public boolean isFullPath() {
        return this.fullPath;
    }

    private List<String> getNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.objects.size());
        for (RObject rObject : this.objects) {
            if (this.fullPath) {
                arrayList.add(rObject.getFullName());
                continue;
            }
            arrayList.add(rObject.getName(false));
        }
        return arrayList;
    }

    private String getNewlineSeparatedNames() {
        return StringUtils.join(this.getNames(), (char)'\n');
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (RObjectFlavor.getInstance().equals(dataFlavor)) {
            return this.objects;
        }
        if (RObjectFlavor.getFullPathFlavor().equals(dataFlavor)) {
            return this.fullPath;
        }
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            return this.getNewlineSeparatedNames();
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (int i = 0; i < FLAVORS.length; ++i) {
            if (!dataFlavor.equals(FLAVORS[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public View createPreviewView() {
        RObjectViewer rObjectViewer = RObjectViewer.create(this.r, this.objects);
        rObjectViewer.setAutoRefresh(false);
        return rObjectViewer;
    }
}

