/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.object;

import com.ef_prime.rflow.core.app.r.base.RInterface;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RObjectViewerSessionEntry;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.base.SessionEntry;
import com.ef_prime.rflow.core.base.SessionEntrySupplier;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.node.ui.OpManager;
import com.ef_prime.rflow.node.ui.OpPopupMenu;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.object.RObjectBrowser;
import com.ef_prime.rflow.ui.app.r.object.RObjectTransferable;
import com.ef_prime.rflow.ui.app.r.object.RObjectView;
import com.ef_prime.rflow.ui.app.r.object.RObjectViewMap;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.MenuActionProvider;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.ViewSwitchPanel;
import com.ef_prime.rflow.ui.common.item.ItemEvent;
import com.ef_prime.rflow.ui.common.item.ItemEventHandler;
import com.ef_prime.rflow.ui.common.view.View;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ArrayUtils;

public class RObjectViewer
extends View
implements ItemEventHandler,
MenuActionProvider,
SessionEntrySupplier {
    private static final Logger LOGGER = Logger.getLogger(RObjectViewer.class.getName());
    private RObjectViewMap classToViewMap;
    private RInterface r;
    private RObject lastRObject;
    private RObject rObject;
    private List<RObject> rObjects;
    private View view;
    private List<RObjectView> views = new ArrayList<RObjectView>();
    private UINodeAction nodeAction = new UINodeAction();
    private boolean actionButton = true;
    private boolean autoRefresh = true;
    private RObjectBrowser browser;

    public static RObject convertObject(List<RObject> list) {
        RObject rObject;
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() > 1 && (rObject = list.get(0).getParent()) != null && (rObject.inherits("data.frame") || rObject.inherits("matrix"))) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (RObject rObject2 : list) {
                if (rObject2.getParent() != rObject) {
                    arrayList = null;
                    break;
                }
                arrayList.add(rObject2.getName(false));
            }
            if (arrayList != null) {
                return RObject.builder(rObject.getFullName() + "[, " + RUtility.combineCharacters(arrayList) + ", drop = FALSE]").setType(rObject.getType()).setClasses(rObject.getClasses()).setNewClasses(rObject.getNewClasses()).setFlag(rObject.getFlag()).setDim(rObject.getDim()[0], arrayList.size()).setTip(rObject.getTip()).setValidName(rObject.isValidName()).build();
            }
        }
        return null;
    }

    public static boolean isViewable(List<RObject> list) {
        if (list == null || list.size() == 0) {
            return false;
        }
        if (list.size() == 1) {
            return true;
        }
        return RObjectViewer.convertObject(list) != null;
    }

    public static RObjectViewer create(RInterface rInterface, List<RObject> list) {
        RObject rObject = RObjectViewer.convertObject(list);
        if (rObject == null) {
            return null;
        }
        return new RObjectViewer(rInterface, rObject, list);
    }

    public RObjectViewer(RInterface rInterface, RObject rObject) {
        this.r = rInterface;
        this.classToViewMap = RObjectViewMap.getInstance();
        if (rObject != null) {
            this.setRObject(rObject);
        }
    }

    public RObjectViewer(RInterface rInterface, RObject rObject, List<RObject> list) {
        this(rInterface, rObject);
        this.rObjects = list;
    }

    public void setActionButton(boolean bl) {
        this.actionButton = bl;
    }

    public boolean isActionButton() {
        return this.actionButton;
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        super.viewDidBecomeDisplayable();
        this.r.client().addItemEventHandler(this);
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        this.r.client().removeItemEventHandler(this);
        this.saveSessionEntryToHistory();
        for (RObjectView rObjectView : this.views) {
            rObjectView.unload();
        }
    }

    @Override
    public boolean canRefreshView() {
        return true;
    }

    @Override
    public void refreshView() {
        this.setRObject(null);
    }

    public void setBrowser(RObjectBrowser rObjectBrowser) {
        this.browser = rObjectBrowser;
    }

    public void setRObject(RObject rObject) {
        if (rObject == null) {
            View view2;
            if (this.rObject == null) {
                return;
            }
            rObject = this.r.client().updateObject(this.rObject);
            if (rObject == null && (view2 = this.getRootView()) != null && view2.isClosable()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RObjectViewer.this.closeTab();
                    }
                });
                return;
            }
        }
        if (this.rObject != null && rObject != null && this.rObject.pointerEquals(rObject) && !this.rObject.is("refObject")) {
            return;
        }
        this.lastRObject = this.rObject;
        this.rObject = rObject;
        this.refresh();
    }

    public void clearView() {
        this.rObject = null;
        this.refresh();
    }

    protected boolean isViewable(Class<? extends RObjectView> clazz, RObject rObject) {
        try {
            Method method = clazz.getMethod("isViewable", RObject.class);
            return (Boolean)method.invoke(null, rObject);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            return false;
        }
    }

    @Override
    protected Object refreshWork() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        RObject rObject = this.rObject;
        if (rObject != null) {
            this.r.client().removeNewItem(rObject.getFullName(true));
            List<Class<? extends RObjectView>> list = this.classToViewMap.get(rObject);
            ArrayList<RObjectView> arrayList2 = new ArrayList<RObjectView>(this.views);
            block0: for (Class<? extends RObjectView> serializable : list) {
                if (!this.isViewable(serializable, rObject)) continue;
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    RObjectView rObjectView = (RObjectView)iterator.next();
                    if (!serializable.equals(rObjectView.getClass())) continue;
                    iterator.remove();
                    arrayList.add(rObjectView);
                    continue block0;
                }
                arrayList.add(serializable);
            }
            for (RObjectView rObjectView : arrayList2) {
                rObjectView.unload();
            }
        } else {
            for (RObjectView rObjectView : this.views) {
                rObjectView.unload();
            }
        }
        arrayList.add(rObject);
        return arrayList;
    }

    @Override
    protected void refreshWorkDone(Object object) {
        List list = (List)Utility.cast(object);
        RObject rObject = (RObject)list.remove(list.size() - 1);
        this.views.clear();
        for (Object object2 : list) {
            if (object2 instanceof RObjectView) {
                ((RObjectView)object2).startMoving();
                this.views.add((RObjectView)object2);
                continue;
            }
            if (!(object2 instanceof Class)) continue;
            try {
                Class clazz = (Class)Utility.cast(object2);
                this.views.add((RObjectView)clazz.getConstructor(RInterface.class, RObjectBrowser.class).newInstance(this.r, this.browser));
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        if (this.views.isEmpty()) {
            this.view = null;
        } else {
            boolean bl = this.lastRObject != null && rObject != null && (this.lastRObject.isInPreviewEnv() ^ rObject.isInPreviewEnv() && this.lastRObject.getName(false).equals(rObject.getName(false)) || this.lastRObject.getFullName().equals(rObject.getFullName())) && ArrayUtils.isEquals((Object)this.lastRObject.getClasses(), (Object)rObject.getClasses());
            ViewSwitchPanel viewSwitchPanel = new ViewSwitchPanel();
            int n = 0;
            for (int i = 0; i < this.views.size(); ++i) {
                RObjectView rObjectView = this.views.get(i);
                if (bl && rObjectView.isDisplayable()) {
                    n = i;
                }
                viewSwitchPanel.addView(rObjectView);
            }
            viewSwitchPanel.setSelectedIndex(n);
            if (this.isActionButton()) {
                viewSwitchPanel.addToToolBar(this.nodeAction);
            }
            this.view = viewSwitchPanel;
        }
        this.removeAll();
        if (this.view != null) {
            this.add((Component)this.view, "Center");
        }
        this.revalidate();
        this.repaint();
        for (RObjectView rObjectView : this.views) {
            rObjectView.endMoving();
        }
        if (rObject != null) {
            for (RObjectView rObjectView : this.views) {
                rObjectView.setRObject(rObject);
            }
        }
    }

    public RObject getRObject() {
        return this.rObject;
    }

    @Override
    public Object getKey() {
        return this.rObject == null ? this : this.rObject.getFullName();
    }

    @Override
    public boolean isClosable() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.rObject == null ? "" : this.rObject.getDisplayTitle();
    }

    @Override
    public void itemChanged(ItemEvent itemEvent) {
        if (this.autoRefresh) {
            switch (itemEvent.getType()) {
                case 1: 
                case 2: {
                    this.refreshView();
                    break;
                }
            }
        }
    }

    @Override
    public Action getAction(String string) {
        if ("MENU_ACTION_FIND".equals(string)) {
            for (RObjectView rObjectView : this.views) {
                if (!rObjectView.isShowing() || !(rObjectView instanceof MenuActionProvider)) continue;
                return ((MenuActionProvider)((Object)rObjectView)).getAction(string);
            }
        }
        return null;
    }

    @Override
    public SessionEntry getSessionEntry(boolean bl) {
        if (this.rObject == null || !bl) {
            return null;
        }
        return new RObjectViewerSessionEntry(this.rObject, this.getViewPosition(), this.isShowing(), this.getIcon());
    }

    private class UINodeAction
    extends LoggableAction {
        public UINodeAction() {
            this.putValue("Name", Messages.getString("Action.op"));
            this.putValue("SmallIcon", Icons.getIcon("16/toolbar_go.png"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            RObjectTransferable rObjectTransferable = RObjectViewer.this.rObjects != null ? new RObjectTransferable(RObjectViewer.this.r, RObjectViewer.this.rObjects) : new RObjectTransferable(RObjectViewer.this.r, new RObject[]{RObjectViewer.this.getRObject()});
            JPopupMenu jPopupMenu = OpPopupMenu.createPopupMenu(OpManager.getInstance().getCurrentTreeNode(), rObjectTransferable, true);
            Component component = (Component)actionEvent.getSource();
            jPopupMenu.show(component, 0, component.getHeight());
        }
    }
}

