/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.object;

import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.object.RObjectsBuilder;
import com.ef_prime.rflow.ui.app.r.object.RObjectsClassifier;
import com.ef_prime.rflow.ui.app.r.object.RObjectsFactoryEvent;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import com.ef_prime.rflow.ui.common.event.SimpleEventHandler;
import java.util.ArrayList;
import java.util.List;

public class RObjectsFactory {
    private List<RObjectsBuilder> builders = new ArrayList<RObjectsBuilder>(2);
    private List<RObjectsClassifier> classifiers;
    private RObjectsClassifier otherClassifier;
    private EventSupport<RObjectsFactoryEvent, SimpleEventHandler> eventSupport = new EventSupport();
    private static final RObjectsFactory instance = new RObjectsFactory();

    private RObjectsFactory() {
        this.classifiers = new ArrayList<RObjectsClassifier>(5);
        RObjectsClassifier rObjectsClassifier = new RObjectsClassifier(){

            @Override
            public String getName() {
                return Messages.getString("View.object_browser.data_frame");
            }

            @Override
            public boolean accept(RObject rObject) {
                return rObject.inherits("data.frame");
            }
        };
        RObjectsClassifier rObjectsClassifier2 = new RObjectsClassifier(){

            @Override
            public String getName() {
                return Messages.getString("View.object_browser.function");
            }

            @Override
            public boolean accept(RObject rObject) {
                return rObject.getClas().equals("function");
            }
        };
        this.otherClassifier = new RObjectsClassifier(){

            @Override
            public String getName() {
                return Messages.getString("View.object_browser.other");
            }

            @Override
            public boolean accept(RObject rObject) {
                return true;
            }
        };
        this.classifiers.add(rObjectsClassifier);
        this.classifiers.add(rObjectsClassifier2);
        this.classifiers.add(this.otherClassifier);
    }

    public static RObjectsFactory getInstance() {
        return instance;
    }

    public void addBuilder(RObjectsBuilder rObjectsBuilder) {
        if (!this.builders.contains(rObjectsBuilder)) {
            this.builders.add(rObjectsBuilder);
        }
    }

    public void removeBuilder(RObjectsBuilder rObjectsBuilder) {
        this.builders.remove(rObjectsBuilder);
    }

    public List<RObjectsBuilder> getBuilders() {
        return this.builders;
    }

    public List<RObjectsClassifier> getClassifiers() {
        return this.classifiers;
    }

    public RObjectsClassifier getOtherClassifier() {
        return this.otherClassifier;
    }

    public void addClassifier(int n, RObjectsClassifier rObjectsClassifier) {
        if (!this.classifiers.contains(rObjectsClassifier)) {
            this.classifiers.add(n, rObjectsClassifier);
            this.eventSupport.dispatchEvent(new RObjectsFactoryEvent());
        }
    }

    public void removeClassifier(RObjectsClassifier rObjectsClassifier) {
        this.classifiers.remove(rObjectsClassifier);
        this.eventSupport.dispatchEvent(new RObjectsFactoryEvent());
    }

    public void addEventHandler(SimpleEventHandler simpleEventHandler) {
        this.eventSupport.addEventHandler(simpleEventHandler);
    }

    public void removeEventHandler(SimpleEventHandler simpleEventHandler) {
        this.eventSupport.removeEventHandler(simpleEventHandler);
    }
}

