/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.object;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.RInterface;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.console.BasicCommand;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandListener;
import com.ef_prime.rflow.core.util.ArgsList;
import com.ef_prime.rflow.ui.app.r.RflowGDView;
import com.ef_prime.rflow.ui.app.r.gd.GD;
import com.ef_prime.rflow.ui.app.r.gd.GDHandler;
import com.ef_prime.rflow.ui.app.r.gd.GDView;
import com.ef_prime.rflow.ui.app.r.object.RObjectBrowser;
import com.ef_prime.rflow.ui.app.r.object.RObjectView;
import com.ef_prime.rflow.ui.common.component.Refreshable;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Component;
import java.awt.Dimension;

public class RPlotObjectView
extends RObjectView {
    private PlotHandler plotHandler;

    public RPlotObjectView(RInterface rInterface, RObjectBrowser rObjectBrowser) {
        super(rInterface, rObjectBrowser);
        this.setTitle("plot");
        this.plotHandler = new PlotHandler();
    }

    public static boolean isViewable(RObject rObject) {
        return !rObject.getName(false).endsWith("more objects");
    }

    @Override
    protected void loadContent() {
    }

    @Override
    protected Object refreshWork() throws Exception {
        Object object;
        if (this.getRObject() == null) {
            return null;
        }
        String string = this.getPlotRScript();
        ArgsList argsList = new ArgsList();
        argsList.add("", "{" + string + "}");
        if (this.plotHandler.gdView != null) {
            object = this.plotHandler.gdView.getCanvasSize();
            argsList.add("width", Integer.toString(((Dimension)object).width));
            argsList.add("height", Integer.toString(((Dimension)object).height));
        }
        object = RUtility.function(".backgroundPlot", argsList);
        object = this.r.client().noDebug((String)object);
        BasicCommand basicCommand = new BasicCommand((String)object);
        basicCommand.addCommandListener(this.plotHandler);
        basicCommand.setCheckError(true);
        basicCommand.setNoRecover(true);
        if (!Rflow.isDevel() || !Rflow.getInstance().getDevelSettings().isOutputPreviewCode()) {
            basicCommand.setCaptureOutput(true);
        }
        this.r.receiver().passCommand(basicCommand);
        return super.refreshWork();
    }

    protected String getPlotRScript() {
        return "plot(" + this.getRObject().getFullName() + ")";
    }

    protected void resized() {
        this.refresh();
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        this.plotHandler.unloadGDView();
    }

    private class PlotHandler
    implements CommandListener,
    GDHandler,
    Refreshable {
        private GDView gdView;

        private PlotHandler() {
        }

        private void unloadGDView() {
            if (this.gdView != null) {
                this.gdView.unloadView();
            }
        }

        @Override
        public GDView openGraphicDevice(RInterface rInterface, int n, int n2) {
            if (this.gdView == null) {
                this.gdView = new RflowGDView(rInterface, new Dimension(n, n2), true);
                this.gdView.setRefreshable(this);
                this.gdView.setCloseParentView(false);
                this.gdView.loadView();
                RPlotObjectView.this.add((Component)this.gdView, "Center");
                RPlotObjectView.this.revalidate();
            } else {
                this.gdView.loadView();
            }
            return this.gdView;
        }

        @Override
        public void commandStart(Command command) {
            GD.addGDHandler(this);
        }

        @Override
        public void commandFinished(Command command) {
            GD.removeGDHandler(this);
            UIUtility.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlotHandler.this.unloadGDView();
                }
            });
        }

        @Override
        public void commandCanceled(Command command) {
        }

        @Override
        public void errorOccurred(Command command) {
        }

        @Override
        public void commandDiscarded(Command command) {
        }

        @Override
        public void refresh() {
            RPlotObjectView.this.resized();
        }
    }
}

