/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.object;

import com.ef_prime.rflow.core.app.r.base.RInterface;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.ui.app.r.object.RFunctionObjectView;
import com.ef_prime.rflow.ui.app.r.object.RObjectBrowser;
import com.ef_prime.rflow.ui.app.r.object.RObjectView;
import com.ef_prime.rflow.ui.app.r.object.RPrintToPlotObjectView;
import com.ef_prime.rflow.ui.base.UIColor;
import com.ef_prime.rflow.ui.util.FontSupport;
import java.awt.BorderLayout;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;

public class RPrintObjectView
extends RObjectView {
    private JTextArea textPane;

    public static boolean isViewable(RObject rObject) {
        if (rObject.getName(false).endsWith("more objects")) {
            return false;
        }
        return !RFunctionObjectView.isViewable(rObject) && !RPrintToPlotObjectView.isViewable(rObject);
    }

    public RPrintObjectView(RInterface rInterface, RObjectBrowser rObjectBrowser) {
        super(rInterface, rObjectBrowser);
        this.setTitle("print");
    }

    @Override
    protected void loadContent() {
        this.textPane = new JTextArea();
        this.textPane.setFont(FontSupport.getCodeFont());
        this.textPane.setEditable(false);
        this.textPane.setLineWrap(false);
        this.textPane.setBackground(UIColor.UNEDITABLE_BACKGROUND);
        JScrollPane jScrollPane = new JScrollPane(this.textPane);
        this.setLayout(new BorderLayout());
        this.add(jScrollPane);
    }

    @Override
    protected SwingWorker<?, String> createRefreshWorker() {
        return new RPrintWorker();
    }

    protected String getScript() {
        ScriptBuilder scriptBuilder = new ScriptBuilder("\n");
        scriptBuilder.appendLn("(function(x){");
        scriptBuilder.appendLn("old <- getOption(\"max.print\")");
        scriptBuilder.appendLn("on.exit(options(max.print = old))");
        scriptBuilder.appendLn("options(max.print=1000)");
        scriptBuilder.appendLn("print(x)");
        scriptBuilder.appendLn("invisible()");
        scriptBuilder.appendLn("})(" + this.getRObject().getFullName() + ")");
        return scriptBuilder.toString();
    }

    private class RPrintWorker
    extends SwingWorker<String, String> {
        private RPrintWorker() {
        }

        @Override
        protected String doInBackground() throws Exception {
            Callable<String> callable = new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return RPrintObjectView.this.r.client().captureOutput(RPrintObjectView.this.getScript());
                }
            };
            FutureTask<String> futureTask = new FutureTask<String>(callable);
            RPrintObjectView.this.r.queryQueue().addQuery(futureTask);
            return futureTask.get();
        }

        @Override
        protected void done() {
            try {
                String string = (String)this.get();
                if (string != null) {
                    RPrintObjectView.this.textPane.setText(string);
                    RPrintObjectView.this.textPane.setCaretPosition(0);
                } else {
                    RPrintObjectView.this.textPane.setText("");
                }
            }
            catch (Exception exception) {
                RPrintObjectView.this.textPane.setText("");
            }
        }
    }
}

