/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.object;

import com.ef_prime.rflow.core.app.r.base.RInterface;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.ui.app.r.object.RObjectBrowser;
import com.ef_prime.rflow.ui.app.r.object.RObjectView;
import com.ef_prime.rflow.ui.app.r.object.RObjectViewer;
import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.util.ArrayList;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class RTreeObjectView
extends RObjectView {
    private RObjectBrowser objectBrowser;
    private RObjectViewer objectView;

    public static boolean isViewable(RObject rObject) {
        return rObject.getType().equals("list") || rObject.getType().equals("environment");
    }

    public RTreeObjectView(RInterface rInterface, RObjectBrowser rObjectBrowser) {
        super(rInterface, rObjectBrowser);
        this.setTitle("List");
    }

    @Override
    protected void loadContent() {
        this.objectBrowser = new ObjectBrowserForList();
        this.objectView = new RObjectViewerForList(this.r);
        this.objectView.setBrowser(this.objectBrowser);
        JSplitPane jSplitPane = new JSplitPane(1, this.objectBrowser, this.objectView);
        this.setLayout(new BorderLayout());
        this.add(jSplitPane);
        jSplitPane.setDividerLocation(250);
    }

    @Override
    protected void refreshWorkDone(Object object) {
        this.objectBrowser.setTopObject(this.getRObject());
        this.objectBrowser.setTopName(this.getRObject().getName(false));
        this.objectBrowser.update(false);
    }

    private class ObjectBrowserForList
    extends RObjectBrowser
    implements TreeSelectionListener {
        public ObjectBrowserForList() {
            super("", null, false);
            this.tree.setToggleClickCount(2);
            this.tree.getSelectionModel().addTreeSelectionListener(this);
        }

        @Override
        protected void updateFinished() {
            this.selectionChanged();
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            this.selectionChanged();
        }

        private void selectionChanged() {
            if (!this.isRefreshing() && !this.isWeakSelection()) {
                RObject rObject;
                ArrayList arrayList = this.getSelectedObjects(true);
                if (arrayList.isEmpty() && (rObject = this.getWeakSelection()) != null) {
                    arrayList = Lists.newArrayList((Object[])new RObject[]{rObject});
                }
                if (arrayList.isEmpty()) {
                    RTreeObjectView.this.objectView.clearView();
                } else {
                    RTreeObjectView.this.objectView.setRObject(RObjectViewer.convertObject(arrayList));
                }
            }
        }
    }

    protected static class RObjectViewerForList
    extends RObjectViewer {
        public RObjectViewerForList(RInterface rInterface) {
            super(rInterface, null);
            this.setAutoRefresh(false);
        }

        @Override
        protected boolean isViewable(Class<? extends RObjectView> clazz, RObject rObject) {
            if (clazz.equals(RTreeObjectView.class)) {
                return false;
            }
            return super.isViewable(clazz, rObject);
        }
    }
}

