/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.packages;

import com.ef_prime.rflow.core.app.r.base.RSupport;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TableKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.component.BusyLayerUI;
import com.ef_prime.rflow.ui.common.keyvalue.Widget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.view.View;
import java.awt.BorderLayout;
import java.util.List;
import javax.swing.JLayer;
import org.apache.commons.lang3.ArrayUtils;

public class RCRANMirrorsView
extends View {
    private static final StrKey COL_NAME = StrKey.builder("name", Messages.getString("Setting.cran_mirrors_name")).build();
    private static final StrKey COL_URL = StrKey.builder("url", "URL").build();
    private static final TableKey KEY_MIRRORS = ((TableKey.Builder)((TableKey.Builder)((Key.Builder)((TableKey.Builder)TableKey.builder("mirrors", "", COL_NAME, COL_URL).setEditable(false)).setSelectionMode(1)).setLabelPosition("none")).setUnboundTableArea(false)).build();
    private String originalSelection;
    private String rHome;
    private ValueMap viewModel;
    private BusyLayerUI<Widget> busyLayer;
    private Widget widget;

    public RCRANMirrorsView(String string, String string2) {
        this.originalSelection = string;
        this.rHome = string2;
        this.setTitle(Messages.getString("Setting.cran_mirrors"));
        this.viewModel = new ValueMap();
        this.viewModel.putValueQuietly(KEY_MIRRORS, null);
        this.widget = (Widget)WidgetFactory.getInstance().create(this.viewModel);
        this.busyLayer = new BusyLayerUI();
        this.setLayout(new BorderLayout());
        this.add(new JLayer<Widget>(this.widget, this.busyLayer));
        this.refresh();
    }

    public String getSelectedUrl() {
        KeysTableModel keysTableModel = this.viewModel.getValue(KEY_MIRRORS);
        int[] nArray = keysTableModel.getSelectedRows();
        if (ArrayUtils.isEmpty((int[])nArray)) {
            return null;
        }
        return (String)keysTableModel.getValueAt(nArray[0], COL_URL);
    }

    @Override
    public void busyStatedChanged(boolean bl) {
        if (bl) {
            this.busyLayer.start();
        } else {
            this.busyLayer.stop();
        }
    }

    @Override
    protected Object refreshWork() throws Exception {
        return RSupport.getCranMirrors(this.rHome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refreshWorkDone(Object object) {
        List list = (List)object;
        KeysTableModel keysTableModel = this.viewModel.getValue(KEY_MIRRORS);
        keysTableModel.beginValueChange();
        try {
            keysTableModel.removeAllRows();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    String[] stringArray = (String[])list.get(i);
                    keysTableModel.addNewRow(stringArray[0], stringArray[1]);
                    if (!this.originalSelection.equals(stringArray[1])) continue;
                    keysTableModel.setSelectedRows(new int[]{i});
                }
            }
        }
        finally {
            keysTableModel.endValueChange();
            this.widget.updateWidgetValue();
        }
    }
}

