/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.packages;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.console.BasicCommand;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandAdapter;
import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceProvider;
import com.ef_prime.rflow.core.common.keyvalue.FileKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.keyvalue.TableKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.component.BusyLayerUI;
import com.ef_prime.rflow.ui.common.keyvalue.Widget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.view.Page;
import com.ef_prime.rflow.ui.common.view.PagesView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JLayer;
import org.apache.commons.io.FilenameUtils;

public class RPackageInstallView
extends PagesView {
    private static final String INST_FROM_REPOSITORY = "repository";
    private static final String INST_FROM_LOCAL_FILE = "local_file";
    private static final RadioButtonKey INSTALL_FROM = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("install_from", "").setValuesAndLabels("repository", Messages.getString("View.PackageInstaller.repository"), "local_file", Messages.getString("View.PackageInstaller.local_file"))).noLabel()).build();
    private static final ChoiceKey PACKAGE = ((ChoiceKey.Builder)((ChoiceKey.Builder)ChoiceKey.builder("package", "").setChoiceProvider(new PackagesChoiceProvider())).setChoiceEditable(true)).build();
    private static final TableKey PACKAGES = ((TableKey.Builder)((Key.Builder)((TableKey.Builder)TableKey.builder("packages", Messages.getString("View.PackageInstaller.packages"), PACKAGE).setUiControls(new int[]{0, 1})).setDefaultRowPredicate()).addVisibleKeyLink(INSTALL_FROM, "repository")).build();
    private static final FileKey FILE = ((FileKey.Builder)((FileKey.Builder)FileKey.builder("file", "").addVisibleKeyLink(INSTALL_FROM, "local_file")).addExtensionFilters(new FileKey.FileExtensionFilter(Messages.getString("View.PackageInstaller.r_package_archive") + " (*.zip, *.tgz, *.tar.gz, *.tar.bz2, *.tar.xz)", "zip", "tgz", "tar.gz", "tar.bz2", "tar.xz"))).build();
    private static final TableKey FILES = ((TableKey.Builder)((TableKey.Builder)((Key.Builder)((TableKey.Builder)TableKey.builder("files", Messages.getString("View.PackageInstaller.files"), FILE).setUiControls(new int[]{1})).setDefaultRowPredicate()).addVisibleKeyLink(INSTALL_FROM, "local_file")).setColumnWidth(0, 800)).build();
    private static final ChoiceKey INSTALL_TO = ((ChoiceKey.Builder)ChoiceKey.builder("install_to", Messages.getString("View.PackageInstaller.install_to")).setChoiceProvider(new LibPathsChoiceProvider())).build();
    private ViewModel vm = new ViewModel();

    public RPackageInstallView() {
        this.setPage(new InstallPage());
    }

    public static void show(Window window) {
        RPackageInstallView rPackageInstallView = new RPackageInstallView();
        rPackageInstallView.showDialog(window, Messages.getString("Action.install_r_packages"), false, new Dimension(400, 400));
    }

    private boolean install() {
        Object object;
        List<String> list;
        String string3 = this.vm.getValue(INSTALL_TO);
        String string4 = string3.isEmpty() ? "" : RUtility.quote(string3);
        String string5 = null;
        List<String> list2 = null;
        if (this.vm.getValue(INSTALL_FROM).equals(INST_FROM_REPOSITORY)) {
            list2 = this.vm.getValue(PACKAGES).getValidValues(PACKAGE);
            string5 = RUtility.function("install.packages", "pkgs", RUtility.combineCharacters(list2), "lib", string4);
        } else {
            list = this.vm.getValue(FILES).getValidValues(FILE);
            list2 = list.stream().map(string -> {
                String string2 = FilenameUtils.getName((String)string);
                int n = string2.indexOf(95);
                if (n >= 0) {
                    string2 = string2.substring(0, n);
                }
                return string2;
            }).collect(Collectors.toList());
            if (list.size() == 1) {
                string5 = RUtility.function("install.packages", "pkgs", RUtility.quotedPath(list.get(0)), "lib", string4, "repos", "NULL");
            } else {
                object = R.client().getPkgType();
                String string6 = null;
                if (((Optional)object).isPresent()) {
                    if (((Optional)object).get().equals("win.binary")) {
                        string6 = ".zip";
                    } else if (((Optional)object).get().startsWith("mac.binary")) {
                        string6 = ".tgz";
                    }
                }
                String string7 = string6;
                List<String> list3 = list.stream().filter(string2 -> string2.endsWith(string7)).collect(Collectors.toList());
                if (!list3.isEmpty()) {
                    list.removeAll(list3);
                    list3 = list3.stream().map(RUtility::quotedPath).collect(Collectors.toList());
                    string5 = RUtility.function("install.packages", "pkgs", RUtility.combine(list3), "lib", string4, "repos", "NULL", "type", RUtility.quote((String)((Optional)object).get()));
                }
                if (!list.isEmpty()) {
                    list = list.stream().map(RUtility::quotedPath).collect(Collectors.toList());
                    if (string5 != null) {
                        R.receiver().passCommand(string5);
                    }
                    string5 = RUtility.function("install.packages", "pkgs", RUtility.combine(list), "lib", string4, "repos", "NULL", "type", RUtility.quote("source"));
                }
            }
        }
        list = new BasicCommand(string5);
        object = list2;
        if (object != null) {
            ((Command)((Object)list)).addCommandListener(new CommandAdapter((List)object, string4){
                final /* synthetic */ List val$pkgNames;
                final /* synthetic */ String val$lib;
                {
                    this.val$pkgNames = list;
                    this.val$lib = string;
                }

                @Override
                public void commandFinished(Command command) {
                    Rflow.mainView().getRPackagesView().packagesInstalled(this.val$pkgNames, this.val$lib);
                }
            });
        }
        R.receiver().passCommand((Command)((Object)list));
        return true;
    }

    @Override
    protected boolean viewWillClose(int n) {
        if (n == 1) {
            return this.install();
        }
        return super.viewWillClose(n);
    }

    @Override
    protected String getFinishButtonTitle() {
        return Messages.getString("Action.install");
    }

    private class ViewModel
    extends ValueMap {
        public ViewModel() {
            this.registerKeys(INSTALL_FROM, PACKAGES, FILES, INSTALL_TO);
        }
    }

    private class InstallPage
    extends Page
    implements ValueChangeEventHandler,
    ComponentListener {
        private BusyLayerUI<Component> busyLayer;
        private Component widget;

        public InstallPage() {
            this.widget = WidgetFactory.getInstance().create(RPackageInstallView.this.vm);
            this.widget.setVisible(false);
            this.busyLayer = new BusyLayerUI();
            this.add(new JLayer<Component>(this.widget, this.busyLayer));
            RPackageInstallView.this.vm.addEventHandler(this);
            this.refresh();
            this.widget.addComponentListener(this);
        }

        @Override
        public void busyStatedChanged(boolean bl) {
            if (bl) {
                this.busyLayer.start();
            } else {
                this.busyLayer.stop();
            }
        }

        @Override
        protected Object refreshWork() throws Exception {
            PACKAGE.getChoices(RPackageInstallView.this.vm);
            INSTALL_TO.getChoices(RPackageInstallView.this.vm);
            return null;
        }

        @Override
        protected void refreshWorkDone(Object object) {
            this.widget.setVisible(true);
        }

        @Override
        public boolean canGoNext() {
            if (RPackageInstallView.this.vm.getValue(INSTALL_FROM).equals(RPackageInstallView.INST_FROM_REPOSITORY)) {
                return RPackageInstallView.this.vm.getValue(PACKAGES).validRows().size() > 0;
            }
            return !FILES.isValueEmpty(RPackageInstallView.this.vm.getValue(FILES));
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            if (PACKAGES.equals(valueChangeEvent.getKey()) || FILES.equals(valueChangeEvent.getKey())) {
                this.dispatchPageEvent(0);
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            ((Widget)this.widget).startEditing();
            this.widget.removeComponentListener(this);
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }
    }

    private static class PackagesChoiceProvider
    implements ChoiceProvider {
        private List<Choice> choices;

        private PackagesChoiceProvider() {
        }

        @Override
        public List<Choice> getChoices(ValueMap valueMap) {
            List<String> list;
            if (!(this.choices != null && this.choices.isEmpty() || (list = R.client().getAvailablePackages()) == null || list.isEmpty())) {
                this.choices = new ArrayList<Choice>(list.size());
                for (String string : list) {
                    if (string == null) continue;
                    this.choices.add(new Choice(string));
                }
            }
            return this.choices;
        }
    }

    private static class LibPathsChoiceProvider
    implements ChoiceProvider {
        private List<Choice> choices;

        private LibPathsChoiceProvider() {
        }

        @Override
        public List<Choice> getChoices(ValueMap valueMap) {
            String[] stringArray;
            if (this.choices == null && (stringArray = RClient.rexpToStrings(R.client().silentTimeoutEvalGet(".libPaths()"), null, null)) != null) {
                this.choices = new ArrayList<Choice>(stringArray.length);
                for (String string : stringArray) {
                    if (string == null || !Files.isWritable(Paths.get(string, new String[0]))) continue;
                    this.choices.add(new Choice(string));
                }
                if (this.choices.isEmpty()) {
                    this.choices.add(new Choice("", Messages.getString("View.PackageInstaller.default")));
                }
            }
            return this.choices;
        }

        @Override
        public boolean isLabel() {
            return true;
        }
    }
}

