/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.packages;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RPackageManager;
import com.ef_prime.rflow.core.common.keyvalue.KeyWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TableKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.packages.RPackageInstallView;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.BusyLayerUI;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.keyvalue.TableKeyWidget;
import com.ef_prime.rflow.ui.common.keyvalue.Widget;
import com.ef_prime.rflow.ui.common.table.GeneralTable;
import com.ef_prime.rflow.ui.common.table.UIGeneralTableModel;
import com.ef_prime.rflow.ui.common.view.LazyLoadView;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.google.common.collect.Lists;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JLayer;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;

public class RPackagesView
extends LazyLoadView
implements RPackageManager.RPackageManagerEventHandler {
    private PackagesTableKeyWidget widget;
    private BusyLayerUI<Widget> busyLayer;

    public RPackagesView() {
        this.setTitle(Messages.getString("R.Packages.title"));
        this.setIcon(Icons.getIcon("16/box_front.png"));
        this.setIconOnly(true);
    }

    @Override
    protected void loadContent() {
        PackagesActions packagesActions = new PackagesActions();
        packagesActions.installActions(this, false, 1);
        this.widget = new PackagesTableKeyWidget(R.packageManager(), new KeyWidgetNode(RPackageManager.PACKAGES));
        this.widget.getTable().addRowSelectionListener(packagesActions);
        this.busyLayer = new BusyLayerUI();
        this.add(new JLayer<Widget>(this.widget, this.busyLayer), "Center");
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(RPackagesView.createToolbarButton(packagesActions.get(PackagesActions.Install.class), false));
        jToolBar.add(RPackagesView.createToolbarButton(packagesActions.get(PackagesActions.Refresh.class), true));
        this.add((Component)jToolBar, "North");
        R.packageManager().addRPackageManagerEventHandler(this);
    }

    private static JButton createToolbarButton(Action action, boolean bl) {
        JButton jButton = new JButton(action);
        if (bl) {
            jButton.setHideActionText(true);
            jButton.setToolTipText((String)action.getValue("Name"));
        }
        jButton.setFocusable(false);
        return jButton;
    }

    private PackagesTable getTable() {
        return (PackagesTable)this.widget.getTable();
    }

    public void packagesInstalled(List<String> list, String string) {
        Future<Void> future = R.packageManager().refresh();
        Thread thread = new Thread(() -> {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
            int[] nArray = R.packageManager().getRows(list, string);
            SwingUtilities.invokeLater(() -> this.getTable().selectRows(nArray));
        });
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void handleRPackageManagerEvent(RPackageManager.RPackageManagerEvent rPackageManagerEvent) {
        if (rPackageManagerEvent.getType() == 0) {
            if (R.packageManager().isRefreshing()) {
                this.busyLayer.start();
            } else {
                this.busyLayer.stop();
            }
        }
    }

    private class PackagesActions
    extends Actions
    implements ListSelectionListener {
        public PackagesActions() {
            this.put(new Install());
            this.put(new Refresh());
            this.put(new Help());
            this.put(new Information());
            this.put(new Uninstall());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int[] nArray = RPackagesView.this.getTable().getModelSelectedRows();
            boolean bl = nArray == null || nArray.length == 0;
            boolean bl2 = !bl && nArray.length == 1;
            this.get(Help.class).setEnabled(bl2);
            this.get(Information.class).setEnabled(!bl);
            if (!bl) {
                int[] nArray2 = Arrays.stream(nArray).filter(n -> R.packageManager().isUninstallable(n)).toArray();
                this.get(Uninstall.class).setEnabled(nArray2.length > 0);
            } else {
                this.get(Uninstall.class).setEnabled(false);
            }
        }

        private class Install
        extends LoggableAction {
            public Install() {
                this.putValue("Name", Messages.getString("Action.install"));
                this.putValue("SmallIcon", Icons.getIcon("16/add.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                RPackageInstallView.show(Rflow.mainFrame());
            }
        }

        private class Refresh
        extends LoggableAction {
            public Refresh() {
                this.putValue("Name", Messages.getString("Action.refresh"));
                this.putValue("SmallIcon", Icons.getIcon("16/update.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                R.packageManager().refresh();
            }
        }

        private class Help
        extends LoggableAction {
            public Help() {
                this.putValue("Name", Messages.getString("Action.help"));
                this.putValue("SmallIcon", Icons.getIcon("16/help.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                int[] nArray = RPackagesView.this.getTable().getModelSelectedRows();
                if (nArray == null || nArray.length == 0) {
                    return;
                }
                R.packageManager().showHelp(nArray[0]);
            }
        }

        private class Information
        extends LoggableAction {
            public Information() {
                this.putValue("Name", Messages.getString("View.Package.package_info"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                R.packageManager().showDocuments(RPackagesView.this.getTable().getModelSelectedRows());
            }
        }

        private class Uninstall
        extends LoggableAction {
            public Uninstall() {
                this.putValue("Name", Messages.getString("Action.uninstall"));
                this.putValue("SmallIcon", Icons.getIcon("16/delete.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                int[] nArray = RPackagesView.this.getTable().getModelSelectedRows();
                if (nArray == null || nArray.length == 0) {
                    return;
                }
                if ((nArray = Arrays.stream(nArray).filter(n -> R.packageManager().isUninstallable(n)).toArray()).length == 0) {
                    return;
                }
                if (UIUtility.confirmDelete(Rflow.mainFrame(), nArray.length, R.packageManager().getName(nArray[0]))) {
                    R.packageManager().uninstall(nArray);
                }
            }
        }
    }

    private class PackagesTableKeyWidget
    extends TableKeyWidget {
        public PackagesTableKeyWidget(ValueMap valueMap, WidgetNode widgetNode) {
            super(valueMap, widgetNode);
        }

        @Override
        protected GeneralTable createTable() {
            return new PackagesTable(this.getKey());
        }
    }

    private class PackagesTable
    extends GeneralTable {
        public PackagesTable(TableKey tableKey) {
            super(tableKey);
        }

        @Override
        protected RowSorter<UIGeneralTableModel> createSorter(UIGeneralTableModel uIGeneralTableModel) {
            TableRowSorter<UIGeneralTableModel> tableRowSorter = new TableRowSorter<UIGeneralTableModel>(uIGeneralTableModel);
            tableRowSorter.setMaxSortKeys(1);
            tableRowSorter.setSortKeys(Lists.newArrayList((Object[])new RowSorter.SortKey[]{new RowSorter.SortKey(1, SortOrder.ASCENDING)}));
            return tableRowSorter;
        }

        @Override
        protected void configurePopup(JPopupMenu jPopupMenu) {
            ActionMap actionMap = RPackagesView.this.getActionMap();
            jPopupMenu.add(actionMap.get(PackagesActions.Help.class));
            jPopupMenu.add(actionMap.get(PackagesActions.Information.class));
            jPopupMenu.addSeparator();
            jPopupMenu.add(actionMap.get(PackagesActions.Uninstall.class));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void selectRows(int[] nArray) {
            ListSelectionModel listSelectionModel = this.table.getSelectionModel();
            listSelectionModel.setValueIsAdjusting(true);
            try {
                listSelectionModel.clearSelection();
                for (int i = 0; i < nArray.length; ++i) {
                    int n = this.table.convertRowIndexToView(nArray[i]);
                    listSelectionModel.addSelectionInterval(n, n);
                }
            }
            finally {
                listSelectionModel.setValueIsAdjusting(false);
            }
        }
    }
}

