/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.script;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.RInterface;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.script.RTokenMaker;
import com.ef_prime.rflow.core.base.DevelSettings;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.util.ThreadUtility;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.util.Platform;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.object.RObjectFlavor;
import com.ef_prime.rflow.ui.app.r.object.RObjectViewer;
import com.ef_prime.rflow.ui.app.r.script.PasteSpecial;
import com.ef_prime.rflow.ui.app.r.script.PasteSpecialView;
import com.ef_prime.rflow.ui.app.r.script.RAutoCompletion;
import com.ef_prime.rflow.ui.app.r.script.RCompletion;
import com.ef_prime.rflow.ui.app.r.script.RCompletionProvider;
import com.ef_prime.rflow.ui.app.r.script.RObjectPasteSpecial;
import com.ef_prime.rflow.ui.app.r.script.RScriptUtility;
import com.ef_prime.rflow.ui.app.r.script.TableDataPasteSpecial;
import com.ef_prime.rflow.ui.app.r.script.TextPasteSpecial;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.CodingTextArea;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.table.TableDataFlavor;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.AttributedCharacterIterator;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.folding.CurlyFoldParser;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;
import org.fife.ui.rsyntaxtextarea.folding.FoldParserManager;
import org.fife.ui.rtextarea.RTATextTransferHandler;

public abstract class AbstractRCodingTextArea
extends CodingTextArea {
    private static final Logger LOGGER = Logger.getLogger(AbstractRCodingTextArea.class.getName());
    public static final String RUN = "CodingTextArea.RUN";
    public static final String RUN_ALL = "CodingTextArea.RUN_ALL";
    private RInterface r;
    private boolean simplePopup = false;
    private AutoCompletion ac;
    private AutoCompletionNotifier notifier;
    private int hoveredOverLinkOffset = -1;
    private NotifyDispatcher notifyDispatcher;

    public AbstractRCodingTextArea(RInterface rInterface) {
        this(rInterface, "");
    }

    public AbstractRCodingTextArea(RInterface rInterface, String string) {
        super(string);
        this.r = rInterface;
        this.setSyntaxEditingStyle("RSYNTAX");
        this.getSyntaxScheme().setStyle(15, this.getSyntaxScheme().getStyle(20));
        this.getSyntaxScheme().setStyle(36, this.getSyntaxScheme().getStyle(10));
        RCompletionProvider rCompletionProvider = new RCompletionProvider();
        this.ac = new RAutoCompletion((CompletionProvider)rCompletionProvider){

            protected int refreshPopupWindow() {
                if (AbstractRCodingTextArea.this.notifier != null) {
                    AbstractRCodingTextArea.this.notifier.hideNotifier();
                }
                return super.refreshPopupWindow();
            }

            @Override
            protected void insertCompletion(Completion completion, boolean bl) {
                RCompletion rCompletion;
                if (AbstractRCodingTextArea.this.notifier != null) {
                    AbstractRCodingTextArea.this.notifier.setNotifierEnabled(false);
                }
                try {
                    super.insertCompletion(completion, bl);
                }
                finally {
                    if (AbstractRCodingTextArea.this.notifier != null) {
                        AbstractRCodingTextArea.this.notifier.setNotifierEnabled(true);
                    }
                }
                if (AbstractRCodingTextArea.this.notifier != null && completion instanceof RCompletion && (rCompletion = (RCompletion)completion).isFunction()) {
                    AbstractRCodingTextArea.this.requestAutoCompletionNotifier();
                }
            }
        };
        this.ac.setAutoActivationEnabled(true);
        this.ac.setAutoActivationDelay(200);
        this.ac.setShowDescWindow(true);
        this.ac.setDescriptionWindowSize(500, 300);
        this.ac.setAutoCompleteSingleChoices(false);
        this.ac.install((JTextComponent)((Object)this));
        CodingActions codingActions = new CodingActions();
        codingActions.installActions((JComponent)((Object)this), false, 0);
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
    }

    @Override
    protected RTATextTransferHandler createTransferHandler() {
        return new RCodingTransferHandler();
    }

    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        if (attributedCharacterIterator != null && attributedCharacterIterator.first() == '\u00a0' && attributedCharacterIterator.next() == '\uffff') {
            inputMethodEvent.consume();
        }
        if (Platform.isLinux() && attributedCharacterIterator != null && attributedCharacterIterator.first() == '/' && attributedCharacterIterator.next() == '\uffff') {
            inputMethodEvent.consume();
        }
        super.processInputMethodEvent(inputMethodEvent);
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
        if (Platform.isMac()) {
            if (keyEvent.isAltDown() && keyEvent.getKeyCode() == 32) {
                if (this.getAutoCompletion().isAutoCompleteEnabled()) {
                    this.getAutoCompletion().doCompletion();
                }
                keyEvent.consume();
            }
        } else if (Platform.isLinux() && keyEvent.isAltDown() && keyEvent.getID() == 400 && keyEvent.getKeyChar() == '/') {
            if (this.getAutoCompletion().isAutoCompleteEnabled()) {
                this.getAutoCompletion().doCompletion();
            }
            keyEvent.consume();
        }
        super.processComponentKeyEvent(keyEvent);
    }

    protected void openHelp(final String string, final String string2) {
        this.getR().queryQueue().addQuery(new Runnable(){

            @Override
            public void run() {
                String string3 = RUtility.function("help", "topic", RUtility.quote(string), "package", string2 == null ? "" : RUtility.quote(string2));
                AbstractRCodingTextArea.this.getR().client().silentIdleEval("print(" + string3 + ")");
            }
        });
    }

    protected void openObject(String string) {
        RObject rObject = this.getR().client().getObject(string);
        Rflow.mainView().openViewAtDefaultObjectPane(new RObjectViewer(this.r, rObject), ViewOpenType.OPEN_NEW, true);
    }

    @Override
    protected void fileDropped(List<File> list) {
        String string = "";
        if (list.size() == 1) {
            File file = WorkingDirectory.toAbstractPath(list.get(0));
            if (file.getPath().isEmpty()) {
                file = WorkingDirectory.getWorkingDirectory();
            }
            string = RUtility.quotedPath(file.getPath());
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("c(");
            for (int i = 0; i < list.size(); ++i) {
                File file = list.get(i);
                if ((file = WorkingDirectory.toAbstractPath(file)).getPath().isEmpty()) {
                    file = WorkingDirectory.getWorkingDirectory();
                }
                stringBuilder.append(RUtility.quotedPath(file.getPath()));
                if (i == list.size() - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(")");
            string = stringBuilder.toString();
        }
        try {
            this.getDocument().insertString(this.getCaretPosition(), string, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.requestFocusInWindow();
    }

    protected abstract void runScript(String var1);

    protected abstract List<Integer> getBreakpoints();

    protected RInterface getR() {
        return this.r;
    }

    public AutoCompletion getAutoCompletion() {
        return this.ac;
    }

    @Override
    public RSyntaxDocument getDocument() {
        return super.getDocument();
    }

    public void setText(String string) {
        this.beginAtomicEdit();
        super.setText(string);
        this.endAtomicEdit();
    }

    public void paste() {
        if (this.pasteRObject()) {
            return;
        }
        super.paste();
    }

    private boolean pasteRObject() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard == null) {
            return false;
        }
        Transferable transferable = clipboard.getContents(null);
        if (transferable == null || !transferable.isDataFlavorSupported(RObjectFlavor.getInstance())) {
            return false;
        }
        List<RObject> list = RObjectFlavor.get(transferable);
        if (list == null) {
            return false;
        }
        RObjectPasteSpecial rObjectPasteSpecial = new RObjectPasteSpecial(list);
        String string = rObjectPasteSpecial.joinWith(", ", "", RObjectFlavor.isFullPath(transferable));
        this.pasteText(string);
        return true;
    }

    private void pasteText(String string) {
        if (string == null) {
            return;
        }
        this.beginAtomicEdit();
        try {
            this.getTransferHandler().importData(new TransferHandler.TransferSupport((Component)((Object)this), new StringSelection(string)));
        }
        finally {
            this.endAtomicEdit();
        }
    }

    public void setSimplePopup(boolean bl) {
        this.simplePopup = bl;
    }

    public JPopupMenu getPopupMenu() {
        return this.createPopupMenu();
    }

    protected void configurePopupMenu(JPopupMenu jPopupMenu) {
    }

    protected JPopupMenu createPopupMenu() {
        return new CodingPopup();
    }

    @Override
    public Color getForegroundForToken(Token token) {
        if (token.getOffset() == this.hoveredOverLinkOffset) {
            return this.getHyperlinkForeground();
        }
        return super.getForegroundForToken(token);
    }

    public boolean getUnderlineForToken(Token token) {
        if (token.getOffset() == this.hoveredOverLinkOffset) {
            return true;
        }
        return super.getUnderlineForToken(token);
    }

    private String getFunction(int n) {
        try {
            int n2 = this.getLineOfOffset(n);
            Token token = this.getTokenListForLine(n2);
            RScriptUtility.CurrentFunctionInfo currentFunctionInfo = RScriptUtility.getCurrentFunction(token, n);
            if (currentFunctionInfo == null) {
                return null;
            }
            return currentFunctionInfo.getFunction().getLexeme();
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private boolean isNonWordToken(Token token) {
        switch (token.getType()) {
            case 21: 
            case 22: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    public Token modelToWordToken(int n) {
        if (n < 0) {
            return null;
        }
        try {
            int n2 = this.getLineOfOffset(n);
            Token token = null;
            for (Token token2 = this.getTokenListForLine(n2); token2 != null && token2.isPaintable(); token2 = token2.getNextToken()) {
                if (token2.containsPosition(n)) {
                    if (!this.isNonWordToken(token2)) {
                        return token2;
                    }
                    return token;
                }
                if (this.isNonWordToken(token2)) continue;
                token = token2;
            }
            return token;
        }
        catch (BadLocationException badLocationException) {
            LOGGER.log(Level.WARNING, "Failed to get token from offset.", badLocationException);
            return null;
        }
    }

    private String getPackagePrefix(Token token) {
        Token token2 = this.modelToWordToken(token.getOffset() - 1);
        if (token2 == null) {
            return null;
        }
        Token token3 = token2.getNextToken();
        if (token3 == null) {
            return null;
        }
        String string = token3.getLexeme();
        if (string == null || !string.equals("::") && !string.equals(":::")) {
            return null;
        }
        return new String(token2.getTextArray(), token2.getTextOffset(), token2.length() + token3.length());
    }

    private String[] toNameAndNameSpace(String string) {
        String string2 = string;
        String string3 = null;
        String string4 = null;
        int n = string.indexOf("::");
        if (n >= 0) {
            int n2 = 2;
            if (string.length() > n + 2 && string.charAt(n + 2) == ':') {
                n2 = 3;
            }
            string3 = string.substring(0, n);
            string2 = string.substring(n + n2);
            string4 = string.substring(n, n + n2);
        }
        return new String[]{string2, string3, string4};
    }

    private String getObjectAt(int n) {
        String[] stringArray;
        Object object;
        if (this.isSelection()) {
            object = this.getSelectedText();
        } else {
            stringArray = this.modelToWordToken(n);
            if (stringArray == null) {
                return null;
            }
            if (stringArray.getType() != 20 && stringArray.getType() != 15 && stringArray.getType() != 8) {
                return null;
            }
            object = stringArray.getLexeme();
            String string = this.getPackagePrefix((Token)stringArray);
            if (string != null) {
                object = string + (String)object;
            }
        }
        stringArray = this.toNameAndNameSpace((String)object);
        if (!this.r.client().exists(stringArray[0], stringArray[1])) {
            return null;
        }
        return object;
    }

    private String[] getHelpTopicAt(int n) {
        Token token;
        Object object;
        if (this.isSelection()) {
            object = this.getSelectedText();
        } else {
            object = this.getFunction(n);
            if (object == null && (token = this.modelToWordToken(n)) != null) {
                object = token.getLexeme();
                String string = this.getPackagePrefix(token);
                if (string != null) {
                    object = string + (String)object;
                }
            }
        }
        if (object == null) {
            return null;
        }
        token = this.toNameAndNameSpace((String)object);
        if (!this.r.client().isHelp((String)token[0], (String)token[1])) {
            return null;
        }
        return token;
    }

    protected void insertTab() {
        Action action = this.getActionMap().get("insert-tab");
        if (action == null) {
            this.insert("\t", this.getCaretPosition());
        } else {
            action.actionPerformed(new ActionEvent(this, 1001, ""));
        }
    }

    @Override
    public Key<Boolean> getLineWrapKey() {
        return Settings.R_EDITOR_LINE_WRAP;
    }

    public boolean getCloseCurlyBraces() {
        return super.getCloseCurlyBraces() && Rflow.settings().getValue(Settings.R_CODE_PARENS_AND_QUOTES) != false;
    }

    public void startAutoCompletionNotifier() {
        this.notifier = new AutoCompletionNotifier();
        this.addFocusListener(this.notifier);
        this.addCaretListener(this.notifier);
        this.addInputMethodListener(this.notifier);
        this.addKeyListener(this.notifier);
    }

    public void endAutoCompletionNotifier() {
        this.removeFocusListener(this.notifier);
        this.removeCaretListener(this.notifier);
        this.removeInputMethodListener(this.notifier);
        this.removeKeyListener(this.notifier);
        this.hideAndKillNotifier();
        this.notifier = null;
    }

    public void hideAndKillNotifier() {
        if (this.notifier != null) {
            this.notifier.hideNotifier();
        }
        if (this.notifyDispatcher != null) {
            this.notifyDispatcher.kill();
        }
    }

    private void requestAutoCompletionNotifier() {
        if (this.notifier != null) {
            this.notifier.hideNotifier();
        }
        if (this.notifyDispatcher == null || !this.notifyDispatcher.alive()) {
            this.notifyDispatcher = new NotifyDispatcher();
            ThreadUtility.execute(this.notifyDispatcher);
        } else {
            this.notifyDispatcher.reset();
        }
    }

    private void showAutoCompletionNotifier() {
        if (!this.notifier.isNotifierEnabled()) {
            return;
        }
        RCompletionProvider rCompletionProvider = (RCompletionProvider)this.ac.getCompletionProvider();
        this.notifier.showNotifier(rCompletionProvider.getCompletions((JTextComponent)((Object)this), false));
    }

    static {
        AbstractTokenMakerFactory abstractTokenMakerFactory = (AbstractTokenMakerFactory)TokenMakerFactory.getDefaultInstance();
        abstractTokenMakerFactory.putMapping("RSYNTAX", RTokenMaker.class.getCanonicalName());
        TokenMakerFactory.setDefaultInstance((TokenMakerFactory)abstractTokenMakerFactory);
        FoldParserManager.get().addFoldParserMapping("RSYNTAX", (FoldParser)new CurlyFoldParser(false, false));
    }

    private class CodingActions
    extends Actions {
        private static final String TAB = "TAB";
        private static final String OPEN_OBJECT = "OPEN_OBJECT";
        private static final String OPEN_HELP = "OPEN_HELP";
        private static final String BACKSPACE = "BACKSPACE";
        private static final String ENTER = "ENTER";
        private static final String BEGIN_LINE = "BEGIN_LINE";
        private static final String END_LINE = "END_LINE";
        private static final String MOVE_UP = "MOVE_UP";
        private static final String MOVE_DOWN = "MOVE_DOWN";
        private static final String CORRECT_INDENTATION = "CORRECT_INDENTATION";
        private static final String PASTE_SPECIAL = "PASTE_SPECIAL";

        public CodingActions() {
            this.put(AbstractRCodingTextArea.RUN, new Run());
            this.put(new RunToNextLine());
            this.put(AbstractRCodingTextArea.RUN_ALL, new RunAll());
            this.put(TAB, new Tab());
            this.put(OPEN_OBJECT, new OpenObject());
            this.put(OPEN_HELP, new OpenHelp());
            this.put(ENTER, new Enter());
            this.put(BEGIN_LINE, new BeginLine());
            this.put(END_LINE, new EndLine());
            this.put(MOVE_UP, new MoveLine(true));
            this.put(MOVE_DOWN, new MoveLine(false));
            this.put(CORRECT_INDENTATION, new CorrectIndentation());
            this.put(PASTE_SPECIAL, new PasteSpecialAction());
            char[] cArray = new char[]{'(', ')', '\"', '\"', '\'', '\'', '`', '`', '[', ']', '{', '}'};
            String[] stringArray = new String[]{"LEFT_PARENTHESIS", "QUOTE", "SINGLE_QUOTE", "BACKTICK", "BRACE", "CURLY_BRACE"};
            for (int i = 0; i < stringArray.length; ++i) {
                char c = cArray[2 * i];
                char c2 = cArray[2 * i + 1];
                this.put(stringArray[i], new PairMark(c, c2));
                if (c == c2) continue;
                this.put("CLOSE_" + stringArray[i], new PairMarkClose(c, c2));
            }
            char[] cArray2 = new char[]{'(', ')', '[', ']'};
            this.put(BACKSPACE, new Backspace(cArray2));
            this.put("ASSIGN", new Insert(" <- ", true, KeyStroke.getKeyStroke(45, 512)));
            this.put("PIPE", new Insert(" %>% ", true, KeyStroke.getKeyStroke(77, UIUtility.MENU_AND_SHIFT_KEY_MASK)));
        }

        private void run(String string) {
            if (string != null) {
                string = string.replaceAll("\r\n", "\n");
                string = string.replaceAll("\r", "\n");
                AbstractRCodingTextArea.this.runScript(string);
            }
        }

        private void run(int n, int n2) {
            int n3;
            AbstractRCodingTextArea abstractRCodingTextArea = AbstractRCodingTextArea.this;
            List<Integer> list = AbstractRCodingTextArea.this.getBreakpoints();
            Element element = abstractRCodingTextArea.getDocument().getDefaultRootElement();
            Element element2 = element.getElement(n3 = element.getElementIndex(n));
            boolean bl = element2.getStartOffset() == n;
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            try {
                string = abstractRCodingTextArea.getText(n, n2 - n);
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            String[] stringArray = string.split("\n");
            for (int i = 0; i < stringArray.length; ++i) {
                if (list.contains(n3 + i + 1) && (i != 0 || bl)) {
                    stringBuilder.append(AbstractRCodingTextArea.this.r.client().getDebugCommand());
                    stringBuilder.append("\n");
                }
                stringBuilder.append(stringArray[i]);
                stringBuilder.append("\n");
            }
            this.run(stringBuilder.toString());
        }

        private class Run
        extends LoggableAction {
            public Run() {
                this.putValue("Name", Messages.getString("Action.run_selection"));
                this.putValue("SmallIcon", Icons.getIcon("16/bullet_arrow_right.png"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                AbstractRCodingTextArea abstractRCodingTextArea = AbstractRCodingTextArea.this;
                List<Integer> list = AbstractRCodingTextArea.this.getBreakpoints();
                int n = abstractRCodingTextArea.getSelectionStart();
                int n2 = abstractRCodingTextArea.getSelectionEnd();
                Object object = "";
                if (n == n2) {
                    int n3 = abstractRCodingTextArea.getCaretPosition();
                    Element element = abstractRCodingTextArea.getDocument().getDefaultRootElement();
                    int n4 = element.getElementIndex(n3);
                    if (n4 >= 0) {
                        Element element2 = element.getElement(n4);
                        try {
                            object = abstractRCodingTextArea.getText(element2.getStartOffset(), element2.getEndOffset() - element2.getStartOffset());
                            if (list.contains(n4 + 1)) {
                                object = AbstractRCodingTextArea.this.r.client().getDebugCommand() + "\n" + (String)object;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                    CodingActions.this.run((String)object);
                } else {
                    CodingActions.this.run(n, n2);
                }
            }
        }

        private class RunToNextLine
        extends LoggableAction {
            public RunToNextLine() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                int n;
                AbstractRCodingTextArea abstractRCodingTextArea = AbstractRCodingTextArea.this;
                List<Integer> list = AbstractRCodingTextArea.this.getBreakpoints();
                int n2 = abstractRCodingTextArea.getSelectionStart();
                if (n2 == (n = abstractRCodingTextArea.getSelectionEnd())) {
                    int n3 = abstractRCodingTextArea.getCaretPosition();
                    Element element = abstractRCodingTextArea.getDocument().getDefaultRootElement();
                    int n4 = element.getElementIndex(n3);
                    Object object = "";
                    if (n4 >= 0) {
                        Element element2 = element.getElement(n4);
                        try {
                            object = abstractRCodingTextArea.getText(element2.getStartOffset(), element2.getEndOffset() - element2.getStartOffset());
                            if (list.contains(n4 + 1)) {
                                object = AbstractRCodingTextArea.this.r.client().getDebugCommand() + "\n" + (String)object;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                    CodingActions.this.run((String)object);
                    int n5 = ++n4;
                    if (n5 == element.getElementCount()) {
                        try {
                            AbstractRCodingTextArea.this.getDocument().insertString(AbstractRCodingTextArea.this.getDocument().getLength(), "\n", null);
                        }
                        catch (BadLocationException badLocationException) {
                            LOGGER.log(Level.WARNING, "Failed to insert a new line.", badLocationException);
                        }
                    } else {
                        while (n4 < element.getElementCount()) {
                            Token token = AbstractRCodingTextArea.this.getTokenListForLine(n4);
                            while (token.isWhitespace() && token.getNextToken() != null) {
                                token = token.getNextToken();
                            }
                            if (token.getType() != 0) {
                                AbstractRCodingTextArea.this.setCaretPosition(token.getOffset());
                                return;
                            }
                            ++n4;
                        }
                        AbstractRCodingTextArea.this.setCaretPosition(element.getElement(n5).getStartOffset());
                    }
                } else {
                    CodingActions.this.run(n2, n);
                }
            }
        }

        private class RunAll
        extends LoggableAction {
            public RunAll() {
                this.putValue("Name", Messages.getString("Action.run"));
                this.putValue("SmallIcon", Icons.getIcon("16/resultset_next.png"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, UIUtility.MENU_AND_SHIFT_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                CodingActions.this.run(0, AbstractRCodingTextArea.this.getDocument().getLength());
            }
        }

        private class Tab
        extends LoggableAction {
            public Tab() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(9, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (!Rflow.develSettings().getValue(DevelSettings.KEY_TAB_COMPLETION).booleanValue()) {
                    AbstractRCodingTextArea.this.insertTab();
                    return;
                }
                String string = this.stringBeforeCaret();
                boolean bl = false;
                if (AbstractRCodingTextArea.this.ac.isPopupOrNoMatchVisible()) {
                    AbstractRCodingTextArea.this.ac.hideChildWindows();
                } else {
                    for (int i = 0; i < string.length(); ++i) {
                        char c = string.charAt(i);
                        if (c == ' ' || c == '\t') continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) {
                    AbstractRCodingTextArea.this.ac.doCompletion();
                } else {
                    AbstractRCodingTextArea.this.insertTab();
                }
            }

            private String stringBeforeCaret() {
                RSyntaxDocument rSyntaxDocument = AbstractRCodingTextArea.this.getDocument();
                int n = AbstractRCodingTextArea.this.getCaretPosition();
                Element element = rSyntaxDocument.getDefaultRootElement();
                int n2 = element.getElementIndex(n);
                Element element2 = element.getElement(n2);
                int n3 = element2.getStartOffset();
                int n4 = n - n3;
                try {
                    return rSyntaxDocument.getText(n3, n4);
                }
                catch (BadLocationException badLocationException) {
                    return "";
                }
            }
        }

        private class OpenObject
        extends LoggableAction {
            public OpenObject() {
                this.putValue("Name", Messages.getString("Action.open_object"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(113, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                String string = AbstractRCodingTextArea.this.getObjectAt(AbstractRCodingTextArea.this.getCaretPosition());
                if (string == null) {
                    return;
                }
                AbstractRCodingTextArea.this.openObject(string);
            }
        }

        private class OpenHelp
        extends LoggableAction {
            public OpenHelp() {
                this.putValue("Name", Messages.getString("Action.open_help"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(112, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                String[] stringArray = AbstractRCodingTextArea.this.getHelpTopicAt(AbstractRCodingTextArea.this.getCaretPosition());
                if (stringArray == null) {
                    return;
                }
                AbstractRCodingTextArea.this.openHelp(stringArray[0], stringArray[1]);
            }
        }

        private class Enter
        extends AbstractAction {
            public Enter() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractRCodingTextArea abstractRCodingTextArea = AbstractRCodingTextArea.this;
                abstractRCodingTextArea.clearMarkOccurrencesHighlights();
                abstractRCodingTextArea.getActionMap().get("insert-break").actionPerformed(actionEvent);
            }
        }

        private class BeginLine
        extends AbstractAction {
            public BeginLine() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(36, 0));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractRCodingTextArea abstractRCodingTextArea = AbstractRCodingTextArea.this;
                Element element = AbstractRCodingTextArea.this.getDocument().getDefaultRootElement();
                int n = element.getElementIndex(abstractRCodingTextArea.getCaretPosition());
                Element element2 = element.getElement(n);
                abstractRCodingTextArea.setCaretPosition(element2.getStartOffset());
            }
        }

        private class EndLine
        extends AbstractAction {
            public EndLine() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(35, 0));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractRCodingTextArea abstractRCodingTextArea = AbstractRCodingTextArea.this;
                Element element = AbstractRCodingTextArea.this.getDocument().getDefaultRootElement();
                int n = element.getElementIndex(abstractRCodingTextArea.getCaretPosition());
                Element element2 = element.getElement(n);
                abstractRCodingTextArea.setCaretPosition(element2.getEndOffset() - 1);
            }
        }

        private class MoveLine
        extends AbstractAction {
            boolean up;

            public MoveLine(boolean bl) {
                this.up = bl;
                if (bl) {
                    this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 512));
                } else {
                    this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 512));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractRCodingTextArea abstractRCodingTextArea = AbstractRCodingTextArea.this;
                RSyntaxDocument rSyntaxDocument = abstractRCodingTextArea.getDocument();
                Element element = rSyntaxDocument.getDefaultRootElement();
                int n = element.getElementIndex(AbstractRCodingTextArea.this.getSelectionStart());
                int n2 = element.getElementIndex(AbstractRCodingTextArea.this.getSelectionEnd());
                if (this.up && n == 0) {
                    return;
                }
                if (!this.up && n2 >= element.getElementCount() - 1) {
                    return;
                }
                int n3 = element.getElement(n).getStartOffset();
                int n4 = element.getElement(n2).getEndOffset();
                boolean bl = n2 >= element.getElementCount() - 1;
                int n5 = n4 - n3;
                if (bl) {
                    --n5;
                }
                abstractRCodingTextArea.beginAtomicEdit();
                try {
                    boolean bl2;
                    Object object = rSyntaxDocument.getText(n3, n5);
                    if (bl) {
                        object = (String)object + "\n";
                    }
                    if (bl) {
                        rSyntaxDocument.remove(n3 - 1, n5 + 1);
                    } else {
                        rSyntaxDocument.remove(n3, n5);
                    }
                    int n6 = this.up ? element.getElement(n - 1).getStartOffset() : element.getElement(n).getEndOffset();
                    boolean bl3 = bl2 = n6 > rSyntaxDocument.getLength();
                    if (bl2) {
                        n6 = rSyntaxDocument.getLength();
                        if (((String)object).endsWith("\n")) {
                            object = ((String)object).substring(0, ((String)object).length() - "\n".length());
                        }
                        object = "\n" + (String)object;
                    }
                    rSyntaxDocument.insertString(n6, (String)object, null);
                    int n7 = n6 + ((String)object).length();
                    if (((String)object).charAt(((String)object).length() - 1) == '\n') {
                        --n7;
                    }
                    if (bl2) {
                        n6 += "\n".length();
                    }
                    abstractRCodingTextArea.select(n6, n7);
                }
                catch (BadLocationException badLocationException) {
                    LOGGER.log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
                }
                finally {
                    abstractRCodingTextArea.endAtomicEdit();
                }
            }
        }

        private class CorrectIndentation
        extends LoggableAction {
            public CorrectIndentation() {
                this.putValue("Name", Messages.getString("Action.correct_indentation"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                try {
                    RScriptUtility.correctIndentation(AbstractRCodingTextArea.this);
                }
                catch (BadLocationException badLocationException) {
                    LOGGER.log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
                }
            }
        }

        private class PasteSpecialAction
        extends LoggableAction {
            public PasteSpecialAction() {
                this.putValue("Name", Messages.getStringWithDots("CodingTextArea.paste_special"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, UIUtility.MENU_KEY_MASK | 0x40));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void action(ActionEvent actionEvent) {
                Object object;
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                boolean bl = clipboard.isDataFlavorAvailable(RObjectFlavor.getInstance());
                boolean bl2 = clipboard.isDataFlavorAvailable(TableDataFlavor.getInstance());
                boolean bl3 = clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor);
                if (!(bl || bl2 || bl3)) {
                    return;
                }
                PasteSpecial pasteSpecial = null;
                try {
                    if (bl) {
                        object = (List)Utility.cast(clipboard.getData(RObjectFlavor.getInstance()));
                        pasteSpecial = new RObjectPasteSpecial((List<RObject>)object);
                    } else if (bl2) {
                        object = (List)Utility.cast(clipboard.getData(TableDataFlavor.getInstance()));
                        pasteSpecial = new TableDataPasteSpecial((List<List<String>>)object);
                    } else {
                        object = (String)clipboard.getData(DataFlavor.stringFlavor);
                        pasteSpecial = new TextPasteSpecial((String)object);
                    }
                }
                catch (Exception exception) {
                    return;
                }
                AbstractRCodingTextArea.this.setKeepEditingInTable(true);
                try {
                    object = PasteSpecialView.show((Component)((Object)AbstractRCodingTextArea.this), pasteSpecial);
                    AbstractRCodingTextArea.this.pasteText((String)object);
                }
                finally {
                    AbstractRCodingTextArea.this.setKeepEditingInTable(false);
                }
            }
        }

        private class PairMark
        extends AbstractAction {
            private char mark;
            private char closeMark;

            public PairMark(char c, char c2) {
                this.mark = c;
                this.closeMark = c2;
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(c));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractRCodingTextArea abstractRCodingTextArea = AbstractRCodingTextArea.this;
                if (!Rflow.settings().getValue(Settings.R_CODE_PARENS_AND_QUOTES).booleanValue()) {
                    abstractRCodingTextArea.getActionMap().get("insert-content").actionPerformed(actionEvent);
                    return;
                }
                try {
                    RSyntaxDocument rSyntaxDocument = abstractRCodingTextArea.getDocument();
                    int n = abstractRCodingTextArea.getCaretPosition();
                    Action action = abstractRCodingTextArea.getActionMap().get("insert-content");
                    if (this.mark == this.closeMark && !abstractRCodingTextArea.isSelection() && rSyntaxDocument.getLength() != n && rSyntaxDocument.charAt(n) == this.closeMark) {
                        abstractRCodingTextArea.setCaretPosition(n + 1);
                        return;
                    }
                    if (abstractRCodingTextArea.isSelection()) {
                        int n2 = abstractRCodingTextArea.getSelectionStart();
                        rSyntaxDocument.remove(n2, abstractRCodingTextArea.getSelectionEnd() - n2);
                        abstractRCodingTextArea.setCaretPosition(n2);
                    }
                    if (this.shouldInsertOpeningMarkOnly()) {
                        action.actionPerformed(new ActionEvent(actionEvent.getSource(), actionEvent.getID(), Character.toString(this.mark)));
                    } else {
                        action.actionPerformed(new ActionEvent(actionEvent.getSource(), actionEvent.getID(), new String(new char[]{this.mark, this.closeMark})));
                        abstractRCodingTextArea.setCaretPosition(abstractRCodingTextArea.getCaretPosition() - 1);
                    }
                }
                catch (BadLocationException badLocationException) {
                    LOGGER.log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
                }
            }

            private boolean shouldInsertOpeningMarkOnly() throws BadLocationException {
                int n;
                String string;
                AbstractRCodingTextArea abstractRCodingTextArea = AbstractRCodingTextArea.this;
                RSyntaxDocument rSyntaxDocument = abstractRCodingTextArea.getDocument();
                int n2 = abstractRCodingTextArea.getCaretPosition();
                if (this.mark == '{' && (string = rSyntaxDocument.getText(n = abstractRCodingTextArea.getLineStartOffsetOfCurrentLine(), n2 - n)).length() == RSyntaxUtilities.getLeadingWhitespace((String)string).length()) {
                    return true;
                }
                if (this.mark != '[' && rSyntaxDocument.getLength() > n2 && (Character.isUnicodeIdentifierPart((char)(n = (int)rSyntaxDocument.charAt(n2))) || n == 46 || n == 40 || n == 34 || n == 39 || n == 96)) {
                    return true;
                }
                if (this.mark != this.closeMark) {
                    int n3;
                    while (n2 - 1 >= 0 && rSyntaxDocument.charAt(n2 - 1) == this.mark) {
                        --n2;
                    }
                    rSyntaxDocument.insertString(n2, String.valueOf(this.mark), null);
                    n = RScriptUtility.getMatchingBracketPosition(abstractRCodingTextArea, n2, this.mark, this.closeMark);
                    rSyntaxDocument.remove(n2, 1);
                    if (n >= 0 && (n3 = RScriptUtility.getMatchingBracketPosition(abstractRCodingTextArea, n2, this.closeMark, this.mark)) < 0) {
                        return true;
                    }
                }
                if (this.mark == this.closeMark && n2 > 0) {
                    int n4;
                    n = rSyntaxDocument.charAt(n2 - 1);
                    if (Character.isUnicodeIdentifierPart((char)n) || n == 46 || n == 41 || n == 125 || n == 93 || n == 34 || n == 39 || n == 96 || n == 92) {
                        return true;
                    }
                    int n5 = abstractRCodingTextArea.getLineOfOffset(n2);
                    int n6 = abstractRCodingTextArea.getLineStartOffset(n5);
                    if (n6 == n2) {
                        --n5;
                    }
                    if (n5 >= 0 && ((n4 = rSyntaxDocument.getLastTokenTypeOnLine(n5)) == 13 && this.mark == '\"' || n4 == 14 && this.mark == '\'' || n4 == 15 && this.mark == '`')) {
                        return true;
                    }
                }
                return false;
            }
        }

        private class PairMarkClose
        extends AbstractAction {
            private char mark;
            private char closeMark;

            public PairMarkClose(char c, char c2) {
                this.mark = c;
                this.closeMark = c2;
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(c2));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractRCodingTextArea abstractRCodingTextArea = AbstractRCodingTextArea.this;
                if (!Rflow.settings().getValue(Settings.R_CODE_PARENS_AND_QUOTES).booleanValue()) {
                    abstractRCodingTextArea.getActionMap().get("insert-content").actionPerformed(actionEvent);
                    return;
                }
                RSyntaxDocument rSyntaxDocument = abstractRCodingTextArea.getDocument();
                int n = abstractRCodingTextArea.getCaretPosition();
                try {
                    if (abstractRCodingTextArea.getDocument().getLength() != n && !abstractRCodingTextArea.isSelection() && rSyntaxDocument.charAt(n) == this.closeMark) {
                        while (n + 1 < rSyntaxDocument.getLength() && rSyntaxDocument.charAt(n + 1) == this.closeMark) {
                            ++n;
                        }
                        rSyntaxDocument.insertString(++n, String.valueOf(this.closeMark), null);
                        int n2 = RScriptUtility.getMatchingBracketPosition(abstractRCodingTextArea, n, this.closeMark, this.mark);
                        rSyntaxDocument.remove(n, 1);
                        if (n2 < 0) {
                            abstractRCodingTextArea.setCaretPosition(abstractRCodingTextArea.getCaretPosition() + 1);
                            return;
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                abstractRCodingTextArea.getActionMap().get("insert-content").actionPerformed(actionEvent);
            }
        }

        private class Backspace
        extends AbstractAction {
            private char[] pairs;

            public Backspace(char[] cArray) {
                this.pairs = cArray;
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(8, 0));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractRCodingTextArea abstractRCodingTextArea = AbstractRCodingTextArea.this;
                if (!Rflow.settings().getValue(Settings.R_CODE_PARENS_AND_QUOTES).booleanValue()) {
                    abstractRCodingTextArea.getActionMap().get("delete-previous").actionPerformed(actionEvent);
                    return;
                }
                int n = abstractRCodingTextArea.getCaretPosition();
                int n2 = abstractRCodingTextArea.getDocument().getLength();
                if (n > 0 && n < n2) {
                    try {
                        String string = abstractRCodingTextArea.getText(n - 1, 2);
                        if (string.length() == 2) {
                            char c = string.charAt(0);
                            char c2 = string.charAt(1);
                            for (int i = 0; i < this.pairs.length; i += 2) {
                                if (c != this.pairs[i] || c2 != this.pairs[i + 1]) continue;
                                abstractRCodingTextArea.getDocument().remove(n - 1, 2);
                                return;
                            }
                        } else {
                            LOGGER.warning("Unexpected length: pos=" + n + " length=" + string.length() + " docLength=" + n2 + " docLengthNow=" + abstractRCodingTextArea.getDocument().getLength());
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                abstractRCodingTextArea.getActionMap().get("delete-previous").actionPerformed(actionEvent);
            }
        }

        private class Insert
        extends LoggableAction {
            private String insertString;
            boolean skipSpace;

            public Insert(String string, boolean bl, KeyStroke keyStroke) {
                this.insertString = string;
                this.skipSpace = bl;
                this.putValue("AcceleratorKey", keyStroke);
            }

            @Override
            public void action(ActionEvent actionEvent) {
                AbstractRCodingTextArea abstractRCodingTextArea = AbstractRCodingTextArea.this;
                String string = this.insertString;
                if (this.skipSpace) {
                    int n = abstractRCodingTextArea.getCaretPosition();
                    RSyntaxDocument rSyntaxDocument = abstractRCodingTextArea.getDocument();
                    try {
                        if (n > 0 && n - 1 < rSyntaxDocument.getLength() && rSyntaxDocument.charAt(n - 1) == ' ') {
                            string = string.substring(1);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Action action = abstractRCodingTextArea.getActionMap().get("insert-content");
                action.actionPerformed(new ActionEvent(actionEvent.getSource(), actionEvent.getID(), string));
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private boolean isScanningForLinks;

        private MouseHandler() {
        }

        private boolean canOpenHelp(Token token) {
            if (token.getType() != 8) {
                return false;
            }
            String[] stringArray = AbstractRCodingTextArea.this.toNameAndNameSpace(token.getLexeme());
            return AbstractRCodingTextArea.this.r.client().isHelp(stringArray[0], stringArray[1]);
        }

        private boolean canOpenObject(Token token) {
            if (token.getType() != 20 && token.getType() != 15) {
                return false;
            }
            String string = AbstractRCodingTextArea.this.getObjectAt(token.getOffset() + token.length());
            return string != null;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n = UIUtility.MENU_KEY_MASK;
            if ((mouseEvent.getModifiers() & n) == n) {
                Cursor cursor;
                int n2;
                this.isScanningForLinks = true;
                Token token = AbstractRCodingTextArea.this.viewToToken(mouseEvent.getPoint());
                if (token != null && (this.canOpenHelp(token) || this.canOpenObject(token))) {
                    n2 = token.getOffset();
                    cursor = Cursor.getPredefinedCursor(12);
                } else {
                    n2 = -1;
                    cursor = Cursor.getPredefinedCursor(2);
                }
                if (AbstractRCodingTextArea.this.hoveredOverLinkOffset != n2) {
                    AbstractRCodingTextArea.this.hoveredOverLinkOffset = n2;
                    AbstractRCodingTextArea.this.repaint();
                }
                if (AbstractRCodingTextArea.this.getCursor().getType() != cursor.getType()) {
                    AbstractRCodingTextArea.this.setCursor(cursor);
                }
            } else if (this.isScanningForLinks) {
                Cursor cursor = AbstractRCodingTextArea.this.getCursor();
                this.isScanningForLinks = false;
                AbstractRCodingTextArea.this.hoveredOverLinkOffset = -1;
                if (cursor != null && cursor.getType() == 12) {
                    AbstractRCodingTextArea.this.setCursor(Cursor.getPredefinedCursor(2));
                    AbstractRCodingTextArea.this.repaint();
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (UIUtility.isLeftMouseButton(mouseEvent) && this.isScanningForLinks && AbstractRCodingTextArea.this.hoveredOverLinkOffset > -1) {
                Token token = AbstractRCodingTextArea.this.modelToToken(AbstractRCodingTextArea.this.hoveredOverLinkOffset);
                if (token == null) {
                    return;
                }
                String[] stringArray = AbstractRCodingTextArea.this.toNameAndNameSpace(token.getLexeme());
                if (token.getType() == 8 && AbstractRCodingTextArea.this.r.client().isHelp(stringArray[0], stringArray[1])) {
                    AbstractRCodingTextArea.this.openHelp(stringArray[0], stringArray[1]);
                } else {
                    String string = AbstractRCodingTextArea.this.getObjectAt(token.getOffset());
                    if (string != null) {
                        AbstractRCodingTextArea.this.openObject(string);
                    }
                }
            }
        }
    }

    protected class RCodingTransferHandler
    extends CodingTextArea.CodingTransferHandler {
        protected RCodingTransferHandler() {
            super(AbstractRCodingTextArea.this);
        }

        protected void replaceSelection(JTextComponent jTextComponent, String string) {
            int n = string.indexOf(10);
            boolean bl = n >= 0 && n < string.length() - 1;
            int n2 = jTextComponent.getSelectionStart();
            if (!bl) {
                Document document = jTextComponent.getDocument();
                Element element = document.getDefaultRootElement();
                Element element2 = element.getElement(element.getElementIndex(n2));
                boolean bl2 = true;
                try {
                    String string2 = document.getText(element2.getStartOffset(), n2 - element2.getStartOffset());
                    for (int i = string2.length() - 1; i >= 0; --i) {
                        char c = string2.charAt(i);
                        if (c == ' ' || c == '\t') continue;
                        bl2 = false;
                        break;
                    }
                }
                catch (BadLocationException badLocationException) {
                    LOGGER.log(Level.WARNING, "Failed to get the leading text.", badLocationException);
                }
                if (bl2) {
                    bl = true;
                }
            }
            super.replaceSelection(jTextComponent, string);
            if (bl) {
                try {
                    jTextComponent.select(n2, n2 + string.length());
                    RScriptUtility.correctIndentation((RSyntaxTextArea)jTextComponent);
                    jTextComponent.setCaretPosition(jTextComponent.getSelectionEnd());
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, "Failed to correct indentation.", exception);
                }
            }
        }
    }

    private class CodingPopup
    extends JPopupMenu
    implements PopupMenuListener {
        public CodingPopup() {
            Action action;
            this.addPopupMenuListener(this);
            ActionMap actionMap = AbstractRCodingTextArea.this.getActionMap();
            JMenuItem jMenuItem = new JMenuItem(actionMap.get("RSTA.ToggleCommentAction"));
            jMenuItem.setText(Messages.getString("Action.comment"));
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, UIUtility.MENU_AND_SHIFT_KEY_MASK));
            JMenu jMenu = new JMenu(Messages.getString("Action.folding"));
            JMenuItem jMenuItem2 = new JMenuItem(actionMap.get("RSTA.CollapseAllFoldsAction"));
            jMenuItem2.setText(Messages.getString("Action.collapse_all"));
            JMenuItem jMenuItem3 = new JMenuItem(actionMap.get("RSTA.ExpandAllFoldsAction"));
            jMenuItem3.setText(Messages.getString("Action.expand_all"));
            jMenu.add(jMenuItem2);
            jMenu.add(jMenuItem3);
            JMenuItem jMenuItem4 = new JMenuItem(actionMap.get("RTA.UndoAction"));
            jMenuItem4.setText(Messages.getString("Action.undo"));
            jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(90, UIUtility.MENU_KEY_MASK));
            JMenuItem jMenuItem5 = new JMenuItem(actionMap.get("RTA.RedoAction"));
            jMenuItem5.setText(Messages.getString("Action.redo"));
            jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(89, UIUtility.MENU_KEY_MASK));
            JMenuItem jMenuItem6 = new JMenuItem(actionMap.get("cut-to-clipboard"));
            jMenuItem6.setText(Messages.getString("Action.cut"));
            jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(88, UIUtility.MENU_KEY_MASK));
            JMenuItem jMenuItem7 = new JMenuItem(actionMap.get("copy-to-clipboard"));
            jMenuItem7.setText(Messages.getString("Action.copy"));
            jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(67, UIUtility.MENU_KEY_MASK));
            JMenuItem jMenuItem8 = new JMenuItem(actionMap.get("paste-from-clipboard"));
            jMenuItem8.setText(Messages.getString("Action.paste"));
            jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(86, UIUtility.MENU_KEY_MASK));
            JMenuItem jMenuItem9 = new JMenuItem(actionMap.get("select-all"));
            jMenuItem9.setText(Messages.getString("Action.select_all"));
            jMenuItem9.setAccelerator(KeyStroke.getKeyStroke(65, UIUtility.MENU_KEY_MASK));
            if (!AbstractRCodingTextArea.this.simplePopup) {
                this.add(actionMap.get(AbstractRCodingTextArea.RUN));
                this.add(actionMap.get(AbstractRCodingTextArea.RUN_ALL));
            }
            if ((action = AbstractRCodingTextArea.this.getFindAction()) != null) {
                this.add(action);
            }
            if (!AbstractRCodingTextArea.this.simplePopup) {
                if (AbstractRCodingTextArea.this.isEditable()) {
                    this.add(jMenuItem);
                    this.add(actionMap.get("CORRECT_INDENTATION"));
                }
                if (AbstractRCodingTextArea.this.isCodeFoldingEnabled()) {
                    this.add(jMenu);
                }
            }
            this.addSeparator();
            this.add(actionMap.get("OPEN_HELP"));
            this.add(actionMap.get("OPEN_OBJECT"));
            if (!AbstractRCodingTextArea.this.simplePopup && AbstractRCodingTextArea.this.isEditable()) {
                this.addSeparator();
                this.add(jMenuItem4);
                this.add(jMenuItem5);
            }
            this.addSeparator();
            if (AbstractRCodingTextArea.this.isEditable()) {
                this.add(jMenuItem6);
            }
            this.add(jMenuItem7);
            if (AbstractRCodingTextArea.this.isEditable()) {
                this.add(jMenuItem8);
                this.add(actionMap.get("PASTE_SPECIAL"));
            }
            this.addSeparator();
            this.add(jMenuItem9);
            UIUtility.clearPopupSeparator(this);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            ActionMap actionMap = AbstractRCodingTextArea.this.getActionMap();
            int n = AbstractRCodingTextArea.this.getCaretPosition();
            String string = AbstractRCodingTextArea.this.getObjectAt(n);
            Object object = Messages.getString("Action.open_object");
            if (string != null) {
                object = (String)object + " (" + string + ")";
            }
            actionMap.get("OPEN_OBJECT").setEnabled(string != null);
            actionMap.get("OPEN_OBJECT").putValue("Name", object);
            String[] stringArray = AbstractRCodingTextArea.this.getHelpTopicAt(n);
            StringBuilder stringBuilder = new StringBuilder(Messages.getString("Action.open_help"));
            if (stringArray != null) {
                stringBuilder.append(" (");
                if (stringArray[1] != null) {
                    stringBuilder.append(stringArray[1]);
                    stringBuilder.append(stringArray[2]);
                }
                stringBuilder.append(stringArray[0]);
                stringBuilder.append(")");
            }
            actionMap.get("OPEN_HELP").setEnabled(stringArray != null);
            actionMap.get("OPEN_HELP").putValue("Name", stringBuilder.toString());
            try {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                boolean bl = clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor) || clipboard.isDataFlavorAvailable(RObjectFlavor.getInstance());
                actionMap.get("PASTE_SPECIAL").setEnabled(bl);
                actionMap.get("paste-from-clipboard").setEnabled(bl);
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.WARNING, "Failed to get clipboard state.", throwable);
                actionMap.get("PASTE_SPECIAL").setEnabled(true);
                actionMap.get("paste-from-clipboard").setEnabled(true);
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            this.reset();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.reset();
        }

        private void reset() {
            ActionMap actionMap = AbstractRCodingTextArea.this.getActionMap();
            actionMap.get("OPEN_OBJECT").setEnabled(true);
            actionMap.get("OPEN_HELP").setEnabled(true);
            actionMap.get("PASTE_SPECIAL").setEnabled(true);
            actionMap.get("paste-from-clipboard").setEnabled(true);
        }
    }

    private class AutoCompletionNotifier
    extends JWindow
    implements FocusListener,
    CaretListener,
    InputMethodListener,
    KeyListener {
        private static final String HIDE_NOTIFIER = "HIDE_NOTIFIER";
        private JLabel completion;
        private JLabel tip;
        private boolean enabled = true;
        private Map<KeyStroke, Object> oldInputMap = new HashMap<KeyStroke, Object>();

        public AutoCompletionNotifier() {
            this.completion = new JLabel();
            this.completion.setFont(AbstractRCodingTextArea.this.getFont());
            this.tip = new JLabel();
            this.setTipText(false);
            this.tip.setFont(new Font("Dialog", 0, this.completion.getFont().getSize()));
            this.tip.setForeground(Color.GRAY);
            this.tip.setHorizontalTextPosition(4);
            JPanel jPanel = new JPanel((LayoutManager)new MigLayout("flowy, insets 0 5 0 5, gap 0 0, hidemode 2"));
            jPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            jPanel.setBackground(Color.WHITE);
            this.completion.setForeground(new Color(65, 105, 225));
            jPanel.add((Component)this.completion, "wmax 500");
            jPanel.add(this.tip);
            this.getContentPane().add(jPanel);
            AbstractRCodingTextArea.this.getActionMap().put(HIDE_NOTIFIER, new HideNotifierAction());
        }

        private void setTipText(boolean bl) {
            String string = bl ? Messages.getString("CodingTextArea.autocomplete_notice_select") : Messages.getString("CodingTextArea.autocomplete_notice_show_list");
            String string2 = "Ctrl + Space";
            if (Platform.isMac()) {
                string2 = "Option + Space";
            } else if (Platform.isLinux()) {
                string2 = "Alt + /";
            }
            this.tip.setText(MessageFormat.format(string, string2));
        }

        public void showNotifier(List<Completion> list) {
            Object object;
            if (list.isEmpty()) {
                return;
            }
            if (AbstractRCodingTextArea.this.ac.isPopupVisible()) {
                return;
            }
            boolean bl = StringUtils.isEmpty((CharSequence)AbstractRCodingTextArea.this.ac.getCompletionProvider().getAlreadyEnteredText((JTextComponent)((Object)AbstractRCodingTextArea.this)));
            int n = 3;
            int n2 = Math.min(n, list.size());
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n2; ++i) {
                object = list.get(i);
                stringBuilder.append(object.getInputText());
                if (i == n2 - 1) continue;
                stringBuilder.append("   ");
            }
            if (list.size() > n) {
                stringBuilder.append("   ...");
            }
            this.completion.setText(stringBuilder.toString());
            this.setTipText(n2 == 1 && !bl);
            this.tip.setVisible(true);
            this.pack();
            InputMap inputMap = AbstractRCodingTextArea.this.getInputMap();
            object = KeyStroke.getKeyStroke(27, 0);
            this.oldInputMap.put((KeyStroke)object, inputMap.get((KeyStroke)object));
            inputMap.put((KeyStroke)object, HIDE_NOTIFIER);
            try {
                int n3;
                Rectangle rectangle = AbstractRCodingTextArea.this.modelToView(AbstractRCodingTextArea.this.getCaretPosition());
                Point point = rectangle.getLocation();
                SwingUtilities.convertPointToScreen(point, (Component)((Object)AbstractRCodingTextArea.this));
                Rectangle rectangle2 = UIUtility.getScreenBoundsForPoint(point.x, point.y, true);
                int n4 = point.x;
                if (n4 + this.getWidth() > rectangle2.x + rectangle2.width) {
                    n4 = rectangle2.x + rectangle2.width - this.getWidth();
                }
                if ((n3 = point.y + rectangle.height) + this.getHeight() > rectangle2.y + rectangle2.height) {
                    this.tip.setVisible(false);
                    this.pack();
                    if (n3 + this.getHeight() > rectangle2.y + rectangle2.height) {
                        n3 = point.y - this.getHeight();
                    }
                }
                this.setLocation(n4, n3);
                this.setVisible(true);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public void hideNotifier() {
            if (this.isVisible()) {
                InputMap inputMap = AbstractRCodingTextArea.this.getInputMap();
                KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
                if (AbstractRCodingTextArea.this.simplePopup && inputMap.get(keyStroke).equals(HIDE_NOTIFIER)) {
                    Object object = this.oldInputMap.get(keyStroke);
                    inputMap.put(keyStroke, object);
                }
                this.setVisible(false);
            }
        }

        public void setNotifierEnabled(boolean bl) {
            this.enabled = bl;
        }

        public boolean isNotifierEnabled() {
            int n = AbstractRCodingTextArea.this.getInputMethodRequests().getCommittedTextLength();
            return this.enabled && n == AbstractRCodingTextArea.this.getDocument().getLength();
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            this.hideNotifier();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            AbstractRCodingTextArea.this.hideAndKillNotifier();
        }

        @Override
        public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
            if (inputMethodEvent.isConsumed()) {
                return;
            }
            if (this.isNotifierEnabled()) {
                AbstractRCodingTextArea.this.requestAutoCompletionNotifier();
            }
        }

        @Override
        public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (this.enabled) {
                if ((keyEvent.getModifiersEx() | 0x40) != 64) {
                    return;
                }
                char c = keyEvent.getKeyChar();
                if (Character.getType(c) != 15 || c == '\b') {
                    AbstractRCodingTextArea.this.requestAutoCompletionNotifier();
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        private class HideNotifierAction
        extends LoggableAction {
            private HideNotifierAction() {
            }

            @Override
            public void action(ActionEvent actionEvent) {
                AutoCompletionNotifier.this.hideNotifier();
            }
        }
    }

    private class NotifyDispatcher
    implements Runnable {
        private boolean alive = true;
        private boolean waitAgain = false;

        public synchronized void reset() {
            this.waitAgain = true;
            this.notifyAll();
        }

        public synchronized void kill() {
            this.waitAgain = true;
            this.alive = false;
            this.notifyAll();
        }

        public synchronized boolean alive() {
            return this.alive;
        }

        @Override
        public void run() {
            while (this.alive) {
                this.doWait();
            }
        }

        private synchronized void doWait() {
            try {
                this.wait(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.waitAgain) {
                this.waitAgain = false;
            } else {
                this.alive = false;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractRCodingTextArea.this.showAutoCompletionNotifier();
                    }
                });
            }
        }
    }
}

