/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.script;

import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.script.PasteSpecial;
import com.ef_prime.rflow.ui.common.view.View;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class PasteSpecialView
extends View {
    private PasteSpecial pasteSpecial;
    private JComboBox<String> joinWith;
    private JComboBox<String> quote;
    private JCheckBox fullName;

    public PasteSpecialView(PasteSpecial pasteSpecial) {
        this.pasteSpecial = pasteSpecial;
        JLabel jLabel = new JLabel(Messages.getString("View.paste_special.join_with"));
        jLabel.setEnabled(pasteSpecial.getElementCount() > 1);
        this.joinWith = new JComboBox<String>(new String[]{", ", " + ", "\\n"});
        this.joinWith.setSelectedItem(", ");
        this.joinWith.setRenderer(new JoinWithRenderer());
        this.joinWith.setEnabled(pasteSpecial.getElementCount() > 1);
        JLabel jLabel2 = new JLabel(Messages.getString("View.paste_special.quote"));
        this.quote = new JComboBox<String>(new String[]{"", "\"", "`"});
        this.quote.setRenderer(new QuoteRenderer());
        this.quote.setSelectedItem("");
        JLabel jLabel3 = new JLabel(Messages.getString("View.paste_special.full_object_name"));
        jLabel3.setEnabled(pasteSpecial.isFullObjectNameSupported());
        this.fullName = new JCheckBox();
        this.fullName.setEnabled(pasteSpecial.isFullObjectNameSupported());
        this.setLayout((LayoutManager)new MigLayout(""));
        this.add(jLabel);
        this.add(this.joinWith, "w pref+10, wrap");
        this.add(jLabel2);
        this.add(this.quote, "w pref+10, wrap");
        this.add(jLabel3);
        this.add((Component)this.fullName, "wrap");
    }

    private String parseEscapse(String string) {
        string = string.replaceAll("\\\\t", "\t");
        string = string.replaceAll("\\\\n", "\n");
        return string;
    }

    public String getResult() {
        String string = this.parseEscapse(this.joinWith.getSelectedItem().toString());
        String string2 = this.parseEscapse(this.quote.getSelectedItem().toString());
        boolean bl = this.fullName == null ? false : this.fullName.isSelected();
        return this.pasteSpecial.joinWith(string, string2, bl);
    }

    public static String show(Component component, PasteSpecial pasteSpecial) {
        PasteSpecialView pasteSpecialView = new PasteSpecialView(pasteSpecial);
        int n = JOptionPane.showConfirmDialog(SwingUtilities.windowForComponent(component), pasteSpecialView, Messages.getString("View.paste_special.title"), 2, -1);
        if (n != 0) {
            return null;
        }
        return pasteSpecialView.getResult();
    }

    private class JoinWithRenderer
    extends DefaultListCellRenderer {
        private JoinWithRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            String string = null;
            if (object.equals(", ")) {
                string = Messages.getString("View.paste_special.comma");
            } else if (object.equals(" + ")) {
                string = Messages.getString("View.paste_special.plus");
            } else if (object.equals("\\n")) {
                string = Messages.getString("View.paste_special.newline");
            }
            if (string != null) {
                this.setText(this.getText() + " (" + string + ")");
            }
            return this;
        }
    }

    private class QuoteRenderer
    extends DefaultListCellRenderer {
        private QuoteRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            String string = null;
            if (object.equals("")) {
                string = Messages.getString("View.paste_special.no_quote");
            } else if (object.equals("\"")) {
                string = Messages.getString("View.paste_special.double_quote");
            } else if (object.equals("`")) {
                string = Messages.getString("View.paste_special.back_quote");
            }
            if (string != null) {
                this.setText(this.getText() + " (" + string + ")");
            }
            return this;
        }
    }
}

