/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.script;

import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.node.NodeBreakpointChangeListener;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.ui.app.r.script.AbstractRCodingTextArea;
import com.ef_prime.rflow.ui.app.r.script.SimpleCodingScrollPane;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.util.GraphicsUtility;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rtextarea.GutterIconInfo;
import org.fife.ui.rtextarea.IconRowHeader;
import org.fife.ui.rtextarea.RTextArea;

public class RCodingScrollPane
extends SimpleCodingScrollPane
implements NodeBreakpointChangeListener,
PropertyChangeListener {
    public static final Icon BREAKPOINT = GraphicsUtility.createCircleIcon(16, 3, Color.ORANGE);
    public static final Icon UNABLED_BREAKPOINT = GraphicsUtility.createCircleIcon(16, 3, Color.LIGHT_GRAY);
    private static final String PROPERTY_FONT = "font";
    private FlowNode node;
    private DefaultParserNotice errorNotice;
    private boolean lockBreakpointChanged;
    private ToggleBreakpointCoding toggleBreakpointCoding = new ToggleBreakpointCoding();

    public RCodingScrollPane(AbstractRCodingTextArea abstractRCodingTextArea, FlowNode flowNode) {
        super((RTextArea)abstractRCodingTextArea);
        this.node = flowNode;
        this.setIconRowHeaderEnabled(true);
        if (this.isBreakpointEnabled()) {
            this.getGutter().getIconArea().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (UIUtility.isLeftMouseButton(mouseEvent)) {
                        Point point = mouseEvent.getPoint();
                        try {
                            RCodingScrollPane.this.toggleBreakpoint(point);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        if (this.isBreakpointEnabled()) {
            this.updateBreakpointIcons();
        }
        this.updateErrorIcons();
        this.updateFont();
        abstractRCodingTextArea.addPropertyChangeListener("RSTA.parserNotices", this);
        abstractRCodingTextArea.addPropertyChangeListener(PROPERTY_FONT, this);
    }

    public void uninstall() {
        this.getTextArea().removePropertyChangeListener("RSTA.parserNotices", this);
        this.getTextArea().removePropertyChangeListener(PROPERTY_FONT, this);
    }

    public AbstractRCodingTextArea getTextArea() {
        return (AbstractRCodingTextArea)super.getTextArea();
    }

    private IconRowHeader getIconRowHeader() {
        return this.getGutter().getIconArea();
    }

    private boolean isBreakpointEnabled() {
        return this.node != null && this.getTextArea().isEditable();
    }

    public void updateErrorIcons() {
        ImageIcon imageIcon = FileResource.getIcon("img/error_16.png");
        if (this.errorNotice != null) {
            this.errorNotice = null;
            for (int i = 0; i < this.getTextArea().getLineCount(); ++i) {
                try {
                    Object object = this.getGutter().getIconArea().getTrackingIcons(i);
                    for (int j = 0; j < ((E)object).length; ++j) {
                        Icon icon = object[j].getIcon();
                        if (icon != imageIcon) continue;
                        this.getIconRowHeader().removeTrackingIcon(object[j]);
                    }
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        for (Object object : this.getTextArea().getParserNotices()) {
            if (!(object instanceof DefaultParserNotice)) continue;
            this.errorNotice = (DefaultParserNotice)object;
            if (!this.errorNotice.getLevel().isEqualToOrWorseThan(ParserNotice.Level.WARNING)) continue;
            try {
                this.getIconRowHeader().addOffsetTrackingIcon(this.getTextArea().getLineStartOffset(this.errorNotice.getLine()), (Icon)imageIcon, this.errorNotice.getMessage());
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void updateBreakpointIcons() {
        Icon icon;
        for (int i = 0; i < this.getTextArea().getLineCount(); ++i) {
            try {
                GutterIconInfo[] badLocationException = this.getGutter().getIconArea().getTrackingIcons(i);
                for (int badLocationException2 = 0; badLocationException2 < badLocationException.length; ++badLocationException2) {
                    icon = badLocationException[badLocationException2].getIcon();
                    if (icon != BREAKPOINT && icon != UNABLED_BREAKPOINT) continue;
                    this.getIconRowHeader().removeTrackingIcon((Object)badLocationException[badLocationException2]);
                }
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        for (Integer n : this.node.getModel().getBreakpoints()) {
            try {
                int n2 = Math.abs(n);
                icon = n > 0 ? BREAKPOINT : UNABLED_BREAKPOINT;
                this.getIconRowHeader().addOffsetTrackingIcon(this.getTextArea().getLineStartOffset(n2 - 1), icon);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public List<Integer> getBreakpoints() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        block2: for (int i = 0; i < this.getTextArea().getLineCount(); ++i) {
            try {
                GutterIconInfo[] gutterIconInfoArray = this.getGutter().getIconArea().getTrackingIcons(i);
                for (int j = 0; j < gutterIconInfoArray.length; ++j) {
                    if (gutterIconInfoArray[j].getIcon() == UNABLED_BREAKPOINT) {
                        arrayList.add(-(i + 1));
                        continue block2;
                    }
                    if (gutterIconInfoArray[j].getIcon() != BREAKPOINT) continue;
                    arrayList.add(i + 1);
                    continue block2;
                }
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public void toggleBreakpoint(Point point) throws BadLocationException {
        int n = this.getTextArea().viewToModel(point);
        int n2 = this.getTextArea().getLineOfOffset(n);
        this.toggleBreakpoint(n2);
    }

    public void toggleBreakpoint(int n) throws BadLocationException {
        Integer n2;
        if (this.node == null) {
            return;
        }
        List<Integer> list = this.node.getModel().getBreakpoints();
        int n3 = -1;
        for (int i = 0; i < list.size(); ++i) {
            n2 = Math.abs(list.get(i));
            if (!n2.equals(n + 1)) continue;
            n3 = i;
            break;
        }
        this.lockBreakpointChanged = true;
        GutterIconInfo[] gutterIconInfoArray = this.getGutter().getIconArea().getTrackingIcons(n);
        if (n3 >= 0 && gutterIconInfoArray.length > 0) {
            Icon icon;
            if (gutterIconInfoArray.length == 1 && ((icon = (n2 = gutterIconInfoArray[0]).getIcon()) == BREAKPOINT || icon == UNABLED_BREAKPOINT)) {
                this.getGutter().removeTrackingIcon((GutterIconInfo)n2);
                if (icon == BREAKPOINT) {
                    this.getGutter().addOffsetTrackingIcon(n2.getMarkedOffset(), UNABLED_BREAKPOINT);
                    list.set(n3, -Math.abs(list.get(n3)));
                    this.toggleBreakpointCoding.doAction("off");
                    FlowNode.fireNodeBreakpointChanged(this.node, 2, 1, false);
                } else if (icon == UNABLED_BREAKPOINT) {
                    list.remove(n3);
                    this.toggleBreakpointCoding.doAction("none");
                    FlowNode.fireNodeBreakpointChanged(this.node, 1, 0, false);
                }
            }
        } else if (gutterIconInfoArray.length == 0) {
            this.getIconRowHeader().addOffsetTrackingIcon(this.getTextArea().getLineStartOffset(n), BREAKPOINT);
            list.add(n + 1);
            Collections.sort(list, NodeModel.ABS_COMPARATOR);
            this.toggleBreakpointCoding.doAction("on");
            FlowNode.fireNodeBreakpointChanged(this.node, 0, 2, false);
        }
        this.lockBreakpointChanged = false;
        FlowNode.fireNodeModelChanged(this.node);
    }

    private void updateFont() {
        this.getGutter().setLineNumberFont(this.getTextArea().getFont());
    }

    @Override
    public void nodeBreakpointChanged(FlowNode flowNode, int n, int n2) {
        if (this.lockBreakpointChanged) {
            return;
        }
        if (this.node != flowNode) {
            return;
        }
        this.updateBreakpointIcons();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("RSTA.parserNotices".equals(propertyChangeEvent.getPropertyName())) {
            this.updateErrorIcons();
        } else if (PROPERTY_FONT.equals(propertyChangeEvent.getPropertyName())) {
            this.updateFont();
        }
    }

    private static class ToggleBreakpointCoding
    extends LoggableAction {
        private ToggleBreakpointCoding() {
        }

        @Override
        public void action(ActionEvent actionEvent) {
        }
    }
}

