/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.script;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandAdapter;
import com.ef_prime.rflow.core.app.r.console.CommandUtility;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.task.RCommandTask;
import com.ef_prime.rflow.core.task.Task;
import com.ef_prime.rflow.core.task.TaskQueue;
import com.ef_prime.rflow.ui.app.r.script.AbstractRCodingTextArea;
import com.ef_prime.rflow.ui.app.r.script.RCodingScrollPane;
import com.ef_prime.rflow.ui.app.r.script.RCodingTextAreaUI;
import com.ef_prime.rflow.ui.common.component.DisplayableListener;
import com.ef_prime.rflow.ui.util.FontSupport;
import java.awt.event.HierarchyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.fife.ui.rtextarea.RTextAreaUI;

public class RCodingTextArea
extends AbstractRCodingTextArea {
    private Consumer<Task> taskRunner;

    public RCodingTextArea() {
        this("");
    }

    public RCodingTextArea(String string) {
        super(R.getInterface(), string);
        this.refreshFont();
        this.addHierarchyListener(new DisplayableHandler());
        this.setLineWrap(Rflow.settings().getValue(Settings.R_EDITOR_LINE_WRAP));
        this.setAutoIndentEnabled(Rflow.settings().getValue(Settings.R_CODE_AUTO_INDENT));
        this.setMarkOccurrences(false);
        this.setMarkOccurrenceAfterFocus(true);
        this.setHyperlinksEnabled(false);
        this.setCaretTrace(true);
    }

    public void setTaskRunner(Consumer<Task> consumer) {
        this.taskRunner = consumer;
    }

    public Consumer<Task> getTaskRunner() {
        return this.taskRunner;
    }

    @Override
    protected RTextAreaUI createRTextAreaUI() {
        return new RCodingTextAreaUI((JComponent)((Object)this));
    }

    @Override
    protected void runScript(String string) {
        Command command = CommandUtility.getLineSeparatedCommand(this.getR().client(), string);
        if (command == null) {
            return;
        }
        command.addCommandListener(CommandUtility.objectUpdateListener(this.getR().client()));
        command.addCommandListener(new CommandAdapter(){

            @Override
            public void commandStart(Command command) {
                RCodingTextArea.this.getR().client().setDebugConstant_Wait(true);
            }

            @Override
            public void commandFinished(Command command) {
                this.debugOff();
            }

            @Override
            public void commandCanceled(Command command) {
                this.debugOff();
            }

            private void debugOff() {
                RCodingTextArea.this.getR().queryQueue().addQuery(new Runnable(){

                    @Override
                    public void run() {
                        RCodingTextArea.this.getR().client().setDebugConstant_Wait(false);
                    }
                });
            }
        });
        RCommandTask rCommandTask = new RCommandTask(FlowRunOption.createRunImmediatelyOption().setFocusResult(true), command);
        if (this.taskRunner == null) {
            TaskQueue.getInstance().addTask(rCommandTask);
        } else {
            this.taskRunner.accept(rCommandTask);
        }
    }

    @Override
    protected List<Integer> getBreakpoints() {
        if (this.getParent() != null && this.getParent().getParent() instanceof RCodingScrollPane) {
            RCodingScrollPane rCodingScrollPane = (RCodingScrollPane)((Object)this.getParent().getParent());
            return rCodingScrollPane.getBreakpoints();
        }
        return new ArrayList<Integer>();
    }

    protected RCodingScrollPane getCodingScrollPane() {
        if (this.getParent() != null && this.getParent().getParent() instanceof RCodingScrollPane) {
            RCodingScrollPane rCodingScrollPane = (RCodingScrollPane)((Object)this.getParent().getParent());
            return rCodingScrollPane;
        }
        return null;
    }

    protected void refreshFont() {
        this.setFont(FontSupport.getCodeFont());
    }

    private class DisplayableHandler
    extends DisplayableListener
    implements ValueChangeEventHandler {
        private DisplayableHandler() {
        }

        @Override
        protected void didBecomeDisplayable(HierarchyEvent hierarchyEvent) {
            Rflow.settings().removeEventHandler(this);
            Rflow.settings().addEventHandler(this);
        }

        @Override
        protected void didBecomeUndisplayable(HierarchyEvent hierarchyEvent) {
            Rflow.settings().removeEventHandler(this);
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            if (Settings.CODE_FONT_FAMILY.equals(valueChangeEvent.getKey()) || Settings.CODE_FONT_SIZE.equals(valueChangeEvent.getKey())) {
                RCodingTextArea.this.refreshFont();
            } else if (Settings.R_CODE_AUTO_INDENT.equals(valueChangeEvent.getKey())) {
                RCodingTextArea.this.setAutoIndentEnabled(Rflow.settings().getValue(Settings.R_CODE_AUTO_INDENT));
            }
        }
    }
}

