/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.script;

import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.script.RCodingScrollPane;
import com.ef_prime.rflow.ui.app.r.script.RCodingTextArea;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;

public class RCodingTextAreaEx
extends RCodingTextArea {
    private static final Logger LOGGER = Logger.getLogger(RCodingTextAreaEx.class.getName());
    private static String ESCAPE_ACTION_KEY = "ESCAPE_ACTION_KEY";
    private static String TOGGLE_BREAKPOINT = "TOGGLE_BREAKPOINT";
    private CodingActions actions;

    public RCodingTextAreaEx() {
        this.initEx();
    }

    public RCodingTextAreaEx(String string) {
        super(string);
        this.initEx();
    }

    private void initEx() {
        this.actions = new CodingActions();
        this.actions.installActions((JComponent)((Object)this), false, 1);
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = super.createPopupMenu();
        jPopupMenu.insert(this.actions.get(TOGGLE_BREAKPOINT), 6);
        return jPopupMenu;
    }

    private class CodingActions
    extends Actions {
        public CodingActions() {
            this.put(ESCAPE_ACTION_KEY, new Escape());
            this.put(TOGGLE_BREAKPOINT, new ToggleBreakpoint());
        }

        private class Escape
        extends LoggableAction {
            public Escape() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, 0));
            }

            @Override
            public void action(ActionEvent actionEvent) {
            }
        }

        private class ToggleBreakpoint
        extends LoggableAction {
            public ToggleBreakpoint() {
                this.putValue("Name", Messages.getString("CodingTextArea.toggle_breakpoint"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                RCodingScrollPane rCodingScrollPane = RCodingTextAreaEx.this.getCodingScrollPane();
                if (rCodingScrollPane == null) {
                    return;
                }
                int n = RCodingTextAreaEx.this.getCaretPosition();
                int n2 = RCodingTextAreaEx.this.getDocument().getDefaultRootElement().getElementIndex(n);
                try {
                    rCodingScrollPane.toggleBreakpoint(n2);
                }
                catch (BadLocationException badLocationException) {
                    LOGGER.log(Level.SEVERE, "Failed to toggle a breakpoint.", badLocationException);
                }
            }
        }
    }
}

