/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.script;

import com.ef_prime.rflow.core.app.r.base.ArgEntry;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RObjectNameSet;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.script.RCompletion;
import com.ef_prime.rflow.ui.app.r.script.RCompletionAddOn;
import com.ef_prime.rflow.ui.app.r.script.RScriptUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.autocomplete.DescriptionListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.Token;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;

public class RCompletionProvider
extends DefaultCompletionProvider {
    public static final String EMPTY_MARK = "";
    private static final char[] non = new char[]{'#', '\"', '\'', '%', '`', '<', '-', '>', '!', '=', '&', '|', '{', '}', '(', ')', '[', ']', '?', '*', '+', '/', '^', '~', ' ', '\t', '\f', '\n', ',', '\\'};
    private static final TreeSet<Character> nonSet = new TreeSet();
    private RCompletionAddOn addOn;
    private String function;
    private org.jsoup.nodes.Element functionHtml;
    private Map<String, Integer> argMap;

    public RCompletionProvider() {
        this.setListCellRenderer((ListCellRenderer)((Object)new RCompletionListCellRenderer()));
    }

    public void setPriorityList(RCompletionAddOn rCompletionAddOn) {
        this.addOn = rCompletionAddOn;
    }

    protected boolean isValidChar(char c) {
        return !nonSet.contains(Character.valueOf(c));
    }

    public String getAlreadyEnteredText(JTextComponent jTextComponent) {
        String string = super.getAlreadyEnteredText(jTextComponent);
        if (string.isEmpty()) {
            string = EMPTY_MARK;
        }
        return string;
    }

    public List<Completion> getCompletions(JTextComponent jTextComponent, boolean bl) {
        List<Completion> list = this.getCompletionsImpl(jTextComponent, bl);
        if (this.getParent() != null) {
            list.addAll(this.getParent().getCompletions(jTextComponent));
            Collections.sort(list);
        }
        Collections.sort(list, sortByRelevanceComparator);
        return list;
    }

    protected List<Completion> getCompletionsImpl(JTextComponent jTextComponent) {
        return this.getCompletionsImpl(jTextComponent, true);
    }

    public List<Completion> getCompletionsImpl(JTextComponent jTextComponent, boolean bl) {
        RScriptUtility.CurrentFunctionInfo currentFunctionInfo;
        int n;
        Object object3;
        RObjectNameSet rObjectNameSet;
        Object object22;
        this.function = null;
        this.functionHtml = null;
        this.argMap = null;
        String string = this.getAlreadyEnteredText(jTextComponent);
        String string2 = string.toLowerCase();
        boolean bl2 = string.equals(EMPTY_MARK);
        Token token = this.getCurrentLineToken(jTextComponent);
        ArrayList<Completion> arrayList = new ArrayList<Completion>();
        if (this.addOn != null) {
            int n2 = 1000000;
            for (Object object22 : this.addOn.getCompletions((CompletionProvider)this)) {
                if (!object22.getReplacementText().toLowerCase().startsWith(string2)) continue;
                object22.setRelevance(n2--);
                arrayList.add((Completion)object22);
            }
            if (this.addOn.isExclusive()) {
                return arrayList;
            }
        }
        if ((bl || !string.isEmpty()) && (rObjectNameSet = R.client().supportList(string)) != null) {
            arrayList.ensureCapacity(arrayList.size() + rObjectNameSet.getLength());
            boolean bl3 = false;
            try {
                int n3 = jTextComponent.getCaretPosition() - string.length();
                object3 = jTextComponent.getDocument().getText(n3 - 1, 1);
                if (object3.equals("?")) {
                    bl3 = true;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            for (Object object3 : rObjectNameSet) {
                arrayList.add((Completion)new FunctionCompletion((CompletionProvider)this, object3.getName(), object3.getSearchName(), object3.getSearchIndex(), bl3, string));
            }
            if (!string.isEmpty() && string.indexOf(36) < 0 && string.indexOf(58) < 0) {
                object22 = R.client().getInstalledPackages();
                object3 = object22;
                int n4 = ((String[])object3).length;
                for (n = 0; n < n4; ++n) {
                    String string3 = object3[n];
                    if (!string3.toLowerCase().startsWith(string2)) continue;
                    arrayList.add((Completion)new PackageCompletion((CompletionProvider)this, string3 + "::", string3));
                }
            }
        }
        if ((currentFunctionInfo = RScriptUtility.getCurrentFunction(token, jTextComponent.getCaretPosition())) != null) {
            int n5 = 10;
            if (currentFunctionInfo.getArgs().size() > 0) {
                object22 = ((ArgEntry)currentFunctionInfo.getArgs().get(0)).getValue();
                if (R.client().isDataframe((String)object22)) {
                    String[] stringArray = object3 = R.client().names((String)object22, true, null);
                    n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String string4 = stringArray[i];
                        if (string4 == null || !bl2 && !string4.toLowerCase().startsWith(string2)) continue;
                        FunctionCompletion functionCompletion = new FunctionCompletion((CompletionProvider)this, string4, (String)object22, 0, true, string);
                        arrayList.add((Completion)functionCompletion);
                        functionCompletion.setRelevance(n5);
                    }
                }
            }
            if (!currentFunctionInfo.isParamterValuePosition()) {
                this.function = currentFunctionInfo.getFunctionFullName();
                object22 = R.client().argList(this.function);
                if (object22 != null) {
                    for (int i = 0; i < ((Vector)object22).size(); ++i) {
                        ArgEntry argEntry = (ArgEntry)((Vector)object22).get(i);
                        if (!argEntry.isParam()) continue;
                        int n6 = n = currentFunctionInfo.getArgs().getIndexOfParam(argEntry.getParam()) >= 0 ? 1 : 0;
                        if (n != 0 || !bl2 && !argEntry.getParam().toLowerCase().startsWith(string2)) continue;
                        ArgCompletion argCompletion = new ArgCompletion((CompletionProvider)this, argEntry);
                        argCompletion.setRelevance(n5 + ((Vector)object22).size() - i);
                        arrayList.add((Completion)argCompletion);
                    }
                }
            }
        }
        return arrayList;
    }

    private Token getCurrentLineToken(JTextComponent jTextComponent) {
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)jTextComponent.getDocument();
        Element element = rSyntaxDocument.getDefaultRootElement();
        int n = element.getElementIndex(jTextComponent.getCaretPosition());
        return rSyntaxDocument.getTokenListForLine(n);
    }

    private void enableHtml(Document document) {
        for (org.jsoup.nodes.Element element : document.head().children()) {
            if (!element.tagName().equals("meta")) continue;
            element.remove();
        }
    }

    static {
        for (char c : non) {
            nonSet.add(Character.valueOf(c));
        }
    }

    private static class RCompletionListCellRenderer
    extends SubstanceDefaultListCellRenderer {
        private Font font = new Font("Monospaced", 0, 12);
        private Border padding = new EmptyBorder(0, 2, 0, 0);

        private String colorToHex(Color color) {
            return Integer.toHexString(color.getRGB() & 0xFFFFFF);
        }

        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (object instanceof FunctionCompletion || object instanceof PackageCompletion) {
                RCompletion rCompletion = (RCompletion)((Object)object);
                String string = bl ? this.colorToHex(this.getForeground()) : "#a9a9a9";
                String string2 = StringUtils.rightPad((String)rCompletion.getInputText(), (int)16);
                string2 = StringEscapeUtils.escapeHtml4((String)string2);
                string2 = string2.replaceAll(" ", "&#160;");
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<html>");
                stringBuilder.append(string2);
                stringBuilder.append("<font color='");
                stringBuilder.append(string);
                stringBuilder.append("'>{");
                stringBuilder.append(rCompletion.getShortDescription());
                stringBuilder.append("}</font></html>");
                this.setText(stringBuilder.toString());
            } else if (object instanceof ArgCompletion) {
                ArgCompletion argCompletion = (ArgCompletion)((Object)object);
                ArgEntry argEntry = argCompletion.getArgEntry();
                if (bl) {
                    this.setText(argEntry.getParam() + " = " + argEntry.getValue());
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("<html>");
                    stringBuilder.append(StringEscapeUtils.escapeHtml4((String)argEntry.getParam()));
                    stringBuilder.append(" = ");
                    stringBuilder.append("<font color='#a9a9a9'>");
                    stringBuilder.append(StringEscapeUtils.escapeHtml4((String)argEntry.getValue()));
                    stringBuilder.append("</font></html>");
                    this.setText(stringBuilder.toString());
                }
            }
            this.setFont(this.font);
            this.setBorder(new CompoundBorder(this.getBorder(), this.padding));
            return this;
        }
    }

    private class FunctionCompletion
    extends RCompletion {
        private int pos;
        private boolean notFunction;
        private String alreadyEntered;
        private Boolean isFunction;

        public FunctionCompletion(CompletionProvider completionProvider, String string, String string2, int n, boolean bl, String string3) {
            super(completionProvider, string, string2);
            this.pos = n;
            this.notFunction = bl;
            this.alreadyEntered = string3;
        }

        private boolean isGlobal() {
            return this.pos == 1;
        }

        @Override
        public boolean isFunction() {
            if (this.notFunction) {
                return false;
            }
            if (this.isFunction == null) {
                Object object = this.getReplacementText();
                String string = this.replacePart(this.alreadyEntered);
                if (string.length() != this.alreadyEntered.length()) {
                    object = this.alreadyEntered.substring(0, this.alreadyEntered.length() - string.length()) + (String)object;
                } else if (!this.isGlobal() && this.getShortDescription() != null && !this.getShortDescription().isEmpty()) {
                    object = this.getShortDescription() + ":::" + (String)object;
                }
                this.isFunction = R.client().isFunction((String)object);
            }
            return this.isFunction;
        }

        public String getSummary() {
            String string = R.client().getHtmlHelp(this.getReplacementText(), false);
            if (string == null || string.isEmpty()) {
                return RCompletionProvider.EMPTY_MARK;
            }
            Document document = Jsoup.parse((String)string);
            RCompletionProvider.this.enableHtml(document);
            return document.outerHtml();
        }

        @Override
        public int compareTo(Completion completion) {
            if (completion instanceof FunctionCompletion) {
                FunctionCompletion functionCompletion = (FunctionCompletion)completion;
                if (this.isGlobal()) {
                    if (!functionCompletion.isGlobal()) {
                        return -1;
                    }
                } else if (functionCompletion.isGlobal()) {
                    return 1;
                }
            }
            return super.compareTo(completion);
        }
    }

    private class PackageCompletion
    extends RCompletion {
        public PackageCompletion(CompletionProvider completionProvider, String string, String string2) {
            super(completionProvider, string, string2);
        }
    }

    private class ArgCompletion
    extends RCompletion
    implements DescriptionListener {
        private ArgEntry arg;

        public ArgCompletion(CompletionProvider completionProvider, ArgEntry argEntry) {
            super(completionProvider, argEntry.getParam() + " = ");
            this.arg = argEntry;
        }

        public ArgEntry getArgEntry() {
            return this.arg;
        }

        public String getInputText() {
            return super.getReplacementText();
        }

        public String getReplacementText() {
            String string = super.getReplacementText();
            if (string.startsWith("...")) {
                return RCompletionProvider.EMPTY_MARK;
            }
            return string;
        }

        public String getShortDescription() {
            return "args";
        }

        public void descriptionDidSet(JEditorPane jEditorPane) {
            RChoiceProvider.scrollToArg(jEditorPane, this.arg.getParam(), RCompletionProvider.this.argMap);
        }

        public String getSummary() {
            if (RCompletionProvider.this.function == null) {
                return RCompletionProvider.EMPTY_MARK;
            }
            if (RCompletionProvider.this.functionHtml == null) {
                RCompletionProvider.this.argMap = new HashMap<String, Integer>();
                RCompletionProvider.this.functionHtml = RChoiceProvider.getFunctionHelp(R.client(), RCompletionProvider.this.function, RCompletionProvider.this.argMap);
            }
            return RCompletionProvider.this.functionHtml == null ? RCompletionProvider.EMPTY_MARK : RCompletionProvider.this.functionHtml.outerHtml();
        }
    }
}

