/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.script;

import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.ui.app.r.script.PasteSpecial;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RObjectPasteSpecial
implements PasteSpecial {
    private List<RObject> objects;

    public RObjectPasteSpecial(List<RObject> list) {
        this.objects = list;
    }

    private List<String> getNames(boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>(this.objects.size());
        for (RObject rObject : this.objects) {
            arrayList.add(bl ? rObject.getFullName() : rObject.getName(bl2));
        }
        return arrayList;
    }

    @Override
    public int getElementCount() {
        return this.objects.size();
    }

    @Override
    public String joinWith(String string, String string2, boolean bl) {
        if (string2.isEmpty()) {
            return StringUtils.join(this.getNames(bl, true), (String)string);
        }
        List<String> list = this.getNames(bl, false);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, string2 + list.get(i) + string2);
        }
        return StringUtils.join(list, (String)string);
    }

    @Override
    public String columnSelection() {
        if (!this.isSiblings()) {
            return null;
        }
        RObject rObject = this.objects.get(0).getParent();
        if (!rObject.getClas().equals("data.frame")) {
            return null;
        }
        return rObject.getFullName() + "[,c(" + this.joinWith(", ", "\"", false) + ")]";
    }

    private boolean isSiblings() {
        if (this.objects.size() == 1) {
            return false;
        }
        RObject rObject = this.objects.get(0).getParent();
        if (rObject == null) {
            return false;
        }
        for (int i = 1; i < this.objects.size(); ++i) {
            if (rObject.equals(this.objects.get(i).getParent())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFullObjectNameSupported() {
        return true;
    }

    @Override
    public boolean isColumnSelectionSupported() {
        return true;
    }
}

