/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.app.r.script;

import com.ef_prime.rflow.core.app.r.base.ArgEntry;
import com.ef_prime.rflow.core.app.r.base.ArgList;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.SentenceInfo;
import com.ef_prime.rflow.core.app.r.script.RSyntaxDocumentWithIndentChanged;
import com.ef_prime.rflow.core.app.r.script.RTokenMaker;
import com.ef_prime.rflow.ui.app.r.script.AbstractRCodingTextArea;
import com.ef_prime.rflow.ui.app.r.script.SimpleCodingScrollPane;
import com.ef_prime.rflow.ui.common.component.CodingSearchBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.ErrorStrip;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rtextarea.RTextArea;

public class RScriptUtility {
    private static final Logger LOGGER = Logger.getLogger(RScriptUtility.class.getName());
    public static final RTokenMaker RTOKENMAKER = new RTokenMaker();
    private static Segment charSegment = new Segment();

    public static Token getTokenList(String string) {
        Segment segment = new Segment(string.toCharArray(), 0, string.length());
        return RTOKENMAKER.getTokenList(segment, 0, 0);
    }

    public static CurrentFunctionInfo getCurrentFunction(Token token, int n) {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        Token token2 = token;
        while (!RScriptUtility.isEndToken(token2) && token2.getOffset() + token2.length() <= n) {
            arrayList.add(token2);
            token2 = token2.getNextToken();
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Token token3;
            Token token4 = (Token)arrayList.get(i);
            if (token4.getType() != 8) continue;
            int n2 = -1;
            for (int j = i + 1; j < arrayList.size(); ++j) {
                Token token5 = (Token)arrayList.get(j);
                if (token5.isWhitespace()) continue;
                if (!token5.isSingleChar('(')) break;
                n2 = j + 1;
                break;
            }
            if (n2 < 0) {
                return null;
            }
            ArrayDeque<Character> arrayDeque = new ArrayDeque<Character>();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int j = n2; j < arrayList.size(); ++j) {
                token3 = (Token)arrayList.get(j);
                if (!arrayDeque.isEmpty()) {
                    if (token3.isSingleChar(((Character)arrayDeque.peek()).charValue())) {
                        arrayDeque.pop();
                        continue;
                    }
                    RScriptUtility.checkBlockStart(token3, arrayDeque);
                    continue;
                }
                if (token3.isWhitespace()) continue;
                if (!bl) {
                    if (token3.getType() == 22 && !token3.isSingleChar('(') && !token3.isSingleChar('{')) {
                        if (!token3.isSingleChar(')')) break;
                        bl3 = true;
                        break;
                    }
                    bl = true;
                    continue;
                }
                if (token3.isSingleChar(',')) {
                    bl = false;
                    bl2 = false;
                    continue;
                }
                if (bl2) {
                    if (token3.isSingleChar(')')) {
                        bl3 = true;
                        break;
                    }
                    RScriptUtility.checkBlockStart(token3, arrayDeque);
                    continue;
                }
                if (token3.isSingleChar('=')) {
                    bl2 = true;
                    continue;
                }
                if (token3.isSingleChar(')')) {
                    bl3 = true;
                    break;
                }
                RScriptUtility.checkBlockStart(token3, arrayDeque);
            }
            if (bl3) continue;
            String string = null;
            if (i > 1 && ((token3 = (Token)arrayList.get(i - 1)).is(23, "::") || token3.is(23, ":::")) && ((Token)arrayList.get(i - 2)).getType() == 20) {
                string = ((Token)arrayList.get(i - 2)).getLexeme() + token3.getLexeme();
            }
            return new CurrentFunctionInfo(string, token4, bl2, RScriptUtility.getArgList(token4));
        }
        return null;
    }

    public static ArgList getArgList(Token token) {
        ArgEntry argEntry;
        ArgList argList = new ArgList();
        Token token2 = token.getNextToken();
        while (!RScriptUtility.isEndToken(token2)) {
            if (token2.isWhitespace()) {
                token2 = token2.getNextToken();
                continue;
            }
            if (token2.isSingleChar('(')) {
                token2 = token2.getNextToken();
                break;
            }
            return argList;
        }
        StringBuilder stringBuilder = null;
        StringBuilder stringBuilder2 = null;
        ArrayDeque<Character> arrayDeque = new ArrayDeque<Character>();
        while (!RScriptUtility.isEndToken(token2)) {
            if (!arrayDeque.isEmpty()) {
                if (stringBuilder2 == null) {
                    stringBuilder.append(token2.getLexeme());
                } else {
                    stringBuilder2.append(token2.getLexeme());
                }
                if (token2.isSingleChar(((Character)arrayDeque.peek()).charValue())) {
                    arrayDeque.pop();
                } else {
                    RScriptUtility.checkBlockStart(token2, arrayDeque);
                }
            } else if (!token2.isWhitespace()) {
                if (stringBuilder == null) {
                    if (token2.getType() == 22 && !token2.isSingleChar('(') && !token2.isSingleChar('{')) {
                        if (!token2.isSingleChar(')')) break;
                        stringBuilder = new StringBuilder();
                        break;
                    }
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(token2.getLexeme());
                } else if (token2.isSingleChar(',')) {
                    argEntry = new ArgEntry(stringBuilder2 == null ? "" : stringBuilder.toString(), stringBuilder2 == null ? stringBuilder.toString() : stringBuilder2.toString());
                    argList.add(argEntry);
                    stringBuilder = null;
                    stringBuilder2 = null;
                } else if (stringBuilder2 != null) {
                    if (token2.isSingleChar(')')) break;
                    stringBuilder2.append(token2.getLexeme());
                    RScriptUtility.checkBlockStart(token2, arrayDeque);
                } else if (token2.isSingleChar('=')) {
                    stringBuilder2 = new StringBuilder();
                } else {
                    if (token2.isSingleChar(')')) break;
                    stringBuilder.append(token2.getLexeme());
                    RScriptUtility.checkBlockStart(token2, arrayDeque);
                }
            }
            token2 = token2.getNextToken();
        }
        if (stringBuilder != null) {
            argEntry = new ArgEntry(stringBuilder2 == null ? "" : stringBuilder.toString(), stringBuilder2 == null ? stringBuilder.toString() : stringBuilder2.toString());
            argList.add(argEntry);
        }
        return argList;
    }

    private static boolean isEndToken(Token token) {
        if (token == null) {
            return true;
        }
        switch (token.getType()) {
            case 0: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return true;
            }
        }
        return false;
    }

    private static void checkBlockStart(Token token, Deque<Character> deque) {
        if (token.isSingleChar('(')) {
            deque.push(Character.valueOf(')'));
        } else if (token.isSingleChar('[')) {
            deque.push(Character.valueOf(']'));
        } else if (token.isSingleChar('{')) {
            deque.push(Character.valueOf('}'));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void correctIndentation(RSyntaxTextArea rSyntaxTextArea) throws BadLocationException {
        int n = rSyntaxTextArea.getTabSize();
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rSyntaxTextArea.getDocument();
        Element element = rSyntaxDocument.getDefaultRootElement();
        int n2 = element.getElementIndex(rSyntaxTextArea.getSelectionStart());
        int n3 = element.getElementIndex(rSyntaxTextArea.getSelectionEnd());
        BlockStack blockStack = new BlockStack();
        rSyntaxTextArea.beginAtomicEdit();
        try {
            for (int i = n2; i <= n3; ++i) {
                Token token;
                if (i == n2) {
                    Token token2;
                    if (i == 0) {
                        token = rSyntaxDocument.getTokenListForLine(i);
                        RScriptUtility.removeLeadingSpaces((Document)rSyntaxDocument, token);
                        blockStack.updateToEndOfLine(token);
                        continue;
                    }
                    token = null;
                    if (i >= 2 && (token2 = rSyntaxDocument.getTokenListForLine(i - 2).getLastNonCommentNonWhitespaceToken()) != null) {
                        token = new TokenImpl(token2);
                    }
                    token2 = rSyntaxDocument.getTokenListForLine(i - 1);
                    blockStack.initIndentCount(token2, token, n);
                    blockStack.updateToEndOfLine(token2);
                }
                if ((token = rSyntaxDocument.getTokenListForLine(i)).getType() == 0) {
                    var9_9 = element.getElement(i).getStartOffset();
                    rSyntaxDocument.insertString(var9_9, RScriptUtility.getIndent(blockStack.getIndentCount()), null);
                } else {
                    var9_9 = token.getOffset();
                    blockStack.updateToBeginingOfLine(token);
                    RScriptUtility.removeLeadingSpaces((Document)rSyntaxDocument, token);
                    rSyntaxDocument.insertString(var9_9, RScriptUtility.getIndent(blockStack.getIndentCount()), null);
                }
                token = rSyntaxDocument.getTokenListForLine(i);
                blockStack.updateToEndOfLine(token);
            }
        }
        finally {
            rSyntaxTextArea.endAtomicEdit();
        }
    }

    private static void removeLeadingSpaces(Document document, Token token) throws BadLocationException {
        Token token2;
        if (token.getType() == 0) {
            return;
        }
        Token token3 = null;
        for (token2 = token; token2 != null && token2.isWhitespace(); token2 = token2.getNextToken()) {
            token3 = token2;
        }
        if (token2 == null) {
            return;
        }
        if (token2.getType() == 0) {
            document.remove(token.getOffset(), token3.getOffset() + token3.length() - token.getOffset());
        } else {
            document.remove(token.getOffset(), token2.getOffset() - token.getOffset());
        }
    }

    private static int countIndent(Token token, int n) {
        if (token.getType() == 0) {
            return 0;
        }
        int n2 = 0;
        for (Token token2 = token; token2 != null && token2.isWhitespace(); token2 = token2.getNextToken()) {
            for (int i = 0; i < token2.length(); ++i) {
                char c = token2.getTextArray()[token2.getTextOffset() + i];
                if (c == '\t') {
                    n2 += n;
                    continue;
                }
                ++n2;
            }
        }
        return n2 / n;
    }

    private static String getIndent(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('\t');
        }
        return stringBuilder.toString();
    }

    public static Segment tokenToSegment(Token token) {
        return new Segment(token.getTextArray(), token.getTextOffset(), token.length());
    }

    public static RSyntaxDocument createDocument() {
        return new RSyntaxDocumentWithIndentChanged("RSYNTAX");
    }

    public static RSyntaxDocument copyDocument(Document document) {
        RSyntaxDocument rSyntaxDocument = RScriptUtility.createDocument();
        try {
            rSyntaxDocument.insertString(0, document.getText(0, document.getLength()), null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return rSyntaxDocument;
    }

    public static String documentToString(Document document) {
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public static String tabToSpace(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder((int)((double)string.length() * 1.5));
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\t') {
                int n3 = n2;
                n2 += n;
                n2 -= n2 % n;
                int n4 = n2 - n3;
                for (int j = 0; j < n4; ++j) {
                    stringBuilder.append(' ');
                }
                continue;
            }
            if (c == '\n') {
                stringBuilder.append(c);
                n2 = 0;
                continue;
            }
            stringBuilder.append(c);
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static JPanel createScriptPane(AbstractRCodingTextArea abstractRCodingTextArea) {
        SimpleCodingScrollPane simpleCodingScrollPane = new SimpleCodingScrollPane((RTextArea)abstractRCodingTextArea);
        CodingSearchBar codingSearchBar = new CodingSearchBar(abstractRCodingTextArea);
        ErrorStrip errorStrip = RScriptUtility.createErrorStrip(abstractRCodingTextArea);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)((Object)simpleCodingScrollPane), "Center");
        jPanel.add((Component)codingSearchBar, "South");
        jPanel.add((Component)errorStrip, "East");
        return jPanel;
    }

    public static ErrorStrip createErrorStrip(RSyntaxTextArea rSyntaxTextArea) {
        ErrorStrip errorStrip = new ErrorStrip(rSyntaxTextArea);
        errorStrip.setFollowCaret(false);
        errorStrip.setLevelThreshold(ParserNotice.Level.INFO);
        return errorStrip;
    }

    public static String toNullModel(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (Token token = RScriptUtility.getTokenList(string); token != null; token = token.getNextToken()) {
            if (bl) continue;
            if (token.getType() == 23 && token.isSingleChar('~')) {
                bl = true;
                continue;
            }
            stringBuilder.append(token.getLexeme());
        }
        stringBuilder.append("~ 1");
        return stringBuilder.toString();
    }

    public static SentenceInfo retrieveSentenceInfo(String string) {
        SentenceInfo[] sentenceInfoArray = R.client().parseToNodes(string, false);
        if (sentenceInfoArray == null || sentenceInfoArray.length != 1) {
            return null;
        }
        return sentenceInfoArray[0];
    }

    public static String getSentence(String string) {
        SentenceInfo sentenceInfo = RScriptUtility.retrieveSentenceInfo(string);
        if (sentenceInfo == null) {
            return string;
        }
        if (sentenceInfo.isAssign()) {
            String string2 = string.substring(sentenceInfo.getSymbol().length(), string.length());
            string2 = string2.substring((string2 = string2.trim()).charAt(0) == '=' ? 1 : 2, string2.length());
            return string2.trim();
        }
        return string;
    }

    public static int getMatchingBracketPosition(RSyntaxTextArea rSyntaxTextArea, int n, char c, char c2) {
        try {
            if (n > -1) {
                boolean bl;
                int n2;
                int n3;
                Element element;
                int n4;
                Element element2;
                Token token = null;
                RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rSyntaxTextArea.getDocument();
                switch (c) {
                    case '(': 
                    case '[': 
                    case '{': {
                        element2 = rSyntaxDocument.getDefaultRootElement();
                        n4 = element2.getElementIndex(n);
                        element = element2.getElement(n4);
                        n3 = element.getStartOffset();
                        n2 = element.getEndOffset();
                        bl = true;
                        break;
                    }
                    case ')': 
                    case ']': 
                    case '}': {
                        element2 = rSyntaxDocument.getDefaultRootElement();
                        n4 = element2.getElementIndex(n);
                        element = element2.getElement(n4);
                        n3 = element.getStartOffset();
                        n2 = element.getEndOffset();
                        bl = false;
                        break;
                    }
                    default: {
                        return -1;
                    }
                }
                if (bl) {
                    int n5 = element2.getElementCount();
                    n3 = n + 1;
                    int n6 = 0;
                    boolean bl2 = false;
                    while (true) {
                        int n7;
                        rSyntaxDocument.getText(n3, n2 - n3, charSegment);
                        for (int i = n7 = RScriptUtility.charSegment.offset; i < n7 + RScriptUtility.charSegment.count; ++i) {
                            int n8;
                            char c3 = RScriptUtility.charSegment.array[i];
                            if (c3 == c) {
                                if (!bl2) {
                                    token = rSyntaxDocument.getTokenListForLine(n4);
                                    bl2 = true;
                                }
                                if ((token = RSyntaxUtilities.getTokenAtOffset((Token)token, (int)(n8 = n3 + (i - n7)))).getType() != 22) continue;
                                ++n6;
                                continue;
                            }
                            if (c3 != c2) continue;
                            if (!bl2) {
                                token = rSyntaxDocument.getTokenListForLine(n4);
                                bl2 = true;
                            }
                            if ((token = RSyntaxUtilities.getTokenAtOffset((Token)token, (int)(n8 = n3 + (i - n7)))).getType() != 22) continue;
                            if (n6 == 0) {
                                if (rSyntaxTextArea.isCodeFoldingEnabled() && rSyntaxTextArea.getFoldManager().isLineHidden(n4)) {
                                    return -1;
                                }
                                return n8;
                            }
                            --n6;
                        }
                        if (++n4 == n5) {
                            return -1;
                        }
                        bl2 = false;
                        element = element2.getElement(n4);
                        n3 = element.getStartOffset();
                        n2 = element.getEndOffset();
                    }
                }
                n2 = n;
                int n9 = 0;
                boolean bl3 = false;
                while (true) {
                    int n10;
                    rSyntaxDocument.getText(n3, n2 - n3, charSegment);
                    int n11 = RScriptUtility.charSegment.offset;
                    for (int i = n10 = n11 + RScriptUtility.charSegment.count - 1; i >= n11; --i) {
                        int n12;
                        Token token2;
                        char c4 = RScriptUtility.charSegment.array[i];
                        if (c4 == c) {
                            if (!bl3) {
                                token = rSyntaxDocument.getTokenListForLine(n4);
                                bl3 = true;
                            }
                            if ((token2 = RSyntaxUtilities.getTokenAtOffset((Token)token, (int)(n12 = n3 + (i - n11)))).getType() != 22) continue;
                            ++n9;
                            continue;
                        }
                        if (c4 != c2) continue;
                        if (!bl3) {
                            token = rSyntaxDocument.getTokenListForLine(n4);
                            bl3 = true;
                        }
                        if ((token2 = RSyntaxUtilities.getTokenAtOffset((Token)token, (int)(n12 = n3 + (i - n11)))).getType() != 22) continue;
                        if (n9 == 0) {
                            return n12;
                        }
                        --n9;
                    }
                    if (--n4 == -1) {
                        return -1;
                    }
                    bl3 = false;
                    element = element2.getElement(n4);
                    n3 = element.getStartOffset();
                    n2 = element.getEndOffset();
                }
            }
        }
        catch (BadLocationException badLocationException) {
            LOGGER.log(Level.WARNING, "Failed to get matching bracket position.", badLocationException);
        }
        return -1;
    }

    public static class CurrentFunctionInfo {
        private String namespace;
        private Token function;
        private boolean paramterValuePosition;
        private ArgList args;

        public CurrentFunctionInfo(String string, Token token, boolean bl, ArgList argList) {
            this.namespace = string;
            this.function = token;
            this.paramterValuePosition = bl;
            this.args = argList;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public boolean isNamespace() {
            return this.namespace != null && !this.namespace.isEmpty();
        }

        public Token getFunction() {
            return this.function;
        }

        public String getFunctionFullName() {
            return this.isNamespace() ? this.namespace + this.function.getLexeme() : this.function.getLexeme();
        }

        public boolean isParamterValuePosition() {
            return this.paramterValuePosition;
        }

        public ArgList getArgs() {
            return this.args;
        }
    }

    private static class BlockStack {
        private int indentCount;
        private int tempIndentCount;
        private Deque<Character> blockStack = new ArrayDeque<Character>();
        private Deque<Integer> indented = new ArrayDeque<Integer>();

        private BlockStack() {
        }

        public int getIndentCount() {
            return this.indentCount + this.tempIndentCount;
        }

        public boolean isEmpty() {
            return this.blockStack.isEmpty();
        }

        public void initIndentCount(Token token, Token token2, int n) {
            this.indentCount = RScriptUtility.countIndent(token, n) - this.getTempIndentCount(token2);
        }

        public void updateToBeginingOfLine(Token token) {
            this.indentCount -= this.checkLeadingClosingBlock(token);
            if (this.indentCount < 0) {
                this.indentCount = 0;
            }
        }

        public void updateToEndOfLine(Token token) {
            this.indentCount += this.collectBlocks(token, true);
            if (this.indentCount < 0) {
                this.indentCount = 0;
            }
            this.tempIndentCount = this.getTempIndentCount(token.getLastNonCommentNonWhitespaceToken());
        }

        private int getTempIndentCount(Token token) {
            if (token == null) {
                return 0;
            }
            if (",".equals(token.getLexeme())) {
                return 0;
            }
            if (token.getType() == 23) {
                return 1;
            }
            return 0;
        }

        private int collectBlocks(Token token, boolean bl) {
            int n;
            if (token.getType() == 0) {
                return 0;
            }
            int n2 = this.blockStack.size();
            boolean bl2 = true;
            int n3 = 0;
            Token token2 = token;
            while (token2 != null) {
                if (bl2) {
                    if (token2.isWhitespace()) {
                        token2 = token2.getNextToken();
                        continue;
                    }
                    bl2 = false;
                }
                if (bl) {
                    n = this.checkIfBlockEnd(token2);
                    if (n >= 0) {
                        token2 = token2.getNextToken();
                        continue;
                    }
                    bl = false;
                }
                if (this.pushIfBlockStart(token2)) {
                    this.indented.push(this.blockStack.size() - 1);
                } else {
                    n = this.popIfBlockEnd(token2);
                    if (n == 2) {
                        ++n3;
                    }
                }
                token2 = token2.getNextToken();
            }
            n = this.blockStack.size();
            int n4 = n - n2 - n3;
            int n5 = n - n2;
            if (n5 > 1) {
                for (int i = 0; i < n5 - 1; ++i) {
                    this.indented.pop();
                }
            }
            if (n4 > 0) {
                return 1;
            }
            if (n4 < 0) {
                return n4;
            }
            return 0;
        }

        private int checkLeadingClosingBlock(Token token) {
            Token token2 = token;
            int n = 0;
            boolean bl = true;
            while (token2 != null) {
                int n2;
                if (bl) {
                    if (token2.isWhitespace()) {
                        token2 = token2.getNextToken();
                        continue;
                    }
                    bl = false;
                }
                if ((n2 = this.popIfBlockEnd(token2)) >= 1) {
                    ++n;
                } else if (n2 < 0) break;
                token2 = token2.getNextToken();
            }
            return n;
        }

        public boolean pushIfBlockStart(Token token) {
            if (token.length() > 2 || token.getType() != 22) {
                return false;
            }
            if (token.isSingleChar('(')) {
                this.blockStack.push(Character.valueOf(')'));
            } else if (token.isSingleChar('[')) {
                this.blockStack.push(Character.valueOf(']'));
            } else if (token.isSingleChar('{')) {
                this.blockStack.push(Character.valueOf('}'));
            } else if (token.length() == 2 && token.charAt(0) == '[' && token.charAt(1) == '[') {
                this.blockStack.push(Character.valueOf(']'));
                this.blockStack.push(Character.valueOf(']'));
            } else {
                return false;
            }
            return true;
        }

        public int popIfBlockEnd(Token token) {
            int n = this.checkIfBlockEnd(token);
            if (n == 0 || n == 1) {
                this.blockStack.pop();
                if (n == 1) {
                    this.indented.pop();
                }
            }
            return n;
        }

        private int checkIfBlockEnd(Token token) {
            if (token.length() != 1 || token.getType() != 22) {
                return -1;
            }
            char c = token.getTextArray()[token.getTextOffset()];
            if (!this.isEmpty() && c == this.blockStack.peek().charValue()) {
                if (!this.indented.isEmpty() && this.indented.peek() == this.blockStack.size() - 1) {
                    return 1;
                }
                return 0;
            }
            if (this.isEmpty() && (c == ')' || c == ']' || c == '}')) {
                return 2;
            }
            return -1;
        }
    }
}

